<?php
/* -----------------------------------------------------------------------------------------
   $Id: account_edit.php,v 1.9 2018/12/14 08:31:17 cvs Exp $   
   
   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(account_edit.php,v 1.63 2003/05/19); www.oscommerce.com 
   (c) 2003	 nextcommerce (account_edit.php,v 1.14 2003/08/17); www.nextcommerce.org

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/

include( 'includes/application_top.php');

$smarty = new yesSmarty;
$YesBoxes->load( $smarty, basename(__FILE__) );

// include needed functions
require_once(DIR_FS_INC . 'xtc_draw_hidden_field.inc.php');
require_once(DIR_FS_INC . 'xtc_draw_radio_field.inc.php');
require_once(DIR_FS_INC . 'xtc_date_short.inc.php');
require_once(DIR_FS_INC . 'xtc_image_button.inc.php');
require_once(DIR_FS_INC . 'xtc_validate_email.inc.php');
require_once(DIR_FS_INC . 'xtc_validate_vatid.inc.php');
require_once(DIR_FS_INC . 'xtc_get_geo_zone_code.inc.php');
require_once(DIR_FS_INC . 'xtc_get_customers_country.inc.php');
require_once(DIR_WS_CLASSES.'yes_input_field.php');
if (!isset($_SESSION['customer_id'])) {
    xtc_redirect(xtc_href_link(FILENAME_LOGIN, '', 'SSL'));
}


if (isset($_POST['action']) && ($_POST['action'] == 'process')) {
    if (ACCOUNT_GENDER == 'true') {
        $gender = xtc_db_prepare_input($_POST['gender']);
    }
    $firstname = xtc_db_prepare_input($_POST['firstname']);
    $lastname = xtc_db_prepare_input($_POST['lastname']);
    if (ACCOUNT_DOB == 'true') {
        $dob = xtc_db_prepare_input($_POST['dob']);
    }
    if (ACCOUNT_COMPANY_VAT_CHECK == 'true') {
        $vat = xtc_db_prepare_input($_POST['vat']);
    }
    $email_address = xtc_db_prepare_input($_POST['email_address']);
    $telephone = xtc_db_prepare_input($_POST['telephone']);
    $mobile = xtc_db_prepare_input($_POST['mobile']);
    $fax = xtc_db_prepare_input($_POST['fax']);

    $error = false;

    if (ACCOUNT_GENDER == 'true') {
        if ( ($gender != 'm') && ($gender != 'f') ) {
            $error = true;
            $messageStack->add('account_edit', ENTRY_GENDER_ERROR);
        }
    }

    if (strlen($firstname) < ENTRY_FIRST_NAME_MIN_LENGTH) {
        $error = true;
        $messageStack->add('account_edit', ENTRY_FIRST_NAME_ERROR);
    }

    if (strlen($lastname) < ENTRY_LAST_NAME_MIN_LENGTH) {
        $error = true;
        $messageStack->add('account_edit', ENTRY_LAST_NAME_ERROR);
    }

    if (ACCOUNT_DOB == 'true' and ENTRY_DOB_MIN_LENGTH > 0) {
        $dateTime = DateTime::createFromFormat('Y-m-d', $dob);
        // WENN ZB EIN date FIELD VERWENDET WURDE UND DAS DATUM KORREKT IST
        if($dateTime and $dateTime->format('Y-m-d') === $dob){
            $dob_ymd = $dob;
        }else{
            // KEIN DATEFIELD, UEBERGABE MIT TAG MONAT JAHR
            if (checkdate(substr(xtc_date_raw($dob), 4, 2), substr(xtc_date_raw($dob), 6, 2), substr(xtc_date_raw($dob), 0, 4)) == false) {
                $error = true;
                $messageStack->add('account_edit', ENTRY_DATE_OF_BIRTH_ERROR);
            }else{
                $dob_ymd = null;
            }
        }
    }

    // Vat Check
    $country = xtc_get_customers_country($_SESSION['customer_id']);
    if(xtc_get_geo_zone_code($country) != '6'){
        if ($vat !=''){
            if (ACCOUNT_COMPANY_VAT_CHECK == 'true') {

                $validate_vatid = validate_vatid($vat,STORE_OWNER_VAT_ID,ACCOUNT_COMPANY_VAT_LIVE_CHECK);

                if ($validate_vatid == '0') {
                    if (ACCOUNT_VAT_BLOCK_ERROR == 'true'){
                        $messageStack->add('account_edit', ENTRY_VAT_ERROR);
                        $error = true;
                    }
                    $customer_group = $_SESSION['customers_status']['customers_status_id'];
                    $customers_vat_id_status  = '0';
                }

                if($validate_vatid == '1') {
                    if ($country == '81'){
                        $customer_group = $_SESSION['customers_status']['customers_status_id'];
                    }else{
                        if (ACCOUNT_COMPANY_VAT_GROUP == 'true'){
                            $customer_group = DEFAULT_CUSTOMERS_VAT_STATUS_ID;
                        }else{
                            $customer_group = $_SESSION['customers_status']['customers_status_id'];
                        }
                    }
                    $customers_vat_id_status  = '1';
                }

                if($validate_vatid == '8'){
                    if (ACCOUNT_VAT_BLOCK_ERROR == 'true'){
                        $messageStack->add('account_edit', ENTRY_VAT_ERROR);
                        $error = true;
                    }
                    $customer_group = $_SESSION['customers_status']['customers_status_id'];
                    $customers_vat_id_status  = '8';
                }

                if($validate_vatid == '9'){
                    if (ACCOUNT_VAT_BLOCK_ERROR == 'true'){
                        $messageStack->add('account_edit', ENTRY_VAT_ERROR);
                        $error = true;
                    }
                    $customer_group = $_SESSION['customers_status']['customers_status_id'];
                    $customers_vat_id_status  = '9';
                }
            }else {
                $customer_group = $_SESSION['customers_status']['customers_status_id'];
            }
        }else{
            $customer_group = $_SESSION['customers_status']['customers_status_id'];
        }
    }
    // Vat Check


    if (strlen($email_address) < ENTRY_EMAIL_ADDRESS_MIN_LENGTH) {
        $error = true;
        $messageStack->add('account_edit', ENTRY_EMAIL_ADDRESS_ERROR);
    }

    if (xtc_validate_email($email_address) == false) {
        $error = true;
        $messageStack->add('account_edit', ENTRY_EMAIL_ADDRESS_CHECK_ERROR);
    }

    $check_email = yes_query(
        "select count(customers_id) as total from " . TABLE_CUSTOMERS . " where customers_email_address =:email and customers_id !=:customers_id",
        ['email'=>$email_address,'customers_id'=>(int)$_SESSION['customer_id']],
        true
    );
    if ($check_email['total'] > 0) {
        $error = true;
        $messageStack->add('account_edit', ENTRY_EMAIL_ADDRESS_ERROR_EXISTS);
    }

    if (strlen($telephone) < ENTRY_TELEPHONE_MIN_LENGTH) {
        $error = true;
        $messageStack->add('account_edit', ENTRY_TELEPHONE_NUMBER_ERROR);
    }

    if ($error == false) {
        $sql_data_array = array(
            'customers_id'=>(int)$_SESSION['customer_id'],
            'customers_vat_id' => $vat,
            'customers_vat_id_status' => intval($customers_vat_id_status),
            'customers_status' => intval($customer_group),
            'customers_firstname' => $firstname,
            'customers_lastname' => $lastname,
            'customers_email_address' => $email_address,
            'customers_telephone' => $telephone,
            'mobile' => $mobile,
            'customers_fax' => $fax
        );

        if (ACCOUNT_GENDER == 'true') {
            $sql_data_array['customers_gender'] = $gender;
        }
        if (ACCOUNT_DOB == 'true') {
            if($dob != ''){
                // dob_ymd ist true, wenn das datum schon als Y-m-d vorliegt
                $sql_data_array['customers_dob'] = ($dob_ymd == null)?xtc_date_raw($dob):$dob;
            }else{
                $sql_data_array['customers_dob'] = '';
            }
        }
        $cust = new \YES4Trade\Model\customers($sql_data_array);
        $cust->update();

        // LOGGING FUER SUCHE NACH DER STELLE WO ADMIN USER BEI
        // SHOPKAUF ERZEUGT WIRD - TICKET 2921
        $new = new \YES4Trade\Model\customers_memo([
            'customers_id'=>(int)$_SESSION['customer_id'],
            'memo_date'=>date('Y-m-d H:i:s'),
            'memo_title'=>'Aktualisiert mit customers_status='.$customer_group,
            'memo_text'=>'Account Edit',
            'poster_id'=>0
        ]);
        $new->create();
        $upd = new \YES4Trade\Model\customers_info([
            'customers_info_date_account_last_modified' => date('Y-m-d H:i:s'),
            'customers_info_id' => (int)$_SESSION['customer_id']
        ]);
        $upd->update();

        // reset the session variables
        $customer_first_name = $firstname;
        $messageStack->add_session('account', SUCCESS_ACCOUNT_UPDATED, 'success');
        xtc_redirect(xtc_href_link(FILENAME_ACCOUNT, '', 'SSL'));
    }
} else {
    $cust = \YES4Trade\Model\customers::get_by_customers_id((int)$_SESSION['customer_id']);
    $account = ($cust !== null)?$cust->toArray():[];
}

$breadcrumb->add(NAVBAR_TITLE_1_ACCOUNT_EDIT, xtc_href_link(FILENAME_ACCOUNT, '', 'SSL'));
$breadcrumb->add(NAVBAR_TITLE_2_ACCOUNT_EDIT, xtc_href_link(FILENAME_ACCOUNT_EDIT, '', 'SSL'));

require(DIR_WS_INCLUDES . 'header.php');
$smarty->assign('FORM_ACTION',xtc_draw_form('account_edit', xtc_href_link(FILENAME_ACCOUNT_EDIT, '', 'SSL'), 'post', 'onSubmit="return check_form(account_edit);"') . xtc_draw_hidden_field('action', 'process'));
if ($messageStack->size('account_edit') > 0) {
    $smarty->assign('error',$messageStack->output('account_edit'));
}

if (ACCOUNT_GENDER == 'true') {
    $male = ($account['customers_gender'] == 'm') ? true : false;
    $female = !$male;
    $smarty->assign(array(
	'gender'=>'1',
	'INPUT_MALE'=>xtc_draw_radio_field(array ('name' => 'gender', 'suffix' => MALE.'&nbsp;'), 'm', $male),
	'INPUT_FEMALE'=>xtc_draw_radio_field(array ('name' => 'gender', 'suffix' => FEMALE.'&nbsp;'), 'f', $female),
	'INPUT_GENDER_ARRAY'=>yes_input_field::get_html(array(
	    'name'=>'gender',
	    'label'=>ENTRY_GENDER,
	    'type'=>'radio',
	    'required'=>true,
	    'required_text'=>ENTRY_GENDER_TEXT,
	    'values'=>array(
		array(
		    'label'=>MALE,
		    'value'=>'m',
		    'checked'=>$male
		),
		array(
		    'label'=>FEMALE,
		    'value'=>'f',
		    'checked'=>$female
		)
	    )
	)),
    ));
}

if (ACCOUNT_COMPANY_VAT_CHECK == 'true') {
    $smarty->assign(array(
	'vat'=>'1',
	'INPUT_VAT'=>xtc_draw_input_field('vat',$account['customers_vat_id']) . '&nbsp;' . (xtc_not_null(ENTRY_VAT_TEXT) ? '<span class="inputRequirement">' . ENTRY_VAT_TEXT . '</span>': ''),
	'INPUT_VAT_ARRAY'=>yes_input_field::get_html(array(
	    'name'=>'vat',
	    'label'=>ENTRY_VAT_ID,
	    'type'=>'text',
	    'required'=>false,
	    'maxlength'=>64,
	    'minlength'=>1,
	    'placeholder'=>(defined('ENTRY_VAT_ID_PLACEHOLDER') and ENTRY_VAT_ID_PLACEHOLDER != '') ? ENTRY_VAT_ID_PLACEHOLDER : '',
	    'required_text'=>ENTRY_VAT_TEXT,
	    'value'=>$account['customers_vat_id']
	))
	
    ));
}  else {
    $smarty->assign('vat','0');
}
if (ACCOUNT_DOB == 'true') {
    $smarty->assign(array(
	'birthdate'=>'1',
	'INPUT_DOB'=>xtc_draw_input_field('dob',xtc_date_short($account['customers_dob'])) . '&nbsp;' . ( (xtc_not_null(ENTRY_DATE_OF_BIRTH_TEXT) and ENTRY_DOB_MIN_LENGTH > 0) ? '<span class="inputRequirement">' . ENTRY_DATE_OF_BIRTH_TEXT . '</span>': ''),
	'INPUT_DOB_ARRAY'=>yes_input_field::get_html(array(
	    'name'=>'dob',
	    'label'=>ENTRY_DATE_OF_BIRTH,
	    'type'=>'text',
	    'required'=>((ACCOUNT_DOB == 'true') ? true : false),
	    'maxlength'=>10,
	    'minlength'=>ENTRY_DOB_MIN_LENGTH,
	    'placeholder'=>(defined('ENTRY_DOB_PLACEHOLDER') and ENTRY_DOB_PLACEHOLDER != '') ? ENTRY_DOB_PLACEHOLDER : '',
	    'value'=>xtc_date_short($account['customers_dob'])
	))
    ));
}

$smarty->assign(array(
    'INPUT_FIRSTNAME'=>xtc_draw_input_field('firstname',$account['customers_firstname']) . '&nbsp;' . (xtc_not_null(ENTRY_FIRST_NAME_TEXT) ? '<span class="inputRequirement">' . ENTRY_FIRST_NAME_TEXT . '</span>': ''),
    'INPUT_FIRSTNAME_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'firstname',
	'label'=>ENTRY_FIRST_NAME,
	'type'=>'text',
	'required'=>((defined('ENTRY_FIRST_NAME_MIN_LENGTH') and ENTRY_FIRST_NAME_MIN_LENGTH > 0) ? true : false),
	'minlength'=>ENTRY_FIRST_NAME_MIN_LENGTH,
	'maxlength'=>64,
	'placeholder'=>(defined('ENTRY_FIRST_NAME_PLACEHOLDER') and ENTRY_FIRST_NAME_PLACEHOLDER != '') ? ENTRY_FIRST_NAME_PLACEHOLDER : '',
	'required_text'=>ENTRY_FIRST_NAME_TEXT,
	'value'=>$account['customers_firstname']
    )),
    'INPUT_LASTNAME'=>xtc_draw_input_field('lastname',$account['customers_lastname']) . '&nbsp;' . (xtc_not_null(ENTRY_LAST_NAME_TEXT) ? '<span class="inputRequirement">' . ENTRY_LAST_NAME_TEXT . '</span>': ''),
    'INPUT_LASTNAME_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'lastname',
	'label'=>ENTRY_LAST_NAME,
	'type'=>'text',
	'required'=>((defined('ENTRY_LAST_NAME_MIN_LENGTH') and ENTRY_LAST_NAME_MIN_LENGTH > 0) ? true : false),
	'minlength'=>ENTRY_LAST_NAME_MIN_LENGTH,
	'maxlength'=>64,
	'placeholder'=>(defined('ENTRY_LAST_NAME_PLACEHOLDER') and ENTRY_LAST_NAME_PLACEHOLDER != '') ? ENTRY_LAST_NAME_PLACEHOLDER : '',
	'required_text'=>ENTRY_LAST_NAME_TEXT,
	'value'=>$account['customers_lastname']
    )),
    'INPUT_EMAIL'=>xtc_draw_input_field('email_address',$account['customers_email_address']) . '&nbsp;' . (xtc_not_null(ENTRY_EMAIL_ADDRESS_TEXT) ? '<span class="inputRequirement">' . ENTRY_EMAIL_ADDRESS_TEXT . '</span>': ''),
    'INPUT_EMAIL_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'email_address',
	'label'=>ENTRY_EMAIL_ADDRESS,
	'type'=>'text',
	'required'=>true,
	'maxlength'=>255,
	'minlength'=>ENTRY_EMAIL_ADDRESS_MIN_LENGTH,
	'placeholder'=>(defined('ENTRY_EMAIL_ADDRESS_PLACEHOLDER') and ENTRY_EMAIL_ADDRESS_PLACEHOLDER != '') ? ENTRY_EMAIL_ADDRESS_PLACEHOLDER : '',
	'required_text'=>ENTRY_EMAIL_ADDRESS_TEXT,
	'value'=>$account['customers_email_address']
    )),
    'INPUT_TEL'=>xtc_draw_input_field('telephone',$account['customers_telephone']) . '&nbsp;' . (xtc_not_null(ENTRY_TELEPHONE_NUMBER_TEXT) ? '<span class="inputRequirement">' . ENTRY_TELEPHONE_NUMBER_TEXT . '</span>': ''),
    'INPUT_TEL_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'telephone',
	'label'=>ENTRY_TELEPHONE_NUMBER,
	'type'=>'tel',
	'required'=>(ENTRY_TELEPHONE_MIN_LENGTH>0)?true:false,
	'minlength'=>ENTRY_TELEPHONE_MIN_LENGTH,
	'maxlength'=>32,
	'placeholder'=>(defined('ENTRY_TELEPHONE_PLACEHOLDER') and ENTRY_TELEPHONE_PLACEHOLDER != '') ? ENTRY_TELEPHONE_PLACEHOLDER : '',
	'required_text'=>ENTRY_TELEPHONE_NUMBER_TEXT,
	'value'=>$account['customers_telephone']
    )),
    'INPUT_MOBILE'=>xtc_draw_input_field('mobile',$account['mobile']) . '&nbsp;',
    'INPUT_MOBILE_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'mobile',
	'label'=>ENTRY_MOBILE,
	'type'=>'tel',
	'required'=>false,
	'maxlength'=>32,
	'placeholder'=>(defined('ENTRY_MOBILE_PLACEHOLDER') and ENTRY_MOBILE_PLACEHOLDER != '') ? ENTRY_MOBILE_PLACEHOLDER : '',
	'value'=>$account['mobile']
    )),
    'INPUT_FAX'=>xtc_draw_input_field('fax',$account['customers_fax']) . '&nbsp;' . (xtc_not_null(ENTRY_FAX_NUMBER_TEXT) ? '<span class="inputRequirement">' . ENTRY_FAX_NUMBER_TEXT . '</span>': ''),
    'INPUT_FAX_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'fax',
	'label'=>ENTRY_FAX_NUMBER,
	'type'=>'tel',
	'required'=>false,
	'maxlength'=>32,
	'placeholder'=>(defined('ENTRY_FAX_NUMBER_PLACEHOLDER') and ENTRY_FAX_NUMBER_PLACEHOLDER != '') ? ENTRY_FAX_NUMBER_PLACEHOLDER : '',
	'required_text'=>ENTRY_FAX_NUMBER_TEXT,
	'value'=>$account['customers_fax']
    )),
    'csID'=>$account['customers_cid'],
    'BUTTON_BACK'=>'<a href="' . xtc_href_link(FILENAME_ACCOUNT, '', 'SSL') . '">' . xtc_image_button('button_back.gif', IMAGE_BUTTON_BACK) . '</a>',
    'BUTTON_SUBMIT'=>xtc_image_submit('button_continue.gif', IMAGE_BUTTON_CONTINUE),
    'language'=>$_SESSION['language']
));

$smarty->caching = 0;
$main_content= $smarty->fetch(CURRENT_TEMPLATE.'/module/account_edit.html');

$smarty->assign('language', $_SESSION['language']);
$smarty->assign('main_content',$main_content);
$smarty->caching = 0;
if (!defined('RM')) $smarty->load_filter('output', 'note');
$smarty->display(CURRENT_TEMPLATE . '/index.html');
include('includes/application_bottom.php');
