<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                             Author M. ASPELEITER <dazze@gmx.de>
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/
   
require('includes/application_top.php');
require_once(DIR_WS_CLASSES.'class.basics.php');
require('includes/classes/class.yes_lister.php');

$basics = new basics;

function _draw_checkbox($id){
	return xtc_draw_checkbox_field('bID[]',$id);
}

$admin_access = main::get_admin_access();

if (isset($_GET['action'])) {
	switch ($_GET['action']) {
		case 'save':
			$bID = xtc_db_prepare_input($_GET['bID']);
			$title = xtc_db_prepare_input($_POST['title']);
			$stammlager = xtc_db_prepare_input($_POST['stammlager']);
			$storekeeper_id = xtc_db_prepare_input($_POST['storekeeper_id']);
			xtc_db_query("update branches set title='".$title."',stammlager='".$stammlager."',storekeeper_id='".$storekeeper_id."' where branches_id = '" . $bID . "'");

			// history
			$comments = sprintf(HISTORY_BRANCH_TITLE_UPDATED,$title,$stammlager);
			$sql_insert_array = array('branches_id'=>$bID,
				'date_created'=>"now()",
				'comments'=>$comments,
				'editor_id'=>$_SESSION['customer_id']
			);
			xtc_db_perform('branches_history',$sql_insert_array);

			$messageStack->add_session(MSG_SUCCESS_BRANCH_UPDATE,'success');
	
			xtc_redirect(xtc_href_link('branch.php', 'bID=' . $bID));
	        break;
		case 'insert':
			$bID = xtc_db_input($_POST['branches_id']);
			$cID = xtc_db_input($_POST['customers_id']);
			if((int)$bID == 0 or (int)$cID == 0){
				$messageStack->add_session(MSG_ERROR_ALLOCATION_PARAMETER,'error');
				xtc_redirect(xtc_href_link('branches_to_customers.php', xtc_get_all_get_params(array('action'))));
			}
			$number_of_allocations_query = xtc_db_query(sprintf(
					"SELECT branches_id FROM branches_to_customers
					WHERE branches_id='%s' AND customers_id='%s'",
				$bID,$cID
			));
			if(xtc_db_num_rows($number_of_allocations_query)){
				$messageStack->add_session(MSG_ERROR_ALLOCATION_EXISTS,'error');
				xtc_redirect(xtc_href_link('branches_to_customers.php', xtc_get_all_get_params(array('action'))));
			}
			$insert_sql_array = array(
				'branches_id'=>$bID,
				'customers_id'=>$cID,
				'date_added'=>'now()'
			);
			xtc_db_perform('branches_to_customers',$insert_sql_array);

			$comments = sprintf(HISTORY_SYSTEM_ALLOCATION_ADDED,xtc_get_branch_title($bID),xtc_get_editor_name($cID));
			yes_add_history($comments);

			$messageStack->add_session(MSG_SUCCESS_ALLOCATION_ADDED,'success');
			xtc_redirect(xtc_href_link('branches_to_customers.php', xtc_get_all_get_params(array('action'))));
			break;
		case 'delete':
			$bID = xtc_db_input($_GET['bID']);
			$query = xtc_db_query(sprintf(
					"SELECT * FROM branches_to_customers WHERE branches_to_customers_id='%s'",
					$bID
				)
			);
			$result = xtc_db_fetch_array($query);
			xtc_db_query(sprintf(
				"DELETE FROM branches_to_customers WHERE branches_to_customers_id='%s'",
				$bID)
			);
			$comments = sprintf(HISTORY_SYSTEM_ALLOCATION_DELETED,xtc_get_branch_title($result['branches_id']),xtc_get_editor_name($result['customers_id']));
			yes_add_history($comments);
			$messageStack->add_session(MSG_SUCCESS_ALLOCATION_DELETED,'success');
			xtc_redirect(xtc_href_link('branches_to_customers.php', xtc_get_all_get_params(array('action','bID'))));
			break;
    }
  }
yes_draw_pre_header();
yes_draw_header(TITLE);
?>
<script type="text/javascript" src="minify_js.php?file=includes/general.js"></script>

<?php
$smarty = new yesSmarty;
$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
$listing_smarty = $smarty;

$order_by = isset($_GET['order_by']) ? xtc_db_input($_GET['order_by']) : 'branches_id';

$query_raw = sprintf("select * from branches_to_customers ORDER by %s",$order_by);
$bc_split = new splitPageResults($_GET['page'], MAX_DISPLAY_SEARCH_RESULTS, $query_raw, $query_numrows);
$select_field_array = array(
		0=>array(
			'field'=>'branches_to_customers_id',
			'heading'=>'&nbsp;',
			'format'=>'string',
			'get_param'=>'bID',
			'sortable'=>0,
			'index'=>true,
			'column'=>0
		),
		1=>array(
			'field'=>'branches_id',
			'heading'=>TABLE_HEADING_BRANCH,
			'format'=>'string',
			'get_param'=>'brID',
			'sortable'=>1,
			'function'=>'xtc_get_branch_title',
			'column'=>1
		),
		2=>array(
			'field'=>'customers_id',
			'heading'=>TABLE_HEADING_CUSTOMER,
			'format'=>'string',
			'get_param'=>'cID',
			'sortable'=>1,
			'function'=>'xtc_get_editor_name',
			'column'=>2
		),
		3=>array(
			'field'=>'date_added',
			'heading'=>TABLE_HEADING_DATE_ADDED,
			'format'=>'date',
			'get_param'=>'da',
			'sortable'=>0,
			'column'=>3
		)
);
$YL = new yes_lister($query_raw,'branches_to_customers','branches_to_customers.php',$select_field_array,$where_field_array=array(),$ajax_box=0);
$YL->setSmarty($listing_smarty);
$bcInfo = $YL->active_row;
$smarty->assign('LISTING',$YL->display($bc_split,$query_numrows,MAX_DISPLAY_SEARCH_RESULTS));
$smarty->assign('start_row_input',$YL->start_row_input);
$smarty->assign('SPLIT',$YL->split_string);
$buttons = array(
    array('text'=>BUTTON_NEW_ALLOCATION,
	'link'=>xtc_href_link('branches_to_customers.php',xtc_get_all_get_params(array('action')).'action=new' ),
	'auth'=>true,
	'lbOn'=>false
    )
);
$smarty->assign(array(
    'HEADING_TITLE'=>HEADING_TITLE,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons
));
$smarty->assign('CHANGE_ALLOCATIONS_FORM', xtc_draw_form('branches_to_customers','branches_to_customers.php',xtc_get_all_get_params(array('action','bID')).'action=change_allocations','POST') );

$box_html = '';
$heading = array();
$contents = array();
$action = isset($_GET['action']) ? $_GET['action'] : '';
switch ($action) {
	case 'delete_confirm':
	    $heading[] = array('text' => '<b>'.TEXT_ALLOCATION_DELETE.'</b>');
	    $contents = array('form' => xtc_draw_form('delete', 'branches_to_customers.php', xtc_get_all_get_params(array('bID','action')).'bID=' . $bcInfo->branches_to_customers_id . '&action=delete'));
	    $contents[] = array('text' => TEXT_ALLOCATION_DELETE_INTRO);
		$contents[] = array('text' => '<br /><b>'.TEXT_BRANCH.':</b> ' . $bcInfo->title);
		$contents[] = array('text' => '<b>'.TEXT_CUSTOMER.':</b> ' . xtc_get_editor_name($bcInfo->customers_id));
		$contents[] = array('text' => '<b>'.TEXT_DATE_ADDED.':</b> ' . xtc_date_short($bcInfo->date_added));
		$contents[] = array('align' => 'center', 'text' =>
			'<br />' . yes_draw_href_button(IMAGE_DELETE,'','width:100px;','submit') .
			' '.yes_draw_href_button(IMAGE_CANCEL,xtc_href_link('branches_to_customers.php', xtc_get_all_get_params(array('bID','action')).'bID=' . $bcInfo->branches_to_customers_id),'width:100px;')
		);
		break;
    case 'new':
      $heading[] = array('text' => '<b>'.TEXT_NEW_ALLOCATION.'</b>');
	  $branches_array = array(0=>array('id'=>'','text'=>TEXT_SELECT));
	  $branches_query = xtc_db_query("SELECT branches_id,title FROM branches ORDER BY title");
	  while($branches = xtc_db_fetch_array($branches_query)){
		  $branches_array[] = array('id'=>$branches['branches_id'],'text'=>$branches['title']);
	  }
	  $customers_array = array(0=>array('id'=>'','text'=>TEXT_SELECT));
	  $customers_query = xtc_db_query("SELECT customers_id,CONCAT(customers_firstname,' ',customers_lastname) as cname FROM customers WHERE customers_id != 1 AND customers_status=0");
	  while($customers = xtc_db_fetch_array($customers_query)){
		  $customers_array[] = array('id'=>$customers['customers_id'],'text'=>$customers['cname']);
	  }
      $contents = array('form' => xtc_draw_form('new', 'branches_to_customers.php', 'action=insert'));
      $contents[] = array('text' => TEXT_ALLOCATION_INTRO);
      $contents[] = array('text' => '<br /><b>'.TEXT_BRANCH.'</b><br />' . xtc_draw_pull_down_menu('branches_id',$branches_array));
      $contents[] = array('text' => '<br /><b>'.TEXT_CUSTOMER.'</b><br />' . xtc_draw_pull_down_menu('customers_id',$customers_array));
      $contents[] = array('align' => 'center', 'text' =>
        '<br />' . yes_draw_href_button(IMAGE_UPDATE,'','width:100px;','submit') .
		' '.yes_draw_href_button(IMAGE_CANCEL,xtc_href_link('branches_to_customers.php', xtc_get_all_get_params(array('action'))),'width:100px;')
	  );
      break;
    default:
      if (is_object($bcInfo)) {
        $heading[] = array('text' => '<b>'.TEXT_ALLOCATION_EDIT.'</b>');
		$contents[] = array('text' => '<br /><b>'.TEXT_BRANCH.':</b> ' . xtc_get_branch_title($bcInfo->branches_id));
		$contents[] = array('text' => '<b>'.TEXT_CUSTOMER.':</b> ' . xtc_get_editor_name($bcInfo->customers_id));
		$contents[] = array('text' => '<b>'.TEXT_DATE_ADDED.':</b> ' . xtc_date_short($bcInfo->date_added));
		$contents[] = array('align' => 'center','text'=>yes_draw_href_button(
			IMAGE_DELETE,
			xtc_href_link('branches_to_customers.php',xtc_get_all_get_params(array('action','bID') ).'action=delete_confirm&bID='.$bcInfo->branches_to_customers_id ),
			'width:180px'
		) );

      }
      break;
}
if ( (xtc_not_null($heading)) && (xtc_not_null($contents)) ) {
    $box_html .= '            <td width="25%" valign="top">' . "\n";

    $box = new box;
    $box_html .= $box->infoBox($heading, $contents);
    $box_html .= '            </td>' . "\n";
}

$smarty->assign('BOX',$box_html);
$smarty->display('branches_to_customers.html');

?>

<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>