<?php
require_once(DIR_FS_INC.'xtc_db_affected_rows.inc.php');
function _get_search_result($table,$field,$search,$field_title,$use_binary = false){
    global $has_matches;
    $select_field = ($table == 'ebay_products') ? 'id' : 'products_id';
    $query = xtc_db_query(sprintf(
	    "SELECT %s FROM %s WHERE %s LIKE %s '%%%s%%'",
	    $select_field,$table,$field,(($use_binary)?' BINARY ':''),$search
    ));
    $num = xtc_db_num_rows($query);
    if($num > 0){
	    $has_matches = true;
	    $field = xtc_draw_checkbox_field('replace_fields[]',$field,false);
    }else{
	    $field = '<input type="checkbox" disabled="disabled" />';
    }
    $str = sprintf('%s [%s] ', $field, $field_title);
    $str .= sprintf(TEXT_SEARCH_RESULTS_MATCHED_ITEMS_FOR_TARGET,$num,xtc_db_prepare_input($search));
    return $str.'<br />';
}
$target = (isset($_REQUEST['target']))?$_REQUEST['target']:'';
$search = (isset($_REQUEST['rplc_search'])) ? xtc_db_input($_REQUEST['rplc_search']) : '';
$replace = (isset($_REQUEST['rplc_replace'])) ? xtc_db_input($_REQUEST['rplc_replace']) : '';
if( (isset($_REQUEST['rplc_search']) or isset($_REQUEST['rplc_replace'])) and (strlen(trim($search)) < 3 or strlen(trim($replace)) < 3 )){
	$messageStack->add_session(MSG_ERROR_REPLACE_STRING_TO_SHORT,'error');
	xtc_redirect(xtc_href_link(FILENAME_CONTENT_MANAGER,xtc_get_all_get_params() ));
}
if(isset($_REQUEST['replace_fields']) and sizeOf($_REQUEST['replace_fields'])){
    $search = urldecode($search);
    $replace = urldecode($replace);
    switch($target){
	case 'products':
	    $valid_fields = array('products_name','products_description','products_extra_text','products_short_description','ebay_title','slave_title');
	    foreach($_REQUEST['replace_fields'] as $field){
		$field_desc = constant('TEXT_INPUT_REPLACE_TARGET_PRODUCT_'.strtoupper($field));
		if(in_array($field,$valid_fields)){
			$query_raw = sprintf("UPDATE products_description SET %s = REPLACE(%s, '%s', '%s') WHERE %s LIKE '%%%s%%'",
				$field,$field,$search,$replace,$field,$search
			);
			$upq = xtc_db_query($query_raw);
			$affected = xtc_db_affected_rows($upq);
			$messageStack->add_session(sprintf(MSG_SUCCESS_FIELD_REPLACED,$field_desc,$affected),'success');
		}
	    }
	    break;
	case 'products_meta':
	    $valid_fields = array('products_meta_title','products_meta_description','products_meta_keywords');
	    foreach($_REQUEST['replace_fields'] as $field){
		$field_desc = constant('TEXT_INPUT_REPLACE_TARGET_'.strtoupper($field));
		if(in_array($field,$valid_fields)){
			$query_raw = sprintf("UPDATE products_description SET %s = REPLACE(%s, '%s', '%s') WHERE %s LIKE '%%%s%%'",
				$field,$field,$search,$replace,$field,$search
			);
			$upq = xtc_db_query($query_raw);
			$affected = xtc_db_affected_rows($upq);
			$messageStack->add_session(sprintf(MSG_SUCCESS_FIELD_REPLACED,$field_desc,$affected),'success');
		}
	    }
	    break;
	case 'ebay_products':
            $field = 'ebay_beschreibung';
            $query_raw = sprintf("UPDATE ebay_products SET %s = REPLACE(%s, '%s', '%s') WHERE %s LIKE '%%%s%%'",
                    $field,$field,$search,$replace,$field,$search
            );
            $upq = xtc_db_query($query_raw);
            $affected = xtc_db_affected_rows($upq);
            $messageStack->add_session(sprintf(MSG_SUCCESS_FIELD_REPLACED,$field_desc,$affected),'success');
	    break;
	default:
	    foreach($_REQUEST['replace_fields'] as $field){
		    switch($field){
			    case 'pc_description':
				    $query_raw = sprintf("UPDATE products_characteristic_description SET title = REPLACE(title, '%s', '%s') WHERE title LIKE '%%%s%%'",
					    $search,$replace,$search
				    );
				    $upq = xtc_db_query($query_raw);
				    $affected = xtc_db_affected_rows($upq);
				    $messageStack->add_session(sprintf(MSG_SUCCESS_FIELD_REPLACED,TEXT_INPUT_REPLACE_TARGET_GROUPS_PC_DESCRIPTION,$affected),'success');
				    break;
			    case 'pc_set_description':
				    $query_raw = sprintf("UPDATE products_characteristic_set_description SET title = REPLACE(title, '%s', '%s') WHERE title LIKE '%%%s%%'",
					    $search,$replace,$search
				    );
				    $upq = xtc_db_query($query_raw);
				    $affected = xtc_db_affected_rows($upq);
				    $messageStack->add_session(sprintf(MSG_SUCCESS_FIELD_REPLACED,TEXT_INPUT_REPLACE_TARGET_GROUPS_PC_SET_DESCRIPTION,$affected),'success');
				    break;
			    case 'pc_text_values':
				    $query_raw = sprintf("UPDATE products_characteristic_text_values SET content = REPLACE(content, '%s', '%s') WHERE title LIKE '%%%s%%'",
					    $search,$replace,$search
				    );
				    $upq = xtc_db_query($query_raw);
				    $affected = xtc_db_affected_rows($upq);
				    $messageStack->add_session(sprintf(MSG_SUCCESS_FIELD_REPLACED,TEXT_INPUT_REPLACE_TARGET_GROUPS_PC_SET_DESCRIPTION,$affected),'success');
				    break;
		    }
	    } // eof foreach fields
	    break;
    } // eof target switch
    xtc_redirect(xtc_href_link(FILENAME_CONTENT_MANAGER,xtc_get_all_get_params()));
    exit;
} // EOF IF request_field

$targets = array(
	0=>array('id'=>'products','text'=>TEXT_INPUT_REPLACE_TARGET_PRODUCTS),
	1=>array('id'=>'products_meta','text'=>TEXT_INPUT_REPLACE_TARGET_PRODUCTS_META),
	2=>array('id'=>'groups','text'=>TEXT_INPUT_REPLACE_TARGET_GROUPS),
        3=>array('id'=>'ebay_products','text'=>TEXT_INPUT_REPLACE_TARGET_EBAY_PRODUCTS)
);
yes_draw_pre_header();
yes_draw_header(TITLE);
$buttons = array(
    array('text'=>IMAGE_BACK,
	'link'=>xtc_href_link(FILENAME_CONTENT_MANAGER),
	'lbOn'=>false,
	'auth'=>true
    )
);

$smarty->assign(array(
    'HEADING_TITLE'=>BUTTON_DB_REPLACE,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons
));
$smarty->display('content_manager.html');
?>
<div style="width:100%; margin:3px; padding:3px;" class="main">
	<p><?php echo TEXT_DB_REPLACE_INTRO; ?></p>

	<form action="<?php echo xtc_href_link(FILENAME_CONTENT_MANAGER,xtc_get_all_get_params()); ?>" method="post">
		<fieldset>
			<legend><?php echo TEXT_DB_REPLACE_LEGEND; ?></legend>
			<label for="search"><?php echo TEXT_INPUT_SEARCH_STRING; ?></label>
			<?php echo xtc_draw_input_field('rplc_search', stripslashes(xtc_db_prepare_input($search)), 'size="60" maxlength="128" id="search"'); ?>
			<label for="replace"><?php echo TEXT_INPUT_REPLACE_STRING; ?></label>
			<?php echo xtc_draw_input_field('rplc_replace', stripslashes(xtc_db_prepare_input($replace)), 'size="60" maxlength="128" id="replace"'); ?><br />
			<label for="target"><?php echo TEXT_INPUT_REPLACE_TARGET; ?></label>
			<?php echo xtc_draw_pull_down_menu('target', $targets, $target, 'id="target"'); ?>
			<input type="submit" class="ui-button ui-corner-all ui-state-default" value="<?php echo IMAGE_SEARCH; ?>" />

		</fieldset>
	</form>
<?php
if($search != ''){
	echo '<br /><br />'.xtc_draw_form('replace_start',FILENAME_CONTENT_MANAGER,xtc_get_all_get_params());
	printf('<fieldset><legend>%s</legend>',TEXT_REPLACE_SEARCH_RESULTS);
		
	echo xtc_draw_hidden_field('rplc_search', urlencode(xtc_db_prepare_input($search)));
	echo xtc_draw_hidden_field('rplc_replace',urlencode(xtc_db_prepare_input($replace)));
	echo xtc_draw_hidden_field('target',$target);
	$has_matches = false;
	switch($target){
		case 'products':
		    $has_matches = false;
		    echo _get_search_result('products_description','products_name',xtc_db_prepare_input($search),TEXT_INPUT_REPLACE_TARGET_PRODUCT_PRODUCTS_NAME);
		    echo _get_search_result('products_description','products_description',xtc_db_prepare_input($search),TEXT_INPUT_REPLACE_TARGET_PRODUCT_PRODUCTS_DESCRIPTION,true);
		    echo _get_search_result('products_description','products_short_description',xtc_db_prepare_input($search),TEXT_INPUT_REPLACE_TARGET_PRODUCT_PRODUCTS_SHORT_DESCRIPTION,true);
		    echo _get_search_result('products_description','products_extra_text',xtc_db_prepare_input($search),TEXT_INPUT_REPLACE_TARGET_PRODUCT_PRODUCTS_EXTRA_TEXT,true);
		    echo _get_search_result('products_description','ebay_title',xtc_db_prepare_input($search),TEXT_INPUT_REPLACE_TARGET_PRODUCT_EBAY_TITLE);
		    echo _get_search_result('products_description','slave_title',xtc_db_prepare_input($search),TEXT_INPUT_REPLACE_TARGET_PRODUCT_SLAVE_TITLE);
		    break;
		
		case 'products_meta':
		    echo _get_search_result('products_description','products_meta_title',xtc_db_prepare_input($search),TEXT_INPUT_REPLACE_TARGET_PRODUCTS_META_TITLE);
		    echo _get_search_result('products_description','products_meta_description',xtc_db_prepare_input($search),TEXT_INPUT_REPLACE_TARGET_PRODUCTS_META_DESCRIPTION);
		    echo _get_search_result('products_description','products_meta_keywords',xtc_db_prepare_input($search),TEXT_INPUT_REPLACE_TARGET_PRODUCTS_META_KEYWORDS);
		    break;
		case 'groups':
			$query = xtc_db_query(sprintf(
				"SELECT products_characteristic_description_id FROM products_characteristic_description WHERE title LIKE BINARY '%%%s%%'",
				$search
			));
			$num = xtc_db_num_rows($query);
			if($num > 0){
				$has_matches = true;
				$field = xtc_draw_checkbox_field('replace_fields[]','pc_description',false);
			}else
				$field = '<input type="checkbox" disabled="disabled" />';
			printf('%s [%s] ',
					$field,
					TEXT_INPUT_REPLACE_TARGET_GROUPS_PC_DESCRIPTION
			);
			printf(TEXT_SEARCH_RESULTS_MATCHED_ITEMS_FOR_TARGET,$num,xtc_db_prepare_input($search));
			echo '<br />';
			$query = xtc_db_query(sprintf(
				"SELECT products_characteristic_set_description FROM products_characteristic_set_description WHERE title LIKE BINARY '%%%s%%'",
				$search
			));
			$num = xtc_db_num_rows($query);
			if($num > 0){
				$has_matches = true;
				$field = xtc_draw_checkbox_field('replace_fields[]','pc_set_description',false);
			}else
				$field = '<input type="checkbox" disabled="disabled" />';
			
			printf('%s [%s] ',
					$field,
					TEXT_INPUT_REPLACE_TARGET_GROUPS_PC_SET_DESCRIPTION
			);
			printf(TEXT_SEARCH_RESULTS_MATCHED_ITEMS_FOR_TARGET,$num,xtc_db_prepare_input($search));
			echo '<br />';
			$query = xtc_db_query(sprintf(
				"SELECT products_characteristic_text_values_id FROM products_characteristic_text_values WHERE content LIKE BINARY '%%%s%%'",
				$search
			));
			$num = xtc_db_num_rows($query);
			if($num > 0){
				$has_matches = true;
				$field = xtc_draw_checkbox_field('replace_fields[]','pc_text_values',false);
			}else
				$field = '<input type="checkbox" disabled="disabled" />';
			printf('%s [%s] ',
					$field,
					TEXT_INPUT_REPLACE_TARGET_GROUPS_PC_TEXT_VALUES
			);
			printf(TEXT_SEARCH_RESULTS_MATCHED_ITEMS_FOR_TARGET,$num,xtc_db_prepare_input($search));
			break;
		case 'ebay_products':
		    echo _get_search_result('ebay_products','ebay_beschreibung',xtc_db_prepare_input($search),TEXT_INPUT_REPLACE_TARGET_EBAY_PRODUCTS,true);
		    break;
	}
	if($has_matches)
		echo '<br /><input type="submit" class="ui-button ui-corner-all ui-state-default" value="'.IMAGE_REPLACE_PROCESS.'" />';
	echo '</fieldset>';
	echo '</form>';
}
?>
	</div>
</div>
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>


