<?php
/* --------------------------------------------------------------
   $Id: create_account.php,v 1.30 2017/05/03 15:17:04 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   --------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(customers.php,v 1.76 2003/05/04); www.oscommerce.com 
   (c) 2003	 nextcommerce (create_account.php,v 1.17 2003/08/24); www.nextcommerce.org

   Released under the GNU General Public License 
   --------------------------------------------------------------
   Third Party contribution:
   Customers Status v3.x  (c) 2002-2003 Copyright Elari elari@free.fr | www.unlockgsm.com/dload-osc/ | CVS : http://cvs.sourceforge.net/cgi-bin/viewcvs.cgi/elari/?sortby=date#dirlist

   Released under the GNU General Public License
   --------------------------------------------------------------*/

require('includes/application_top.php');
require_once(DIR_FS_INC . 'xtc_encrypt_password.inc.php');
require_once(DIR_FS_CATALOG.DIR_WS_CLASSES.'class.phpmailer.php');
require_once(DIR_FS_INC . 'xtc_php_mail.inc.php');
require_once(DIR_FS_INC . 'xtc_create_password.inc.php');
require_once(DIR_FS_INC . 'xtc_validate_vatid.inc.php');
require_once(DIR_FS_INC . 'xtc_get_geo_zone_code.inc.php');
require_once(DIR_FS_INC . 'yes_customers_email_alias_functions.inc.php');

// initiate template engine for mail
$smarty = new yesSmarty;
$smarty->assign('language', $_SESSION['language']);
$smarty->assign('tpl_path','templates/'.CURRENT_TEMPLATE.'/');
$smarty->assign('logo_path',HTTP_SERVER  . DIR_WS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/img/');
$smarty->assign('language_path',DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
  
// yes accounting  
$admin_access = main::get_admin_access();

$customers_statuses_array = xtc_get_customers_statuses();
$action = isset($_REQUEST['action']) ? $_REQUEST['action'] : '';
if(isset($_POST['entry_password'])){
      $customers_password = xtc_db_input($_POST[ $_POST['entry_password'] ]);
      if($customers_password == '') $customers_password = xtc_create_password(8);
}
if ($action == 'edit') {
    $customers_firstname = xtc_db_input($_POST['customers_firstname']);
    $customers_cid = xtc_db_input($_POST['csID']);
    $customers_vat_id = xtc_db_input($_POST['customers_vat_id']);
    $customers_vat_id_status = xtc_db_input($_POST['customers_vat_id_status']);
    $customers_lastname = xtc_db_input($_POST['customers_lastname']);
    $customers_email_address = xtc_db_input($_POST['customers_email_address']);
    $customers_telephone = xtc_db_input($_POST['customers_telephone']);
    $mobile = xtc_db_input($_POST['mobile']);
    $customers_fax = xtc_db_input($_POST['customers_fax']);
    $customers_status_c = xtc_db_input($_POST['status']);

    $customers_gender = xtc_db_input($_POST['customers_gender']);
    $customers_dob = xtc_db_input($_POST['customers_dob']);

    $default_address_id = xtc_db_input($_POST['default_address_id']);
    $entry_street_address = xtc_db_input($_POST['entry_street_address']);
    $entry_suburb = xtc_db_input($_POST['entry_suburb']);
    $entry_postcode = xtc_db_input($_POST['entry_postcode']);
    $entry_city = xtc_db_input($_POST['entry_city']);
    $entry_country_id = xtc_db_input($_POST['entry_country_id']);

    $entry_company = xtc_db_input($_POST['entry_company']);
    $entry_state = xtc_db_input($_POST['entry_state']);
    $entry_zone_id = xtc_db_input($_POST['entry_zone_id']);

    $customers_send_mail = xtc_db_input($_POST['customers_mail']);
    $customers_password = xtc_db_input($_POST['entry_password']);

    $customers_mail_comments = xtc_db_input($_POST['mail_comments']);

    if ($customers_password == '') {
        $customers_password = xtc_create_password(8);
    }
    $error = false; // reset error flag


    if (ACCOUNT_GENDER == 'true') {
        if ( ($customers_gender != 'm') and ($customers_gender != 'f') ) {
            $error = true;
            $entry_gender_error = true;
        } else {
            $entry_gender_error = false;
        }
    }
    if (strlen($customers_password) < ENTRY_PASSWORD_MIN_LENGTH) {
        $error = true;
        $entry_password_error = true;
    } else {
        $entry_password_error = false;
    }

    if ( ($customers_send_mail != 'yes') && ($customers_send_mail != 'no')) {
        $error = true;
        $entry_mail_error = true;
    } else {
        $entry_mail_error = false;
    }		

    if (strlen($customers_firstname) < ENTRY_FIRST_NAME_MIN_LENGTH) {
        $error = true;
        $entry_firstname_error = true;
    } else {
        $entry_firstname_error = false;
    }

    if (strlen($customers_lastname) < ENTRY_LAST_NAME_MIN_LENGTH) {
        $error = true;
        $entry_lastname_error = true;
    } else {
        $entry_lastname_error = false;
    }

    if (ACCOUNT_DOB == 'true') {
        if (DateTime::createFromFormat('Y-m-d', $customers_dob) !== false) {
            $entry_date_of_birth_error = false;
        } else {
            $error = true;
            $entry_date_of_birth_error = true;
        }
    }

    // Vat Check
    if(xtc_get_geo_zone_code($entry_country_id) != '6'){
        if ($customers_vat_id !=''){
            if (ACCOUNT_COMPANY_VAT_CHECK == 'true') {
                $validate_vatid = validate_vatid($customers_vat_id);
                if ($validate_vatid == '0') {
                    if (ACCOUNT_VAT_BLOCK_ERROR == 'true'){
                        $entry_vat_error = true;
                        $error = true;
                    }
                    $customers_vat_id_status  = '0';
                }
                if($validate_vatid == '1') {
                    $customers_vat_id_status  = '1';
                }
                if($validate_vatid == '8'){
                    if (ACCOUNT_VAT_BLOCK_ERROR == 'true'){
                        $entry_vat_error = true;
                        $error = true;
                    }
                    $customers_vat_id_status  = '8';
                }
                if($validate_vatid == '9'){
                    if (ACCOUNT_VAT_BLOCK_ERROR == 'true'){
                        $entry_vat_error = true;
                        $error = true;
                    }
                    $customers_vat_id_status  = '9';
                }
            }
        }
    }
    // Vat Check

    if (strlen($customers_email_address) < ENTRY_EMAIL_ADDRESS_MIN_LENGTH) {
        $error = true;
        $entry_email_address_error = true;
    } else {
        $entry_email_address_error = false;
    }

    if (!xtc_validate_email($customers_email_address)) {
        $error = true;
        $entry_email_address_check_error = true;
    } else {
        $entry_email_address_check_error = false;
    }

    if (strlen($entry_street_address) < ENTRY_STREET_ADDRESS_MIN_LENGTH) {
        $error = true;
        $entry_street_address_error = true;
    } else {
        $entry_street_address_error = false;
    }

    if (strlen($entry_postcode) < ENTRY_POSTCODE_MIN_LENGTH) {
        $error = true;
        $entry_post_code_error = true;
    } else {
        $entry_post_code_error = false;
    }

    if (strlen($entry_city) < ENTRY_CITY_MIN_LENGTH) {
        $error = true;
        $entry_city_error = true;
    } else {
        $entry_city_error = false;
    }

    if ($entry_country_id == false) {
        $error = true;
        $entry_country_error = true;
    } else {
        $entry_country_error = false;
    }

    if (ACCOUNT_STATE == 'true') {
        if ($entry_country_error == true) {
            $entry_state_error = true;
        } else {
            $zone_id = 0;
            $entry_state_error = false;
            $check_query = xtc_db_query("select count(*) as total from " . TABLE_ZONES . " where zone_country_id = '" . (int)$entry_country_id . "'");
            $check_value = xtc_db_fetch_array($check_query);
            $entry_state_has_zones = ($check_value['total'] > 0);
            if ($entry_state_has_zones == true) {
                $zone_query = xtc_db_query("select zone_id from " . TABLE_ZONES . " where zone_country_id = '" . (int)$entry_country_id . "' and zone_name = '" . $entry_state . "'");
                if (xtc_db_num_rows($zone_query) == 1) {
                    $zone_values = xtc_db_fetch_array($zone_query);
                    $entry_zone_id = $zone_values['zone_id'];
                } else {
                    $zone_query = xtc_db_query("select zone_id from " . TABLE_ZONES . " where zone_country_id = '" . (int)$entry_country_id . "' and zone_code = '" . $entry_state . "'");
                    if (xtc_db_num_rows($zone_query) >= 1) {
                        $zone_values = xtc_db_fetch_array($zone_query);
                        $zone_id = $zone_values['zone_id'];
                    } else {
                        $error = true;
                        $entry_state_error = true;
                    }
                }
            } else {
                if ($entry_state == false) {
                    $error = true;
                    $entry_state_error = true;
                }
            }
        }
    }

    if (strlen($customers_telephone) < ENTRY_TELEPHONE_MIN_LENGTH) {
        $error = true;
        $entry_telephone_error = true;
    } else {
        $entry_telephone_error = false;
    }

    $check_email = xtc_db_query("select customers_email_address from " . TABLE_CUSTOMERS . " where customers_email_address = '" . xtc_db_input($customers_email_address) . "' and customers_id <> '" . (int)xtc_db_input($customers_id) . "'");
    if (xtc_db_num_rows($check_email)) {
        $error = true;
        $entry_email_address_exists = true;
    } else {
        $entry_email_address_exists = false;
    }
	    
    if ($error == false) {
        yes_remove_customers_email_alias($customers_email_address,$_SESSION['customer_id']);
        $sql_data_array = array(
            'customers_status' => intval($customers_status_c),
            'customers_cid' => $customers_cid,
            'customers_vat_id' => $customers_vat_id,
            'customers_vat_id_status' => intval($customers_vat_id_status),
            'customers_firstname' => $customers_firstname,
            'customers_lastname' => $customers_lastname,
            'customers_email_address' => $customers_email_address,
            'customers_telephone' => $customers_telephone,
            'mobile' => $mobile,
            'customers_fax' => $customers_fax,
            'customers_password' => xtc_encrypt_password($customers_password)
        );

        if (ACCOUNT_GENDER == 'true') {
            $sql_data_array['customers_gender'] = $customers_gender;
        }
        if (ACCOUNT_DOB == 'true') {
            $sql_data_array['customers_dob'] = $customers_dob;
        }
        $new = new \YES4Trade\Model\customers($sql_data_array);
        $cc_id = $new->create();

        // history
        $new = new \YES4Trade\Model\customers_memo([
            'customers_id'=>(int)$cc_id,
            'memo_date'=>date('Y-m-d'),
            'memo_title'=>'User angelegt',
            'memo_text'=>'Im YES System Adminbereich angelegt.',
            'poster_id'=>intval($_SESSION['customer_id'])
        ]);
        $new->create();
        

        $sql_data_array = array(
            'customers_id' => (int)$cc_id,
            'entry_firstname' => $customers_firstname,
            'entry_lastname' => $customers_lastname,
            'entry_street_address' => $entry_street_address,
            'entry_postcode' => $entry_postcode,
            'entry_city' => $entry_city,
            'entry_country_id' => (int)$entry_country_id
        );

        if (ACCOUNT_GENDER == 'true') {
            $sql_data_array['entry_gender'] = $customers_gender;
        }
        if (ACCOUNT_COMPANY == 'true') {
            $sql_data_array['entry_company'] = $entry_company;
        }
        if (ACCOUNT_SUBURB == 'true') {
            $sql_data_array['entry_suburb'] = $entry_suburb;
        }
        if (ACCOUNT_STATE == 'true') {
            if ($zone_id > 0) {
                $sql_data_array['entry_zone_id'] = (int)$entry_zone_id;
                $sql_data_array['entry_state'] = '';
            } else {
                $sql_data_array['entry_zone_id'] = 0;
                $sql_data_array['entry_state'] = $entry_state;
            }
        }
        $new = new \YES4Trade\Model\address_book($sql_data_array);
        $address_id = $new->create();
        
        $upd = new \YES4Trade\Model\customers([
            'customers_id'=>intval($cc_id),
            'customers_default_address_id'=>intval($address_id)
        ]);
        $upd->update();

        $new = new \YES4Trade\Model\customers_info([
            'customers_info_id'=>intval($cc_id), 
            'customers_info_number_of_logons'=>0, 
            'customers_info_date_account_created'=>date('Y-m-d H:i:s')
        ]);
        $new->create();
        
        // Create insert into admin access table if admin is created.
        if ($customers_status_c=='0') {
            xtc_db_query("INSERT into ".TABLE_ADMIN_ACCESS." (customers_id,start) VALUES ('".$cc_id."','1')");
            $key = 'admin_access';
            $InstanceCache->deleteItem($key); // admin_access
        }

        // Create eMail
        if ($customers_send_mail == 'yes' and !main::isDev(true)) {
            $smarty->assign('NAME',$customers_lastname . ' ' . $customers_firstname);
            $smarty->assign('EMAIL',$customers_email_address);
            $smarty->assign('COMMENTS',$customers_mail_comments);
            $smarty->assign('PASSWORD',$customers_password);
            $smarty->assign('STORE_NAME_ADDRESS',STORE_NAME_ADDRESS);
            $smarty->assign('STORE_NAME',STORE_NAME);

            $html_mail=$smarty->fetch(CURRENT_TEMPLATE . '/admin/mail/'.$_SESSION['language'].'/create_account_mail.html');
            $txt_mail=$smarty->fetch(CURRENT_TEMPLATE . '/admin/mail/'.$_SESSION['language'].'/create_account_mail.txt');
            xtc_php_mail(EMAIL_SUPPORT_ADDRESS,EMAIL_SUPPORT_NAME,$customers_email_address , $customers_lastname . ' ' . $customers_firstname , EMAIL_SUPPORT_FORWARDING_STRING, EMAIL_SUPPORT_REPLY_ADDRESS, EMAIL_SUPPORT_REPLY_ADDRESS_NAME, '', '', EMAIL_SUPPORT_SUBJECT, $html_mail , $txt_mail);
        }
        $messageStack->add_session('Kunde wurde angelegt mit der ID '.$cc_id,'success');
        xtc_redirect(xtc_href_link(FILENAME_CUSTOMERS, 'cID=' . $cc_id.'&action=edit'));
    }
}else{
    $customers_password = xtc_create_password(8);
}
yes_draw_pre_header();
yes_draw_header(TITLE);
$password_field_name = xtc_create_password(8);
echo xtc_draw_form('customers', FILENAME_CREATE_ACCOUNT, xtc_get_all_get_params(array('action')) . 'action=edit', 'post', 'onSubmit="return check_form();"') . xtc_draw_hidden_field('default_address_id', $customers_default_address_id); 
echo xtc_draw_hidden_field('entry_password',$password_field_name);
$db_ini = yes_get_database_table_ini();
$len = array(
    'fn'=>yes_get_database_table_field_length($db_ini, TABLE_CUSTOMERS, 'customers_firstname'),
    'ln'=>yes_get_database_table_field_length($db_ini, TABLE_CUSTOMERS, 'customers_lastname'),
    'dob'=>yes_get_database_table_field_length($db_ini, TABLE_CUSTOMERS, 'customers_dob'),
    'em'=>yes_get_database_table_field_length($db_ini, TABLE_CUSTOMERS, 'customers_email_address'),
    'vat'=>yes_get_database_table_field_length($db_ini, TABLE_CUSTOMERS, 'customers_vat_id'),
    'te'=>yes_get_database_table_field_length($db_ini, TABLE_CUSTOMERS, 'customers_telephone'),
    'fax'=>yes_get_database_table_field_length($db_ini, TABLE_CUSTOMERS, 'customers_fax'),
    'mo'=>yes_get_database_table_field_length($db_ini, TABLE_CUSTOMERS, 'mobile'),
    'cid'=>yes_get_database_table_field_length($db_ini, TABLE_CUSTOMERS, 'customers_cid'),
    'co'=>yes_get_database_table_field_length($db_ini, TABLE_ADDRESS_BOOK, 'entry_company'),
    'st'=>yes_get_database_table_field_length($db_ini, TABLE_ADDRESS_BOOK, 'entry_street_address'),
    'su'=>yes_get_database_table_field_length($db_ini, TABLE_ADDRESS_BOOK, 'entry_suburb'),
    'po'=>yes_get_database_table_field_length($db_ini, TABLE_ADDRESS_BOOK, 'entry_postcode'),
    'ci'=>yes_get_database_table_field_length($db_ini, TABLE_ADDRESS_BOOK, 'entry_city'),
    'sta'=>yes_get_database_table_field_length($db_ini, TABLE_ADDRESS_BOOK, 'entry_state'),
);
if ($error === true) {
    if ($entry_firstname_error == true) {
      $input_ca_firstname = xtc_draw_input_field('customers_firstname', $customers_firstname, 'maxlength="'.$len['fn'].'"') . '&nbsp;' . ENTRY_FIRST_NAME_ERROR;
    } else {
      $input_ca_firstname = xtc_draw_input_field('customers_firstname', $customers_firstname, 'maxlength="'.$len['fn'].'"');
    }
    if ($entry_lastname_error == true) {
      $input_ca_lastname = xtc_draw_input_field('customers_lastname', $customers_lastname, 'maxlength="'.$len['ln'].'"') . '&nbsp;' . ENTRY_LAST_NAME_ERROR;
    } else {
      $input_ca_lastname = xtc_draw_input_field('customers_lastname', $customers_lastname, 'maxlength="'.$len['ln'].'"');
    }
    if(ACCOUNT_DOB == 'true'){
      if ($entry_date_of_birth_error == true) {
        $input_ca_dob = xtc_draw_input_field('customers_dob', xtc_date_short($customers_dob), 'maxlength="'.$len['dob'].'"',false,'date') . '&nbsp;' . ENTRY_DATE_OF_BIRTH_ERROR;
      } else {
        $input_ca_dob = xtc_draw_input_field('customers_dob', xtc_date_short($customers_dob), 'maxlength="'.$len['dob'].'"',false,'date');
      }
    }
    if ($entry_email_address_error == true) {
	$input_ca_email_address = xtc_draw_input_field('customers_email_address', $customers_email_address, 'maxlength="'.$len['em'].'"') . '&nbsp;' . ENTRY_EMAIL_ADDRESS_ERROR;
    } elseif ($entry_email_address_check_error == true) {
	$input_ca_email_address = xtc_draw_input_field('customers_email_address', $customers_email_address, 'maxlength="'.$len['em'].'"') . '&nbsp;' . ENTRY_EMAIL_ADDRESS_CHECK_ERROR;
    } elseif ($entry_email_address_exists == true) {
	$input_ca_email_address = xtc_draw_input_field('customers_email_address', $customers_email_address, 'maxlength="'.$len['em'].'"') . '&nbsp;' . ENTRY_EMAIL_ADDRESS_ERROR_EXISTS;
    } else {
	$input_ca_email_address = xtc_draw_input_field('customers_email_address', $customers_email_address, 'maxlength="'.$len['em'].'"');
    }
    if ($entry_company_error == true) {
      $input_ca_company = xtc_draw_input_field('entry_company', $entry_company, 'maxlength="'.$len['co'].'"') . '&nbsp;' . ENTRY_COMPANY_ERROR;
    } else {
      $input_ca_company = xtc_draw_input_field('entry_company', $entry_company, 'maxlength="'.$len['co'].'"');
    }
    if ($entry_vat_error == true) {
      $input_ca_vat_id = xtc_draw_input_field('customers_vat_id', $customers_vat_id, 'maxlength="'.$len['vat'].'"') . '&nbsp;' . ENTRY_VAT_ERROR;
    } else {
      $input_ca_vat_id = xtc_draw_input_field('customers_vat_id', $customers_vat_id, 'maxlength="'.$len['vat'].'"');
    }
    if ($entry_gender_error == true) {
      $input_ca_gender = xtc_draw_radio_field('customers_gender', 'm', false, $customers_gender) . '&nbsp;&nbsp;' . MALE . '&nbsp;&nbsp;' . xtc_draw_radio_field('customers_gender', 'f', false, $customers_gender) . '&nbsp;&nbsp;' . FEMALE . '&nbsp;' . ENTRY_GENDER_ERROR;
    } else {
      $input_ca_gender = ($customers_gender == 'm') ? MALE : FEMALE;
      $input_ca_gender .= xtc_draw_radio_field('customers_gender', 'm', false, $customers_gender) . '&nbsp;&nbsp;' . MALE . '&nbsp;&nbsp;' . xtc_draw_radio_field('customers_gender', 'f', false, $customers_gender) . '&nbsp;&nbsp;' . FEMALE;
    }
    if ($entry_street_address_error == true) {
      $input_ca_street = xtc_draw_input_field('entry_street_address', $entry_street_address, 'maxlength="'.$len['st'].'"') . '&nbsp;' . ENTRY_STREET_ADDRESS_ERROR;
    } else {
      $input_ca_street = xtc_draw_input_field('entry_street_address', $entry_street_address, 'maxlength="'.$len['st'].'"');
    }
    if ($entry_suburb_error == true) {
      $input_ca_suburb = xtc_draw_input_field('suburb', $entry_suburb, 'maxlength="'.$len['su'].'"') . '&nbsp;' . ENTRY_SUBURB_ERROR;
    } else {
      $input_ca_suburb = xtc_draw_input_field('entry_suburb', $entry_suburb, 'maxlength="'.$len['su'].'"');
    }
    if ($entry_post_code_error == true) {
      $input_ca_post_code = xtc_draw_input_field('entry_postcode', $entry_postcode, 'maxlength="'.$len['po'].'"') . '&nbsp;' . ENTRY_POST_CODE_ERROR;
    } else {
      $input_ca_post_code = xtc_draw_input_field('entry_postcode', $entry_postcode, 'maxlength="'.$len['po'].'"');
    }
    if ($entry_city_error == true) {
      $input_ca_city = xtc_draw_input_field('entry_city', $entry_city, 'maxlength="'.$len['ci'].'"') . '&nbsp;' . ENTRY_CITY_ERROR;
    } else {
      $input_ca_city = xtc_draw_input_field('entry_city', $entry_city, 'maxlength="'.$len['ci'].'"');
    }
    if(ACCOUNT_STATE == 'true'){
      if ($entry_state_error == true) {
        if ($entry_state_has_zones == true) {
          $zones_array = array();
          $zones_query = xtc_db_query("select zone_name from " . TABLE_ZONES . " where zone_country_id = '" . xtc_db_input($entry_country_id) . "' order by zone_name");
          while ($zones_values = xtc_db_fetch_array($zones_query)) {
            $zones_array[] = array('id' => $zones_values['zone_name'], 'text' => $zones_values['zone_name']);
          }
          $input_ca_state = xtc_draw_pull_down_menu('entry_state', $zones_array) . '&nbsp;' . ENTRY_STATE_ERROR;
        } else {
          $input_ca_state = xtc_draw_input_field('entry_state', xtc_get_zone_name($entry_country_id, $entry_zone_id, $entry_state),'maxlength="'.$len['sta'].'"') . '&nbsp;' . ENTRY_STATE_ERROR;
        }
      } else {
        $input_ca_state = xtc_draw_input_field('entry_state', xtc_get_zone_name($entry_country_id, $entry_zone_id, $entry_state),'maxlength="'.$len['sta'].'"');
      }
    } // end if account state
    if ($entry_country_error == true) {
      $input_ca_country = xtc_draw_pull_down_menu('entry_country_id', xtc_get_countries(xtc_get_country_name(STORE_COUNTRY)), $entry_country_id) . '&nbsp;' . ENTRY_COUNTRY_ERROR;
    } else {
      $input_ca_country = xtc_draw_pull_down_menu('entry_country_id', xtc_get_countries(xtc_get_country_name(STORE_COUNTRY)), $entry_country_id);
    }
    if ($entry_telephone_error == true) {
      $input_ca_tel = xtc_draw_input_field('customers_telephone',$customers_telephone,'maxlength="'.$len['te'].'"') . '&nbsp;' . ENTRY_TELEPHONE_NUMBER_ERROR;
    } else {
      $input_ca_tel = xtc_draw_input_field('customers_telephone', $customers_telephone,'maxlength="'.$len['te'].'"');
    }
    if ($entry_password_error == true) {
	$input_ca_password .= xtc_draw_password_field($password_field_name, $customers_password) . '&nbsp;' . ENTRY_PASSWORD_ERROR;
    } else {
	$input_ca_password .= xtc_draw_password_field($password_field_name, $customers_password);
    }
    if ($entry_mail_error == true) {
	$input_ca_email = xtc_draw_radio_field('customers_mail', 'yes', false, $customers_send_mail) . '&nbsp;&nbsp;' . YES . '&nbsp;&nbsp;' . xtc_draw_radio_field('customers_mail', 'no', true, $customers_send_mail) . '&nbsp;&nbsp;' . NO . '&nbsp;' . ENTRY_MAIL_ERROR;
    } else {
	$input_ca_email .= xtc_draw_radio_field('customers_mail', 'yes', false, $customers_send_mail) . '&nbsp;&nbsp;' . YES . '&nbsp;&nbsp;' . xtc_draw_radio_field('customers_mail', 'no', true, $customers_send_mail) . '&nbsp;&nbsp;' . NO;
    }
} else {
  $input_ca_firstname = xtc_draw_input_field('customers_firstname', $customers_firstname, 'maxlength="'.$len['fn'].'"');
  $input_ca_lastname = xtc_draw_input_field('customers_lastname', $customers_lastname, 'maxlength="'.$len['ln'].'"');
  if(ACCOUNT_DOB == 'true'){
      $input_ca_dob = xtc_draw_input_field('customers_dob', $customers_dob, 'maxlength="'.$len['dob'].'"',false,'date');
  }
  $input_ca_email_address = xtc_draw_input_field('customers_email_address', $customers_email_address, 'maxlength="'.$len['em'].'"');
  if(ACCOUNT_COMPANY == 'true'){
    $input_ca_company = xtc_draw_input_field('entry_company', $entry_company, 'maxlength="'.$len['co'].'"');
  }
  if(ACCOUNT_COMPANY_VAT_CHECK == 'true'){
    $input_ca_vat_id = xtc_draw_input_field('customers_vat_id', $customers_vat_id, 'maxlength="'.$len['vat'].'"');
  }
  $input_ca_gender = xtc_draw_radio_field('customers_gender', 'm', false, $customers_gender) . '&nbsp;&nbsp;' . MALE . '&nbsp;&nbsp;' . xtc_draw_radio_field('customers_gender', 'f', false, $customers_gender) . '&nbsp;&nbsp;' . FEMALE;
  $input_ca_street = xtc_draw_input_field('entry_street_address', $entry_street_address, 'maxlength="'.$len['st'].'"');
  $input_ca_suburb = xtc_draw_input_field('entry_suburb', $entry_suburb, 'maxlength="'.$len['su'].'"');
  $input_ca_post_code = xtc_draw_input_field('entry_postcode', $entry_postcode, 'maxlength="'.$len['po'].'"');
  $input_ca_city = xtc_draw_input_field('entry_city', $entry_city, 'maxlength="'.$len['ci'].'"');
  if(ACCOUNT_STATE == 'true'){
    $input_ca_state = xtc_draw_input_field('entry_state', xtc_get_zone_name($entry_country_id, $entry_zone_id, $entry_state),'maxlength="'.$len['sta'].'"');
  }
  $input_ca_country = xtc_draw_pull_down_menu('entry_country_id', xtc_get_countries(xtc_get_country_name(STORE_COUNTRY)), $entry_country_id);
  $input_ca_tel = xtc_draw_input_field('customers_telephone', $customers_telephone,'maxlength="'.$len['te'].'"');
  $input_ca_password .= xtc_draw_password_field($password_field_name, $customers_password);
  $input_ca_email = xtc_draw_radio_field('customers_mail', 'yes', false, $customers_send_mail) . '&nbsp;&nbsp;' . YES . '&nbsp;&nbsp;' . xtc_draw_radio_field('customers_mail', 'no', true, $customers_send_mail) . '&nbsp;&nbsp;' . NO;
}
$input_blocks = array();
$input_blocks['CATEGORY_PERSONAL'] = array('title'=>CATEGORY_PERSONAL,'blocks'=>array());
if (ACCOUNT_GENDER == 'true') {
    $input_blocks['CATEGORY_PERSONAL']['blocks'][] = array(
	'input'=>$input_ca_gender,
	'text'=>ENTRY_GENDER
    );
}
$input_blocks['CATEGORY_PERSONAL']['blocks'][] = array(
	'text'=>ENTRY_CID,
	'input'=>xtc_draw_input_field('csID', $customers_cid, 'maxlength="'.$len['cid'].'"')
);
$input_blocks['CATEGORY_PERSONAL']['blocks'][] = array(
    'text'=>ENTRY_FIRST_NAME,
    'input'=>$input_ca_firstname
);
$input_blocks['CATEGORY_PERSONAL']['blocks'][] = array(
    'text'=>ENTRY_LAST_NAME,
    'input'=>$input_ca_lastname
);
if (ACCOUNT_DOB == 'true') {
    $input_blocks['CATEGORY_PERSONAL']['blocks'][] = array(
	'text'=>ENTRY_DATE_OF_BIRTH,
	'input'=>$input_ca_dob
    );
}
$input_blocks['CATEGORY_PERSONAL']['blocks'][] = array(
    'text'=>ENTRY_EMAIL_ADDRESS,
    'input'=>$input_ca_email_address.'&nbsp;<a href="#" onClick="genmail();">[Emailadresse vorschlagen]</a>'
);

if (ACCOUNT_COMPANY == 'true') {
    $input_blocks['CATEGORY_COMPANY'] = array('title'=>CATEGORY_COMPANY,'blocks'=>array(
	array('text'=>ENTRY_COMPANY,'input'=>$input_ca_company)
    ));
    if (ACCOUNT_COMPANY_VAT_CHECK == 'true') {
	$input_blocks['CATEGORY_COMPANY']['blocks'][] = array(
	    'text'=>ENTRY_VAT_ID,
	    'input'=>$input_ca_vat_id
	);
    }
}


$entry_state = xtc_get_zone_name($entry_country_id, $entry_zone_id, $entry_state);
if ($processed == true) {
    $input_ca_status = xtc_draw_hidden_field('status');
} else {
    if ( $_SESSION['customer_id'] === '1' ) {
	$input_ca_status = xtc_draw_pull_down_menu('status', array_merge(array(array('id'=>'','text'=>TEXT_SELECT)),$customers_statuses_array),'');
    }else{
    	$limited = array(array('id'=>'','text'=>TEXT_SELECT));
	$count = 0;
	foreach($customers_statuses_array as $k=>$cv){
		if($cv['id'] > 0){
			$limited[$count]=$cv;
		    $count++;
		}
	}
	$input_ca_status = xtc_draw_pull_down_menu('status', $limited,'');
    }
}





$input_blocks['CATEGORY_ADDRESS'] = array('title'=>CATEGORY_ADDRESS,'blocks'=>array(
    array('text'=>ENTRY_STREET_ADDRESS,'input'=>$input_ca_street)
));
if (ACCOUNT_SUBURB == 'true') {
    $input_blocks['CATEGORY_ADDRESS']['blocks'][] = array(
	'text'=>ENTRY_SUBURB,'input'=>$input_ca_suburb
    );
}
$input_blocks['CATEGORY_ADDRESS']['blocks'][] = array(
    'text'=>ENTRY_POST_CODE,'input'=>$input_ca_post_code
);
$input_blocks['CATEGORY_ADDRESS']['blocks'][] = array(
    'text'=>ENTRY_CITY,'input'=>$input_ca_city
);
if (ACCOUNT_STATE == 'true') {
    $input_blocks['CATEGORY_ADDRESS']['blocks'][] = array(
	'text'=>ENTRY_STATE,'input'=>$input_ca_state
    );
}
$input_blocks['CATEGORY_ADDRESS']['blocks'][] = array(
    'text'=>ENTRY_COUNTRY,'input'=>$input_ca_country
);
$input_blocks['CATEGORY_CONTACT'] = array('title'=>CATEGORY_CONTACT,'blocks'=>array(
    array('text'=>ENTRY_TELEPHONE_NUMBER,'input'=>$input_ca_tel),
    array('text'=>ENTRY_FAX_NUMBER,'input'=>xtc_draw_input_field('customers_fax','','maxlength="'.$len['fax'].'"')),
    array('text'=>'Mobilnr.','input'=>xtc_draw_input_field('mobile', ((isset($mobile) and $mobile != '') ? $mobile : ''), 'maxlength="'.$len['mo'].'"', false, 'text', false))
));
$input_blocks['CATEGORY_OPTIONS'] = array('title'=>CATEGORY_OPTIONS,'blocks'=>array(
    array('text'=>ENTRY_CUSTOMERS_STATUS,'input'=>$input_ca_status),
    array('text'=>ENTRY_MAIL,'input'=>$input_ca_email),
    array('text'=>ENTRY_PASSWORD,'input'=>$input_ca_password),
    array('text'=>ENTRY_MAIL_COMMENTS,'input'=>xtc_draw_textarea_field('mail_comments', 'soft', '60', '5', $mail_comments)),
));
$split_email = split('@', STORE_OWNER_EMAIL_ADDRESS);
$smarty->assign(array(
   'FORM' => xtc_draw_form('customers', FILENAME_CREATE_ACCOUNT, xtc_get_all_get_params(array('action')) . 'action=edit', 'post', 'onSubmit="return check_form();"') . xtc_draw_hidden_field('default_address_id', $customers_default_address_id),
    'INPUT_HIDDEN_PASSWORD'=>xtc_draw_hidden_field('entry_password',$password_field_name),
    'genmail_domain'=>$split_email[1],
    'HEADING_TITLE'=>HEADING_TITLE,
    'PAGE_HEADING_MENU_BUTTONS'=>array(),
    'INPUT_BLOCKS'=>$input_blocks,
    'JS_ERROR_NO_CUSTOMERS_STATUS_SELECTED'=>JS_ERROR_NO_CUSTOMERS_STATUS_SELECTED,
));
$smarty->display(DIR_FS_ADMIN.'templates/create_account.html');
require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');
