<?php
if(php_sapi_name() !== 'cli' and php_sapi_name() !== 'cgi' and php_sapi_name() !== 'cgi-fcgi'){
	die('unauthorized call');
}
die('KEIN AMAZON SP');
include('includes/cron_application_top.php');
function amazon_get_request_error_msg($ex){
	return sprintf("Caught Exception: %s<br />Response Status Code: %s<br />Error Code: %s<br />Error Type: %s<br />Request ID: %s<br /><pre>%s</pre>",
			$ex->getMessage(),
			$ex->getStatusCode(),
			$ex->getErrorCode(),
			$ex->getErrorType(),
			$ex->getRequestId(),
			htmlentities($ex->getXML())
	);
}
$_SESSION['language'] = 'german';
$_SESSION['languages_id'] = 2;
include('includes/config.amazonmws.inc.php');
require_once('includes/classes/class.basics.php');
include('includes/classes/amz_Helper.php');
include('includes/classes/amz_ReportList.php');
include('includes/classes/amz_Service.php');
include('includes/classes/amz_SubmitFeed.php');
require_once('includes/classes/product.php');
include('includes/classes/simple_lock.php');
// NEUES HANDLING
//require_once(DIR_FS_CATALOG.DIR_WS_CLASSES.'class.phpmailer.php');
require_once(DIR_FS_CATALOG.DIR_WS_CLASSES.'xtcPrice.php');
$lock = new simple_lock(\main::get_exportdata_path().basename($argv[0]).'.LOCK');
$lock->lock();

require_once(DIR_FS_INC . 'yes_write_notice.inc.php');
require_once(DIR_FS_INC . 'xtc_encrypt_password.inc.php');
require_once(DIR_FS_INC . 'xtc_get_customer_status_value.inc.php');
require_once(DIR_FS_INC . 'xtc_get_serial_number.inc.php');
require_once(DIR_FS_CATALOG . 'lang/'.$_SESSION['language'].'/modules/order_total/ot_subtotal.php');
require_once(DIR_FS_CATALOG . 'lang/'.$_SESSION['language'].'/modules/order_total/ot_total.php');
require_once(DIR_FS_CATALOG . 'lang/'.$_SESSION['language'].'/admin/amazon.php');

$exportdata_path = \main::get_exportdata_path();
define('AMAZON_SAVE_PATH',$exportdata_path.'amazon/');
define('AMAZON_REPORTLIST_MAX_COUNT',80);
define('AMAZON_ADDRESS_FORMAT_ID',5);
define('MARKETPLACE_ID',MODULE_OTHER_AMAZON_MARKETPLACE_ID);
define('MERCHANT_ID',MODULE_OTHER_AMAZON_MERCHANT_ID);
if(!is_dir(AMAZON_SAVE_PATH))
	mkdir(AMAZON_SAVE_PATH);
$basics = new basics;
$A = new amazon_helper;


// BOF - BEI JEDEM CRON AUFRUF EINEN ANDEREN USER
$auth_user_array = $A->get_auth_user_array();
if(sizeOf($auth_user_array) > 1){
	$toggle_merchant_file = \main::get_exportdata_path().'CRON_AMAZON_GET_FLAT_FILE_ORDERS_DATA.TOGGLE';
	if(!is_file($toggle_merchant_file)){
		file_put_contents($toggle_merchant_file,'0');
	}
	$merchant_nr = (int)file_get_contents($toggle_merchant_file);
	$mercID = $auth_user_array[$merchant_nr];
	$new_merchant_nr = (($merchant_nr+1) >= sizeOf($auth_user_array)) ? 0 : $merchant_nr+1;
	file_put_contents($toggle_merchant_file,$new_merchant_nr);
}else{
	$mercID = $auth_user_array[0];
}
// EOF - BEI JEDEM CRON AUFRUF EINEN ANDEREN USER

$AS = new amazon_service();
$service = $AS->get_service();
$auth_params = $A->get_auth_data_array($mercID);
if(isset($argv[1]) and $argv[1] == 'getreport'){
	$request = new MarketplaceWebService_Model_RequestReportRequest();
	$request->setMarketplace($auth_params['marketplace_id']);
	$request->setMerchant($auth_params['merchant_id']);
	if(!empty($auth_params['mwsauthtoken'])){
	    $request->setMWSAuthToken($auth_params['mwsauthtoken']);
	}
	$request->setReportType('_GET_FLAT_FILE_ORDERS_DATA_');
	$request->setEndDate(new DateTime('now'));
	$request->setStartDate(new DateTime('-1 day'));
	$response = $service->requestReport($request);
	print_r($response);
	$lock->destroy();
	exit;
}

$parameters = array (
    'Marketplace' => $auth_params['marketplace_id'],
    'Merchant' => $auth_params['merchant_id'],
    'AvailableToDate' => new DateTime('now'),
    'AvailableFromDate' => new DateTime('-1 days'),
    'ReportTypeList'=>array ('Type' => array ('_GET_ORDERS_DATA_')),
    'MaxCount' => AMAZON_REPORTLIST_MAX_COUNT,
    'Acknowledged' => false
);
if(!empty($auth_params['mwsauthtoken'])){
    $parameters['MWSAuthToken'] = $auth_params['mwsauthtoken'];
}

$RL = new ReportList;
$request = new MarketplaceWebService_Model_GetReportListRequest($parameters);
$items = $RL->invokeGetReportList($service, $request);
foreach($items as $item){
	$reportId = $item['ID'];
	$parameters = array (
	    'Marketplace' => $auth_params['marketplace_id'],
	    'Merchant' => $auth_params['merchant_id'],
	    'Report' => @fopen('php://memory', 'rw+'),
	    'ReportId' => $reportId
	);
	if(!empty($auth_params['mwsauthtoken'])){
	    $parameters['MWSAuthToken'] = $auth_params['mwsauthtoken'];
	}
	printf("\r\n\r\nCHECKING REPORT ID %s\r\n",$reportId);
	$R = new Report;
	$R->setReportType('_GET_ORDERS_DATA_');
	$request = new MarketplaceWebService_Model_GetReportRequest($parameters);
	$orders = $R->invokeGetReport($service, $request);
	$orders_created_array = array();
	foreach($orders as $order){
		if($R->is_order_processed($order)){
			printf("  Amazon Order %s existiert.\r\n",$order['order_id']);
		}else{
			printf("  Amazon Order %s noch nicht importiert.\r\n",$order['order_id']);
			$orders_created_array = array_merge($orders_created_array,$R->import_order($order,true));
			//printf("    YES Auftrag %s wurde angelegt.\r\n",implode(', ',$yes_orders_id));
		}
	}
	if(sizeOf($orders_created_array)){
		// BESTELLBESTAETIGUNG AN AMAZON
		$SF = new SubmitFeed();
		$feed = $SF->getOrderAcknowledgementFeed($orders_created_array);
		$FeedType = '_POST_ORDER_ACKNOWLEDGEMENT_DATA_';

		$service = $AS->get_service();
		$feed = $feed->asXML();
		$feedHandle = @fopen('php://memory', 'rw+');
		fwrite($feedHandle, $feed);
		rewind($feedHandle);
		$parameters = array (
		    'Marketplace' => $auth_params['marketplace_id'],
		    'Merchant' => $auth_params['merchant_id'],
		    'FeedType' => $FeedType,
		    'FeedContent' => $feedHandle,
		    'PurgeAndReplace' => false,
		    'ContentMd5' => base64_encode(md5(stream_get_contents($feedHandle), true))
		);
		if(!empty($auth_params['mwsauthtoken'])){
		    $parameters['MWSAuthToken'] = $auth_params['mwsauthtoken'];
		}
		$request = new MarketplaceWebService_Model_SubmitFeedRequest($parameters);
		$result = $SF->invokeSubmitFeed($service, $request);
		fclose($feedHandle);
		printf(" Auftraege wurden an Amazon als eingelesen gemeldet");
	}
}
echo "Es wurden ".sizeOf($items)." Datensaetze durchlaufen\r\n";
$lock->destroy();
