<?php
include('includes/cron_application_top.php');
include('includes/config.amazonmws.inc.php');
include('includes/classes/amz_ReportList.php');
include('includes/classes/amz_Service.php');
include('includes/classes/amz_Helper.php');
include('includes/classes/amz_SubmitFeed.php');
include('includes/classes/amz_Feedhandler.php');
include('includes/classes/amz_Sync.php');
require_once('includes/classes/product.php');
require_once('includes/classes/class.basics.php');
ini_set('memory_limit','1200M');
$exportdata_path = \main::get_exportdata_path();
define('AMAZON_SAVE_PATH',$exportdata_path.'amazon/');
define('AMAZON_REPORTLIST_MAX_COUNT',80);
define('AMAZON_ADDRESS_FORMAT_ID',5);
define('MARKETPLACE_ID',MODULE_OTHER_AMAZON_MARKETPLACE_ID);
define('MERCHANT_ID',MODULE_OTHER_AMAZON_MERCHANT_ID);
function amazon_get_request_error_msg($ex){
	return sprintf("Caught Exception: %s<br />Response Status Code: %s<br />Error Code: %s<br />Error Type: %s<br />Request ID: %s<br /><pre>%s</pre>",
			$ex->getMessage(),
			$ex->getStatusCode(),
			$ex->getErrorCode(),
			$ex->getErrorType(),
			$ex->getRequestId(),
			htmlentities($ex->getXML())
	);
}

$A = new amazon_helper;
$AS = new amazon_service();
$basics = new basics;

$auth_params = $A->get_auth_data_array();
$parameters = array (
	'Marketplace' => $auth_params['marketplace_id'],
	'Merchant' => $auth_params['merchant_id'],
	'AvailableToDate' => new DateTime('now'),
	'AvailableFromDate' => new DateTime('-40 Days'),
	'ReportTypeList'=>array ('Type' => array ('_GET_FLAT_FILE_PAYMENT_SETTLEMENT_DATA_')),
	'MaxCount' => AMAZON_REPORTLIST_MAX_COUNT,
	'Acknowledged' => false
);
if(!empty($auth_params['mwsauthtoken'])){
	$parameters['MWSAuthToken'] = $auth_params['mwsauthtoken'];
}
$service = $AS->get_service();
$RL = new ReportList;
$request = new MarketplaceWebService_Model_GetReportListRequest($parameters);
$items = $RL->invokeGetReportList($service, $request);

if(sizeOf($items)){
	foreach($items as $item){
		$parameters = array (
			'Marketplace' => $auth_params['marketplace_id'],
			'Merchant' => $auth_params['merchant_id'],
			'Report' => @fopen('php://memory', 'rw+'),
			'ReportId' => $item['ID']
		);
		if(!empty($auth_params['mwsauthtoken'])){
			$parameters['MWSAuthToken'] = $auth_params['mwsauthtoken'];
		}

		$service = $AS->get_service();
		$R = new Report;
		$R->setReportType($item['NAME']);
		$request = new MarketplaceWebService_Model_GetReportRequest($parameters);
		$reports = $R->invokeGetReport($service, $request);
		if(sizeOf($reports)){
			foreach($reports as $report ){
				if($report['settlement-id'] == '')
					continue;
				switch($report['transaction-type']){
					case 'Order':
						break;
				}
				$sql_insert_array = array();
				foreach($report as $col=>$val){
					if(strstr($col,'-date')){
						$d1=new DateTime($val);
						$val = $d1->format('Y-m-d H:i:s');
					}
					$sql_insert_array[ str_replace('-','_',$col) ] = $val;
				}
				xtc_db_perform('amazon_settlements',$sql_insert_array);
			}
			printf("Payment Settlement Report %s eingelesen\r\n",$item['ID']);
			$service = $AS->get_service();
			$parameters = array (
			    'Marketplace' => $auth_params['marketplace_id'],
			    'Merchant' => $auth_params['merchant_id'],
			    'ReportIdList' => array ('Id' => $item['ID']),
			    'Acknowledged' => true,
			);
			if(!empty($auth_params['mwsauthtoken'])){
				$parameters['MWSAuthToken'] = $auth_params['mwsauthtoken'];
			}
			$request = new MarketplaceWebService_Model_UpdateReportAcknowledgementsRequest($parameters);
			$response = $service->updateReportAcknowledgements($request);
			if ($response->isSetUpdateReportAcknowledgementsResult()) {
				$updateReportAcknowledgementsResult = $response->getUpdateReportAcknowledgementsResult();
				printf("Report wurde ausgeblendet\r\n");
			}else{
				printf("Report konnte nicht ausgeblendet werden\r\n");
			}
		}
	}
}



// NEUEN REPORT ANFORDERN
$request = new MarketplaceWebService_Model_RequestReportRequest();
$request->setMarketplace($auth_params['marketplace_id']);
$request->setMerchant($auth_params['merchant_id']);
if(!empty($auth_params['mwsauthtoken'])){
	$request->setMWSAuthToken($auth_params['mwsauthtoken']);
}
$request->setReportType('_GET_FLAT_FILE_PAYMENT_SETTLEMENT_DATA_');
$response = $service->requestReport($request);


exit;
