<?php
include(__DIR__.'/includes/classes/amazon-sp/autoload.php');

include('includes/cron_application_top.php');
use SellingPartnerApi\Api\SellersV1Api as SellersApi;
use SellingPartnerApi\Configuration;
use SellingPartnerApi\Endpoint;
use SellingPartnerApi\FeedType;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\Client;

if(php_sapi_name() !== 'cli' and php_sapi_name() !== 'cgi' and php_sapi_name() !== 'cgi-fcgi'){
	die('unauthorized call');
}

include('includes/classes/amz_Helper.php');
include('includes/classes/amazon_sp.php');
/*include('includes/config.amazonmws.inc.php');
include('includes/classes/amz_ReportList.php');
include('includes/classes/amz_Service.php');
include('includes/classes/amz_SubmitFeed.php');
 * 
 */
require_once('includes/classes/product.php');
require_once('includes/classes/class.storagequantity.php');
require_once('includes/classes/class.basics.php');
require_once(DIR_FS_INC.'yes_write_notice.inc.php');

$basics = new basics;
$ASP_blank = new amazon_sp(null, false);
$toggle_file = main::get_secure_path().'TOGGLE_SPID_'.basename(__FILE__).'.toggle';
if(is_file($toggle_file)){
    $toggle_last = (int)file_get_contents( $toggle_file );
    if($ASP_blank->auth_params->users > 1){
        $toggle = (sizeOf($ASP_blank->auth_params->users) == ($toggle_last+1) ) ? "0" : "".$toggle_last+1;
    }
}else{
    $toggle = "0";
    file_put_contents($toggle_file, $toggle);
}

$current_seller = $ASP_blank->auth_params->users[$toggle]->selling_partner_id;

$ASP = new amazon_sp( $current_seller );
$apiInstance = new SellingPartnerApi\Api\ReportsV20210630Api($ASP->configObj);
$report_types = [
  "GET_FLAT_FILE_OPEN_LISTINGS_DATA",
];
$processingStatuses = [
    "DONE",
];
$marketplaceIds = $ASP->get_active_marketplaces();
$limit = 1; // nur den neuesten
try {
    $result = $apiInstance->getReports($report_types, $processingStatuses, $marketplaceIds, $limit);
    $items = $result->getReports();
}catch(Exception $e){
    $msg = basename(__FILE__).": Fehler im Cronjob.\r\n".$e->getMessage();
    if(main::isDev(true)){
        die($msg);
    }
    yes_mail_debug($msg);
    die($msg);
}
foreach($items as $item){
    $aktualisiert_counter = 0;
    printf("\r\nReport %s: %s\r\n",current($report_types),$item->getReportId());
    $docId = $item->getReportDocumentId();
    try{
        $doc=$apiInstance->getReportDocument($docId);
    }catch(Exception $e){
        $msg = basename(__FILE__).": Fehler im Cronjob / getReport(".$item->getReportId().").\r\n".$e->getMessage();
        if(main::isDev(true)){
            die($msg);
        }
        yes_mail_debug($msg);
        die($msg);
    }
    $inhalt = file_get_contents($doc->getUrl());
    $rows = explode("\n",$inhalt);
    foreach($rows as $nr=>$row){
        if($nr == 0 or empty($row)){
            continue;
        }
        $cols = explode("\t",$row);
        $sku = $cols[0];
        $asin = $cols[1];
        $preis = $cols[2];
        $qty = $cols[3];
        $products_id = yes_get_products_id_from_amazon_sku($sku, $current_seller);
        if($products_id < 1){
            continue;
        }
        $current_state = yes_get_products_amazon_values($products_id, $current_seller);
        $cs = current($current_state);
        if((float)$cs['price'] <> (float)$preis){
            $aktualisiert_counter++;
            $update_sql_array = array(
                'price'=>$preis,
                /*'quantity'=>$report['qty'],
                'last_quantity_feed'=>'now()',*/
                'last_price_feed'=>'now()'
            );
            xtc_db_perform('amazon_products',$update_sql_array,'update',"amazon_products_id='".$cs['amazon_products_id']."'");
            xtc_db_perform('products_history',[
                'products_id' =>$products_id,
                'editor_id'=>0,
                'date_saved'=>'now()',
                'comments'=>'Amazon Sync: Lokaler Amazon-Preis von '.$cs['price'].' auf '.$preis.' aktualisiert. (Seller '.$current_seller.')',
            ]);
        }
    }
} // end foreach items (ist aber eh immer nur 1 Report)
die(sprintf(
        "\r\nScript beendet (%s)\r\n\tAktualisiert: %d\n\tDurchlaufen: %d\n\n",
        date('d.m.y H:i:s'),
        $aktualisiert_counter,
        sizeOf($rows)-1
));
