<?php
include('includes/cron_application_top.php');
define('CRON_AMAZON_FEEDS_DEBUG','1');
if(php_sapi_name() !== 'cli' and php_sapi_name() !== 'cgi' and php_sapi_name() !== 'cgi-fcgi'){
	die('unauthorized call');
}

include('includes/config.amazonmws.inc.php');
include('includes/classes/amz_Helper.php');
include('includes/classes/amz_ReportList.php');
include('includes/classes/amz_Feed.php');
include('includes/classes/amz_Service.php');
include('includes/classes/amz_SubmitFeed.php');
require_once('includes/classes/amz_Feedshandler.php');
require_once('includes/classes/product.php');
require_once('includes/classes/class.basics.php');
require_once('includes/classes/simple_lock.php');
require_once(DIR_FS_CATALOG.'lang/german/admin/german.php');
require_once(DIR_FS_INC.'xtc_get_order_html_for_pdf.inc.php');
require_once(DIR_FS_INC.'xtc_get_orders_ebay_seller.inc.php');
require_once(DIR_FS_INC . 'xtc_format_price_order.inc.php');
require_once(DIR_FS_INC . 'xtc_format_price_order.inc.php');
require_once(DIR_FS_INC . 'xtc_generate_packingslip_barcode.inc.php');
require_once(DIR_FS_INC.'yes_write_notice.inc.php');

require_once(DIR_WS_CLASSES.'order.php');
define('AMAZON_SAVE_PATH',\main::get_exportdata_path().'amazon/');
define('AMAZON_REPORTLIST_MAX_COUNT',80);
define('AMAZON_ADDRESS_FORMAT_ID',5);
define('MARKETPLACE_ID',MODULE_OTHER_AMAZON_MARKETPLACE_ID);
define('MERCHANT_ID',MODULE_OTHER_AMAZON_MERCHANT_ID);

$lock = new simple_lock(\main::get_exportdata_path().basename(__FILE__).'.LOCK');
$lock->lock();


if(!isset($_SESSION['languages_id'])){
	$_SESSION['languages_id'] = 2;
}
$A = new amazon_helper();
$basics = new basics;
function amazon_get_request_error_msg($ex){
	return sprintf("Caught Exception: %s<br />Response Status Code: %s<br />Error Code: %s<br />Error Type: %s<br />Request ID: %s<br /><pre>%s</pre>",
			$ex->getMessage(),
			$ex->getStatusCode(),
			$ex->getErrorCode(),
			$ex->getErrorType(),
			$ex->getRequestId(),
			htmlentities($ex->getXML())
	);
}


// BOF - VERARBEITEN VON BEREITS GESENDETEN INVOICE FEEDS
/* IST VOELLIG EGAL, WENN ES QUERSCHLAEGER GIBT, MELDET SICH AMAZON BEIM SELLER
$feeds = [];
$query = xtc_db_query(
	"SELECT amazon_feeds_id,feed_submission_id FROM amazon_feeds WHERE feed_type='_UPLOAD_VAT_INVOICE_' LIMIT 10"
);
while($record = xtc_db_fetch_array($query)){
	$feeds[] = $record;
}
foreach($feeds as $feed){
	$AS = new amazon_service();
	$service = $AS->get_service();
	$feed_id = $feed['feed_submission_id'];
	$amazon_feeds_id = $feed['amazon_feeds_id'];
	$ao_query = xtc_db_query(sprintf(
		"SELECT amazon_order_id FROM amazon_feeds_upload_vat_invoice WHERE amazon_feeds_id='%s'",
		$amazon_feeds_id
	));
	$ao_record = xtc_db_fetch_array($ao_query);

	$merc_query = xtc_db_query(sprintf(
		"SELECT merchant_id FROM amazon_orders WHERE orig_amazon_orders_id='%s'",
		$ao_record['amazon_order_id']
	));
	if(!xtc_db_num_rows($merc_query)){
		yes_mail_debug("Kann keine merchant_id fuer amazon order ".$ao_record['amazon_order_id']." ermitteln.");
		printf("Kann keine merchant_id fuer amazon order %s ermitteln.\r\n",
			$ao_record['amazon_order_id']
		);
	}
	$merc = xtc_db_fetch_array($merc_query);
	$auth_params = $A->get_auth_data_array($merc['merchant_id']);
	$feedHandle = @fopen('php://memory', 'rw+');
	// SUBMIT FEED STATUS PRUEFEN
	$parameters = array (
		'Marketplace' => $auth_params['marketplace_id'],
		'Merchant' => $auth_params['merchant_id'],
		'FeedSubmissionId' => $feed_id,
		'FeedSubmissionResult' => $feedHandle,
	);
	if(!empty($auth_params['mwsauthtoken'])){
	    $parameters['MWSAuthToken'] = $auth_params['mwsauthtoken'];
	}
	$request = new MarketplaceWebService_Model_GetFeedSubmissionResultRequest($parameters);
	try {
		$response = $service->getFeedSubmissionResult($request);
		fclose($feedHandle);
		if ($response->isSetGetFeedSubmissionResultResult()) {
			$success = false;
			$error_msg = '';
			$getFeedSubmissionResultResult = $response->getGetFeedSubmissionResultResult(); 
			if ($getFeedSubmissionResultResult->isSetContentMd5()) {
				$handle = $request->getFeedSubmissionResult();
				$csv = stream_get_contents($handle);
				$row_nr = 0;
				foreach(explode("\n", $csv) as $row){
					$cols = explode("\t",$row);
					if($row_nr == 2){
						$anz_verarbeitet = (int)$cols[3];
						$success = ($anz_verarbeitet == 1) ? true : false;
					}
					if($row_nr > 4){
						$error_msg .= $cols[2].' '.$cols[3].': '.$cols[4].'<br />';
					}
					$row_nr++;
				}
			}else{
				$success = true;
			}


			if(!$success){
				yes_write_notice('Amazon Invoice Upload Amazon Order #'.$ao_record['amazon_order_id'],'Amazon meldet folgende Probleme: <br /><br />'.$error_msg,0,main::get_notice_recipients('orders'));
yes_mail_debug($csv);
				$update_sql_array = array(
					'invoice_upload'=>3, // FEHLER
				);
				xtc_db_perform('amazon_orders',$update_sql_array,'update',"orig_amazon_orders_id='".$ao_record['amazon_order_id']."'");
			}else{
				$update_sql_array = array(
					'invoice_upload'=>2, // success
				);
				xtc_db_perform('amazon_orders',$update_sql_array,'update',"orig_amazon_orders_id='".$ao_record['amazon_order_id']."'");
			}
			xtc_db_query(sprintf(
				"DELETE FROM amazon_feeds_upload_vat_invoice WHERE amazon_feeds_id='%s'",
				$amazon_feeds_id
			));
			xtc_db_query(sprintf(
				"DELETE FROM amazon_feeds WHERE amazon_feeds_id='%s'",
				$amazon_feeds_id
			));
			printf("Feed %s verarbeitet\r\n",$feed_id);
			sleep(2);
		}else{
			printf("Feed fuer amazon order %s noch in Warteschleife\r\n",
				$ao_record['amazon_order_id']
			);
			sleep(2);
		}

	     } catch (MarketplaceWebService_Exception $ex) {
		 echo("Caught Exception (Server Status Code ".$ex->getStatusCode().") Feed ".$feed_id." " . $ex->getMessage() . "\n");
		sleep(2);
		fclose($feedHandle);

	     }
}
*/
$query = xtc_db_query(sprintf(
	"SELECT ao.amazon_orders_id,ao.orders_id,ao.orig_amazon_orders_id,ao.merchant_id FROM amazon_orders ao LEFT JOIN orders o USING(orders_id) WHERE ao.invoice_upload=0 AND o.orders_status='%d' ORDER BY ao.date_created DESC LIMIT 25",
        ORDERS_STATUS_ABGESCHLOSSEN
));
$upload_invoice_orders = array();
while($record = xtc_db_fetch_array($query)){
	$upload_invoice_orders[] = $record;
}
//$TEST_OrderId = '028-5949264-3763507';

// ZU ALLEN AMAZON ORDERS MIT invoice_upload 0 WERDEN DIE PDFs AN AMAZON GESENDET
// SIE ERHALTEN invoice_upload=1
// DIE 1 STEHT FUER "ist hochgeladen".
// VERARBEITET WERDEN SIE DANN VOM amz_Feedshandler.php

$AS = new amazon_service();
$service = $AS->get_service();
foreach($upload_invoice_orders as $ord){
	if(isset($TEST_OrderId)){
		if($TEST_OrderId != $ord['orig_amazon_orders_id']){
			continue;
		}
	}
	$OrderId = $ord['orig_amazon_orders_id'];
	// SUBMIT PDF
	$InvoiceNumber = $ord['orders_id'];
	$TotalVATAmount = 0;
	$TotalAmount = 0;
	$auth_params = $A->get_auth_data_array($ord['merchant_id']);

	$order = new order($InvoiceNumber);
	$xtPrice = new xtcPrice($order->info['currency'],$order->info['status']);
	$pdf_smarty = new yesSmarty;
	$pdf_order_html=xtc_get_order_html_for_pdf($order,$pdf_smarty,CURRENT_TEMPLATE . '/admin/mail/german/pdf_order.html');
	// FUEGE ORDER AN GESAMTPDF AN
	$pdf_file = \main::get_exportdata_path().'AMZ_INVOICE_ORDER_'.$InvoiceNumber.'.pdf';
	if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
	    $headerandfooter=(strstr(HTTP_SERVER,'localhost')) ? true : false;
	    $pdf = new yes_pdf($headerandfooter);
	    if(DOMPDF_ORDER_LANDSCAPE == 'True'){
		$pdf->set_landscape();
	    }
	    $pdf->set_html($pdf_order_html);
	    $pdf->save($pdf_file);
	}else{
	    $order_pdf=new HTML2FPDF();
	    $order_pdf->AddPage();
	    $order_pdf->WriteHTML($pdf_order_html);
	    $order_pdf->Output($pdf_file,'F'); //Read the FPDF.org manual to know the other options
	}
	$PDF_BIN = file_get_contents($pdf_file);
	unlink($pdf_file);

	foreach($o->totals as $ot){
		switch($ot['class']){
			case 'ot_total':
				$TotalAmount = number_format($ot['value'],2,'.','');
				break;
			case 'ot_tax':
				$TotalVATAmount += number_format($ot['value'],2,'.','');
				break;
		}
	}

	$SF = new SubmitFeed();
	$FeedOptions = '';
	$FeedOptions .= sprintf("metadata:orderid=%s;metadata:invoicenumber=%s",
		$OrderId, $InvoiceNumber
	);

	if($TotalVATAmount > 0){
		$FeedOptions .= sprintf(";metadata:totalvatamount=%s",
			$TotalVATAmount
		);
	}
	if($TotalAmount > 0){
		$FeedOptions .= sprintf(";metadata:totalamount=%s",
			$TotalAmount
		);
	}
	$FeedType = '_UPLOAD_VAT_INVOICE_';
	$service = $AS->get_service();
	$feedHandle = @fopen('php://memory', 'rw+');
	fwrite($feedHandle, $PDF_BIN);
	rewind($feedHandle);
        switch( $order->delivery['iso_code_2'] ){
            case 'DE':
            case 'AT':
                $marketplaceId = $auth_params['marketplace_id'];
                break;
            case 'NL':
            case 'BE':
                $marketplaceId = 'A1805IZSGTT6HS';
                break;
            case 'ES':
                $marketplaceId = 'A1RKKUPIHCS9HS';
                break;
            case 'UK':
                $marketplaceId = 'A1F83G8C2ARO7P';
                break;
            case 'FR':
                $marketplaceId = 'A13V1IB3VIYZZH';
                break;
            case 'IT':
                $marketplaceId = 'APJ6JRA9NG5V4';
                break;
            case 'PL':
                $marketplaceId = 'A1C3SOZRARQ6R3';
                break;
            case 'SE':
                $marketplaceId = 'A2NODRKZP88ZB9';
                break;      
            default:
                $marketplaceId = $auth_params['marketplace_id'];
                yes_mail_debug("Amazon Auftrag ".$InvoiceNumber." hat Versandland ".$order->delivery['iso_code_2'].". Dafuer haben wir keine MarketplaceId");
                break;
        }
	$marketplaceIdArray = array("Id" => array($marketplaceId));
	$parameters = array (
		'MarketplaceIdList' => $marketplaceIdArray,
		'Merchant' => $auth_params['merchant_id'],
		'FeedType' => $FeedType,
		'FeedOptions' => $FeedOptions,
		'FeedContent'=>$feedHandle,
		'PurgeAndReplace' => false,
		'ContentMd5' => base64_encode(md5(stream_get_contents($feedHandle), true)),
	);
	if(!empty($auth_params['mwsauthtoken'])){
		$parameters['MWSAuthToken'] = $auth_params['mwsauthtoken'];
	}
	$request = new MarketplaceWebService_Model_SubmitFeedRequest($parameters);
	$request->setMarketplaceIdList($marketplaceIdArray);
	try{
		$result = $SF->invokeSubmitFeed($service, $request);
		fclose($feedHandle);
		if(strtolower(gettype($result)) != 'null'){
			if($result->getFeedSubmissionId() != ''){
				$insert_sql_array = array(
					'feed_submission_id'=>$result->getFeedSubmissionId(),
					'feed_type'=>$FeedType,
					'feed_processing_status'=>$result->getFeedProcessingStatus(),
					'submitted_date'=>$result->getSubmittedDate()->format('Y-m-d H:i:s'),
					'processed'=>0,
					'merchant_id'=>$auth_params['merchant_id']
				);
				xtc_db_perform('amazon_feeds',$insert_sql_array);
				$amazon_feeds_id = xtc_db_insert_id();

				$insert_sql_array = array(
					'amazon_order_id'=>$ord['orig_amazon_orders_id'],
					'processed'=>0,
					'amazon_feeds_id'=>$amazon_feeds_id,
					'date_added'=>'now()'
				);
				xtc_db_perform('amazon_feeds_upload_vat_invoice',$insert_sql_array);
				$update_sql_array = array(
					// eigentlich 1, da wir aber die Feeds nicht auslesen
					// gilt jeder Upload als successful
					'invoice_upload'=>2, 
				);
				xtc_db_perform('amazon_orders',$update_sql_array,'update',"amazon_orders_id='".$ord['amazon_orders_id']."'");
				echo "\r\nAmazon Order ".$ord['orig_amazon_orders_id']." oID ".$InvoiceNumber." has FeedSubmissionID: ".$result->getFeedSubmissionId()."\r\n";
				sleep(2);
			}
		}else{
			yes_mail_debug("Fehler bei Invoice Upload Feed<br />".implode('<br />',$parameters)."\r\n\r\n\r\n".$pdf_order_html);
			echo "Call fehlgeschlagen\n";
			sleep(2);
		}
	} catch (MarketplaceWebService_Exception $ex) {
		echo("Caught Exception Amazon Order ".$OrderId."\r\n" . $ex->getMessage() . "\n");
		sleep(2);
	}
}
$lock->destroy();
die("\r\n".basename(__FILE__)."Done\r\n");
