<?php
include('includes/cron_application_top.php');
ini_set('max_execution_time', 6000);
require_once(DIR_WS_CLASSES.'class.csv.php');
require_once(DIR_WS_CLASSES.'class.basics.php');
require_once(DIR_WS_CLASSES.'ebay_import_csv_item.php');
require_once(DIR_WS_CLASSES.'ebay_finding_api.php');
require_once(DIR_WS_CLASSES.'ebay_import.php');
require_once(DIR_WS_CLASSES.'simple_lock.php');
$lock = new simple_lock(\main::get_exportdata_path().basename(__FILE__).'.lock',true,'1',30);
$lock->lock();

function output($string,$die = false){
    global $lock;
    $wrap = (!isset($_SERVER['REMOTE_ADDR'])) ? "\r\n%s\r\n" : '<pre><code>%s</code></pre>';
    printf($wrap,$string);
    if($die) {
	$lock->destroy();
	exit;
    }
}
$csv_file_save_path = \main::get_importdata_path().'ebay_import_csv/';
$basics = new basics;
$tpl_path = DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/module/';
$tpl_itemspecifics = 'ebay_import_itemspecifics.html';
define('EBAY_IMPORT_CSV_ITEMSPECIFICS_TEMPLATE',$tpl_path.$tpl_itemspecifics);
if(!is_file(EBAY_IMPORT_CSV_ITEMSPECIFICS_TEMPLATE)){
    output('Templateset '.CURRENT_TEMPLATE.': Es fehlt die Vorlage '.$tpl_itemspecifics.' (Path: '.$tpl_path.')',true);
}

$EBAYAPI = new ebayApi();
$file = current($basics->get_directory_content($csv_file_save_path));
if(empty($file) or $file === false){
    output('No Files to process',true);
}else{
    output('Processing File '.$file);
}
if(strtolower(substr($file,strlen($file)-3,strlen($file))) != 'csv'){
    output(strtolower(substr($file,strlen($file)-3,strlen($file))) . ' is not CSV',true);
}
$rows = array();
if (($handle = fopen($csv_file_save_path.$file, "r")) !== FALSE) {
}else{
    output('INVALID CSV - CANT READ',true);
}



// ENTHAELT EINE AUKTION BZW EINE AUKTION UND DEREN VARIANTE
$current_row = array(); 
$current_page_nr = 1;
if(isset($_SERVER['REMOTE_ADDR'])){
    $current_page_nr = (isset($_REQUEST['nr'])) ? $_REQUEST['nr'] : 1;
}else{
    if(isset($argv[1]) and $argv[1] > 0){
	echo 'delete pID '.$argv[1];
	$product = new product($argv[1],2,false);
	$_SESSION['languages_id'] = 2;
	$cs_array = xtc_get_customers_statuses();
	$product->delete($cs_array);
	exit;
    }
}
$counter = 0;
while (($row = fgetcsv($handle, 1000, ";")) !== FALSE) {
    if($counter == 0) {
	$counter++;
	continue; // HEADERZEILE IMMER DRIN
    }
    // VARIANTEN HABEN ERSTE SPALTE LEER - ALSO LESEN WIR SOLANGE EIN, BIS DAS
    // NAECHSTE HAUPTPRODUKT KOMMT
    if($row[0] != ''){
	if($counter == $current_page_nr){
	    $current_row = $row;
	}
	$counter++;
    }
}
fclose($handle);
if(!sizeOf($current_row)){
    output('No Data to import',true);
}
$eici = new ebay_import_csv_item($current_row[1]);
$data = $eici->collect_data();
if(isset($data['Error'])){
	echo $data['Error'];
	$lock->destroy();
}
if(isset($_SERVER['REMOTE_ADDR'])){
    $smarty = new yesSmarty;
    
    if(isset($data['Error'])){
	$data['Error'] = htmlspecialchars($data['Error'], ENT_HTML401, CHARSET);
    }
    if( ($current_page_nr+1) <= $counter){
	$smarty->assign('NEXT_ITEM_LINK',xtc_href_link(basename(__FILE__),'nr='.($current_page_nr+1)));
    }
    if( $current_page_nr > 1){
	$smarty->assign('LAST_ITEM_LINK',xtc_href_link(basename(__FILE__),'nr='.($current_page_nr-1)));
    }
    $smarty->assign(array(
	'DATA'=>$data,
    ));
    $smarty->display('cron_ebay_import_csv.html');
}else{
    $ei = new ebay_import($data);
    if(!$ei->process()){
	echo "Cant import item ".$data['ItemID']." (logged)\r\n";
	// SCHREIBE EIN REPORT FILE MIT DEN NICHT IMPORTIERTEN AUKTIONEN
	$report_file = \main::get_importdata_path().$file.'-REPORT_FAILED.txt';
	if(!is_file($report_file)){
	    $current = $data['ItemID']."\n";
	}else{
	    // �ffnet die Datei, um den vorhandenen Inhalt zu laden
	    $current = file_get_contents($file);
	    // F�gt eine neue Person zur Datei hinzu
	    $current .= $data['ItemID']."\n";
	// Schreibt den Inhalt in die Datei zur�ck
	}
	file_put_contents($report_file, $current);
    }
    $counter = 0;
    if (($handle = fopen($csv_file_save_path.$file, "r")) !== FALSE) {
    }else{
    	output('INVALID CSV - CANT READ',true);
    }
    $variation_flag = false;
    while (($row = fgetcsv($handle, 1000, ";")) !== FALSE) {
	if($counter == 1) {
	    $variation_flag = true;
	    $counter++;
	    continue; // HEADERZEILE IMMER DRIN
	}
	if($variation_flag){
	    if(empty($row[0])){
		$counter++;
		continue;
	    }else{
		$variation_flag = false;
	    }
	}
	$new_data[] = $row;
	$counter++;
    }
    fclose($handle);

    echo "Auction line(s) deleted from file\r\n";
    if (($handle = fopen($csv_file_save_path.$file, "w")) !== FALSE) {
    }else{
    	output('INVALID CSV - CANT READ',true);
    }
    foreach($new_data as $data){
	fputcsv($handle, $data,';');
    }
    fclose($handle);
    if(sizeOf($ei->results)){
	echo implode("\r\n",$ei->results);
    }
    output("CLI Mode done");
}
$lock->destroy();
