<?php
use ZBateson\MailMimeParser\Message;
use ZBateson\MailMimeParser\Message\MessagePart;

$_SERVER['PHP_SELF'] = basename(__FILE__);
error_reporting(E_ERROR);
require_once('includes/cron_application_top.php');
require_once(DIR_FS_INC.'yes_get_sha1_from_string.inc.php');

$query = xtc_db_query(sprintf(
	"SELECT * FROM mailaccounts WHERE protocol='imap'"
));
if(!xtc_db_num_rows($query)){
	die("Keine IMAP Postfaecher hinterlegt.\r\n");
}
while($record = xtc_db_fetch_array($query)){
	$imap_accounts[] = $record;
}
if(sizeOf($imap_accounts) > 1){
	$basics = new \basics;
	$toggle_user_file = \main::get_secure_path().basename(__FILE__).'.CURRENT_USER';
	if(!is_file($toggle_user_file)){
		$basics->create_file($toggle_user_file,'0');
	}
	$current_user = (int)file_get_contents($toggle_user_file);
	$next_user = ( ($current_user+1) < sizeOf($imap_accounts) ) ? $current_user+1 : 0;
	unlink($toggle_user_file);
	$basics->create_file($toggle_user_file,"$next_user");	
	$imap_account = $imap_accounts[$current_user];
}else{
	$imap_account = current($imap_accounts);
}

$hostname_str = sprintf('{%s}INBOX',$imap_account['mailserver']);
$imap = @imap_open($hostname_str, $imap_account['email_user'], $imap_account['email_password']);
if(!$imap) {
	printf("Verbindung fuer %s fehlgeschlagen:\n\n%s\n",
		$imap_account['email_user'],
		imap_last_error()
	);
	exit;
}

$status = imap_status($imap, $hostname_str, SA_MESSAGES);
if ($status === false) {
	throw new \Exception("Konnte Status nicht abrufen: " . imap_last_error());
}
$num_messages = intval($status->messages);
if($num_messages > 2500){
	throw new \Exception(sprintf("Es befinden sich %s Emails in Postfach %s auf Server %s. (max 2500)",
	$num_messages,
	$imap_account['email_user'],
	HTTP_SERVER
)); 
}    
$emails = imap_search($imap, 'ALL');
if(is_countable($emails) and sizeOf($emails)){
	rsort($emails);
}
printf("\nEs wird das imap Konto fuer %s ausgelesen.\n",$imap_account['email_user']);
if($emails === false or !is_countable($emails) or !sizeOf($emails)){
	echo "\nkeine emails, nichts zu tun.\n";
	imap_close($imap);
	exit;
}
$line = "\n#################################################\n";
printf("\nEs werden %s Emails durchlaufen.\n",sizeOf($emails));
foreach($emails as $email_nr){
	$rawEmail = imap_fetchheader($imap, $email_nr) 
		. imap_body($imap, $email_nr, FT_PEEK);
            
	$message = \ZBateson\MailMimeParser\Message::from($rawEmail, false);
	$text = $message->getTextContent();
	$html = $message->getHtmlContent();
	$fromObj = $message->getHeader('From');
	if($fromObj === null){
		$status = imap_fetch_overview($imap, $email_nr, 0);
		preg_match('/<([^>]+)>/', $status[0]->from, $matches);

		if (isset($matches[1])) {
		    $from_email = $matches[1];
		} else {
		    $from_email = $status[0]->from;
		}		
		$from_name = '';
	}else{
		$from_name = $fromObj->getPersonName();
		$from_email = $fromObj->getEmail();
	}
	$date = $message->getHeader('Date');
	if($date !== null and gettype($date->getDateTime()) !== 'NULL'){
		try{
			$date_string = $date->getDateTime()->format('Y-m-d H:i:s');
		}catch(\Exception $e){
			$date_string = date('Y-m-d H:i:s');
		}
	}else{
		$date_string = date('Y-m-d H:i:s');
	}
	
//	echo $line.'Email Nr '.$email_nr.' Subject:'.$message->getSubject()."\nAbsender: ".$fromObj->getEmail()."\nBody:\n".substr(trim($text),0,100)."...\n\n".$line;
	$new_email_sql = [
		'subject'=>$message->getSubject(),
		'mailto'=>$imap_account['email_user'], // immer die emailadresse aus mailaccounts
		'from_name'=>$from_name,
		'from_email'=>(empty((string)$from_email) or $from_email === null or $from_email == 'null') ? 'unknown' : $from_email,
		'messageid'=>$message->getMessageId()??'unknown',
		'date'=>$date_string,
		'format'=>''
	];
	$email_id = \YES4Trade\Model\ebay_emails::create_ebay_emails($new_email_sql,
		(!empty($html))?$html:$text??'-- [YES System Meldung] kein inhalt gefunden ---'
	);
//	echo "YES EMAIL ID $email_id wurde erzeugt\n";
	foreach($message->getAllAttachmentParts() as $attachment){
		$filename = $attachment->getFilename();
		$stream = $attachment->getContent();
		if ($stream === null) {
			// Logge einen Fehler oder ignoriere diesen Anhang
			continue;
		}

		$save_path = \main::get_importdata_path().'mail_attachments/'.$email_id;
		$filename_sha1 = yes_get_sha1_from_string($filename);
		$save_name = $save_path.'/'.$filename_sha1;
		if(!is_dir($save_path)){
			mkdir($save_path);
		}
		if(is_file($save_name)){
			unlink($save_name);
		}
		$attachment->saveContent($save_name);
		\YES4Trade\Model\ebay_email_attachments::create_ebay_email_attachments([
			'email_id'=>intval($email_id),
			'filename'=>$filename,
			'filesize'=>filesize($save_name),
			'filetype'=>$attachment->getContentType()
		]);
	}
	if(!main::isDev(true)){
//		echo "\n\t#".$email_nr." zum loeschen markiert";
		imap_delete($imap, $email_nr);
	}
	/*
	try{
		$imported_id = $imap->yes_import_mail($email_number);
		if($imported_id == -1){
			printf("\n\tEmail Nr. %d konnte nicht eingelesen werden.\n",$email_number);
		}
		if(!main::isDev(true)){
			$imap->delete($email_number);
		}
	}catch(Exception $e){
		printf("\n\tEmail Nr. %d erzeugte einen Fehler: %s\n",
			$email_number, $e->getMessage()
		);
		yes_mail_debug($e->getMessage(),false,'Email import Fehler '.$imap_account['email_user']);
		continue;
	}*/
}

if(!main::isDev(true)){
	if(sizeOf($emails)){
		imap_expunge($imap);
//		echo "\nLoeschen der vorgemerkten Mails vom Emailserver ausgefuehrt\n";
	}
}
imap_close($imap);
//echo "\nIMAP Verbindung zum Emailserver geschlossen.\n";
