<?php
/*------------------------------------------------------------------------------

   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *

                                             Author M. ASPELEITER <dazze@gmx.de>
                                             Copyright (c) 2004 mario aspeleiter

   ---------------------------------------------------------------------------*/
if(php_sapi_name() !== 'cli' and php_sapi_name() !== 'cgi' and php_sapi_name() !== 'cgi-fcgi'){
    die('unauthorized call');
}
include('includes/cron_application_top.php');

include('includes/classes/class.ebaymail.php');
include('includes/classes/Imap.class.php');
require_once('includes/classes/class.basics.php');
include(DIR_FS_INC.'yes_get_sha1_from_string.inc.php');
define('MODULE_OTHER_ATTACHMENTS_STATUS','True');
define('MODULE_OTHER_ATTACHMENTS_MAX_FILESIZE','1024');

$att_path = \main::get_importdata_path().'mail_attachments/';
if(!is_dir($att_path)){
	mkdir($att_path);
}
$basics = new basics;

$records = array();
$mailaccounts_query = xtc_db_query("SELECT * FROM mailaccounts");
while($row  = xtc_db_fetch_array($mailaccounts_query) ){
	$records[] = $row;
}
if(!sizeOf($records)){
	die('Nothing to do.');
}
foreach($records as $mailaccount){
	$folder = 'INBOX';
	if($mailaccount['protocol'] == 'pop3'){
		$port = '110';
		$tls = 'POP3';
	}else{
		$port = '143';
		$tls='notls';
	}
	$imap = new \Imap(
		$mailaccount['mailserver'],$mailaccount['email_user'],$mailaccount['email_password'],$folder,$port,$tls
	) or die('Keine Verbindung moeglich.<br />'.imap_last_error());
	$info = $imap->returnImapMailBoxmMsgInfoObj();
	$num_msg = $info->Nmsgs;

	$emailcount = 0;
	for($i=0;$i<$num_msg;$i++){
		$mail = $imap->returnEmailMessageArr( ($i+1) );
		//$subject = $imap->flatMimeDecode($mail['header']['subject']);
		$subject = $mail['header']['subject'];
		$date = date('Y-m-d H:i:s');
		$to = str_replace("<","",$mail['header']['to']);
		$to = str_replace(">","",$to);
		$from_name = $mail['header']['from'];
		if(isset($mail['header']['reply_toaddress']) and !empty($mail['header']['reply_toaddress'])){
			$from_name = $mail['header']['reply_toaddress'];
		}else{
			if($mail['header']['sender'] and !empty($mail['header']['sender'])){
				$from_name = $mail['header']['sender'];
			}
		}
		$from_email = $mail['header']['from'];
		$reply_to = $mail['header']['sender'];
		if(empty($mail['header']['sender'])){
			$reply_to = $from_email;
		}
		$body = quoted_printable_decode($mail['plain']);

		// * PRUEFEN OB WIR DIE MAIL SCHON HABEN
		if(strlen($mail['header']['message_id'])>3){
			$check = \YES4Trade\Model\ebay_emails::filter([
					'messageid'=>$mail['header']['message_id'],
					'ebay_user'=>$mailaccount['ebay_user']
				],['id']
			);
		}else{
			$check = \YES4Trade\Model\ebay_emails::filter([
					'from_name'=>$from_name,
					'from_email'=>$from_email,
					'subject'=>$subject,
					'mailto'=>$to
				],['id']
			);
		} // end if !messageID

		if(!sizeOf($check)){
			// * MAIL SPEICHERN
			$insert_id = \YES4Trade\Model\ebay_emails::create_ebay_emails([
				'subject'=>$subject,
				'mailto'=>$to,
				'from_name'=>$from_name,
				'from_email'=>$from_email,
				'messageid'=>$mail['header']['message_id'],
				'ebay_user'=>$mailaccount['ebay_user'],
				'date'=>date('Y-m-d H:i:s')
			],$body);

			$emailcount++;
			if (!isset($mail['attachments'])) {
				if(!main::isDev(true)){
					$imap->delete( ($i+1) );
				}
				continue;
			}
			foreach($mail['attachments'] as $part){
				$save_path = $att_path.$insert_id;
				$filename_sha1 = yes_get_sha1_from_string($part['name']);
				$save_name = $save_path.'/'.$filename_sha1;
				if(!is_dir($save_path)){
					mkdir($save_path);
				}
				$imap->saveAttachment( ($i+1), $part['part'], $save_name);
				\YES4Trade\Model\ebay_email_attachments::create_ebay_email_attachments([
					'email_id'=>intval($insert_id),
					'filename'=>$part['name'],
					'filesize'=>intval(filesize($save_name)),
					'filetype'=>strtolower($part['type'])
				]);
			}
			if(!main::isDev(true)){
				$imap->delete( ($i+1) );
			}
		} // end if !saved

	} // end for messages

	if($num_msg>0){
			echo $num_msg . " emails eingelesen.\n";
	}

	if($i>0){
			echo $i . " E-Mails vom Postfach ".$mailaccount['email_user']." geloescht.\n";
	}
	$imap->close_connection(); // delete
	$imap = new Imap(
			$mailaccount['mailserver'],$mailaccount['email_user'],$mailaccount['email_password'],$folder,$port,$tls
	) or die('Keine Verbindung moeglich.<br />'.imap_last_error());
	$imap->expunge();
}
printf("\n\n[%s] Script beendet, ParseTime %s Sek)\n\n",basename(__FILE__),
	number_format(\YES4Trade\Model\BaseType::get_parse_time(),4)
);
exit;