<?php
ini_set('gd.jpeg_ignore_warning', 1);
ini_set('memory_limit','512M');
ini_set('max_execution_time', 6000); //300 seconds = 5 minutes
set_time_limit(0);
include('includes/cron_application_top.php');
define('HISTORY_PRODUCTS_IMAGE1_UPLOAD','BILD 1 wurde neu hochgeladen.');
include('includes/classes/simple_lock.php');
$_SESSION['languages_id'] = 2;
//error_reporting(E_ALL & ~E_NOTICE);
require_once('includes/classes/class.csv.php');
require_once('includes/classes/image_manipulator_GD2.php');
require_once('includes/classes/curl_cache.php');
require_once('includes/classes/class.basics.php');
require_once('includes/classes/product.php');
require_once(DIR_FS_INC.'yes_write_notice.inc.php');
function vc_download_picture($url,$products_id,$nr){
    $save_path = DIR_FS_CATALOG.'images/product_images/original_images/'.$products_id.'_'.$nr.'.jpg';
    $handle = fopen($url,'rb');
    $content = '';
    if($handle){
            while(!feof($handle)) {
                    $content = $content . fread($handle, 1024);
            }
            fclose($handle);
            $save_handle = fopen($save_path,'ab');
            fwrite($save_handle,$content);
            fclose($save_handle);
            return true;
    }else{
        return false;
    }
}
$file = \main::get_importdata_path().'PRODUCTS_IMAGES_UPLOAD.csv';
$max_rows_to_import = constant('PRODUCT_IMAGES_IMPORT_SIZE');
if((int)$max_rows_to_import < 1){
    $max_rows_to_import = 1;
}
$logfile = \main::get_importdata_path().'PRODUCT_IMAGES_IMPORT.log';

if(!is_file($file) or !is_readable($file)){
    die('Nothing to do.');
}

$lock = new simple_lock(\main::get_exportdata_path().basename(__FILE__).'.LOCK');
$lock->lock();

$basics = new basics;
$CSV = new CSVfile($file);
$CSV->delimiter = "\t";
$CSV->open('r+');
$errors = [];
$counter = 0;
while($row = $CSV->readRow()){
    if($counter == 0){
        $counter++;
        continue; //HEADERZEILE
    }
    if($counter > $max_rows_to_import){
        break;
    }
    $pID = (int)xtc_db_input($row[0]);
    if(!product::isProduct($pID)){
        $errors[] = sprintf('Row #%d products_id %d is not a valid product',
                $counter, $pID
        );
        $counter++;
        continue;
    }
    printf("Processing Images for pID %d\r\n",$pID);
    $product = new product($pID);
    foreach($row as $col_nr => $url){
        if($col_nr == 0 or $url == ''){
            continue; // pID
        }
        error_reporting(E_ERROR);
        if(vc_download_picture($url,$pID,($col_nr-1))){
            $filename = DIR_FS_CATALOG.'images/product_images/original_images/'.$pID.'_'.($col_nr-1).'.jpg';
            try{
                $product->copy_and_save_image($filename, ($col_nr-1));
            }catch(Exception $e){
                yes_mail_debug($e->getMessage(),true,'cron_product_images_import.php Fehler');
                $errors[] = sprintf("Row #%d products_id %d Image #%d: %s",
                    $counter, $pID, $col_nr,
                    $e->getMessage()
                );
            }
        }else{
            $errors[] = sprintf("Row #%d products_id %d Image #%d: Download failed",
                    $counter, $pID, $col_nr
            );
        }
    }
    $counter++;
}
$CSV->close();
$finished = false;
if($counter > 1){
    $data = explode("\n",file_get_contents($file));
    
    foreach($data as $k=>$row){
        if(empty($row)){
            unset($data[$k]);
        }
    }
    $new = array_slice($data,$max_rows_to_import+1);
    if(sizeOf($new)>0){
        array_unshift($new, $data[0]);
        $fp = fopen($file, "w+");
        flock($fp, LOCK_EX);
        foreach($new as $line) {
            if($line != ''){
                fwrite($fp, $line."\n");
            }
        }
        flock($fp, LOCK_UN);
        fclose($fp);
    }else{
        $finished = true;
    }
}

if(sizeOf($errors)){
    $fp = fopen($logfile, 'a');
    fwrite($fp, implode("\r\n",$errors));
    fclose($fp);
}
if($finished){
    $msg = nl2br(file_get_contents($logfile));
    yes_write_notice('Bilderimport abgeschlossen', 
            "Fehlermeldungen:<br />".$msg, 
            0, main::get_notice_recipients('categories')
    );
    unlink($logfile);
    unlink($file);
    echo "Import abgeschlossen. Dateien geloescht.\r\n";
    echo $msg."\r\n";
}

printf("\r\n%d Rows Imported\r\n",($counter-1));
$lock->destroy();

