<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                             Author M. ASPELEITER <dazze@gmx.de>
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/

require('includes/application_top.php');
require('includes/classes/distributor_invoice.php');
require(DIR_WS_CLASSES . 'distributor_order.php');
require_once(DIR_WS_CLASSES . 'distributor.php');
require(DIR_FS_INC.'xtc_get_distributor_invoice_status_name.inc.php');
require(DIR_FS_INC.'xtc_get_invoice_reason_title.inc.php');
require_once(DIR_FS_INC . 'xtc_get_parent_categories.inc.php');
require_once(DIR_FS_INC . 'xtc_get_product_path.inc.php');

$admin_access = main::get_admin_access();

$smarty = new yesSmarty;
$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
$action = isset($_GET['action']) ? $_GET['action'] : '';
switch ($action) {
    case 'update_payment_target':
        $diID = (int)xtc_db_input($_GET['diID']);
        $payment_target = (isset($_GET['payment_target']) and $_GET['payment_target'] != '')?xtc_db_input($_GET['payment_target']):'';
        $update_sql_array = array(
            'payment_target'=>$payment_target,
            'last_modified'=>"now()"
        );
        xtc_db_perform('distributor_invoices',$update_sql_array,'update',"distributor_invoices_id='".$diID."'");
        $di = new distributor_invoice($diID);
        $payment_target_title = '';
        if($payment_target != ''){
            $payment_target_title = xtc_date_short($payment_target);
            $comments = sprintf(HISTORY_INVOICE_PAYMENT_TARGET_UPDATED,
                $payment_target_title
            );
        }else{
            $comments = HISTORY_INVOICE_PAYMENT_TARGET_DELETED;
        }
        $di->insert_history($di->info['status'], false, $comments,(int)$_SESSION['customer_id']);
        die(json_encode([
            'MSG'=>$comments,
            'PAYMENT_TARGET'=> $payment_target_title
        ]));
        break;
    case 'quick_edit_payment_target':
        $diID = (int)xtc_db_input($_GET['diID']);
        $di = new distributor_invoice($diID);
        $current_pt = $di->info['payment_target'];
        if(strpos($current_pt,'0000-00-00')){
            $current_pt = '';
        }else{
            $datetime = new DateTime($current_pt); 
            $current_pt = $datetime->format('Y-m-d');
        }
        echo xtc_draw_form('di_payment_target_form',basename(__FILE__),xtc_get_all_get_params(['action']).'action=update_payment_target');
        printf('<label for="payment_target">%s<br /></label>%s<br /><br />',
             TEXT_PAYMENT_TARGET,
             xtc_draw_input_field('payment_target',$current_pt,'id="payment_target"',false,'date')
        );
        printf('<input onclick="update_payment_target()" type="button" class="ui-button ui-corner-all ui-state-default" value="%s" /></form>',
                IMAGE_SAVE
        );
        echo '</form>';
        exit;
        break;
    case 'update_reason':
        $diID = (int)xtc_db_input($_GET['diID']);
        $reasons_id = (isset($_GET['reasons_id']) and $_GET['reasons_id'] != '')?(int)xtc_db_input($_GET['reasons_id']):'';
        $update_sql_array = array(
            'reasons_id'=>$reasons_id,
            'last_modified'=>"now()"
        );
        xtc_db_perform('distributor_invoices',$update_sql_array,'update',"distributor_invoices_id='".$diID."'");
        $di = new distributor_invoice($diID);
        $reason_title = '';
        if($reasons_id != ''){
            $reason_title = xtc_get_invoice_reason_title($reasons_id);
            $comments = sprintf(HISTORY_INVOICE_REASON_UPDATED,
                $reason_title
            );
        }else{
            $comments = HISTORY_INVOICE_REASON_DELETED;
        }
        $di->insert_history($di->info['status'], false, $comments,(int)$_SESSION['customer_id']);
        die(json_encode([
            'MSG'=>$comments,
            'REASON'=> $reason_title
        ]));
        break;
    case 'quick_edit_reason':
        $diID = (int)xtc_db_input($_GET['diID']);
        $di = new distributor_invoice($diID);
        $current_reason_id = (int)$di->info['reasons_id'];
        $options = [['id'=>'','text'=>TEXT_SELECT]];
        $items = \YES4Trade\Model\distributor_invoices_reasons::get_all();
        foreach($items as $it){
            $options[] = [
                'id'=>$it->distributor_invoices_reasons_id,
                'text'=>$it->title
            ];
        }
        echo xtc_draw_form('di_reason_form',basename(__FILE__),xtc_get_all_get_params(['action']).'action=update_reason');
        printf('<label for="reason">%s<br /></label>%s<br /><br />',
             TEXT_INVOICE_REASON,
             xtc_draw_pull_down_menu('reason',$options,$current_reason_id,'id="reason"')
        );
        printf('<input onclick="update_reason()" type="button" class="ui-button ui-corner-all ui-state-default" value="%s" /></form>',
                IMAGE_SAVE
        );
        echo '</form>';
        exit;
    case 'print':
        $diID = (int)xtc_db_input($_GET['diID']);
        $di = new distributor_invoice($diID);
        $format_id = 5;
        $smarty->assign(array(
           'INFO' => $di->info,
           'PRODUCTS' => $di->products,
           'TOTALS'=>$di->totals,
            'STORE_NAME'=>STORE_NAME,
            'STORE_NAME_ADDRESS'=>STORE_NAME_ADDRESS,
            'address_label_distributor'=>xtc_address_format($format_id, xtc_db_prepare_input($di->distributor), true, '', '<br />'),
        ));
        $file = DIR_FS_CATALOG.'templates'.DIRECTORY_SEPARATOR.CURRENT_TEMPLATE.DIRECTORY_SEPARATOR.'admin'.DIRECTORY_SEPARATOR.'print_distributor_invoice.html';
        if(!file_exists($file)){
            printf(
                    'Template file %s not exists',
                    $file
            );
            exit;
        }
        $smarty->display($file);
        exit;
        break;
    case 'add':
        require_once(DIR_FS_CATALOG.'lang/german/modules/order_total/ot_subtotal.php');
        require_once(DIR_FS_CATALOG.'lang/german/modules/order_total/ot_total.php');
        $dID = (int)xtc_db_input($_GET['distributors_id']);
        $d = new distributor($dID);
        $total_ek = (float)xtc_db_input($_GET['total_ek']);
        $payment_terms_pre = '';
        if(isset($_GET['payment_terms'])){
            $payment_terms_pre = xtc_db_input($_GET['payment_terms']);
            if($d->info['payent_terms'] != ''){
                $payment_terms_pre .= '<br />';
            }
        }
        $items = array();
        foreach($_GET['order_items'] as $oi){
            foreach($oi as $k=>$v){
                if(!stristr(CHARSET,'utf-8')){
                    $oi[$k] = utf8_encode($v);
                }
            }
            $items[] = array(
                'products_id'=>$oi['products_id'],
                'products_quantity'=>$oi['products_quantity'],
                'price'=>$oi['ek_price'],
                'products_name'=>sprintf('#%s: %s / %s (%s)',
                        $oi['orders_id'],
                        $oi['event_date_time'],
                        substr($oi['products_name'],0,120),
                        substr($oi['event_ticket_info'],0,100)
                 )
            );
        }
        if(sizeOf($items)){
            $insert_sql_array = array(
                'distributor_id'=>$dID,
                'date_created'=>'now()',
                'status'=>1,
                'distributor_name'=> $d->info['name'],
                'distributor_street_address'=>$d->info['strasse'],
                'distributor_city'=>$d->info['ort'],
                'distributor_postcode'=>$d->info['plz'],
                'distributor_country'=>$d->info['land'],
                'distributor_email_address'=>$d->info['email'],
                'currency'=>DEFAULT_CURRENCY,
                'invoice_type'=>'receipt',
                'payment_terms'=>$payment_terms_pre.$d->info['payent_terms']
            );
            xtc_db_perform('distributor_invoices',$insert_sql_array);
            $diID = xtc_db_insert_id();
            
            foreach($items as $it){
                $single_price = ($it['price'] > 0) ? $it['price'] / $it['products_quantity'] : 0;
                $products_tax_class_id = yes_eu_oss_get_products_tax_class_id($it['products_id'], STORE_COUNTRY);
                $tax_rate = xtc_get_tax_rate($products_tax_class_id);
                $insert_sql_array = array(
                    'distributor_invoices_id'=>$diID,
                    'products_id'=>$it['products_id'],
                    'products_quantity'=>$it['products_quantity'],
                    'products_model'=>'',
                    'products_name'=>$it['products_name'],
                    'products_price'=>$single_price,
                    'final_price'=>$it['price'],
                    'products_tax'=>$tax_rate,
                    'allow_tax'=>$di->info['tax_orders'],
                    'date_added'=>'now()'
                );
                xtc_db_perform('distributor_invoices_products',$insert_sql_array);
            }
            $insert_sql_array = array(
                'distributor_invoices_id'=>$diID,
                'title'=>'<b>'.MODULE_ORDER_TOTAL_SUBTOTAL_TITLE.'</b>',
                'text'=>number_format($total_ek,2,',','.').' '.DEFAULT_CURRENCY,
                'value'=>$total_ek,
                'class'=>'ot_subtotal',
                'sort_order'=>MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER
            );
            xtc_db_perform('distributor_invoices_total',$insert_sql_array);
            
            $insert_sql_array = array(
                'distributor_invoices_id'=>$diID,
                'title'=>'<b>'.MODULE_ORDER_TOTAL_TOTAL_TITLE .'</b>',
                'text'=>number_format($total_ek,2,',','.').' '.DEFAULT_CURRENCY,
                'value'=>$total_ek,
                'class'=>'ot_total',
                'sort_order'=>MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER
            );
            xtc_db_perform('distributor_invoices_total',$insert_sql_array);
            $msg = sprintf(MSG_SUCCESS_LR_GENERATE,$diID);
            $link = xtc_href_link(basename(__FILE__),'action=edit&diID='.$diID);
        }else{
            $msg = MSG_ERROR_NO_ITEMS_FOR_LR_GENERATE;
            $link = '';
        }
        die(json_encode(array(
            'MSG'=>$msg,
            'LINK'=>$link
        )));
        break;
	    case 'delete':
		    $diID = (int)$_GET['diID'];
		    $di = new distributor_invoice($diID);
		    $di->delete($msg,$_SESSION['customer_id']);
		    $messageStack->add_session($msg,'success');
		    xtc_redirect(xtc_href_link('distributor_invoices.php',xtc_get_all_get_params(array('edit_action','iID','diID','action'))));
		    break;
}
if (isset($_GET['edit_action'])) {
	switch ($_GET['edit_action']) {
		case 'change_status':
			$diID = xtc_db_input($_GET['diID']);
			$di = new distributor_invoice($diID);
			$status = xtc_db_input($_POST['status_select']);
			if($di->info['status'] != $_POST['old_status']){
				$messageStack->add_session('Der Rechnungsstatus wurde in der Zwischenzeit bereits ge&auml;ndert.','error');
			}else{
				if(strlen(trim($_POST['comm']))<3){
					$messageStack->add_session('Es wurde kein Kommentar angegeben.','error');
				}else{
					if($status == $_POST['old_status']){
						$messageStack->add_session('Der Rechnungsstatus wurde nicht ge&auml;ndert.','error');
					}else{
						$msg=$_POST['comm'];
						$di->update_status($status,$msg,$_SESSION['customer_id']);
						$messageStack->add_session($msg,'success');
					}
				}
			}
			xtc_redirect(xtc_href_link('distributor_invoices.php',xtc_get_all_get_params(array('edit_action','iID'))));
			break;
		case 'delete_installment':
			$diID = xtc_db_input($_GET['diID']);
			$iID = xtc_db_input($_GET['iID']);
			$di = new distributor_invoice($diID);
			$di->delete_installment($iID,$_SESSION['customer_id']);
			$messageStack->add_session($msg,'success');
			xtc_redirect(xtc_href_link('distributor_invoices.php',xtc_get_all_get_params(array('edit_action','iID'))));
			break;
		case 'save_installment':
			$diID = xtc_db_input($_GET['diID']);
			$iID = xtc_db_input($_GET['iID']);
			$di = new distributor_invoice($diID);
			$error = false;
			if(!xtc_not_null($_POST['payment_method'])){
				$messageStack->add_session('Bitte geben Sie eine Bezahlart an.','error');
				$error = true;
			}else{
				if(!xtc_not_null($_POST['installment'])){
					$messageStack->add_session('Bitte geben Sie einen Betrag an.','error');
					$error = true;
				}else{
					$installment = (float)xtc_db_input(str_replace(',','.',$_POST['installment']));
					$di->update_installment($iID,$installment,xtc_db_input($_POST['payment_method']),$_SESSION['customer_id']);
					$messageStack->add_session('&Uuml;berweisung gespeichert.','success');
					xtc_redirect(xtc_href_link('distributor_invoices.php',xtc_get_all_get_params(array('edit_action','iID'))));
				}
			}
			if($error)
				xtc_redirect(xtc_href_link('distributor_invoices.php',xtc_get_all_get_params(array('edit_action')).'edit_action=edit_installment'));
			break;
		case 'add_installment_save':
			$diID = xtc_db_input($_GET['diID']);
			$di = new distributor_invoice($diID);
			$error = false;
			if(!xtc_not_null($_POST['payment_method'])){
				$error = true;
				$messageStack->add_session('Bitte geben Sie eine Bezahlart an.','error');
			}
			if(!xtc_not_null($_POST['installment'])){
				$error = true;
				$messageStack->add_session('Bitte geben Sie einen Betrag an.','error');
			}
			if(!$error){
				$installment = (float)xtc_db_input(str_replace(',','.',$_POST['installment']));
				$payment_method = xtc_db_input($_POST['payment_method']);
				$di->insert_installment($installment,$payment_method,$_SESSION['customer_id']);
				$messageStack->add_session('&Uuml;berweisung gespeichert.','success');
				xtc_redirect(xtc_href_link('distributor_invoices.php',xtc_get_all_get_params(array('edit_action'))));
			}else{
				xtc_redirect(xtc_href_link('distributor_invoices.php',xtc_get_all_get_params(array('edit_action')).'edit_action=add_installment'));
			}
			break;
    }
}
yes_draw_pre_header();
yes_draw_header(TITLE);
$action = (isset($_REQUEST['action'])) ? $_REQUEST['action'] : '';
switch($action){
    case 'edit':
	$di = new distributor_invoice($_GET['diID']);
	$invoice = array();
	$invoice['addressdata'] = $di->distributor;
	$invoice['info'] = $di->info;
	$invoice['info']['reasons_title'] = xtc_get_invoice_reason_title($di->info['reasons_id']);
	$invoice['info']['status_title'] = xtc_get_distributor_invoice_status_name($di->info['status']);
	$invoice['totals'] = $di->totals;
	$buttons = array(
	    array('text'=>IMAGE_BACK,
		'link'=>xtc_href_link('distributor_invoices.php',xtc_get_all_get_params(array('action','dID','iID','edit_action')).'dID='.$di->info['distributor_id']),
		'lbOn'=>false,
		'auth'=>true
	    ),
	    array('text'=>IMAGE_EDIT,
		'link'=>xtc_href_link('distributor_invoices_edit.php',xtc_get_all_get_params(array('action','iID','edit_action'))),
		'lbOn'=>false,
		'auth'=>true
	    ),
	    array('text'=>TEXT_DISTRIBUTOR,
		'link'=>xtc_href_link('distributor.php','dID='.$di->info['distributor_id']),
		'lbOn'=>false,
		'auth'=>true
	    ),
	    array('text'=>TEXT_PRINT,
		'link'=>xtc_href_link(basename(__FILE__),'action=print&diID='.$_GET['diID']),
		'lbOn'=>false,
		'auth'=>true,
                'target'=>'blank'
	    ),
          
	);
	$smarty->assign(array(
	    'HEADING_TITLE'=>sprintf(HEADING_TITLE_EDIT,$_REQUEST['diID']),
	    'ADDITIONAL_TITLE'=>TEXT_STATUS.' '.$invoice['info']['status_title'],
	    'SHOW_HEADER'=>1,
	    'PAGE_HEADING_MENU_BUTTONS'=>$buttons
	));
	break;
    default:
	$smarty->assign(array(
	    'HEADING_TITLE'=>HEADING_TITLE,
	    'SHOW_HEADER'=>1
	));
	break;
}
$smarty->display('distributor_invoices.html');
$smarty->assign('SHOW_HEADER',0);
?>
	
<table border="0" width="100%" cellspacing="0" cellpadding="2">
<tr>
	<td class="main">
<?php
$statuses_array = array();
$statuses_query = xtc_db_query("SELECT * FROM distributor_invoices_status");
while($statuses = xtc_db_fetch_array($statuses_query)){
	$statuses_array[] = array('id'=>$statuses['distributor_invoices_status_id'],'text'=>$statuses['distributor_invoices_status_name']);
}
if(!isset($_GET['action']) or $_GET['action'] != 'edit'){
	$status = isset($_GET['status']) ? $_GET['status'] : '1';
	$reason = isset($_GET['reason']) ? xtc_db_input($_GET['reason']) : '';
	$reasons_array = array(0=>array('id'=>'','text'=>TEXT_SELECT));
        $ritems = \YES4Trade\Model\distributor_invoices_reasons::get_all();
	foreach($ritems as $rit){
            $reasons_array[] = array(
                'id'=>$rit->distributor_invoices_reasons_id,
                'text'=>$rit->title
            );
	}
?>
		<table border="0">
		    <tr>
			<td valign="top">
<?php if(sizeOf($reasons_array)>1){ ?>
			    <?php echo xtc_draw_form('reasonsselect','distributor_invoices.php',xtc_get_all_get_params(array('action','reason')),'GET','class="yesForm"');?>
			    <fieldset>
				<legend><?php echo TEXT_STATS_STATUS_FILTER; ?> Buchungsklasse</legend>
			    Buchungsklasse
			    <?php echo xtc_draw_pull_down_menu('reason',$reasons_array,$reason,'onChange="document.forms[\'reasonsselect\'].submit();"'); ?>
			    </fieldset>
			    </form>
<?php } ?>
			</td><td valign="top">
			    <?php echo xtc_draw_form('statusselect','distributor_invoices.php',xtc_get_all_get_params(array('action','status')),'GET','class="yesForm"');?>
			    <fieldset>
				<legend><?php echo TEXT_STATS_STATUS_FILTER; ?> Status</legend>
			    Status:
			    <?php echo xtc_draw_pull_down_menu('status',$statuses_array,$status,'onChange="document.forms[\'statusselect\'].submit();"'); ?>
			    </fieldset>
			    </form>
			</td>
		    </tr>
		</table>
		<br />
	</td>
</tr>

<?php
}
?>

<tr>
	<td class="main" valign="top">
	
<?php
switch($action){
	case 'edit':
		if(sizeOf($di->entries)>0)
			$invoice['entries'] = $di->entries;
		if(sizeOf($di->products)>0)
			$invoice['products'] = $di->products;
		if(sizeOf($di->installments)>0){
			$invoice['installments'] = $di->installments;
			for($i=0;$i<sizeOf($invoice['installments']);$i++){
				$invoice['installments'][$i]['edit_link'] = xtc_href_link('distributor_invoices.php',xtc_get_all_get_params(array('edit_action','iID')).'edit_action=edit_installment&iID='.$invoice['installments'][$i]['id']).'#edit';
				$invoice['installments'][$i]['delete_link'] = xtc_href_link('distributor_invoices.php',xtc_get_all_get_params(array('edit_action','iID')).'edit_action=delete_installment&iID='.$invoice['installments'][$i]['id']);
				$invoice['installments'][$i]['form'] = xtc_draw_form('edit_inst','distributor_invoices.php',xtc_get_all_get_params(array('edit_action','iID')).'edit_action=save_installment&iID='.$invoice['installments'][$i]['id']);
				if($_GET['edit_action'] == 'edit_installment' and $_GET['iID'] == $invoice['installments'][$i]['id']){
					$invoice['installments'][$i]['edit'] = 1;
					$invoice['installments'][$i]['payment_method_input'] = xtc_draw_input_field('payment_method',$invoice['installments'][$i]['payment_method'],'maxlength="32"');
					$invoice['installments'][$i]['installment_input'] = xtc_draw_input_field('installment',$invoice['installments'][$i]['installment'],'maxlength="16" size="6"');
				}
			}
		}
		$smarty->assign('installments_total',$di->get_installments_sum());
		$smarty->assign('to_pay_total',$di->get_total_sum()-$di->get_installments_sum());
		$smarty->assign('invoice',$invoice);
		$smarty->assign('edit_status_form',xtc_draw_form('change_status','distributor_invoices.php',xtc_get_all_get_params(array('edit_action','iID')).'edit_action=change_status'));
		$smarty->assign('invoice_edit_status_input',xtc_draw_pull_down_menu('status_select',$statuses_array,$di->info['status']));
		$smarty->assign('invoice_edit_old_status',xtc_draw_hidden_field('old_status',$di->info['status']));
		$smarty->assign('add_installment_link',xtc_href_link('distributor_invoices.php',xtc_get_all_get_params(array('edit_action','iID')).'edit_action=add_installment').'#add');
		$history_array = array();
		$history_query = xtc_db_query("SELECT * FROM distributor_invoices_status_history WHERE distributor_invoices_id='".xtc_db_input($_GET['diID'])."' ORDER BY date_added DESC");
		while($history = xtc_db_fetch_array($history_query)){
			$history['status_name'] = xtc_get_distributor_invoice_status_name($history['distributor_invoices_status_id']);
			$history['editor_name'] = xtc_get_editor_name($history['editor_id']);
			$history_array[] = $history;
		}
		$smarty->assign('history',$history_array);

		if(isset($_GET['edit_action']) and $_GET['edit_action'] == 'add_installment'){
			$smarty->assign('add_installment',1);
			$smarty->assign('add_installment_form',xtc_draw_form('add_installment_form','distributor_invoices.php',xtc_get_all_get_params(array('edit_action','iID')).'edit_action=add_installment_save') );
			$smarty->assign('add_installment_payment_method_input',xtc_draw_input_field('payment_method','','maxlength="32"'));
			$smarty->assign('add_installment_installment_input',xtc_draw_input_field('installment','0.00','maxlength="16" size="6"'));
		}
                
                $smarty->assign(array(
                    'JS_CONFIRM_REALLY_DELETE_INSTALLMENT'=>JS_CONFIRM_REALLY_DELETE_INSTALLMENT,
                    'JS_PROMPT_STATUS_COMMENT'=>JS_PROMPT_STATUS_COMMENT,
                    'JS_ERROR_MISSING_COMMENT'=>JS_ERROR_MISSING_COMMENT,
                    'TEXT_NO_STATUS_CHANGE'=>TEXT_NO_STATUS_CHANGE,
                    'TEXT_PAYMENT_TARGET'=>TEXT_PAYMENT_TARGET,
                    'TEXT_ORDER_DATE_CREATED'=>TEXT_ORDER_DATE_CREATED,
                    'TEXT_DISTRIBUTOR_ORDER_NUMBER'=>TEXT_DISTRIBUTOR_ORDER_NUMBER,
                    'TEXT_INVOICE_REASON'=>TEXT_INVOICE_REASON,
                    'TEXT_DISTRIBUTOR_INVOICE_NUMBER'=>TEXT_DISTRIBUTOR_INVOICE_NUMBER,
                    'TEXT_INVOICE_POSITION'=>TEXT_INVOICE_POSITION,
                    'TEXT_INVOICE_POSITIONS'=>TEXT_INVOICE_POSITIONS,
                    'TEXT_DISPLAY_EXTERN_PRODUCT_LINK'=>TEXT_DISPLAY_EXTERN_PRODUCT_LINK,
                    'TEXT_AMOUNT_TO_PAY'=>TEXT_AMOUNT_TO_PAY,
                    'TEXT_UEBERWEISUNGEN'=>TEXT_UEBERWEISUNGEN,
                    'TEXT_DELETE_INSTALLMENT'=>IMAGE_DELETE,
                    'TEXT_NO_SAVED_UEBERWEISUNGEN'=>TEXT_NO_SAVED_UEBERWEISUNGEN,
                    'TEXT_ADD_INSTALLMENT'=>TEXT_ADD_INSTALLMENT,
                    'TEXT_PAYMENT_METHOD_INTRO'=>TEXT_PAYMENT_METHOD_INTRO,
                    'TEXT_CHANGE_DISTRIBUTOR_INVOICE_STATUS'=>TEXT_CHANGE_DISTRIBUTOR_INVOICE_STATUS,
                    'TEXT_CHANGE_DISTRIBUTOR_INVOICE_STATUS_CURRENT_STATUS'=>TEXT_CHANGE_DISTRIBUTOR_INVOICE_STATUS_CURRENT_STATUS,
                    'TEXT_CHANGE_DISTRIBUTOR_INVOICE_STATUS_NEW_STATUS'=>TEXT_CHANGE_DISTRIBUTOR_INVOICE_STATUS_NEW_STATUS,
                    'BUTTON_CHANGE_DISTRIBUTOR_INVOICE_STATUS'=>BUTTON_CHANGE_DISTRIBUTOR_INVOICE_STATUS,
                    
                ));
		$html=$smarty->fetch('distributor_invoices.html');
		echo $html;
		break;
	default:
		include('distributor_invoices_listing.php');
		break;
} // end switch action
?>

	</td>
</tr>
</table>
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>

