<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                             Author M. ASPELEITER <dazze@gmx.de>
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/

require('includes/application_top.php');
require_once(DIR_FS_INC.'xtc_get_product_path.inc.php');
require_once(DIR_FS_INC.'xtc_get_parent_categories.inc.php');

$action = (isset($_REQUEST['action'])) ? $_REQUEST['action'] : '';

// yes accounting  
$admin_access = main::get_admin_access();

$smarty = new yesSmarty;
$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');

$pID = (int) xtc_db_input($_GET['pID']);
if($pID<1)
	die("FEHLENDER PARAMETER.");

switch($action){
	case 'remove_dpp':
		$dppID  = xtc_db_input($_GET['dppID']);
		$distID  = xtc_db_input($_GET['distID']);
		if($dppID > 0){
			xtc_db_query("DELETE FROM distributor_product_prices WHERE distributor_product_prices_id='".$dppID."'");
			$messageStack->add_session(MSG_SUCCESS_EK_DELETE,'success');
			xtc_redirect(xtc_href_link('distributor_products.php','pID='.$pID.'&view=prices&distID='.$distID));
		}else{
			$messageStack->add_session(MSG_ERROR_EK_DELETE,'error');
			xtc_redirect(xtc_href_link('distributor_products.php','pID='.$pID.'&view=prices&distID='.$distID));
		}
		break;
	case 'add_price':
		$distID = (int)xtc_db_input($_GET['distID']);
		$price  = xtc_db_input(str_replace(',','.',$_POST['price']));
		$conditions  = xtc_db_input($_POST['conditions']);
		$shippings  = xtc_db_input($_POST['shippings']);
                $shipping_status_id  = xtc_db_input($_POST['shipping_status_id']);
		$vpe  = (int)xtc_db_input($_POST['vpe']);
		$vse  = (int)xtc_db_input($_POST['vse']);
		$vpe_width  = (int)xtc_db_input($_POST['vpe_width']);
		$vpe_height = (int)xtc_db_input($_POST['vpe_height']);
		$vpe_depth  = (int)xtc_db_input($_POST['vpe_depth']);
		$is_default  = (int)xtc_db_input($_POST['is_default']);
		if($distID > 0 && $price != ''){
			if($is_default == 1){
				xtc_db_query("UPDATE distributor_product_prices SET is_default='0' WHERE distributor_id='".$distID."'");
			}
                        $insert_sql_array = array(
                            'is_default'=>$is_default,
                            'products_id'=>$pID,
                            'distributor_id'=>$distID,
                            'conditions'=>$conditions,
                            'shippings'=>$shippings,
                            'price'=>$price,
                            'vse'=>$vse,
                            'vpe'=>$vpe, 
                            'vpe_width'=>$vpe_width, 
                            'vpe_height'=>$vpe_height, 
                            'vpe_depth'=>$vpe_depth, 
                            'date_saved'=>'now()'
                        );
                        $insert_sql_array['shipping_status_id'] = $shipping_status_id;

			xtc_db_perform('distributor_product_prices',$insert_sql_array);
			$messageStack->add_session(MSG_SUCCESS_EK_ADDED,'success');
			xtc_redirect(xtc_href_link('distributor_products.php','pID='.$pID.'&view=prices&distID='.$distID));
		}else{
			$messageStack->add_session(MSG_ERROR_EK_ADDED,'error');
			xtc_redirect(xtc_href_link('distributor_products.php','pID='.$pID.'&view=prices&distID='.$distID));
		}
		break;
	case 'change_price':
		$distID = (int)xtc_db_input($_GET['distID']);
		$dppID = (int)xtc_db_input($_POST['dppID']);
		$price  = xtc_db_input(str_replace(',','.',$_POST['price']));
		$vpe  = (int)xtc_db_input($_POST['vpe']);
		$vse  = (int)xtc_db_input($_POST['vse']);
		$vpe_width  = (int)xtc_db_input($_POST['vpe_width']);
		$vpe_height = (int)xtc_db_input($_POST['vpe_height']);
		$vpe_depth  = (int)xtc_db_input($_POST['vpe_depth']);
		$conditions  = xtc_db_input($_POST['conditions']);
		$shippings  = xtc_db_input($_POST['shippings']);
                $shipping_status_id  = xtc_db_input($_POST['shipping_status_id']);
		$is_default  = (int)xtc_db_input($_POST['is_default']);
		if($distID > 0 && $price != '' && $dppID > 0){
			if($is_default == 1){
				xtc_db_query("UPDATE distributor_product_prices SET is_default='0' WHERE distributor_id='".$distID."' and products_id='".$pID."'");
			}
                        $update_sql_array = array(
                            'is_default'=>$is_default, 
                            'conditions'=>$conditions,
                            'shippings'=>$shippings,
                            'price'=>$price,
                            'vse'=>$vse,
                            'vpe'=>$vpe,
                            'vpe_width'=>$vpe_width, 
                            'vpe_height'=>$vpe_height, 
                            'vpe_depth'=>$vpe_depth
                        );
                        $update_sql_array['shipping_status_id'] = $shipping_status_id;
			xtc_db_perform("distributor_product_prices",$update_sql_array,'update',"distributor_product_prices_id='".$dppID."'");
			$messageStack->add_session(MSG_SUCCESS_EK_UPDATE,'success');
			xtc_redirect(xtc_href_link('distributor_products.php','pID='.$pID.'&view=prices&distID='.$distID));
		}else{
			$messageStack->add_session(MSG_ERROR_EK_UPDATE,'error');
			xtc_redirect(xtc_href_link('distributor_products.php','pID='.$pID.'&view=prices&distID='.$distID));
		}
		break;
	case 'add_distributor':
		$distID = (int)xtc_db_input($_POST['distID']);
		if($distID > 0){
                    $item = \YES4Trade\Model\products_distributors::get_by_products_id_and_distributor_id(
                        intval($pID), intval($distID),['id']
                    );
                    if($item === null){
                        $dnumber = xtc_db_input($_REQUEST['distributor_number']);
                        $is_default = intval($_REQUEST['is_default']??0);
                        $new = new \YES4Trade\Model\products_distributors([
                            'products_id'=>intval($pID),
                            'distributor_id'=>intval($distID),
                            'distributor_products_number'=>$dnumber, 
                            'is_default'=>intval($is_default)
                        ]);
                        $new->create();
                        $messageStack->add_session(MSG_SUCCESS_ADD_DISTRIBUTOR,'success');
                        xtc_redirect(xtc_href_link('distributor_products.php','pID='.$pID));
                    }else{
                        $messageStack->add_session(MSG_ERROR_ADD_DISTRIBUTOR_DOUBLE,'error');
                        xtc_redirect(xtc_href_link('distributor_products.php','pID='.$pID));
                    }
		}else{
                    $messageStack->add_session(MSG_ERROR_ADD_DISTRIBUTOR,'error');
                    xtc_redirect(xtc_href_link('distributor_products.php','pID='.$pID));
		}
		break;
	case 'delete_distributor':
		$distID = (int)xtc_db_input($_GET['distID']);
		if($distID > 0){
                    $item = \YES4Trade\Model\products_distributors::get_by_products_id_and_distributor_id(
                        intval($pID), intval($distID),['id']
                    );
                    if($item !== null){
                        \YES4Trade\Model\products_distributors::delete($item->id);
                        xtc_db_query("DELETE FROM distributor_product_prices WHERE products_id='".$pID."' and distributor_id='".$distID."'");
                        $messageStack->add_session(MSG_SUCCESS_DELETE_DISTRIBUTOR,'success');
                        xtc_redirect(xtc_href_link('distributor_products.php','pID='.$pID));
                    }else{
                        $messageStack->add_session(MSG_ERROR_DELETE_DISTRIBUTOR_ALLOCATION,'error');
                        xtc_redirect(xtc_href_link('distributor_products.php','pID='.$pID));
                    }
		}else{
                    $messageStack->add_session(MSG_ERROR_DELETE_DISTRIBUTOR,'error');
                    xtc_redirect(xtc_href_link('distributor_products.php','pID='.$pID));
		}
		break;
	case 'save_number':
		$distID = (int)xtc_db_input($_POST['distID']);
		if($distID > 0){
                    $item = \YES4Trade\Model\products_distributors::get_by_products_id_and_distributor_id(
                        intval($pID), intval($distID),['id']
                    );
                    if($item !== null){
                        if($_REQUEST['is_default'] == 1){
                            \YES4Trade\Model\products_distributors::unset_default_for_products_id(intval($pID));
                        }
                        $upd = new \YES4Trade\Model\products_distributors([
                            'mindestbestellmenge'=>intval($_POST['mindestbestellmenge']),
                            'distributor_products_number'=>$_POST['distributor_products_number'],
                            'distributor_products_link'=>$_POST['distributor_products_link'],
                            'is_default'=>intval($_REQUEST['is_default']),
                            'comments'=>$_REQUEST['comments'],
                            'id'=>$item->id
                        ]);
                        $upd->update();
                        $messageStack->add_session(MSG_SUCCESS_SAVE_NUMBER,'success');
                        xtc_redirect(xtc_href_link('distributor_products.php','pID='.$pID));
                    }else{
                            $messageStack->add_session(MSG_ERROR_SAVE_NUMBER_ALLOCATION,'error');
                            xtc_redirect(xtc_href_link('distributor_products.php','pID='.$pID));
                    }
		}else{
			$messageStack->add_session(MSG_ERROR_SAVE_NUMBER,'error');
			xtc_redirect(xtc_href_link('distributor_products.php','pID='.$pID));
		}
		break;
}

$product_query = xtc_db_query("SELECT pd.products_name,p.products_model,p.products_image,p2c.categories_id,p.size_width,p.size_height,p.size_depth FROM products p,products_to_categories p2c LEFT JOIN products_description pd ON pd.products_id=p2c.products_id WHERE p.products_id='".$pID."' and pd.language_id='".$_SESSION['languages_id']."' and p2c.products_id=p.products_id");
if(xtc_db_num_rows($product_query)){
	$product = xtc_db_fetch_array($product_query);
}else{
	$product = array(
		'products_name'=>sprintf(TEXT_NO_PRODUCTS_DESC_FOR_LANGUAGE,$_SESSION['language']),
	);
}

$product_storage_array['storages'] = array();
$product_storage_query = xtc_db_query("SELECT s.id,sn.nummer,s.name FROM storage_numbers sn LEFT JOIN storages s ON s.id=sn.storage_id WHERE sn.products_id='".$pID."'");
while($product_storage = xtc_db_fetch_array($product_storage_query)){
	$product_storage_array['storages'][] = $product_storage;
}

$product_distributors_array['distributors'] = array();
$product_distributors_query = xtc_db_query("SELECT dp.mindestbestellmenge,dp.distributor_products_number,dp.distributor_products_link,dp.is_default,dp.comments,d.name,d.id FROM products_distributors dp LEFT JOIN distributors d ON d.id=dp.distributor_id WHERE dp.products_id='".$pID."'");
while($product_distributors = xtc_db_fetch_array($product_distributors_query)){
	$product_storage_array['distributors'][] = $product_distributors;
}

$products_more_array = xtc_array_merge($product,$product_distributors_array);
$products_array = xtc_array_merge($products_more_array,$product_storage_array);
$pInfo = new objectInfo($products_array);
yes_draw_pre_header();
yes_draw_header(TITLE);
?>
<script type="text/javascript">
<!--
function really_delete(distID){
	yes = confirm('<?php echo JS_CONFIRM_DELETE_ALLOCATION; ?>');
	if(yes){
		window.location.href='<?php echo xtc_href_link('distributor_products.php','action=delete_distributor&pID='.$pID.'&distID='); ?>'+distID;
	}
}

function really_delete_dpp(dppID){
	yes = confirm('<?php echo JS_CONFIRM_REALLY_DELETE_EK_PRICE; ?>');
	if(yes){
		window.location.href='<?php echo xtc_href_link('distributor_products.php',xtc_get_all_get_params(array('action')).'action=remove_dpp&dppID='); ?>'+dppID;
	}
}
//-->
</script>

<?php
$smarty->assign(array(
	'TEXT_DEFAULT_EK_PRICE'=>TEXT_DEFAULT_EK_PRICE,
	'TEXT_VOLUME'=>TEXT_VOLUME,
	'TEXT_VOLUME_INTRO'=>TEXT_VOLUME_INTRO,
	'TEXT_PRODUCTS_SIZE'=>TEXT_PRODUCTS_SIZE,
	'TEXT_PRODUCTS_SIZE_INTRO'=>TEXT_PRODUCTS_SIZE_INTRO,
	'TEXT_STORAGE_NUMBERS_ALLOCATED'=>TEXT_STORAGE_NUMBERS_ALLOCATED,
	'TEXT_COLLIES_INTRO'=>TEXT_COLLIES_INTRO,
	'TEXT_COLLIES_INTRO2'=>TEXT_COLLIES_INTRO2,
	'TEXT_COLLIES_CALCULATED_EK'=>TEXT_COLLIES_CALCULATED_EK,
	'TEXT_PRODUCT_ALLOCATED_TO_DISTRIBUTORS'=>TEXT_PRODUCT_ALLOCATED_TO_DISTRIBUTORS,
	'TEXT_DISTRIBUTOR_PRODUCT_LINK'=>TEXT_DISTRIBUTOR_PRODUCT_LINK,
	'TEXT_DISTRIBUTOR_EK_PRICES'=>TEXT_DISTRIBUTOR_EK_PRICES,
	'TEXT_EK_PRICE'=>TEXT_EK_PRICE,
	'TEXT_CONDITIONS'=>TEXT_CONDITIONS,
	'TEXT_SHIPPINGTIME'=>TEXT_SHIPPINGTIME,
	'TEXT_VPE_SIZES'=>TEXT_VPE_SIZES,
	'TEXT_NO_DISTRIBUTOR_PRICES'=>TEXT_NO_DISTRIBUTOR_PRICES,
	'TEXT_ADD_NEW_DISTRIBUTOR_PRICE'=>TEXT_ADD_NEW_DISTRIBUTOR_PRICE,
	'TEXT_ADD_PRODUCT_DISTRIBUTOR'=>TEXT_ADD_PRODUCT_DISTRIBUTOR,
	'TEXT_NO_DISTRIBUTORS_EXIST'=>TEXT_NO_DISTRIBUTORS_EXIST
));
$view = (isset($_GET['view'])) ? $_GET['view'] : '';
switch($view){
	case 'prices':
		$smarty->assign('edit_ek',1);
		$dist_query = xtc_db_query("SELECT name FROM distributors WHERE id='".(int)xtc_db_input($_GET['distID'])."'");
		$dist = xtc_db_fetch_array($dist_query);
		$smarty->assign('distributor_name',$dist['name']);
		$ekprice_query = xtc_db_query("SELECT vse,distributor_product_prices_id,shippingtime,price,is_default,date_saved,shippings,conditions,vpe,vpe_width,vpe_height,vpe_depth,shipping_status_id FROM distributor_product_prices WHERE products_id='".$pID."' and distributor_id='".(int)xtc_db_input($_GET['distID'])."' ORDER BY date_saved ASC");
		$anzahl = xtc_db_num_rows($ekprice_query);
                
                $shippingtimes = xtc_get_shipping_status();
                
                
		$ek_prices = array();
		while($ekprice = xtc_db_fetch_array($ekprice_query)){
			$ek = array();
			if(isset($_GET['change_price']) and $_GET['change_price'] == $ekprice['distributor_product_prices_id']){
                            $smarty->assign('EDIT_PRICE_MODE',1);
				$ek['edit'] = 1;
				$ek['form'] = xtc_draw_form('price_change','distributor_products.php','pID='.$pID.'&distID='.(int)xtc_db_input($_GET['distID']).'&action=change_price');
				$ek['input_id'] = xtc_draw_hidden_field('dppID',$ekprice['distributor_product_prices_id']);
				$ek['is_default'] = $ekprice['is_default'];
				$ek['input_price'] = xtc_draw_input_field('price',$ekprice['price'],'size="6"');
				$ek['input_conditions'] = xtc_draw_textarea_field('conditions','',25,2,$ekprice['conditions']);
				$ek['input_shippings'] = xtc_draw_textarea_field('shippings','',25,2,$ekprice['shippings']);
                                $ek['input_shippingtime'] = xtc_draw_pull_down_menu('shipping_status_id',$shippingtimes,$ekprice['shipping_status_id']);
				$ek['input_vse'] = xtc_draw_input_field('vse',(int)$ekprice['vse'],'size="5" maxlength="10"');
				$ek['input_vpe'] = xtc_draw_input_field('vpe',(int)$ekprice['vpe'],'size="5" maxlength="10"');
				$ek['input_vpe_width'] = xtc_draw_input_field('vpe_width',(int)$ekprice['vpe_width'],'size="5" maxlength="10"');
				$ek['input_vpe_height'] = xtc_draw_input_field('vpe_height',(int)$ekprice['vpe_height'],'size="5" maxlength="10"');
				$ek['input_vpe_depth'] = xtc_draw_input_field('vpe_depth',(int)$ekprice['vpe_depth'],'size="5" maxlength="10"');
				$ek['date_saved'] = yes_strftime('%d.%m.%Y',strtotime($ekprice['date_saved']));
				$ek['input_sav'] = xtc_draw_input_field('sav',IMAGE_SAVE,'src="images/icon_save.gif" border="0"','','image');
			}else{
				$ek['price'] = number_format($ekprice['price'],2,',','');
				$ek['conditions'] = $ekprice['conditions'];
				$ek['shippings'] = $ekprice['shippings'];
                                $ek['shippingtime'] = xtc_get_shipping_status_name($ekprice['shipping_status_id']);
				$ek['is_default'] = $ekprice['is_default'];
				$ek['vse'] = $ekprice['vse'];
				$ek['vpe'] = $ekprice['vpe'];
				$ek['vpe_width'] = $ekprice['vpe_width'];
				$ek['vpe_height'] = $ekprice['vpe_height'];
				$ek['vpe_depth'] = $ekprice['vpe_depth'];
				$ek['m3'] = number_format((($ekprice['vpe_depth']*$ekprice['vpe_height']*$ekprice['vpe_width'])/1000000),4,',','.');
				$ek['date_saved'] = yes_strftime('%d.%m.%Y',strtotime($ekprice['date_saved']));
				$ek['edit_link'] = '<a href="'.xtc_href_link('distributor_products.php',xtc_get_all_get_params(array('action')).'&change_price='.$ekprice['distributor_product_prices_id']).'">'.xtc_image('images/icons/icon_edit.gif','editieren').'</a>';
    				$ek['delete_link'] = '<a href="#" onClick="really_delete_dpp(\''.$ekprice['distributor_product_prices_id'].'\');">'.xtc_image('images/icons/cross.gif',IMAGE_DELETE).'</a>';
			}
			$ek_prices[] = $ek;
		}
		if(sizeOf($ek_prices)>0)
			$smarty->assign('dek_array',$ek_prices);

		$smarty->assign('add_price_form',xtc_draw_form('add_price','distributor_products.php','view=prices&pID='.$pID.'&distID='.(int)xtc_db_input($_GET['distID']).'&action=add_price'));
		$smarty->assign('add_input_price',xtc_draw_input_field('price','','size="6"'));
		$smarty->assign('add_input_conditions',xtc_draw_textarea_field('conditions','',25,2,''));
		$smarty->assign('add_input_shippings',xtc_draw_textarea_field('shippings','',25,2,''));
                $smarty->assign('add_input_shippingtime',xtc_draw_pull_down_menu('shipping_status_id',$shippingtimes));
		$smarty->assign('add_input_vse',xtc_draw_input_field('vse',1,'size="5" maxlength="10"'));
		$smarty->assign('add_input_vpe',xtc_draw_input_field('vpe',1,'size="5" maxlength="10"'));
		$smarty->assign('add_input_vpe_width',xtc_draw_input_field('vpe_width','','size="5" maxlength="10"'));
		$smarty->assign('add_input_vpe_height',xtc_draw_input_field('vpe_height','','size="5" maxlength="10"'));
		$smarty->assign('add_input_vpe_depth',xtc_draw_input_field('vpe_depth','','size="5" maxlength="10"'));
		break;
}
?>

<!-- header //-->
<?php 
$cPath = xtc_get_product_path( xtc_db_input($_GET['pID']));
$back_link = xtc_href_link('categories.php','action=new_product&cPath='.$cPath.'&pID='.(int)xtc_db_input($_GET['pID'] ));
$buttons = array(
    array('text'=>TEXT_LINK_PRODUCTS_EDIT,
	'link'=>$back_link,
	'lbOn'=>false,
	'auth'=>true
    )
);
$newest_ek_prices = array();
$query = xtc_db_query(sprintf(
	"SELECT dpp.date_saved,dpp.price,d.name FROM distributor_product_prices dpp LEFT JOIN distributors d ON dpp.distributor_id=d.id WHERE dpp.products_id='%s' ORDER BY date_saved DESC LIMIT 10 ",
	$pID
));
while($record = xtc_db_fetch_array($query)){
    $newest_ek_prices[] = array(
	'distributor'=>$record['name'],
	'price'=>number_format($record['price'],2,',','.'),
	'date_created'=>xtc_date_short($record['date_saved'])
    );
}

$smarty->assign(array(
    'HEADING_TITLE'=>TEXT_PAGE_HEADING,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
    'TEXT_NEWEST_EK_PRICES'=>TEXT_NEWEST_EK_PRICES,
    'newest_ek_prices'=>$newest_ek_prices,
    'JS_ERROR_NO_DEFAULT_EK'=>JS_ERROR_NO_DEFAULT_EK,
    'NO_DEFAULT_EK'=>NO_DEFAULT_EK,
    'JS_ERROR_NO_DEFAULT_EK_HELP_LINK_TITLE'=>JS_ERROR_NO_DEFAULT_EK_HELP_LINK_TITLE,
));
$collies = xtc_get_product_collies($pID);
$smarty->assign('products_image',xtc_image(DIR_WS_CATALOG.'images/product_images/thumbnail_images/'.$pInfo->products_image));
$smarty->assign('products_name',$pInfo->products_name);
$smarty->assign('products_model',$pInfo->products_model);

if(sizeOf($collies)>0){
	$total_ek = 0;
	$colli_array = array();
	foreach($collies as $ck=>$collie){
		$colli = array();
		$colli['qty'] = $collie['quantity'];
		$colli['pID'] = $collie['collie_products_id'];
		$colli['link'] = xtc_href_link('distributor_products.php','pID='.$collie['collie_products_id']);
		$colli['name'] = xtc_get_products_name($collie['collie_products_id']);
		if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_products_distributors_prices'] == '1')){
				$ek = xtc_get_price_ek($collie['collie_products_id'])*$collie['quantity'];
				$total_ek += $ek;
				$colli['ek'] = number_format($ek,2,',','.').' '.DEFAULT_CURRENCY;
		}else{
			$colli['ek']  = '&nbsp;';
		}
		$colli_array[] = $colli;
	}
	if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_products_distributors_prices'] == '1')) {
		$smarty->assign('total_ek',number_format($total_ek,2,',','.').' '.DEFAULT_CURRENCY);
	}
	$smarty->assign('colli_array',$colli_array);
	$volumina = floatval(str_replace(',','.',xtc_get_volumina($pID)));
	$smarty->assign('volume',number_format($volumina,4,',','.'));
}
if(sizeOf($pInfo->storages)>0){ 
	$storage_array = array();
	foreach($pInfo->storages as $k=>$storage_info){
		$storage_array[] = array('name'=>$storage_info['name'],'nummer'=>$storage_info['nummer'],'link'=>xtc_href_link('storage.php','sID='.$storage_info['id']));
	}
	$smarty->assign('storages_array',$storage_array);
	$smarty->assign('product_info_link',xtc_href_link('categories.php','cPath='.$pInfo->categories_id.'&pID='.$pID.'&action=new_product'));
} 

$smarty->assign(array(
    'size_width'=>$pInfo->size_width,
    'size_height'=>$pInfo->size_height,
    'size_depth'=>$pInfo->size_depth,
    'products_id'=>$pID,
    'JS_ERROR_NO_DISTRIBUTOR_PRODUCTS_NUMBER'=>JS_ERROR_NO_DISTRIBUTOR_PRODUCTS_NUMBER
));
switch($view) {
	case 'start':
		// gruppieren nach versender
		foreach($_POST['versender'] as $order => $versender) {
			$sorted_orders[$versender][] = $order;
		}
		foreach($sorted_orders as $versender => $orders){
			for($i=0;$i<count($orders);$i++) {
				$oID = $orders[$i];
				
				$query = xtc_db_query("select o.date_payment,o.orders_id,o.ebay_id,o.customers_id,o.is_parent, c.customers_ebay_userid,o.delivery_name, o.delivery_street_address, delivery_postcode, delivery_city, delivery_country, delivery_company from orders as o, customers as c WHERE o.customers_id=c.customers_id AND o.orders_status='".ORDERS_STATUS_BEZAHLT."' && o.orders_id='".$oID."'");
				$shipping = xtc_db_fetch_array($query);
				
				if($shipping['date_payment'] > 0) {
					$paydate = '<b>'.TEXT_PAYMENT_DATE.':</b> <font size=1>'.yes_strftime('%d.%m.%y',strtotime($shipping['date_payment']))."</font><br>";
				}else{
					$paydate_query = xtc_db_query("SELECT date_added FROM orders_status_history WHERE orders_id='".$oID."'");
					$paydate_res = xtc_db_fetch_array($paydate_query);
					$paydate = '<b>'.TEXT_PAYMENT_DATE.':</b> <font size=1>'.yes_strftime('%d.%m.%y',strtotime($paydate_res['date_added']))."</font><br>";
				}
				$payment_query = xtc_db_query("SELECT ip.buchungstag,ip.betrag FROM incoming_payments ip, payment_orders po WHERE ip.id=po.payment_id and po.orders_id='".$oID."'");
				$payment_orders = '';
				if(xtc_db_num_rows($payment_query) > 0){
					$payment_orders .= '<table border="0" cellpadding="1" cellspacing="0" width=100%>';
					while($payment = xtc_db_fetch_array($payment_query)) {
						$payment_orders .= '<tr><td class="smallText"><b>'.TEXT_INCOMING_PAYMENT.':</b></td><td class="smallText">'.$payment['buchungstag'].'</td><td class="smallText" align="right">'.number_format($payment['betrag'],2,',','').'</td></tr>';
					}
					$payment_orders .= '</table>';
				}
				
				$orderdata[] = array('orders_id'=>$shipping['orders_id'],
				'customers_ebay_userid' => $shipping['customers_ebay_userid'],
				'customers_id' => $shipping['customers_id'],
				'delivery_name' => $shipping['delivery_name'],
				'delivery_street_address' => $shipping['delivery_street_address'],
				'delivery_postcode' => $shipping['delivery_postcode'],
				'delivery_city' => $shipping['delivery_city'],
				'delivery_country' => $shipping['delivery_country'],
				'is_parent' => $shipping['is_parent'],
				'paydate'=>$payment_orders.$paydate,
				'versender' => $_POST['versendet['.$oID.']'],
				'ebay_id' => $shipping['ebay_id'],
				'delivery_company' => $shipping['delivery_company']);
			}
		}
		break;
	default:
		if(sizeOf($pInfo->distributors)>0){
			$distributors = array();
			foreach($pInfo->distributors as $k=>$distData){
				$distributor = array();
				$distributor['rowstyle'] = (isset($_GET['distID']) and $_GET['distID'] == $distData['id']) ? 'dataTableRowSelected' : 'dataTableRow';
				$distributor['form'] = xtc_draw_form('DF'.$distData['id'],'distributor_products.php','pID='.$pID.'&action=save_number');
				$distributor['input_id'] = xtc_draw_hidden_field('distID',$distData['id']);
				$distributor['link'] = xtc_href_link('distributor.php','dID='.$distData['id']);
				$distributor['distributor_name'] = $distData['name'];
				$distributor['input_number'] = xtc_draw_input_field('distributor_products_number',$distData['distributor_products_number'],'size="25" maxlength="128"');
				$distributor['input_link'] = xtc_draw_input_field('distributor_products_link',$distData['distributor_products_link'],'size="20" maxlength="255"');
				$distributor['input_mindestbestellmenge'] = xtc_draw_input_field('mindestbestellmenge',(int)$distData['mindestbestellmenge'],'size="5" maxlength="6"');
				$distributor['input_is_default'] = xtc_draw_checkbox_field('is_default',1,(($distData['is_default'] == 1)?true:false));
				$distributor['input_comments'] = xtc_draw_textarea_field('comments', 'virtual', 20, 3,xtc_db_prepare_input($distData['comments']));

				if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_products_distributors_prices'] == '1')) {
					$distributor['edit_price_link'] =  "<a href='".xtc_href_link('distributor_products.php','view=prices&pID='.$pID.'&distID='.$distData['id'])."'><u>".TEXT_LINK_EK_PRICES."</u></a>";
				}else{
					$distributor['edit_price_link'] =  "<a href='#' onClick=\"alert('".JS_ALERT_AUTH_ERROR_EDIT_EK."');\">".xtc_image('images/icons/preview.gif',TEXT_LINK_EK_PRICES)."</a>";
				}
				$distributor['delete_link'] =  "<a href='#' onClick=\"really_delete('".$distData['id']."');\">".xtc_image('images/icons/cross.gif',IMAGE_DELETE)."</a>";
				$distributors[] = $distributor;
			}
			$smarty->assign('distributors',$distributors);
		}

		// WORKAROUND - PRODUKTE MIT EK PREISEN OHNE LIEFERANTENZUWEISUNG
		$dpp_array = array();
		$dpp_query = xtc_db_query("SELECT d.name,dpp.* FROM distributor_product_prices dpp LEFT JOIN products_distributors dp USING(distributor_id,products_id), distributors d WHERE dpp.products_id='".$pID."' and d.id=dpp.distributor_id AND dp.id IS NULL");
		if(xtc_db_num_rows($dpp_query)){
			$count = 0;
			$ek_prices = array();
			while($dpp = xtc_db_fetch_array($dpp_query)){
				$ek = array();
				$submit = '';
				$ek['delete_link'] = '<a href="'.xtc_href_link('distrubutor_products',xtc_get_all_get_params(array('action')).'action=remove_dpp&dppID='.$dpp['distributor_product_prices_id'].'&distID='.$dpp['distributor_id']).'">'.xtc_image('images/icons/cross.gif',IMAGE_DELETE).'</a>';
				$ek['form'] = xtc_draw_form('add_distributor_'.$count,'distributor_products.php','pID='.$pID.'&action=add_distributor');
				$ek['input_id'] = xtc_draw_hidden_field('distID',$dpp['distributor_id']);
				$ek['submit_button'] = $submit = '<input type="image" src="images/plus.gif" border="0" alt="'.BUTTON_ALLOCATE_TO_DISTRIBUTOR.'" title="'.BUTTON_ALLOCATE_TO_DISTRIBUTOR.'" />';
				$ek['distributor_name'] = $dpp['name'].' '.TEXT_NOT_ALLOCATED;
				$ek['price'] = number_format($dpp['price'],2,',','.');
				$ek['vse'] = $dpp['vse'];
				$ek['vpe'] = $dpp['vpe'];
				$ek['date_saved'] = xtc_date_short($dpp['date_saved']);
				$ek_prices[] = $ek;
				$count++;
			}
			$smarty->assign('ek_prices_unallocated',$ek_prices);
		}
		// ENDE WORKAROUND
		
		$dist_query = xtc_db_query("SELECT id,name FROM distributors WHERE account_type='Lieferant' ORDER BY name");
		$distributors_array[] = array('id'=>'','text'=>TEXT_SELECT);
		while( $dist = xtc_db_fetch_array($dist_query) ){
			$distributors_array[] = array('id'=>$dist['id'],'text'=>$dist['name']);
		}
		if(sizeOf($distributors_array)>1){
			$smarty->assign('distributors_array',$distributors_array);
			$smarty->assign('add_distributor_form',xtc_draw_form('add_distributor','distributor_products.php','pID='.$pID.'&action=add_distributor','POST','onsubmit="return _check_add_distributor_submit()"'));
			$smarty->assign('add_distributor_input',xtc_draw_pull_down_menu('distID',$distributors_array));
		}
		break;
}
$html=$smarty->fetch('distributor_products.html');
echo $html;
require(DIR_WS_INCLUDES . 'footer.php'); 
require(DIR_WS_INCLUDES . 'application_bottom.php'); 
