<?php
require_once(DIR_FS_INC.'yes_products_calc_in_auction_quantity.inc.php');
$id = (int)xtc_db_input($_REQUEST['id']);
$auction = new ebay_auction($id);
$EBAYAPI = new ebayApi;
$site_id = $EBAYAPI->get_site_id_from_name($auction->getSite());
$sandbox = (main::isDev(true)) ? true : false;
$ebaycaller = new \YES4Trade\Model\ebaycalls();
$res = $ebaycaller->tradingQuery($auction->getUser(),'GetItem',$site_id,[
    'ItemID'=>$auction->ebay_id,
    'OutputSelector'=>'Item.Variations'
]);
$VariationSpecificNameForPics = '';
if($EBAYAPI->isGood($res)){
    $Variations = $res->Item->Variations;
    $VariationArray = $Variations->Variation;
    $VArray = array();
    foreach($VariationArray as $pos=>$VariationType){
        $VS = array();
        foreach($VariationType->VariationSpecifics as $NVLT){
            // neu - 2024/07
            foreach($NVLT->NameValueList as $nv){
            //alt
            //foreach($NVLT->__get('NameValueList') as $nv){
                $VS[ $nv->Name ] = implode(', ',current($nv->Value));
            }
        }
        $sold = (isset($VariationType->SellingStatus->QuantitySold)) ? intval($VariationType->SellingStatus->QuantitySold) : 0;
        $vstartprice = $VariationType->StartPrice;

        $VArray[] = array(
            'SKU'=>$VariationType->SKU,
            'StartPrice'=>number_format($vstartprice,2,',','.'),
            'Quantity'=>(int)$VariationType->Quantity-$sold,
            'QuantitySold'=>$sold,
            'VariationSpecifics'=>$VS
        );
    }
    $Pictures = $Variations->Pictures;
    $VariationSpecificsSet = $Variations->VariationSpecificsSet;
    $VSArray = array();
    // NEU 2024-07
    foreach($VariationSpecificsSet->NameValueList as $NVLT){
    // ALT
    //foreach($VariationSpecificsSet->__get('NameValueList') as $NVLT){
        $value = (!is_countable($NVLT->Value))?[$NVLT->Value]:$NVLT->Value;
        $vs = array(
            'Name'=>$NVLT->Name,
            'Value'=>$value,
        );
        if($Pictures !== null and $Pictures->VariationSpecificName == $NVLT->Name){
            foreach($Pictures->VariationSpecificPictureSet as $VSPS){
                $VariationSpecificNameForPics = $NVLT->Name;
                foreach($vs['Value'] as $vsID=>$vs_val){
                    if($vs_val == $VSPS->VariationSpecificValue){
                        $vpicurl = $VSPS->PictureURL;
                        if(main::isDev(true)){
                            $vpicurl = str_replace('https:','http:',$vpicurl);
                        }
                        $vs['Value_images'][$vs_val] = $vpicurl;
                    }
                }
            }
        }
        $VSArray[] = $vs;
    }
    /**
      * wenn eine Variante erweitert wird und das Set bisher kein Bild beinhaltete, dann
      * nehmen wir das erste Merkmal
    */
    if($VariationSpecificNameForPics == ''){
            $VariationSpecificNameForPics = $VSArray[0]['Name'];
    }
}else{
    $msg = implode('<br />',$EBAYAPI->getResponseErrors($res));
    die(json_encode(array(
        'MSG'=>$msg
    )));
}
/**
 * AKTUALISIERE DIE ANGEBOTENE MENGE EINER VARIANTE
 * MUSS GROESSER ALS 0 SEIN - SONST IST ES VARIANTE LOESCHEN
 */
if(isset($_GET['quantity_update']) and $_GET['quantity_update'] == 1 and isset($_GET['sku']) and !empty($_GET['sku']) and isset($_GET['qty']) and (int)$_GET['qty'] > 0){
    $sku = urldecode($_GET['sku']);
    $qty = (int)$_GET['qty'];
    $pID = 0;
    foreach($auction->getVariations() as $av){
        if($av->sku == $sku){
            $pID = $av->products_id;
        }
    }
    if($pID < 1){
        die(json_encode([
            'MSG'=>'Unknown pID for SKU '.$sku
        ]));
    }
    $product = new product($pID);
    $SQ = new products_quantity($pID);
    if(STOCK_CHECK == 'true'){
        if($SQ->get_available1_qty() < $qty){
            $avmsg = TEXT_MESSAGE_QUANTITY_CHECK_AUCTION.' (pID '.$pID.': '.$qty.' / '.$SQ->get_available1_qty().')';
            die(json_encode(array(
                'MSG'=>yes_encode_string($avmsg)
            )));
        }
    }
    foreach($Variations->Variation as $Variation){
        if($sku != $Variation->SKU){
            continue;
        }
        $item = new \stdClass();
        $new_Variations = new \stdClass();
        $item->ItemID = $auction->ebay_id;
        $Variation->Quantity = $qty;

        $new_Variations->Variation[] = $Variation;
        $item->Variations = $new_Variations;
        $res = $EBAYAPI->revise_auction($id, $item);
        if($res != ''){
                $msg = $res;
        }else{
            $msg = '';
        }
        \YES4Trade\Model\ebay_auctions_variations::update_ebay_auctions_variations_by_ebay_auctions_id_and_sku_and_products_id([
            'quantity'=>intval($qty),
            'quantity_sold'=>intval($Variation->SellingStatus->QuantitySold),
            'ebay_auctions_id'=>intval($id),
            'products_id'=>intval($pID),
            'sku'=>$sku
        ]);
        $new_in_auction_qty = yes_products_calc_in_auction_quantity(intval($pID));
        yes_update_products_in_auction_quantity(intval($pID),
            $new_in_auction_qty,
            sprintf(TEXT_SQ_UPDATED_QUANTITY_VARIATION_AUCTION,$auction->ebay_id,$qty),
            true
        );
        die(json_encode(array(
            'MSG'=>$msg
        )));
    }
    exit;
}


/**
 * LOESCHEN EINES BILDS AUS EINEM VARIANTENSET EINER LAUFENDEN AUKTION
 * DIE PICTURES DIE UEBRIG BLEIBEN SOLLEN WERDEN ALLE UEBERGEBEN
 */

if(isset($_GET['delete_img']) and $_GET['delete_img'] != '' and isset($_GET['vsvalue']) and $_GET['vsvalue'] != ''){
    $vsvalue = urldecode($_GET['vsvalue']);
    $delete_url = urldecode($_GET['delete_img']);
    if($Variations->Pictures !== null){
    	$newVariationSpecificPictureSets = [];
        foreach($Variations->Pictures->VariationSpecificPictureSet as $VariationSpecificPictureSetType){
            if($VariationSpecificPictureSetType->VariationSpecificValue != $vsvalue){
                $newVariationSpecificPictureSets[] = $VariationSpecificPictureSetType;
            }
            /*
            $new_PictureURLArray = [];
            if(is_countable($VariationSpecificPictureSetType->PictureURL)){
                foreach($VariationSpecificPictureSetType->PictureURL as $url){
                    if(main::isDev(true)){
                        if(strpos($delete_url,'localhost') !== false){
                            $delete_url = str_replace('http:','https:',$delete_url);
                        }
                    }
                    printf('<li>%s vs %s</li>',$url, $delete_url);
                    if($url != $delete_url){
                        $new_PictureURLArray[] = $url;
                    }
                }
                if(is_countable($new_PictureURLArray) and sizeOf($new_PictureURLArray) == 1){
                    // HIER WIRD ES AUCH ZUM STRING
                    // WENN NUR NOCH EIN BILD UEBRIG IST
                    $new_PictureURLArray = (string)current($new_PictureURLArray);
                }
            }else{
                if($url != $delete_url){
                    $new_PictureURLArray = $url; // HIER WIRD ES ZUM STRING
                }
            }
            $VariationSpecificPictureSetType->PictureURL = $new_PictureURLArray;*/
        }
    }
    $Variations->Pictures->VariationSpecificPictureSet = $newVariationSpecificPictureSets;
    $item = new \stdClass();
    $item->ItemID = $auction->ebay_id;
    $item->Variations = $Variations;
    $res = $EBAYAPI->revise_auction($id, $item);
    if($res != ''){
            $msg = $res;
    }else{
        $msg = '';
    }
    die(json_encode(array(
        'MSG'=>$msg
    )));
}

/**
 * LOESCHEN EINER VARIANTE AUS EINEM VARIANTENSET EINER LAUFENDEN AUKTION
 * DIE VARIATIONS WERDEN ALLE UEBERGEBEN UND DIE ZU LOESCHENDE VARIANTE ERHAELT
 * ZUSAETZLICH DAS FLAG "Deleted" MIT True
 */
if(isset($_GET['delete']) and $_GET['delete'] == 1){
    $sku = xtc_db_input($_GET['sku']);
    $new_Variations = [];
    foreach($Variations->Variation as $Variation){
        if($Variation->SKU != $sku){
            continue;
        }
        $Variation->Delete = true;
        $deleted = true;
    }
    if(!$deleted){
        $msg = 'Error: Unknown SKU';
        die(json_encode(array(
                'MSG'=>$msg
        )));
    }
   
    $item = new \stdClass();
    $item->ItemID = $auction->ebay_id;
    $item->Variations = $Variations;
    $res = $EBAYAPI->revise_auction($id, $item);
    if($res != ''){
        $msg = $res;
    }else{
        $eav = \YES4Trade\Model\ebay_auctions_variations::get_by_ebay_auctions_id_and_sku(
            intval($id),$sku,
            ['ebay_auctions_variations_id','quantity','products_id']
        );
        if($eav === null){
            die(json_encode(array(
                'MSG'=>'SKU "'.$sku.'" unknown in this auction variationset'
            )));
        }
        \YES4Trade\Model\ebay_auctions_variations::delete($eav->ebay_auctions_variations_id);

        // IN_AUCTION quantity aktualisieren
        yes_update_products_in_auction_quantity(intval($eav->products_id),
            yes_products_calc_in_auction_quantity(intval($eav->products_id)),
            sprintf(TEXT_SQ_DELETED_VARIATION_AUCTION,$auction->ebay_id,-$eav->quantity),
            true // overwrite!
        );
        $msg = '';
    }
    die(json_encode(array(
        'MSG'=>$msg
    )));
}
/**
 * Neue Variante dem Set hinzufuegen
 */
if(isset($_REQUEST['new_variation_pID']) and isset($_REQUEST['price']) and $_REQUEST['price'] != '' and isset($_REQUEST['quantity']) and $_REQUEST['quantity'] > 0){
    $msg = '';
    $ebay_auctions_id = (int)xtc_db_input($_REQUEST['id']);
    $new_variation_pID = (int)xtc_db_input($_REQUEST['new_variation_pID']);
    $qty = (int)xtc_db_input($_REQUEST['quantity']);
    $price = (float)xtc_db_input(str_replace(',','.',$_REQUEST['price']));

    $SQ = new products_quantity($new_variation_pID);
    if(STOCK_CHECK == 'true'){
            if($SQ->get_available2_qty() < $qty){
                    die(json_encode(array(
                            'MSG'=>yes_encode_string(sprintf(TEXT_ERROR_PRODUCT_HAS_NOT_ENOUGH_AV2_QTY,$new_variation_pID,$SQ->get_available2_qty()))
                    )));
            }
    }
    $collies = xtc_get_product_collies($new_variation_pID);
    if(sizeOf($collies)){ // stklistenartikel abfrage
        die(json_encode(array(
            'MSG'=>yes_encode_string(TEXT_STUECKLISTENARTIKEL_NOT_ALLOWED_AS_VARIATION)
        )));
    }
    if(defined('MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_STATUS') and MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_STATUS == 'True'){
        $ea = new ebay_auction($ebay_auctions_id);
        if($ea->has_staffelpreise()){
            die(json_encode(array(
                'MSG'=>yes_encode_string(ERROR_NO_VARIATION_ADD_FOR_STAFFELPREISE)
            )));
        }
    }
    foreach($Variations->Variation as $Variation){
        foreach($Variation->VariationSpecifics as $VariationSpecific){
            foreach($VariationSpecific->NameValueList as $NVL){
                if($NVL->Name != $VariationSpecificNameForPics){
                    continue;
                }
                if($NVL->Value[0] != urldecode($_GET['vs'][$VariationSpecificNameForPics])){
                    continue;
                }
                die(json_encode(array(
                    'MSG'=>yes_encode_string(sprintf(ERROR_VARIATIONSPECIFICS_EXISTS_IN_VARIATIONSPECIFICSSET,
                            $_GET['vs'][$VariationSpecificNameForPics],$VariationSpecificNameForPics
                    ))
                )));
            }
        }
    }

    $item = new \stdClass();
    $variation = new \stdClass();
    $variation->StartPrice = (float)$price;
    $vs = new \stdClass();
    foreach($_REQUEST['vs'] as $vsid=>$vsval){
        $nvl = new \stdClass();
        $nvl->Name = yes_decode_string($vsid);
        $nvl->Value[] = yes_decode_string($vsval);
        $vs->NameValueList[] = $nvl;
    }
    $Variations = new \stdClass();
    $item->ItemID = $auction->ebay_id;
    $variation->SKU = (string)$new_variation_pID;
    $variation->Quantity = (int)$qty;
    
    // LINKAUFBAU
    // http://localhost/yes/admin/ebayapi_cart.php?action=add_variation_to_auction&id=15&new_variation_pID=3&price=9.00&quantity=9&vs[Farbe]=Pink&vs[MPN]=Does%20not%20apply&img[]=3_0.jpg
        
    $variation->VariationSpecifics[] = $vs;
    $Variations->Variation[] = $variation;
    $item->Variations = $Variations;
    $res = $EBAYAPI->revise_auction($id, $item);
    if($res != ''){
            $msg = str_replace("\n"," ",$res);
    }else{
        $eav_list = \YES4Trade\Model\ebay_auctions_variations::get_by_ebay_auctions_id_and_products_id(
            intval($auction->getId()), intval($new_variation_pID),
            ['ebay_auctions_variations_id']
        );
        if(!sizeOf($eav_list)){
            \YES4Trade\Model\ebay_auctions_variations::create_ebay_auctions_variations([
                'ebay_auctions_id'=>intval($auction->getId()),
                'products_id'=>intval($new_variation_pID),
                'quantity'=>intval($qty),
                'sku'=>(string)$new_variation_pID,
                'price'=>(float)$price
            ]);
            // IN_AUCTION quantity aktualisieren
            yes_update_products_in_auction_quantity(intval($new_variation_pID),
                yes_products_calc_in_auction_quantity(intval($new_variation_pID)),
                sprintf(TEXT_SQ_NEW_VARIATION_AUCTION,$auction->ebay_id,$qty),
                true // overwrite!
            );
        }
    }
    die(json_encode(array(
        'MSG'=>$msg
    )));
}
if(isset($_REQUEST['new_variation_pID']) and $_REQUEST['new_variation_pID'] > 0){
    $new_variation_pID = (int)xtc_db_input($_REQUEST['new_variation_pID']);
    $query = xtc_db_query(sprintf(
        "SELECT products_id FROM %s WHERE products_id='%d'",
        TABLE_PRODUCTS,$new_variation_pID
    ));
    if(!xtc_db_num_rows($query)){
        die(json_encode(array(
            'MSG'=>yes_encode_string(sprintf(TEXT_ERROR_PRODUCTS_ID_NOT_EXISTS,$new_variation_pID))
        )));
    }
    $product = new product($new_variation_pID);
    $SQ = new products_quantity($new_variation_pID);
    if(STOCK_CHECK == 'true'){
        if($SQ->get_available2_qty() < 1){
            die(json_encode(array(
                'MSG'=>yes_encode_string(sprintf(TEXT_ERROR_PRODUCT_HAS_NO_AV2_QTY,$new_variation_pID))
            )));
        }
    }
    $eav_list = \YES4Trade\Model\ebay_auctions_variations::get_by_ebay_auctions_id_and_products_id(
        intval($auction->getId()),intval($new_variation_pID),
        ['ebay_auctions_variations_id','quantity']
    );
    if(sizeOf($eav_list)){
        foreach($eav_list as $eav){
            if(intval($eav->quantity) > 0){
                die(json_encode(array(
                    'MSG'=>yes_encode_string(sprintf(TEXT_ERROR_AUCTION_VARIATION_EXISTS,$new_variation_pID))
                )));
            }
        }
    }
    
    // BOF - TICKET 1525 - VORHANDENEN DATENSATZ GGF LOESCHEN
    foreach($eav_list as $eav){
        \YES4Trade\Model\ebay_auctions_variations::delete($eav->ebay_auctions_variations_id);
    }
    // EOF - TICKET 1525 - VORHANDENEN DATENSATZ GGF LOESCHEN
    yes_update_products_in_auction_quantity(intval($new_variation_pID),
        yes_products_calc_in_auction_quantity(intval($new_variation_pID)),
        '[new variation pID] deleted',
        true // overwrite!
    );

	
    $product_name = (!empty($product->info['ebay_title']))?$product->info['ebay_title']:$product->info['slave_title'];
    if($products_name == ''){
        $products_name = $product->info['products_name'];
    }
    require_once(DIR_FS_CATALOG.DIR_WS_CLASSES . 'xtcPrice.php');
    $xtPrice = new xtcPrice(DEFAULT_CURRENCY,EBAY_CUSTOMERS_STATUS);
    $final_price=$xtPrice->xtcGetPrice($new_variation_pID,
        false,
        1,
        $product->info['products_tax_class_id'],0
    );
    $input_vs = array();
    // NEU
    foreach($VariationSpecificsSet->NameValueList as $NVLT){
    // ALT
    // foreach($VariationSpecificsSet as $NVLT){
        $values_array = array();
        if(!is_countable($NVLT->Value) and !empty($NVLT->Value)){
            $NVLT->Value = [$NVLT->Value];
        }
        foreach($NVLT->Value as $val){
            $values_array[] = array('id'=>yes_encode_string($val),'text'=>yes_encode_string($val));
        }
        $input_vs[] = array(
            'id'=>yes_encode_string($NVLT->Name),
            'input'=>xtc_draw_pull_down_menu('vs['.yes_encode_string($NVLT->Name).']',$values_array,'','id="'.yes_encode_string($NVLT->Name).'"')
        );
    }
    die(json_encode(array(
        'MSG'=>'',
        'NAME'=>yes_encode_string($products_name),
        'SKU'=>$new_variation_pID,
        'QTY'=>($SQ->get_available2_qty() > 0) ? $SQ->get_available2_qty() : 1,
        'PRICE'=>number_format($final_price,2,'.',''),
        'INPUT_VS'=>$input_vs,
        'IMAGES'=>$product->get_images(),
        'IMAGE_PATH'=>HTTP_SERVER.'images/product_images/thumbnail_images/'
    )));
}

if(isset($_REQUEST['evs']) and $_REQUEST['evs'] != '' and isset($_REQUEST['evs_value']) and $_REQUEST['evs_value'] != '' and isset($_REQUEST['url']) and $_REQUEST['url'] != ''){
    if($msg == ''){
        $evs = urldecode(yes_decode_string(xtc_db_input($_REQUEST['evs'])));
        $evs_value = urldecode(yes_decode_string(xtc_db_input($_REQUEST['evs_value'])));
        $url = xtc_db_input($_REQUEST['url']);
        
        $item = new \stdClass();
        $item->ItemID = $auction->ebay_id;
        if($Variations->Pictures !== null and $Variations->Pictures->VariationSpecificName == $evs){
            foreach($Variations->Pictures->VariationSpecificPictureSet as $VSPS){
                if($VSPS->VariationSpecificValue != $evs_value){
                    continue;
                }
                if($VSPS->PictureURL !== null and !is_countable($VSPS->PictureURL) and !empty($VSPS->PictureURL)){
                    $VSPS->PictureURL = [$VSPS->PictureURL];
                }
                $VSPS->PictureURL[] = $url;
                $found = true;
            }
            if(!$found){
                $new_VariationSpecificPictureSetType = new \stdClass();
                $new_VariationSpecificPictureSetType->VariationSpecificValue = $evs_value;
                $new_VariationSpecificPictureSetType->PictureURL = [$url];
                //$Picture->VariationSpecificPictureSet[] = $new_VariationSpecificPictureSetType;
                // NEU
                $Variations->Pictures->VariationSpecificPictureSet[] = $new_VariationSpecificPictureSetType;
            }
        }
        $item->Variations = $Variations;
        $msg = $EBAYAPI->revise_auction($id,$item);
    }
    die(json_encode(array(
            'MSG'=>yes_encode_string($msg)
    )));
}
if(isset($_REQUEST['evs']) and $_REQUEST['evs'] != '' and isset($_REQUEST['value']) and $_REQUEST['value'] != ''){
    if($msg == ''){
        $evs = xtc_db_input($_REQUEST['evs']);
        $value = xtc_db_input($_REQUEST['value']);
        
        $item = new \stdClass();
        $Variations = new \stdClass();
        $item->ItemID = $auction->ebay_id;
        foreach($VariationSpecificsSet->NameValueList as $VSSid=>$NVLT){
            if($NVLT->Name == urldecode(yes_decode_string($evs))){
                // wenn ein neuer Wert angegeben wurde und Value noch
                // kein array ist
                if(!is_countable($VariationSpecificsSet->NameValueList[$VSSid]->Value)){
                    if(urldecode(yes_decode_string($value)) != $VariationSpecificsSet->NameValueList[$VSSid]->Value){
                        if(!is_countable($VariationSpecificsSet->NameValueList[$VSSid]->Value)){
                            $VariationSpecificsSet->NameValueList[$VSSid]->Value = [$VariationSpecificsSet->NameValueList[$VSSid]->Value];
                        }
                    }
                }
                $VariationSpecificsSet->NameValueList[$VSSid]->Value[] = urldecode(yes_decode_string($value));
            }
        }
        $Variations->VariationSpecificsSet = $VariationSpecificsSet;
        $item->Variations = $Variations;
        $msg = $EBAYAPI->revise_auction($id, $item);
    }
    die(json_encode(array(
            'MSG'=>$msg
    )));
}
if($msg != ''){
    die($msg);
}
$smarty->assign(array(
    'V_ARRAY'=>$VArray,
    'VS_ARRAY'=>$VSArray,
    'VariationSpecificNameForPics'=>$VariationSpecificNameForPics,
    'ebay_auctions_id'=>$id
));
header('Content-Type: text/html; charset='.CHARSET);
$smarty->display('auction_variations.html');
exit;
