<?php
require_once(DIR_FS_INC.'xtc_db_affected_rows.inc.php');
$params = [
	
];
$MA = new eBayMediaApi( $seller,$access_token, $env );
$action = (isset($_GET['action']))?$_GET['action']:'';
switch($action){
    case 'delete_media':
        $id = xtc_db_input($_GET['id']);
        $type = $_GET['type'];
        try{
            $MA->delete($id, $type, $seller);
        } catch (Exception $ex) {
            die(json_encode([
                'MSG'=>$e->getMessage()
            ]));
        }
        die(json_encode([
            'MSG'=>''
        ]));
        break;
    case 'getDocument':
        $id = xtc_db_input($_GET['id']);
        $response = $MA->getDocument($id);
        $MA->db_update_document($response);
        die(json_encode([
            'RESPONSE'=>[
                'documents_id'=>$response['documentId'],
                'documentStatus'=>$response['documentStatus'],
                'documentType'=>$response['documentType'],
                'fileName'=>$response['documentMetadata']['fileName'],
                'fileSize'=>$response['documentMetadata']['fileSize'],
                'fileType'=>$response['documentMetadata']['fileType']
            ]
        ]));
        break;
    case 'getVideo':
        $id = xtc_db_input($_GET['id']);
        $response = $MA->getVideo($id);
        $MA->db_update_video($response);
        die(json_encode([
            'RESPONSE'=>[
                'video_id'=>$id,
                'video_status'=>$response['status'],
                'expirationDate'=>$response['expirationDate'],
                'video_description'=>$response['description'],
                'video_title'=>$response['title'],
                'video_thumbnail'=>(isset($response['thumbnail']['imageUrl']))?$response['thumbnail']['imageUrl']:'',
                'seller'=>$MA->getSeller()
            ]
        ]));
        break;
    case 'upload_video_view':
        $videos = $MA->get_videos();
        foreach($videos as $vn=>$row){
            if($row->video_status != 'LIVE'){
                $response = $MA->getVideo($row->video_id);
                $MA->db_update_video($response);
                $videos[$vn]->video_status = $response['status'];
                $videos[$vn]->video_thumbnail = (isset($response['thumbnail']['imageUrl']))?$response['thumbnail']['imageUrl']:'';
                $videos[$vn]->video_description = $response['description'];
                $videos[$vn]->video_title = $response['title'];
                if($MA->debug){
                    $MA->debug_array[] = sprintf('[Status Video #%s aktualisiert zu %s]',
                        $response['videoId'], $response['status']
                    );
                }
            }
        }
        $smarty->assign([
            'LINK_UPLOAD_FORM'=>xtc_href_link(FILENAME_EBAYAPI_CART,xtc_get_all_get_params(['action']).'action=upload'),
            'ITEMS'=>$videos,
            'TYPE'=>'video',
            'UPLOAD_MAX'=>ini_get('upload_max_filesize'),
            'BASEURL'=>xtc_href_link(FILENAME_EBAYAPI_CART,xtc_get_all_get_params(array('action'))),
        ]);
        $smarty->display('ebayapi_media_upload.html');
        exit;
        break;
    case 'upload_document_view':
        $smarty->assign([
            'LINK_UPLOAD_FORM'=>xtc_href_link(FILENAME_EBAYAPI_CART,xtc_get_all_get_params(['action']).'action=upload_document'),
            'input_document_type'=>xtc_draw_pull_down_menu('documentType',$MA->get_document_types_values(),'','id="documentType"'),
            'input_document_languages'=>xtc_draw_pull_down_menu('languages[]',$MA->get_document_languages_values(),'','id="languages" multiple="multiple"'),
            'ITEMS'=>$MA->get_documents(),
            'TYPE'=>'document',
            'UPLOAD_MAX'=>ini_get('upload_max_filesize'),
            'BASEURL'=>xtc_href_link(FILENAME_EBAYAPI_CART,xtc_get_all_get_params(array('action'))),
        ]);
        $smarty->display('ebayapi_media_upload.html');
        exit;
        break;
    case 'upload_document':
        if(!isset($_POST['languages']) or !is_countable($_POST['languages']) or !sizeOf($_POST['languages'])){
            die(json_encode([
                'MSG'=>MSG_ERROR_MEDIA_NO_LANGUAGES_SUBMITTED
            ]));
        }
        $valid_ct = ['image/jpeg','image/png','application/pdf'];
        if(!in_array(mime_content_type($_FILES['documentfile']['tmp_name']),$valid_ct)){
            die(json_encode([
                'MSG'=>'Invalid Filetype '.mime_content_type($_FILES['documentfile']['tmp_name'])
            ]));
        }
        
        $data = [
            "documentType" => $_POST['documentType'],
            "languages"=>$_POST['languages'],
        ];
        
        $document_data = $MA->createDocument($data);
        if($MA->debug){
            $MA->debug_array[] = 'createDocument Response: '.print_r($document_data,true);
        }
        if(isset($document_data['errors'])){
            $error_msg = [];
            foreach($document_data['errors'] as $error){
                $error_params = [];
                if(isset($error['parameters']) and sizeOf($error['parameters'])){
                    foreach($error['parameters'] as $p){
                        $error_params[] = sprintf('%s: %s<br />',
                              $p['name'],$p['value']
                        );
                    }
                }
                $error_msg[] = sprintf('<b>#%d %s %s:</b> %s<br /><i>%s</i><br />%s<br />',
                        $error['errorId'],
                        $error['domain'],
                        $error['category'],
                        $error['message'],
                        $error['longMessage'],
                        implode('<br />',$error_params)
                );
            }
            die(json_encode([
                'MSG'=>implode('<br />',$error_msg),
                'DEBUG'=>implode('<br />',$MA->debug_array)
            ]));
        }
        if(is_countable($document_data) and sizeOf($document_data)){
            $document_id = $document_data['documentId'];
            if($MA->debug){
                $MA->debug_array[] = 'createDocument Response Array document_id: '.$document_id;
            }
        }else{
            $document_id = current(array_reverse(explode('/',$document_data)));
            if($MA->debug){
                $MA->debug_array[] = 'createDocument Response String document_id: '.$document_id;
            }
        }
        try{
            $response = $MA->uploadDocument($document_id,$_FILES['documentfile']['tmp_name']);
            if(isset($response['errorMessage']) and isset($response['errorMessage']['error'])){
                $error_msg = [];
                foreach($response['errorMessage']['error'] as $error){
                    $error_params = [];
                    if(isset($error['parameters']) and sizeOf($error['parameters'])){
                        foreach($error['parameters'] as $p){
                            $error_params[] = sprintf('%s: %s<br />',
                                  $p['name'],$p['value']
                            );
                        }
                    }
                    $error_msg[] = sprintf('<b>#%d %s %s:</b> %s<br /><i>%s</i><br />%s<br />',
                            $error['errorId'],
                            $error['domain'],
                            $error['category'],
                            $error['message'],
                            $error['longMessage'],
                            implode('<br />',$error_params)
                    );
                }
                die(json_encode([
                    'MSG'=>implode('<br />',$error_msg),
                    'DEBUG'=>implode('<br />',$MA->debug_array)
                ]));
            }
            $new = new \YES4Trade\Model\ebay_media_documents([
                'documents_id'=>$response['documentId'],
                'documentStatus'=>$response['documentStatus'],
                'documentType'=>$response['documentType'],
                'fileName'=>$response['documentMetadata']['fileName'],
                'fileType'=>$response['documentMetadata']['fileType'],
                'fileSize'=>(int)$response['documentMetadata']['fileSize'],
                'seller'=>$seller,
            ]);
            $new->create();
        }catch(Exception $e){
            die(json_encode([
                'MSG'=>$e->getMessage()
            ]));
        }
        die(json_encode([
            'MSG'=>'',
            'RESPONSE'=>$response,
            'DEBUG'=>$MA->debug_array
        ]));
        break;
    case 'upload':
		if(strpos($_FILES['videofile']['type'],'video/')<0){
                    $err = sprintf(
                            'eBay erlaubt nur bestimmte MP4 Dateien - hochgeladene Datei hat den Typ %s',
                            $_FILES['videofile']['type']
                    );
                    die(json_encode([
                        'MSG'=>$err
                    ]));
		}
		if(!isset($_POST['description']) or empty($_POST['description'])){
                    $err = 'eBay verlangt eine kurze Beschreibung des Videos';
                    die(json_encode([
                        'MSG'=>$err
                    ]));
		}
		if(!isset($_POST['title']) or empty($_POST['title'])){
                    $err= 'eBay verlangt einen Video Titel';
                    die(json_encode([
                        'MSG'=>$err
                    ]));
		}
		$data = [
			"classification" => ['ITEM'],
			"description"=>$_POST['description'],
			"size"=>fileSize($_FILES['videofile']['tmp_name']),
			"title"=>$_POST['title']
		];
		$video_url = $MA->createVideo($data);
		if(!empty($video_url)){
                        $video_url_id = current(array_reverse(explode('/',$video_url)));
			try{
                            $MA->uploadVideo($video_url_id,$_FILES['videofile']['tmp_name']);
                            $new = new \YES4Trade\Model\ebay_media_videos([
                                'video_id'=>$video_url_id,
                                'seller'=>$seller
                            ]);
                            $new->create();
                            die(json_encode([
                                'MSG'=>'',
                                'RESPONSE'=>$video_url_id
                            ]));
			}catch(Exception $e){
                            die(json_encode([
                                'MSG'=>'eBay Video Upload Error: '.$e->getMessage()
                            ]));
			}
		}else{
                    die(json_encode([
                        'MSG'=>'Videoupload failed'
                    ]));
		}
		exit;
		break;
}

/*xtc_db_query(sprintf("DELETE FROM ebay_media_videos WHERE expirationDate < '%s' AND expirationDate >0",
	date('Y-m-d H:i:s')
));*/
