<?php
require_once(DIR_FS_INC.'xtc_checkdate.inc.php');
require_once(DIR_FS_INC.'xtc_is_leap_year.inc.php');
require_once(DIR_WS_CLASSES . 'specials_ebay_revise.php');
$EBAYAPI = new ebayAPI();        

$post_keys = array('startprice','duration','dispatchtimemax','quantity');
$post_process = false;
foreach($post_keys as $pk){
    if(isset($_POST[$pk]) and $_POST[$pk] != ''){
        $post_process = true;
    }
    if(!isset($_GET['id']) or !sizeOf($_GET['id'])){
        $post_process = false;
    }
}
if($post_process){
    $fails = array(); // AUKTIONEN DIE KEINE UPDATES BEKOMMEN
    $success = 0; // FEHLER BEIM VERARBEITEN
    $update_price_revise_date = '';
    if(isset($_POST['price_timing_end_date']) and isset($_POST['price_timing']) and $_POST['price_timing'] == 1){
        $price_revise_date = xtc_db_input($_POST['price_timing_end_date']);
        $date_array = array();
        if(xtc_checkdate($price_revise_date, 'yyyy-mm-dd', $date_array)){
            if(strtotime($price_revise_date) < strtotime(date('Y-m-d'))){
                $fails[] = sprintf(RUNNING_AUCTIONS_NO_PROCESS_REVISE_DATE_MUST_BE_IN_FUTURE,$price_revise_date);
            }else{
                $update_price_revise_date = $price_revise_date;
            }
        }else{
            $fails[] = sprintf(RUNNING_AUCTIONS_NO_PROCESS_REVISE_DATE_INVALID,$price_revise_date);
        }
    }
    if(sizeOf($fails)){
        die(json_encode(array(
            'FAILS'=>$fails,
           'MSG'=>'Error'
       )));
    }
    $request_array = [];
    foreach($_GET['id'] as $eaID){
        $ea = new ebay_auction((int)xtc_db_input($eaID));
        $update = array();
        // PREIS UPDATE NUR BEI NICHT-VARIANTEN
        $ea_variations = $ea->getVariations();
        if(!is_countable($ea_variations) or !sizeOf($ea_variations) 
            and 
            (
                (isset($_POST['startprice']) and !in_array($_POST['startprice'],array('0','0%','')))
                or (isset($_POST['price_from_ebayapi_cart']) and $_POST['price_from_ebayapi_cart']=='1')
            )
        ){
            $price = 0;
            if(isset($_POST['price_from_ebayapi_cart']) and $_POST['price_from_ebayapi_cart']=='1'){
                if($ea->getEbayProductsId() > 0){
                    $ep = new ebay_product($ea->getEbayProductsId());
                    if($ep->getAuctionprice() >= 1){
                        $price = $ep->getAuctionprice();
                    }else{
                        $fails[] = sprintf(RUNNING_AUCTIONS_EBAYPRODUCTSID_ALLOCATION_NO_PRICE, $ea->getEbayId());
                    }
                }else{
                    $fails[] = sprintf(RUNNING_AUCTIONS_NO_EBAYPRODUCTSID_ALLOCATION, $ea->getEbayId());
                }
            }else{
                if(strstr($_POST['startprice'],'%')){
                    $percent = str_replace('%','',xtc_db_input($_POST['startprice']));
                    $percent = (float)str_replace(',','.',$percent);
                    if($percent >= -100 and $percent <= 100 and $percent != 0){
                        $price = $ea->auctionprice * ((100+$percent)/100);
    //                    printf('Orig %s plus %s = %s',$ea->auctionprice,$_POST['startprice'],$update_price);
                    }
                }else{
                    $price = (float)str_replace(',','.',xtc_db_input($_POST['startprice']));
                }
            }
            if($price > 0 and $price <> $ea->getAuctionprice()){
                // PREISUPDATE NUR, WENN ES KEINEN SPECIALS REVISE EINTRAG GIBT
                if(specials_ebay_revise::has_ebay_auction_id_reference($ea->getId())){
                    $fails[] = sprintf(RUNNING_AUCTIONS_NO_PROCESS_SPECIAL_REVISE_EXISTS,$ea->getEbayId());
                }else{
                    $update['price'] = $price;
                    if($update_price_revise_date != ''){
                        $update['price_revise_date'] = $update_price_revise_date;
                    }
                }
            }
        }else{
            if(sizeOf($ea->getVariations())){
                $fails[] = sprintf(RUNNING_AUCTIONS_NO_PRICE_PROCESS_HAS_VARIATIONS, $ea->getEbayId());
            }
        }
        if($_POST['duration'] != '' and $_POST['duration'] != $ea->getDuration()){
            // Days_X oder GTC
            if($_POST['duration'] == '0'){
                $update['duration'] = 'GTC';
            }else{
                $update['duration'] = sprintf('Days_%s',(int)xtc_db_input($_POST['duration']));
            }
        }
        if($_POST['dispatchtimemax'] != '' and $_POST['dispatchtimemax'] != $ea->getDispatchtimemax()){
            // INT
            $update['dispatchtimemax'] = (int)xtc_db_input($_POST['dispatchtimemax']);
        }
        if(EBAY_FEATURE_OUTOFSTOCK == 'True'){
            $qty_update = (isset($_POST['quantity']) and $_POST['quantity'] > -1) ? true : false;
        }else{
            $qty_update = (isset($_POST['quantity']) and $_POST['quantity'] > 0) ? true : false;
        }
        if($qty_update and $_POST['quantity'] <> $ea->getQuantity()){
            // QUANTITY UPDATE NUR BEI NICHT-VARIANTEN
            if(!sizeOf($ea->getVariations())){
                // BESTANDSPRUEFUNG
                $bestand_ok = true;
                if(STOCK_CHECK == 'true'){
                    $SQ = new products_quantity($ea->getProductsId());
                    $products_stock = $SQ->get_available1_qty();
                    if( $products_stock < (int)xtc_db_input($_POST['quantity']) ){
                        $fails[] = sprintf(RUNNING_AUCTIONS_QUANTITY_ERROR, 
                            $ea->getEbayId(),$products_stock,
                            (int)xtc_db_input($_POST['quantity'])
                        );
                        $bestand_ok = false;
                    }
                }
                if($bestand_ok){
                    $update['quantity'] = (int)xtc_db_input($_POST['quantity']);
                }
            }else{
                $fails[] = sprintf(RUNNING_AUCTIONS_NO_QUANTITY_PROCESS_HAS_VARIATIONS, $ea->getEbayId());
            }
        }
        if(sizeOf($update)){
            $success++;
            $site_id = $EBAYAPI->get_site_id_from_name($ea->getSite());
            if(!isset($request_array[ $ea->getUser() ])){
                $request_array[ $ea->getUser() ] = [
                    'request_object'=>null,
                    'site_id'=>$site_id,
                    'InventoryStatuses'=>[],
                ];
            }
            $InventoryStatus = [];
            $InventoryStatus['ItemID'] = $ea->getEbayId();
            if(isset($update['price']) and $update['price'] > 0){
                $InventoryStatus['StartPrice'] = (float)$update['price'];
            }
            if(isset($update['quantity']) and $update['quantity'] > 0){
                $InventoryStatus['Quantity'] = (int)$update['quantity'];
            }
            $request_array[ $ea->getUser() ]['InventoryStatuses'][] = $InventoryStatus;
            
        }
    } // end foreach auctions
    $err = [];
    foreach($request_array as $user => $reqData){
        $counter_to_four = 0;
        $InventoryStatus = [];
        $ebaycalls = new \YES4Trade\Model\ebaycalls();
        foreach($reqData['InventoryStatuses'] as $is){
            if($counter < 4){
                $InventoryStatus[] = $is;
                $counter_to_four++;
            }else{
                if(ebayApi::oauth2_refreshtoken_exists($user)){
                    if(!ebayApi::oauth2_usertoken_exists($user) or ebayApi::get_oauth2_usertoken_lifetime($user) < 1){
                        try{
                            ebayApi::refresh_oauth2_usertoken($user);
                        }catch(Exception $e){
                            $api_error = 'refresh_oauth2_usertoken() for seller '.$user.'  '.$e->getMessage();
                        }
                    }
                }
                $res = $ebaycalls->tradingQuery($user,'ReviseInventoryStatus',$reqData['site_id'],[
                    'InventoryStatus'=>$InventoryStatus
                ]);
                //$res = $reqData['request_object']->reviseInventoryStatus($ReviseInventoryStatusRequest);
                $fails[] = implode("<br />",$EBAYAPI->getResponseErrors($res));
                $InventoryStatus = [];
                $counter_to_four = 0;
            }
        }
        if(sizeOf($InventoryStatus) > 0){
            $res = $ebaycalls->tradingQuery($user,'ReviseInventoryStatus',$reqData['site_id'],[
                'InventoryStatus'=>$InventoryStatus
            ]);
            if($res->Ack == 'Success' or $res->Ack == 'Warning'){
                foreach($res->InventoryStatus as $ris){
                    $yesAuction = \YES4Trade\Model\ebay_auctions::get_by_ebay_id_and_user($ris->ItemID, $user, ['id']);
                    if($yesAuction !== null){
                        $upd = new \YES4Trade\Model\ebay_auctions([
                            'id'=>intval($yesAuction->id),
                            'quantity'=>intval($ris->Quantity),
                            'auctionprice'=>floatval($ris->StartPrice),
                        ]);
                        $upd->update();
                    }
                }
            }
            $fails[] = implode("<br />",$EBAYAPI->getResponseErrors($res));
        }
    }
    die(json_encode(array(
        'FAILS'=>$fails,
        'MSG'=>'Revise wurde verarbeitet. Laden Sie ggf. diese Seite neu um alle &Auml;nderungen zu sehen.'
    )));
}


$dispatch_values = array(array('id'=>'','text'=>TEXT_SELECT));
$ebay_dispatch_details = $EBAYAPI->get_ebay_details('DispatchTimeMaxDetails');
foreach($ebay_dispatch_details->DispatchTimeMaxDetails as $dtm){
    $dispatch_values[(int)$dtm->DispatchTimeMax] = array(
        'id'=>$dtm->DispatchTimeMax,
        'text'=>str_replace(array('Days','Day'), array('Tage','Tag'),$dtm->Description)
    );
}
sort($dispatch_values);
$dispatch_values = array_merge(array(array('id'=>'','text'=>TEXT_SELECT)),$dispatch_values);
$smarty->assign(array(
    'INTRO'=>sprintf(RUNNING_AUCTIONS_MASS_EDIT_INTRO,sizeOf($_GET['id'])),
    'FORM'=>xtc_draw_form('running_auctions_mass_edit','ebayapi_cart.php',xtc_get_all_get_params()),
    'TEXT_AUCTION_STARTPRICE'=>TEXT_AUCTION_STARTPRICE,
    'RUNNING_AUCTIONS_PRICE_INPUT_TYPE_PERCENT'=>RUNNING_AUCTIONS_PRICE_INPUT_TYPE_PERCENT,
    'RUNNING_AUCTIONS_PRICE_INPUT_TYPE_BRUTTO'=>RUNNING_AUCTIONS_PRICE_INPUT_TYPE_BRUTTO,
    'RUNNING_AUCTIONS_PRICE_TIMER_ACTIVATION'=>RUNNING_AUCTIONS_PRICE_TIMER_ACTIVATION,
    'price_timing_end_date'=>date('Y-m-d',time()+(60*60*24)),
    //'TEXT_AUCTION_DURATION'=>TEXT_AUCTION_DURATION,
    //'INPUT_DURATION'=>xtc_draw_pull_down_menu('duration',$auction_durations,''),
    'TEXT_EBAY_DISPATCHTIMEMAX'=>TEXT_EBAY_DISPATCHTIMEMAX,
    'TEXT_EBAY_QUANTITY'=>TEXT_EBAY_QUANTITY,
    'INPUT_DISPATCHTIMEMAX'=>xtc_draw_pull_down_menu('dispatchtimemax',$dispatch_values,''),
    'RUNNING_AUCTIONS_QUANTITY_INTRO'=>(EBAY_FEATURE_OUTOFSTOCK == 'False') ? RUNNING_AUCTIONS_QUANTITY_INTRO : RUNNING_AUCTIONS_QUANTITY_INTRO_OUTOFSTOCK,
    'RUNNING_AUCTIONS_NO_VARIATIONS_PROCESS'=>RUNNING_AUCTIONS_NO_VARIATIONS_PROCESS,
    'IMAGE_SAVE'=>IMAGE_SAVE,
    'INPUT_QUANTITY_DEFAULT'=>(EBAY_FEATURE_OUTOFSTOCK == 'False') ? '0' : '-1',
    'MASS_EDIT_PRICE_MODE_MANUAL'=>MASS_EDIT_PRICE_MODE_MANUAL,
    'MASS_EDIT_PRICE_MODE_CART'=>MASS_EDIT_PRICE_MODE_CART,
    'MASS_EDIT_PRICE_MODE_CART_INTRO'=>MASS_EDIT_PRICE_MODE_CART_INTRO,
));
$smarty->display('ebayapi_running_auctions_mass_edit.html');