<?php
if($argc > 0){
	include('includes/cron_application_top.php');
}else{
	include('includes/application_top.php');
	$smarty = new yesSmarty;
    $key = 'ebay_auth_duration_check';
    $InstanceCache->deleteItem($key); // ebay_auth_duration_check
}

include(realpath(__DIR__).DIRECTORY_SEPARATOR.'includes/classes/class.ebay.php');
$EBAYAPI = new \ebayAPI;
$ini_conf = ebayApi::get_ebay_config_ini();
$config = [
    'production'=>[
        'credentials' => [
            'devId' => $ini_conf['ebay-config']['dev-key-prod'],
            'appId' => $ini_conf['ebay-config']['app-key-prod'],
            'certId' => $ini_conf['ebay-config']['cert-id-prod'],
        ],
        'ruName'=>YES_UNIQUE_RUNAME
    ],
    'sandbox'=>[
        'credentials' => [
            'devId' => $ini_conf['ebay-config']['dev-key-test'],
            'appId' => $ini_conf['ebay-config']['app-key-test'],
            'certId' => $ini_conf['ebay-config']['cert-id-test'],
        ],
        'ruName'=>'agri_consulting-agricons-dccb-4-dttjfcj'
    ],
    'sandbox-devlocal'=>[
        'credentials' => [
            'devId' => 'J73R2RS56Y8ZX5117F8445AI1I9US7',
            'appId' => "agricons-dccb-49b6-be03-a3f5d9cf923c",
            'certId' => "79ed4a03-9c83-4a54-9fdd-c07744ffca42",
        ],
        'ruName'=>'agri_consulting-agricons-dccb-4-dttjfcj'
    ],
];
/**
 * Create the service object.
 */
if(defined('EBAY_TESTMODE') and EBAY_TESTMODE == '1'){
    if(main::isDev(true)){
        $env = 'sandbox-devlocal';
    }else{
        $env = 'sandbox';
    }
}else{
    $env = 'production';
}
//$http_opts = (main::isDev(true))?['debug' => true]:[];
$http_opts = [];
if(isset($_GET['seller'])){
    $seller = $_GET['seller'];
}else{
    $seller = EBAY_USER;
}
if(ebayApi::oauth2_refreshtoken_exists($seller)){
        if(!ebayApi::oauth2_usertoken_exists($seller) or ebayApi::get_oauth2_usertoken_lifetime($seller) < 1){
            try{
                ebayApi::refresh_oauth2_usertoken($seller);
            }catch(Exception $e){
                $api_error = 'refresh_oauth2_usertoken() for seller '.$seller.'  '.$e->getMessage();
            }
        }
}

function createTable( $obj, $params = '' ){
    $table = new tableBlock();
    $table->table_parameters = $params;
    $blacklist = ['EIASToken'];
    $contents = [];
    foreach($obj as $key=>$value){
        if(in_array($key,$blacklist)){
            continue;
        }
        $content = [];
        switch(gettype($value)){
            case 'object':
                if($key == 'UserSubscription'){
                    $subs = [];
                    foreach($value as $v){
                        $subs[] = $v;
                    }
                    if(sizeOf($subs)){
                        $content[] = ['text'=>$key,'params'=>'','align'=>'left','form'=>''];
                        $content[] = ['text'=>implode(', ',$subs),'params'=>'','align'=>'left','form'=>''];
                    }
                    continue;
                }
                switch(get_class($value)){
                    case 'DateTime':
                        $content[] = ['text'=>$key,'params'=>'','align'=>'left','form'=>''];
                        $content[] = ['text'=>$value->format('d.m.Y H:i:s'),'params'=>'','align'=>'left','form'=>''];
                        break;
                    case 'DTS\eBaySDK\Trading\Types\SchedulingInfoType':
                        break;
                    case 'stdClass':
                        $content[] = ['text'=>$key,'params'=>'style="vertical-align:top;"','align'=>'left','form'=>''];
                        $str = [];
                        foreach($value as $k=>$v){
                            if(gettype($v) == 'object'){
                                continue;
                            }
                            $str[] = $k.': '.$v;
                        }
                        $content[] = ['text'=>implode('<br />', $str),'params'=>'','align'=>'left','form'=>''];
                        break;
                    case 'DTS\eBaySDK\Trading\Types\SellerType':
                    case 'DTS\eBaySDK\Trading\Types\RecoupmentPolicyConsentType':
                        $content[] = ['text'=>$key,'params'=>'style="vertical-align:top;"','align'=>'left','form'=>''];
                        $content[] = ['text'=>createTable(current((array)$value)),'params'=>'','align'=>'left','form'=>''];
                        break;
                    default:
                        echo $key.': '.get_class($value);
                        //yes_debug($value);
                        break;
                }

                break;
            default:
                if(empty($value)){
                    $value = '-';
                }
                $content[] = ['text'=>$key,'params'=>'','align'=>'left','form'=>''];
                $content[] = ['text'=>$value,'params'=>'','align'=>'left','form'=>''];
                break;
        }
        if(sizeOf($content)){
            $contents[] = $content;
        }
    }
    return $table->tableBlock_draw($contents);
}

$action = (isset($_GET['action']) and $_GET['action'] != '') ? $_GET['action'] : '';
switch($action){
    case 'seller_profile':
        $env = main::isDev(true)?'sandbox':'production';
        $seller = (isset($_GET['seller']))?$_GET['seller']:EBAY_USER;
        if(isset($_GET['marketplaceId'])){
            $marketplaceId = $_GET['marketplaceId'];
            switch($marketplaceId){
                case 77:
                    $marketplaceId = 'EBAY_DE';
                    break;
            }
        }else{
            $marketplaceId = 'EBAY_DE';
        }
        $site_id = $EBAYAPI->get_site_id_from_name(EBAY_SITE);
        $ebaycalls = new \YES4Trade\Model\ebaycalls();
        $res = $ebaycalls->tradingQuery($seller, 'GetUser',$site_id);
        $user = (array)$res->User;
        printf('<div class="main">%s</div>',createTable( $user, 'class="yesListTable_minimal"' ));
        exit;
        break;
    case 'keymanagement':
        try{
            $token = ebayAPI::get_oauth2_usertoken($seller);
        }catch(Exception $e){
            // kein Token vorhanden
            $_SESSION['redirect_after_oauth_generating'] = xtc_href_link(basename(__FILE__),xtc_get_all_get_params());
            xtc_redirect(xtc_href_link(basename(__FILE__),'seller='.$seller));
        }
        
        // 0 = file existiert nicht
        // 1 = abgelaufen
        // 2 = existiert und gueltig
        $kv = ebayApi::getKeymanagementValuesObject($seller);
        if(isset($kv->error)){
            printf('<p style="padding: 6px;background-color: red; color: white">F&uuml;r den eBay Seller %s existiert noch kein gespeichertes eBay Keymanagement Set.<br /><a href="%s">Keymanagement Set erzeugen</a></p>',
                    $seller, xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['seller','k_action','signingKeyId']).'seller='.$seller.'&k_action=create')
            );
        }
        
        $k_action = (isset($_GET['k_action'])) ? $_GET['k_action'] : 'list';
        if(isset($_GET['signingKeyId']) and !empty($_GET['signingKeyId'])){
            $k_action = 'get';
        }
        $post = false;
        $post_fields = '';
        $link = sprintf('https://apiz.%sebay.com/developer/key_management/v1/signing_key',
                ($env == 'sandbox') ? $env.'.' : ''
        );
        switch($k_action){
            case 'get':
                $link .= '/'.$_GET['signingKeyId'];
                break;
            case 'list':
                break;
            case 'create':
                $post = true;
                $post_fields = json_encode(["signingKeyCipher"=>'ED25519']);
                break;
        }
        $ch = curl_init($link);
        $add_header = array(
            'Authorization: Bearer ' . $token,
            'Content-Type: application/json',
            //"Content-Type: application/json",
            //'X-EBAY-C-MARKETPLACE-ID: EBAY_DE'
        );
        //$post_fields = 'grant_type=client_credentials&scope=https%3A%2F%2Fapi.ebay.com%2Foauth%2Fapi_scope';
        //$post_fields = '';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $add_header);
        //        curl_setopt($ch, CURLHEADER_SEPARATE, true);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        if($post){
            curl_setopt($ch, CURLOPT_POST, 1);
        }
        if(!empty($post_fields)){
            curl_setopt($ch, CURLOPT_POSTFIELDS, $post_fields);
        }
        //  curl_setopt($ch, CURLOPT_HEADER, 1);


        //scurl_setopt($ch, CURLOPT_PROXY, '127.0.0.1:8888');
        $response = curl_exec($ch);
        $obj = json_decode($response);
        if(isset($obj->signingKeyId)){
            $data = [
                'signingKeyId' => $obj->signingKeyId,
                'signingKeyCipher' => $obj->signingKeyCipher,
                'publicKey' => $obj->publicKey,
                'privateKey' => (isset($obj->privateKey))?$obj->privateKey:'',
                'jwe' => $obj->jwe,
                'creationTime' => $obj->creationTime,
                'expirationTime' => $obj->expirationTime,
            ];
            if($k_action == 'get'){
                echo '<table>';
                foreach($obj as $key => $val){
                    switch($key){
                        case 'expirationTime':
                        case 'creationTime':
                            $val = date('d.m.Y H:i:s',$val);
                            break;
                    }
                    printf('<tr><td style="font-weight: bold;" id="%s">%s</td><td>%s</td></tr>',
                            $key,$key, $val
                    );
                }
                echo '</table>';
                echo '<a href="?action=keymanagement">'.IMAGE_BACK.'</a>';
                exit;
            }else{
                ebayApi::saveKeymanagementValues( $obj, $seller );
                xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('k_action'))));
            }
        }
        if(isset($obj->signingKeys) and is_countable($obj->signingKeys)){
            echo '<table><thead><tr>'
            . '<th>&nbsp;</th>'
            . '<th>Public Key</th>'
            . '<th>Angelegt</th>'
            . '<th>G&uuml;ltig bis</th>'
            . '<th>Cipher</th>'
            . '</tr></thead><tbody>';
            foreach($obj->signingKeys as $sk){
                printf('<tr><td><a href="?action=keymanagement&signingKeyId=%s">View</a></td>'
                        . '<td title="%s">%s</td><td>%s</td><td>%s</td><td>%s</td></tr>',
                        urlencode($sk->signingKeyId),
                        $sk->publicKey,
                        substr($sk->publicKey,0,24).'...',
                        date('d.m.Y H:i:s',$sk->creationTime),
                        date('d.m.Y H:i:s',$sk->expirationTime),
                        $sk->signingKeyCipher
                        
                );
            }
            echo '</tbody></table>';
        }
        exit;
        
        
        break;
    case 'itemspecifics':
        if(isset($_GET['marketplaceId'])){
            $marketplaceId = $_GET['marketplaceId'];
            switch($marketplaceId){
                case 77:
                    $marketplaceId = 'EBAY_DE';
                    break;
            }
        }else{
            $marketplaceId = 'EBAY_DE';
        }
        try{
            $token = ebayAPI::get_oauth2_usertoken($seller);
        }catch(Exception $e){
            // kein Token vorhanden
            //$_SESSION['redirect_after_oauth_generating'] = xtc_href_link(basename(__FILE__),xtc_get_all_get_params());
            //xtc_redirect(xtc_href_link(basename(__FILE__),'seller='.$seller));
            die('kein token');
        }
        $service = new Services\TaxonomyService([
            'sandbox'     => ($env == 'sandbox'),
            'authorization'=> ebayAPI::get_oauth2_usertoken($seller),
            'marketplaceId' => 'EBAY_DE',
            'httpOptions' => $http_opts
        ]);
        $request = new Types\GetADefaultCategoryTreeIdRestRequest();
        $request->marketplace_id = $marketplaceId;
        /**
         * Send the request.
         */
        $response = $service->getADefaultCategoryTreeId($request);
        yes_debug($response);
        exit;
        break;
    case 'fulfillment_policies':
        if(isset($_GET['marketplaceId'])){
            $marketplaceId = $_GET['marketplaceId'];
            switch($marketplaceId){
                case 77:
                    $marketplaceId = 'EBAY_DE';
                    break;
            }
        }else{
            $marketplaceId = 'EBAY_DE';
        }
        try{
            $token = ebayAPI::get_oauth2_usertoken($seller);
        }catch(Exception $e){
            // kein Token vorhanden
            if(ebayApi::oauth2_refreshtoken_exists($seller)){
                $token = ebayApi::refresh_oauth2_usertoken($seller);
            }
            yes_mail_debug(print_r($e,true));
        }
        if(empty($token)){
            $messageStack->add_session(sprintf(MSG_ERROR_OAUTH_FOR_SELLER_NOT_SAVED,$seller),'error');
            xtc_redirect(xtc_href_link('token.php',xtc_get_all_get_params(array('action'))));
        }
        $ebaycaller = new \YES4Trade\Model\ebaycalls();
        try{
            $response = $ebaycaller->getFulfillmentPolicy($token, $marketplaceId);
        }catch( Exception $e){
            $messageStack->add_session(sprintf(MSG_ERROR_FULFILLMENT_POLICIES_UPDATE_FORBIDDEN,$seller).'<br />'.$e->getMessage(),'error');
            xtc_redirect(xtc_href_link('token.php'));                
        }
            
        foreach ($response->fulfillmentPolicies as $FulfillmentPolicy) {
            $options[] = array(
                'profileId'=>$FulfillmentPolicy->fulfillmentPolicyId,
                'profileName'=>$FulfillmentPolicy->name,
                'profileDesc'=>$FulfillmentPolicy->description
            );
        }
        if(sizeOf($options)){
            $file = main::get_secure_path().DIRECTORY_SEPARATOR.'ebay_shipping_policies.json';
            if(is_file($file)){
                unlink($file);
            }
            file_put_contents($file, json_encode($options));
            $messageStack->add_session(sprintf('Es wurden %d Versandbedingungen verarbeitet.',sizeOf($options)),'success');
        }else{
            $messageStack->add_session(MSG_ERROR_FULFILLMENT_POLICIES_UPDATE,'error');
        }
        xtc_redirect(xtc_href_link('token.php'));
        exit;
        break;
    case 'itemsInPromotionAtEbay':
        $promotionId = $_GET['promotionId'];
        $service = new \DTS\eBaySDK\Marketing\Services\MarketingService([
            'sandbox'     => ($env == 'sandbox'),
            'authorization'=> ebayAPI::get_oauth2_usertoken($seller),
            'marketplaceId' => 'EBAY_DE',
            'httpOptions' => $http_opts
        ]);
        $request = new Types\GetItemPromotionRestRequest([
            'promotion_id'=>$promotionId
        ]);
        $response = $service->getItemPromotion($request);
        echo '<div class="main"><table class="yes-ui-table" id="itemsInPromotionAtEbay_table"><tbody>';
        foreach($response->inventoryCriterion->listingIds as $ebay_id){
            $ea = \YES4Trade\Model\ebay_auctions::get_by_ebay_id($ebay_id,[
                'id', 'picture', 'title'
            ]);
            $record = $ea->toArray();
            if($record['picture'] != ''){
                $img = '../images/product_images/thumbnail_images/'.$record['picture'];
            }else{
                $img = 'images/basicons/square182.png';
            }
            printf('<tr id="%s"><td valign="top"><a href="javascript:;" class="removeAuctionFromPromotion" title="%s" data-ebay_id="%s">&#128465;</a>&nbsp;<a href="%s" target="_blank">%s</td><td><img style="max-width: 60px;" src="%s" border="0" /></td><td valign="top">%s</td></tr>',
                    $ebay_id,
                    IMAGE_DELETE,
                    $ebay_id,
                    EBAY_PRODUCTSVIEW_LINK.$ebay_id,
                    $ebay_id,
                    $img,
                    substr($record['title'],0,80)
            );
        }
        echo '</table></div>';

        exit;
        break;
    case 'deleteFromList':
        $id = $_GET['id'];
        foreach($_SESSION['addPromotion']['AUCTIONS'] as $nr=>$ebay_id){
            if($ebay_id == $id){
                unset($_SESSION['addPromotion']['AUCTIONS'][$nr]);
            }
        }
        die(json_encode(array(
            'MSG'=>''
        )));
        exit;
        break;
    case 'view_promotion_items':
        echo '<div class="main"><table class="yes-ui-table" id="view_promotion_items_table"><tbody>';
        foreach($_SESSION['addPromotion']['AUCTIONS'] as $ebay_id){
            $ea = \YES4Trade\Model\ebay_auctions::get_by_ebay_id($ebay_id,[
                'id', 'picture', 'title'
            ]);
            $record = $ea->toArray();
            if($record['picture'] != ''){
                $img = '../images/product_images/thumbnail_images/'.$record['picture'];
            }else{
                $img = 'images/basicons/square182.png';
            }
            printf('<tr id="%s"><td valign="top"><a href="javascript:;" class="removeAuctionFromList" title="%s" data-ebay_id="%s">&#128465;</a>&nbsp;<a href="%s" target="_blank">%s</td><td><img style="max-width: 60px;" src="%s" border="0" /></td><td valign="top">%s</td></tr>',
                    $ebay_id,
                    IMAGE_DELETE,
                    $ebay_id,
                    EBAY_PRODUCTSVIEW_LINK.$ebay_id,
                    $ebay_id,
                    $img,
                    substr($record['title'],0,80)
            );
        }
        echo '</table></div>';
        exit;
        break;
    case 'cancelPromotion':
        unset($_SESSION['addPromotion']);
        $messageStack->add_session('Die Konfiguration der Multirabatt Promotion wurde abgebrochen','success');
        xtc_redirect(xtc_href_link(basename(__FILE__)));
        break;
    case 'addItems':
        if(!isset($_SESSION['addPromotion']['AUCTIONS'])){
            $_SESSION['addPromotion']['AUCTIONS'] = array();
        }
        $added = 0;
        foreach($_GET['id'] as $id){
            $ea = \YES4Trade\Model\ebay_auctions::get_by_id(intval($id),['ebay_id']);
            if($ea === null){
                continue;
            }
            if(!in_array($ea->ebay_id, $_SESSION['addPromotion']['AUCTIONS'])){
                if(sizeOf($_SESSION['addPromotion']['AUCTIONS']) < 501){
                    $_SESSION['addPromotion']['AUCTIONS'][] = $ea->ebay_id;
                    $added++;
                }
            }
        }
        $messageStack->add_session('Es wurden '.$added.' Auktionen dem Multirabatt hinzugef&uuml;gt.','success');
        xtc_redirect(xtc_href_link('ebayapi_cart.php?page_type=runnings'));
        exit;
        break;
    case 'paymentPolicies':
        $CategoryTypeEnum = [
            'MOTORS_VEHICLES','ALL_EXCLUDING_MOTORS_VEHICLES'
        ];
        $CategoryTypeEnum_types = [['id'=>'','text'=>TEXT_SELECT]];
        foreach($CategoryTypeEnum as $c){
            $CategoryTypeEnum_types[] = [
                'id'=>$c,
                'text'=>$c
            ];
        }

        $seller = $_GET['seller']??EBAY_USER;
        $token = ebayAPI::get_oauth2_usertoken($seller);
        $client = new \GuzzleHttp\Client();
        if(isset($_POST['paymentPolicyId'])){
            $id = $_POST['paymentPolicyId'];
            $pm = [];
            foreach($_POST['paymentMethodType'] as $pmt){
                $pm[] = ['paymentMethodType'=>trim($pmt)];
            }
            $json = [
                'categoryTypes'=>[
                    ['name'=>$_POST['CategoryTypeEnum']]
                ],
                'description'=>$_POST['description'],
                'name'=>$_POST['name'],
                'immediatePay'=>(isset($_POST['immediatePay']) and $_POST['immediatePay'] == '1') ? true: false,
                'marketplaceId'=>$_POST['marketplace_id'],
                //'paymentMethods'=>$pm
            ];
            try{
                $response = $client->request('PUT','https://api.sandbox.ebay.com/sell/account/v1/payment_policy/'.$id,[
                    'headers'=>[
                        'Authorization' => 'Bearer '.$token,
                        'Content-Type' => 'application/json'
                    ],
                    'json'=>$json
                ]);
            }catch(Exception $e){
                yes_debug($json);
                die($e->getMessage());
            }
            echo 'OK';
            yes_debug($response->getReasonPhrase());
            exit;
        }else if(isset($_POST['name'])){
            $pm = [];
            foreach($_POST['paymentMethodType'] as $pmt){
                $pm[] = ['paymentMethodType'=>trim($pmt)];
            }
            $json = [
                'categoryTypes'=>[
                    ['name'=>$_POST['CategoryTypeEnum']]
                ],
                'description'=>$_POST['description'],
                'name'=>$_POST['name'],
                'immediatePay'=>(isset($_POST['immediatePay']) and $_POST['immediatePay'] == '1') ? true: false,
                'marketplaceId'=>$_POST['marketplace_id'],
                //'paymentMethods'=>$pm
            ];
            try{
                $response = $client->request('POST','https://api.sandbox.ebay.com/sell/account/v1/payment_policy/',[
                    'headers'=>[
                        'Authorization' => 'Bearer '.$token,
                        'Content-Type' => 'application/json'
                    ],
                    'json'=>$json
                ]);
            }catch(Exception $e){
                yes_debug($json);
                die($e->getMessage());
            }
            echo 'OK';
            yes_debug($response->getReasonPhrase());
            exit;
        }
        

        $response = $client->request('GET','https://api.sandbox.ebay.com/sell/account/v1/payment_policy?marketplace_id=EBAY_DE',[
            'headers'=>[
                'Authorization' => 'Bearer '.$token,
                'Content-Type' => 'application/json'
            ]
        ]);
        $stream = $response->getBody();
        $res = json_decode($stream->getContents());

        $marketplaces = [];
        foreach(EBAY_MARKETPLACE_IDS as $mID){
            $marketplaces[] = ['id'=>$mID,'text'=>$mID];
        }
        $available_paymentMethods = [
            'CASH_IN_PERSON',
            'CASH_ON_DELIVERY',
            'CASH_ON_PICKUP',
            'CASHIER_CHECK',
            'ESCROW',
            'MONEY_ORDER',
            'PERSONAL_CHECK',
            'OTHER'
        ];
        $input = [];
        foreach($res->paymentPolicies as $pp){
            $ct = current($pp->categoryTypes);
            $default = $ct->name;
            $payment_method_options = [];
            foreach($available_paymentMethods as $ap){
                $checked = false;
                foreach($pp->paymentMethods as $pm){
                    if($pm->paymentMethodType == $ap){
                        $checked = true;
                    }
                }
                $payment_method_options[] = xtc_draw_checkbox_field(
                    'paymentMethodType[]',$ap,$checked
                ).'&nbsp;'.$ap;
            }
            
            $input[] = [
                'CategoryTypes' => xtc_draw_pull_down_menu('CategoryTypeEnum',$CategoryTypeEnum_types,$default),
                'name'=>xtc_draw_input_field('name',$pp->name,'size="64" maxlength="64"'),
                'description'=>xtc_draw_input_field('description',$pp->description,'size="64" maxlength="250"'),
                'marketplace_id'=>xtc_draw_pull_down_menu('marketplace_id',$marketplaces,$pp->marketplaceId),
                'immediate_pay'=>xtc_draw_checkbox_field('immediatePay','1',$pp->immediatePay == true),
                'id'=>xtc_draw_hidden_field('paymentPolicyId',$pp->paymentPolicyId).$pp->paymentPolicyId,
                'paymentMethods'=>$payment_method_options
            ];
        }
        $payment_method_options = [];
        foreach($available_paymentMethods as $ap){
            $checked = false;
            $payment_method_options[] = xtc_draw_checkbox_field(
                'paymentMethodType[]',$ap,false
            ).'&nbsp;'.$ap;
        }
        $smarty->assign([
            'SELLER'=>$seller,
            'POLICIES'=>$input,
            'ADD'=> [
                'CategoryTypes' => xtc_draw_pull_down_menu('CategoryTypeEnum',$CategoryTypeEnum_types),
                'name'=>xtc_draw_input_field('name','','size="64" maxlength="64"'),
                'description'=>xtc_draw_input_field('description','','size="64" maxlength="250"'),
                'marketplace_id'=>xtc_draw_pull_down_menu('marketplace_id',$marketplaces),
                'immediate_pay'=>xtc_draw_checkbox_field('immediatePay','1'),
                'paymentMethods'=>$payment_method_options
            ]
        ]);
        $smarty->display('SellerPaymentPolicies.html');
        exit;
        break;
	case 'addPromotion':
		if(sizeOf($_POST)){
		
			if(!isset($_POST['save_now'])){
				if(isset($_POST['name']) and $_POST['name'] != ''){
					$_SESSION['addPromotion'] = $_POST;
                                        xtc_redirect(xtc_href_link('ebayapi_cart.php?page_type=runnings'));
				}
			}else{
				$seller = $_POST['seller'];
				$service = new \DTS\eBaySDK\Marketing\Services\MarketingService([
				    'sandbox'     => ($env == 'sandbox'),
				    'authorization'=> ebayAPI::get_oauth2_usertoken($seller),
				    'marketplaceId' => 'EBAY_DE',
				    'httpOptions' => $http_opts
				]);
				$discountRules1 = new Types\DiscountRule([
				    'ruleOrder'=>1,
				    'discountBenefit'=>new Types\DiscountBenefit([
						"percentageOffOrder"=>"0"
				    ]),
				    'discountSpecification'=>new Types\DiscountSpecification([
					    "minQuantity" => 1
				    ])
				]);
				$discountRules2 = new Types\DiscountRule([
				    'ruleOrder'=>2,
				    'discountBenefit'=>new Types\DiscountBenefit([
						"percentageOffOrder"=>$_POST['discountRule'][1]
				    ]),
				    'discountSpecification'=>new Types\DiscountSpecification([
					    "minQuantity" => 2
				    ])
				]);
				$drules = [$discountRules1, $discountRules2];
				if(isset($_POST['discountRule'][2]) and $_POST['discountRule'][2] != ''){
					$discountRules3 = new Types\DiscountRule([
					    'ruleOrder'=>3,
					    'discountBenefit'=>new Types\DiscountBenefit([
							"percentageOffOrder"=>$_POST['discountRule'][2]
					    ]),
					    'discountSpecification'=>new Types\DiscountSpecification([
						    "minQuantity" => 3
					    ])
					]);
					$drules[] = $discountRules3;
				}
				if(isset($_POST['discountRule'][3]) and $_POST['discountRule'][3] != ''){
					$discountRules4 = new Types\DiscountRule([
					    'ruleOrder'=>4,
					    'discountBenefit'=>new Types\DiscountBenefit([
							"percentageOffOrder"=>$_POST['discountRule'][3]
					    ]),
					    'discountSpecification'=>new Types\DiscountSpecification([
						    "minQuantity" => 4
					    ])
					]);
					$drules[] = $discountRules4;
				}
				
				$inventoryItem = new Types\InventoryItem([
				    'inventoryReferenceId'=>$id
				]);
				
				if(!isset($_POST['startDate']) or empty($_POST['startDate'])){
					$startDate = gmdate(DATE_ATOM);
				}else{
					$startDate = gmdate(DATE_ATOM,strtotime($_POST['startDate'].' '.$_POST['startDateTime'])+date('Z'));
				}
				
				if(!isset($_POST['endDate']) or empty($_POST['endDate'])){
					$endDate = gmdate(DATE_ATOM,time()+(60*60*24*365*4));
				}else{
					$endDate = gmdate(DATE_ATOM,strtotime($_POST['endDate'].' '.$_POST['endDateTime'])+date('Z'));
				}
				$request = new Types\CreateItemPromotionRestRequest([
				    'marketplaceId' =>'EBAY_DE',
				    'name' =>$_POST['name'],
				    "discountRules" => $drules,
				    "inventoryCriterion"=>[
					"listingIds"=> $_SESSION['addPromotion']['AUCTIONS'],
					"inventoryCriterionType"=> "INVENTORY_BY_VALUE"
				    ],
				    'startDate'=>$startDate,
				    'endDate'=>$endDate,
				    'promotionType'=>'VOLUME_DISCOUNT',
				    'promotionStatus'=>'SCHEDULED', // DRAFT/SCHEDULED
				    'applyDiscountToSingleItemOnly'=>(isset($_POST['applyDiscountToSingleItemOnly']) and $_POST['applyDiscountToSingleItemOnly'] == 1)?true:false,
				]);


				try{
				    $response = $service->createItemPromotion($request);
				}catch(Exception $e){
				    echo "\r\n".$e->getMessage()."\r\n";
				    exit;
				}
				if($response->getStatusCode() != 201){
				    foreach($response->Errors as $nr=>$error){
					printf("\r\n======== %s %s ==========\r\n[%s@%s]\r\n%s\r\n\r\n%s\r\n------------------\r\n\r\n",
						$error->ErrorClassification,$error->ErrorCode,
						EBAY_USER, $env,
						$error->ShortMessage,
						$error->LongMessage
					);
				    }
				    exit;
				}
				$_SESSION['addPromotion'] = null;
				unset($_SESSION['addPromotion']);
				$messageStack->add_session(MSG_SUCCESS_ADDED_PROMOTION,'success');
				xtc_redirect(xtc_href_link(basename(__FILE__)));
				exit;
			}
		}
		break;
	case  'oauth_consent_submit':
		$consent = $_GET['consent'];
		break;
	case 'json_update':
		$old_error_handler = set_error_handler("myErrorHandler");
		$old_exc_handler = set_exception_handler("myExcHandler");
		$promotionId = $_GET['promotionId'];
		$service = new \DTS\eBaySDK\Marketing\Services\MarketingService([
		    'sandbox'     => ($env == 'sandbox'),
		    'authorization'=> ebayAPI::get_oauth2_usertoken($seller),
		    'marketplaceId' => 'EBAY_DE',
		    'httpOptions' => $http_opts
		]);
		$request = new Types\GetItemPromotionRestRequest([
		    'promotion_id'=>$promotionId
		]);
		$response = $service->getItemPromotion($request);
		$promotionStatus = ($response->promotionStatus == 'RUNNING') ? 'SCHEDULED' : $response->promotionStatus;
		$promotionName = $response->name;
		$endDate = $response->endDate;
		$startDate = $response->startDate;
		$iC = $response->inventoryCriterion;
		
		$drules = [];
		foreach($response->discountRules as $dr){
			$drules[] = $dr;
		}
		switch($_GET['update_field']){
			case 'itemId':
				if($iC->inventoryCriterionType == 'INVENTORY_BY_VALUE'){
					$valid_listingIds = array();
					foreach($iC->listingIds as $k=>$ebay_id){
						if($ebay_id != $_GET['id']){
							$valid_listingIds[] = $ebay_id;
						}
					}
					$iC->listingIds = $valid_listingIds;
					
				}
				break;
			case 'promotionName':
				$promotionName = $_GET['promotionName'];
				break;
			case 'promotionStatus':
				if($promotionStatus == 'PAUSED'){
					if($_GET['promotionStatus'] == 'RUNNING'){
						$request = new Types\ResumeAPromotionRestRequest([
						    'promotion_id'=>$promotionId,
						]);
						$response = $service->resumeAPromotion($request);
						
						die(json_encode(array(
							'MSG'=>''
						)));
					}
				}
				$promotionStatus = $_GET['promotionStatus'];
				if($promotionStatus == 'PAUSED'){
					$request = new Types\PauseAPromotionRestRequest([
					    'promotion_id'=>$promotionId,
					]);
					$response = $service->pauseAPromotion($request);
					
					die(json_encode(array(
						'MSG'=>''
					)));
				}
				break;
			case 'endDate':
				$date_str = $_GET['endDate'].' '.$_GET['endDateTime'];
				$endDate = gmdate(DATE_ATOM,strtotime($date_str)+date('Z'));
				$promotionStatus = 'SCHEDULED';
				break;
			case 'startDate':
				$date_str = $_GET['startDate'].' '.$_GET['startDateTime'];
				$promotionStatus = 'SCHEDULED';
				$startDate = gmdate(DATE_ATOM,strtotime($date_str)+date('Z'));
				break;
			case 'deletePromotion':
				$request = new Types\DeleteItemPromotionRestRequest([
				    'promotion_id'=>$promotionId,
				]);
				$response = $service->deleteItemPromotion($request);
				
				die(json_encode(array(
					'MSG'=>''
				)));
				break;
		}
		$request = new Types\UpdateItemPromotionRestRequest([
		    'promotion_id'=>$promotionId,
		    'startDate'=>$startDate,
		    'endDate'=>$endDate,
		    'marketplaceId' => $response->marketplaceId,
		    'promotionStatus'=>$promotionStatus,
		    'promotionType'=>'VOLUME_DISCOUNT', // ist nicht im response
		    'priority'=>$response->priority,
		    'name'=>$promotionName,
		    'inventoryCriterion'=>$iC,
		    'discountRules'=>$drules,
		]);
		$response = $service->updateItemPromotion($request);
		
		die(json_encode(array(
			'MSG'=>''
		)));
		break;
}

if(isset($argc) and $argc > 0){
    if(isset($argc)){
        for($i=0;$i<$argc;$i++){
            if($i == 1){
                if($argv[$i] == 'set_consent'){
                    echo "\r\nBitte hier den Consent Token eingeben:";
                    $handle = fopen ("php://stdin","r");
                    $line = fgets($handle);
                    if(trim($line) != ''){
                    	$consent = $line;
                    }
                }
            }
        }
    }
}
if(isset($consent) and !empty($consent)){
	if(ebayAPI::create_oauth2_usertoken($seller,$consent)){
            if(isset($_GET['action']) and $_GET['action'] == 'oauth_consent_submit'){
                    $messageStack->add_session(MSG_SUCCESS_OAUTH2_USERTOKEN_CREATED,'success');
                    if(isset($_SESSION['redirect_after_oauth_generating'])){
                        $url = $_SESSION['redirect_after_oauth_generating'];
                        $_SESSION['redirect_after_oauth_generating'] = Null;
                        unset($_SESSION['redirect_after_oauth_generating']);
                        xtc_redirect($url);
                    }
                    if(isset($_GET['yes_ebay_sdk_oauth_redirect_target']) and $_GET['yes_ebay_sdk_oauth_redirect_target'] != ''){
                        xtc_redirect(xtc_href_link(
                                $_GET['yes_ebay_sdk_oauth_redirect_target']
                        ));
                    }
                    if(isset($_GET['close_window']) and $_GET['close_window'] == 1){
                        die('<script>window.close();</script>');
                    }
                    xtc_redirect(xtc_href_link('ebayapi_cart.php'));
            }
            die('OAUTH2 Usertoken wurde erzeugt.');
	}
	if(isset($_GET['action']) and $_GET['action'] == 'oauth_consent_submit'){
		$messageStack->add_session(MSG_ERROR_OAUTH2_USERTOKEN_FAILED,'error');
		xtc_redirect(xtc_href_link(
			'ebayapi_cart.php'
		));
	}
        // cli mode
	die(MSG_ERROR_OAUTH2_USERTOKEN_FAILED);
}
$er = error_reporting();
error_reporting(E_ERROR);
$chk = ebayApi::check_oauth2_usertoken($seller);
error_reporting($er);
if(!$chk){
    $service = new \DTS\eBaySDK\OAuth\Services\OAuthService([
        'credentials' => $config[$env]['credentials'],
        'ruName'      => $config[$env]['ruName'],
//        'sandbox'     => ($env == 'sandbox'),
        'httpOptions' => $http_opts,
    ]);
    if(ebayApi::refresh_or_create_oauth2_usertoken($seller)){
        ebayApi::refresh_oauth2_usertoken($seller,$service);
    }else{
        ebayAPI::create_oauth2_usertoken($seller);
    }
}

$service = new \DTS\eBaySDK\Marketing\Services\MarketingService([
    'sandbox'     => ($env == 'sandbox'),
    'authorization'=> ebayAPI::get_oauth2_usertoken($seller),
    'marketplaceId' => 'EBAY_DE',
    'httpOptions' => $http_opts
]);

$config[$env]['oauthUserToken'] = ebayApi::get_oauth2_usertoken($seller);


// TEST
/*
$service = new \DTS\eBaySDK\Trading\Services\TradingService([
//    'apiVersion' => '',
    'sandbox'     => ($env == 'sandbox'),
    'authorization' => $config[$env]['oauthUserToken'],
    'credentials' => $config[$env]['credentials'],
    'siteId' => 77,
    'httpHandler' => new \DTS\eBaySDK\HttpHandler()
]);

$request = new \DTS\eBaySDK\Trading\Types\GetItemTransactionsRequestType([
    'ItemID'=>'110526210595',
    'TransactionID' => '29031211001',
    'OutputSelector'=>['TransactionArray.Transaction.Status']
]);
$response = $service->getItemTransactions($request);
print_r($response);
exit;
 * 
 */
// TEST

yes_draw_pre_header();
yes_draw_header(TITLE);
$request = new Types\GetPromotionsRestRequest([
    'marketplace_id' =>'EBAY_DE',
]);
if(isset($_SESSION['addPromotion']) and $_SESSION['addPromotion'] != Null){
	$promotionType = (isset($_SESSION['addPromotion']['promotionType']))?$_SESSION['addPromotion']['promotionType']:'VOLUME_DISCOUNT';
	$name = (isset($_SESSION['addPromotion']['name']))?$_SESSION['addPromotion']['name']:'Multirabatt '.date('d.m.Y_H:i:s');
	$startDate = (isset($_SESSION['addPromotion']['startDate']))?$_SESSION['addPromotion']['startDate']:'';
	$endDate = (isset($_SESSION['addPromotion']['endDate']))?$_SESSION['addPromotion']['endDate']:'';
	$startDateTime = (isset($_SESSION['addPromotion']['startDateTime']))?$_SESSION['addPromotion']['startDateTime']:date('H:i');
	$endDateTime = (isset($_SESSION['addPromotion']['endDateTime']))?$_SESSION['addPromotion']['endDateTime']:date('H:i');
	$seller = (isset($_SESSION['addPromotion']['seller']))?$_SESSION['addPromotion']['seller']:EBAY_USER;
        $items = $_SESSION['addPromotion']['AUCTIONS'];
}else{
	$promotionType = 'VOLUME_DISCOUNT';
	$name = 'Multirabatt '.date('d.m.Y_H:i:s');
	$startDate = '';
	$endDate = '';
	$startDateTime = date('H:i');
	$endDateTime = date('H:i');
	$seller = EBAY_USER;
        $items = array();
}

$amountoffitemvalues = array(5, 6, 7, 8, 9, 10, 15, 20, 25,
		30, 35, 40, 45, 50, 55, 60, 65,
		70, 75, 80, 85, 90, 95, 100, 110,
		120, 125, 150, 200, 250
);
$amountoffitemvalues_options = array();
foreach($amountoffitemvalues as $aoiv){
	$amountoffitemvalues_options[] = array(
		'id'=>$aoiv,
		'text'=>$aoiv.'%',
	);
}
$page_heading = PAGE_HEADING;
if($_GET['action'] != 'addPromotion'){
    $buttons = array(
        array('text'=>TEXT_ADD_EBAY_ITEM_PROMOTION,
            'link'=>xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action')).'action=addPromotion'),
            'lbOn'=>false,
            'auth'=>true
        ),
    );
    $response = $service->getPromotions($request);
}else{
    $page_heading = PAGE_HEADING_ADD_PROMOTION;
    if(isset($_SESSION['addPromotion']) and $_SESSION['addPromotion'] != Null){
        $buttons = array(
            array('text'=>BUTTON_CANCEL_PROMOTION_DRAFT,
                'link'=>xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action')).'action=cancelPromotion'),
                'lbOn'=>false,
                'auth'=>true
            ),
        );
    }
}
$dr2 = (isset($_SESSION['addPromotion']['discountRule'][1]))?$_SESSION['addPromotion']['discountRule'][1]:'10';
$dr3 = (isset($_SESSION['addPromotion']['discountRule'][2]))?$_SESSION['addPromotion']['discountRule'][2]:'';
$dr4 = (isset($_SESSION['addPromotion']['discountRule'][3]))?$_SESSION['addPromotion']['discountRule'][3]:'';
$PROMOTION_APPLYDISCOUNTTOSINGLEITEMONLY_VALUE = (isset($_SESSION['addPromotion']['applyDiscountToSingleItemOnly']) and $_SESSION['addPromotion']['applyDiscountToSingleItemOnly'] == 1)?1:'';
$smarty->assign(array(
	'PROMOTION_APPLYDISCOUNTTOSINGLEITEMONLY_VALUE'=>$PROMOTION_APPLYDISCOUNTTOSINGLEITEMONLY_VALUE,
	'ADDPROMOTION'=>(isset($_GET['action']) and $_GET['action'] == 'addPromotion'),
	'ADDPROMOTION_SELECTIONMODE'=>(isset($_SESSION['addPromotion']['itemSelection']))?$_SESSION['addPromotion']['itemSelection']:'',
	'HEADING_TITLE'=>$page_heading,
	'HEADING_TITLE_ADD'=>TEXT_ADD_EBAY_ITEM_PROMOTION,
	'INPUT_SELLER'=>xtc_draw_pull_down_menu('seller',xtc_get_ebay_users(),$seller),
	'INPUT_NAME'=>xtc_draw_input_field('name',$name,'size="32" maxlength="64"'),
	'INPUT_TYPE'=>xtc_draw_pull_down_menu('promotionType',array(0=>array('id'=>'VOLUME_DISCOUNT','text'=>'VOLUME_DISCOUNT')),$promotionType),
	'INPUT_STARTDATE'=>xtc_draw_input_field('startDate',$startDate,'size="16" maxlength="16"',false,'date'),
	'INPUT_ENDDATE'=>xtc_draw_input_field('endDate',$endDate,'size="16" maxlength="16"',false,'date'),
	'INPUT_STARTDATETIME'=>xtc_draw_input_field('startDateTime',$startDateTime,'size="5" maxlength="5"',false,'date'),
	'INPUT_ENDDATETIME'=>xtc_draw_input_field('endDateTime',$endDateTime,'size="5" maxlength="5"',false,'date'),
	'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
	'language_path'=>DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
	'PROMOTIONS'=>$response,
	'BASELINK'=>xtc_href_link(basename(__FILE__),xtc_get_all_get_params()),
	'DISCOUNTBENEFITAMOUNTOFFITEMVALUES'=>$amountoffitemvalues_options,
	'INPUT_DISCOUNTRULE2'=>xtc_draw_pull_down_menu('discountRule[1]',$amountoffitemvalues_options,$dr2),
	'INPUT_DISCOUNTRULE3'=>xtc_draw_pull_down_menu('discountRule[2]',array_merge(array('id'=>'','text'=>'-'),$amountoffitemvalues_options),$dr3),
	'INPUT_DISCOUNTRULE4'=>xtc_draw_pull_down_menu('discountRule[3]',array_merge(array('id'=>'','text'=>'-'),$amountoffitemvalues_options),$dr4),

    'ADDPROMOTION_AUCTIONS'=>$items,
    'PROMOTION_NUMBER_OF_AUCTIONS_INTRO'=>sprintf(PROMOTION_NUMBER_OF_AUCTIONS_INTRO,sizeOf($items)),
    'PROMOTION_NUMBER_OF_AUCTIONS_INTRO_RAW'=>PROMOTION_NUMBER_OF_AUCTIONS_INTRO,
    'PROMOTION_ADD_MORE_AUCTIONS'=>PROMOTION_ADD_MORE_AUCTIONS,
    'PROMOTION_BUTTON_SAVE_INTRO'=>PROMOTION_BUTTON_SAVE_INTRO,
    'PROMOTION_BUTTON_SAVE_INTRO2'=>PROMOTION_BUTTON_SAVE_INTRO2,
    'TEXT_ADD_EBAY_ITEM_PROMOTION'=>TEXT_ADD_EBAY_ITEM_PROMOTION,
    'PROMOTION_STARTDATE'=>PROMOTION_STARTDATE,
    'PROMOTION_ENDDATE'=>PROMOTION_ENDDATE,
    'PROMOTION_DISCOUNTRULE1'=>PROMOTION_DISCOUNTRULE1,
    'PROMOTION_DISCOUNTRULE2'=>PROMOTION_DISCOUNTRULE2,
    'PROMOTION_DISCOUNTRULE3'=>PROMOTION_DISCOUNTRULE3,
    'PROMOTION_DISCOUNTRULE4'=>PROMOTION_DISCOUNTRULE4,
    'PROMOTION_DISCOUNTRULE_SPAREN'=>PROMOTION_DISCOUNTRULE_SPAREN,
    'PROMOTION_APPLYDISCOUNTTOSINGLEITEMONLY'=>PROMOTION_APPLYDISCOUNTTOSINGLEITEMONLY,
    'PROMOTION_APPLYDISCOUNTTOSINGLEITEMONLY_INTRO'=>PROMOTION_APPLYDISCOUNTTOSINGLEITEMONLY_INTRO,
    'PROMOTION_CONFIRM_DELETE_FROM_LIST'=>PROMOTION_CONFIRM_DELETE_FROM_LIST,
    'REALLY_REMOVE_ITEMID_FROM_PROMOTION'=>REALLY_REMOVE_ITEMID_FROM_PROMOTION,
));
$smarty->display('ebayapi_sdk_calls.html');
require(DIR_WS_INCLUDES . 'footer.php');
include('includes/application_bottom.php');
exit;


$request = new Types\GetAllCampaignsRestRequest();
$response = $service->getAllCampaigns($request);
printf("Es sind %d Campaigns gespeichert",$response->total);
exit;

/*$discountRules1 = new Types\DiscountRule([
    'ruleOrder'=>1,
    'discountBenefit'=>new Types\DiscountBenefit([
        'percentageOffOrder'=>"0"
    ]),
    'discountSpecification'=>new Types\DiscountSpecification([
        'minQuantity' => 1
    ])
]);*/
$discountRules1 = new Types\DiscountRule([
    'ruleOrder'=>1,
    'discountBenefit'=>new Types\DiscountBenefit([
                "percentageOffOrder"=>"0"
    ]),
    'discountSpecification'=>new Types\DiscountSpecification([
            "minQuantity" => 1
    ])
]);
$discountRules2 = new Types\DiscountRule([
    'ruleOrder'=>2,
    'discountBenefit'=>new Types\DiscountBenefit([
                "percentageOffOrder"=>"10"
    ]),
    'discountSpecification'=>new Types\DiscountSpecification([
            "minQuantity" => 2
    ])
]);
$discountRules3 = new Types\DiscountRule([
    'ruleOrder'=>3,
    'discountBenefit'=>new Types\DiscountBenefit([
                "percentageOffOrder"=>"20"
    ]),
    'discountSpecification'=>new Types\DiscountSpecification([
            "minQuantity" => 3
    ])
]);
$inventoryItem = new Types\InventoryItem([
    'inventoryReferenceId'=>$id
]);
$request = new Types\CreateItemPromotionRestRequest([
    'marketplaceId' =>'EBAY_DE',
    'name' =>'Alles muss raus!',
    "discountRules" => [$discountRules1,$discountRules2,$discountRules3],
    "inventoryCriterion"=>[
        "listingIds"=> [
            $id,
        ],
        "inventoryCriterionType"=> "INVENTORY_BY_VALUE"
    ],
/*
    "inventoryCriterion" => [
        "inventoryItems"=>[
            $inventoryItem
        ]
    ],*/
//    nicht bei volume_pricing    
//    'description'=>'Ich versuch mal was', 
    'startDate'=>gmdate(DATE_ATOM),
    'endDate'=>'2021-01-04T12:00:00Z',
    'promotionType'=>'VOLUME_DISCOUNT',
    'promotionStatus'=>'SCHEDULED', // DRAFT/SCHEDULED
    'applyDiscountToSingleItemOnly'=>true,
    
]);


try{
    $response = $service->createItemPromotion($request);
}catch(Exception $e){
    echo "\r\n".$e->getMessage()."\r\n";
    exit;
}
if($response->getStatusCode() != 201){
    foreach($response->Errors as $nr=>$error){
        printf("\r\n======== %s %s ==========\r\n[%s@%s]\r\n%s\r\n\r\n%s\r\n------------------\r\n\r\n",
                $error->ErrorClassification,$error->ErrorCode,
                EBAY_USER, $env,
                $error->ShortMessage,
                $error->LongMessage
        );
    }
}
print_r($response);
echo "\r\nDas hat geklappt\r\n";
exit;

