<?php
class ACK {
    var $errors, $messages, $success;
    function __construct(){
        $this->errors = array();
        $this->messages = array();
        $this->success = false;
    }
    
    public function add_error($err){
        $this->errors[] = $err;
    }
    
    public function add_message($msg){
        $this->messages[] = $msg;
    }
    
    public function set_success($success){
        $this->success = $success;
    }
    
    public function output(){
        $str  = "\r\n###### ACK STATUS ######\r\n";
        $str .= sprintf("STATUS: %s\r\n\r\n",
            (($this->success) ? 'ERFOLGREICH' : 'FEHLERHAFT')
        );
        foreach($this->errors as $err){
            $str .= sprintf("FEHLER: %s\r\n",$err);
        }
        if(sizeOf($this->errors) and sizeOf($this->messages)){
            $str .= "\r\n\r\n";
        }
        foreach($this->messages as $msg){
            $str .= sprintf("MSG: %s\r\n",$msg);
        }
        $str .= "\r\n########################\r\n";
        return $str;
    }
}
