<?php
namespace YES4Trade\Enums;

enum JQUERY_UI_THEMES: string
{

    case THEME_SMOOTHNESS = 'smoothness';
    case THEME_START = 'start';
    case THEME_REDMOND = 'redmond';
    case THEME_CUPERTINO = 'cupertino';
    case THEME_BLITZER = 'blitzer';
    case THEME_OVERCAST = 'overcast';
    case THEME_SUNNY = 'sunny';
    case THEME_LE_FROG = 'le-frog';
    case THEME_PEPPER_GRINDER = 'pepper-grinder';
    case THEME_UI_DARKNESS = 'ui-darkness';
    case THEME_UI_LIGHTNESS = 'ui-lightness';
    
    public static function fromName(string $name): ?self
    {
        foreach (self::cases() as $case) {
            if ($case->name === $name) {
                return $case;
            }
        }
        return null;
    }

    public function label(): string{
        return match($this) {
            self::THEME_SMOOTHNESS => 'Klassisch, hell, sauber - neutrale Farbgebung, gut für Standard-Backend mit wenig Stilbruch',
            self::THEME_START => 'Ähnlich -smoothness-, etwas moderner und schlicht gehalten — ideal wenn dein aktuelles Backend -start- nutzt',
            self::THEME_REDMOND => 'Leicht kantiger Stil mit moderner Akzentfarbe (oft blau) - wirkt professioneller, geeignet für geschäftliches UI',
            self::THEME_CUPERTINO => 'Sanfte Farben, gerundete Ecken, dezenter Apple-Look - fühlt sich freundlich und modern an',
            self::THEME_BLITZER => 'Auffälliger im Kontrast, etwas kräftiger in Farben und Schatten - gut wenn du visuell mehr Akzente willst',
            self::THEME_OVERCAST => 'Helles Thema mit leichter Transparenz oder feinem Farbton, wirkt luftig und modern',
            self::THEME_SUNNY => 'Warm-farbiges Thema, helle Hauptfarben mit warmen Akzenten - freundliches, offenes Erscheinungsbild',
            self::THEME_LE_FROG => 'Verspielter Stil mit kräftigem Grün-Akzent (Frosch), etwas informeller - gut wenn das Backend nicht ultra-seriös sein muss',
            self::THEME_PEPPER_GRINDER => 'Ein leicht gewürztes (Pepper) Design mit einem dunkleren Akzent und subtilen Textur- oder Farbnuancen - wirkt ausgeprägt, aber nicht übertrieben. Ideal, wenn dein Backend etwas mehr Charakter haben darf, aber trotzdem professionell bleiben soll',
            self::THEME_UI_DARKNESS => 'Ein dunkles Theme mit hoher Kontrastwirkung. Ideal für Arbeitsumgebungen mit wenig Licht oder wenn du ein Dark-Mode-Empfinden erzeugen möchtest. Buttons und Elemente leuchten vor dunklem Hintergrund klar hervor',
            self::THEME_UI_LIGHTNESS => 'Helles, zurückhaltendes Design mit dezenter Farbgebung - ideal für klassische Backends, in denen Lesbarkeit und Klarheit im Vordergrund stehen. Gut geeignet als neutrale Standardwahl'
        };
    }
}
