<?php

namespace YES4Trade\Model;

class amazon_feeds_upload_vat_invoice extends \YES4Trade\Model\BaseType {

    const TABLE_NAME = 'amazon_feeds_upload_vat_invoice';
    const TABLE_INDEX = 'amazon_feeds_upload_vat_invoice_id';

    private static $propertyTypes = [
        'amazon_feeds_upload_vat_invoice_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'amazon_feeds_upload_vat_invoice_id'
        ],
        'amazon_order_id' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'amazon_order_id'
        ],
        'processed' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'processed'
        ],
        'date_added' => [
            'type' => 'DateTime',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'date_added'
        ],
        'amazon_feeds_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'amazon_feeds_id'
        ],
    ];


public function __construct(array $values = []) {
    list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
    parent::__construct($parentValues);
    if (!array_key_exists(__CLASS__, self::$properties)) {
        self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
    }
    if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
        self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
    }
    $this->setValues(__CLASS__, $childValues);
    }


    public function create() {
        $data = $this->toArray();
        yes_db_perform(self::TABLE_NAME, self::convert_values($data,self::$propertyTypes));
        return xtc_db_insert_id();
    }


    public function update() {
        $data = $this->toArray();
        unset($data[self::TABLE_INDEX]);
        $index = self::TABLE_INDEX;
        yes_db_perform(self::TABLE_NAME, 
            self::convert_values($data,self::$propertyTypes),
            'update',
            [$index=>$this->$index]
        );
    }


    public static function delete(int $index) {
        yes_query(sprintf(
                "DELETE FROM %s WHERE %s=:id",
                self::TABLE_NAME,self::TABLE_INDEX
           ),['id'=>$index]
        );
    }


    public static function get_by_amazon_feeds_upload_vat_invoice_id(int $amazon_feeds_upload_vat_invoice_id) {
        $query = yes_query(sprintf(
                "SELECT * FROM %s WHERE %s=:id",
                   self::TABLE_NAME, self::TABLE_INDEX                
                ),['id'=>$amazon_feeds_upload_vat_invoice_id]
        );
        if(!sizeOf($query)){
            return null;
        }
        $record = current($query);
        return new self($record);
    }

    public static function get_by_amazon_feeds_id(int $amazon_feeds_id){
        $items = [];
        $query = yes_query(sprintf(
                "SELECT * FROM %s WHERE amazon_feeds_id=:id",
                    self::TABLE_NAME
                ),['id'=>$amazon_feeds_id]
        );
        foreach($query as $record){
            $items[] = new self(self::convert_values($record,self::$propertyTypes));
        }
        return $items;
    }
}
