<?php

namespace YES4Trade\Model;

class distributor_invoices_reasons extends \YES4Trade\Model\BaseType {

    const TABLE_NAME = 'distributor_invoices_reasons';
    const TABLE_INDEX = 'distributor_invoices_reasons_id';

    private static $propertyTypes = [
        'distributor_invoices_reasons_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'distributor_invoices_reasons_id'
        ],
        'title' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'title'
        ],
        'konto' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'konto'
        ],
    ];


    public function __construct(array $values = []) {
        list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
        parent::__construct($parentValues);
        if (!array_key_exists(__CLASS__, self::$properties)) {
            self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
        }
        if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
            self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
        }
        $this->setValues(__CLASS__, $childValues);
    }


    public function create() {
        $data = $this->toArray();
        yes_db_perform(self::TABLE_NAME, $data);
        return xtc_db_insert_id();
    }


    public function update() {
        $data = $this->toArray();
        unset($data[self::TABLE_INDEX]);
        $index = self::TABLE_INDEX;
        yes_db_perform(self::TABLE_NAME, $data,'update',[
            $index=>$this->$index
        ]);
    }


    public static function delete(int $index) {
        yes_query(sprintf(
            "DELETE FROM %s WHERE %s=:id",
                self::TABLE_NAME,self::TABLE_INDEX
            ),['id'=>$index]
        );
    }


    public static function get_by_distributor_invoices_reasons_id(int $distributor_invoices_reasons_id) {
        $query = yes_query(sprintf(
                "SELECT * FROM %s WHERE %s=:id",
                self::TABLE_NAME, self::TABLE_INDEX
        ),['id'=>$distributor_invoices_reasons_id]);
        if(!sizeOf($query)){
            return null;
        }
        $record = current($query);
        $record[self::TABLE_INDEX] = (int)$record[self::TABLE_INDEX];
        return new self($record);
    }

    public static function get_all(){
        $items = [];
        $query = xtc_db_query(sprintf(
                "SELECT * FROM %s ORDER BY title",
                self::TABLE_NAME
        ));
        while($record = xtc_db_fetch_array($query)){
            $record[self::TABLE_INDEX] = (int)$record[self::TABLE_INDEX];
            $items[] = new self($record);
        }
        return $items;
    }
}
