<?php
namespace YES4Trade\Model;

class eBayMessageExtractor{
	var $Message;
	public function __construct(string $xml){
		try{
			$sxe = simplexml_load_string(trim($xml));
			$sxe->registerXPathNamespace("soap", "http://schemas.xmlsoap.org/soap/envelope/");
			$resXML = current($sxe->xpath('//soap:Body'));
			$this->Message = current($resXML->children());	
		}catch(Exception $e){
			die($e->getMessage());
		}
	}
	public function getEbayId(){
		return (string)$this->Message->Item->ItemID;
	}
	public function getName(){
		return $this->Message->getName();
	}
	public function getEventName(){
		return (string)$this->Message->NotificationEventName;
	}
	public function getRecipientUserID(){
		return (string) $this->Message->RecipientUserID;
	}

    public function getMessage(){
        return $this->Message;
    }
}
