<?php
namespace YES4Trade\Model;

class eBayPlattformNotification{
    public const TEST_MODUS = false;
    public const SEND_DEBUG_MAIL_WHEN_ACTION = false;
    var $debug;
    function __construct( string $xml, bool $debug = false ){
        $this->debug = $debug;
        $M = new \YES4Trade\Model\eBayMessageExtractor($xml);
        self::dbg($M->getEventName().' for seller '.$M->getRecipientUserID());
        switch($M->getEventName()){
            case 'ItemSuspended':
                $Msg = new \YES4Trade\Model\eBayPlatformNotifications\ItemSuspended(
                    $M->getRecipientUserID(), 
                    $M->getEventName(),
                    $M->getMessage(),
                    $this->debug
                );
                break;
            case 'ItemUnsold':
                $Msg = new \YES4Trade\Model\eBayPlatformNotifications\ItemUnsold(
                    $M->getRecipientUserID(), 
                    $M->getEventName(),
                    $M->getMessage(),
                    $this->debug
                );
                break;
            case 'ItemSold':
                $Msg = new \YES4Trade\Model\eBayPlatformNotifications\ItemSold(
                    $M->getRecipientUserID(), 
                    $M->getEventName(),
                    $M->getMessage(),
                    $this->debug
                );
                break;
            case 'ItemExtended':
                $Msg = new \YES4Trade\Model\eBayPlatformNotifications\ItemExtended(
                    $M->getRecipientUserID(), 
                    $M->getEventName(),
                    $M->getMessage(),
                    $this->debug
                );
                break;
            case 'ItemClosed':
                $Msg = new \YES4Trade\Model\eBayPlatformNotifications\ItemClosed(
                    $M->getRecipientUserID(), 
                    $M->getEventName(),
                    $M->getMessage(),
                    $this->debug
                );
                break;
        }
        $Msg->process();
    }

    public static function checkRequirements(array $requirements){
        if(!class_exists('ebayAPI')){
            throw new \Exception('Need Class ebayAPI');
        }
        foreach($requirements as $reqGroup=>$req){
            switch($reqGroup){
                case 'functions':
                    foreach($req as $r){
                        if(!function_exists($r)){
                            if(is_file(DIR_FS_INC.$r.'.inc.php')){
                                require_once(DIR_FS_INC.$r.'.inc.php');
                            }else{
                                throw new \Exception('Need function '.$r.'()');
                            }
                        }
                    }
                    break;
                case 'classes':
                    foreach($req as $r){
                        if(!class_exists($r)){
                            throw new \Exception('Need class '.$r);
                        }
                    }
                    break;
            }
        }

    }

    public static function dbg( string $debug_string ){
        printf("%s\n",$debug_string);
    }
}
