<?php

namespace YES4Trade\Model;

class ebay_email_attachments extends \YES4Trade\Model\BaseType {

    const TABLE_NAME = 'ebay_email_attachments';
    const TABLE_INDEX = 'ebay_email_attachments_id';

    private static $propertyTypes = [
        'ebay_email_attachments_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ebay_email_attachments_id'
        ],
        'email_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'email_id'
        ],
        'filename' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'filename'
        ],
        'filesize' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'filesize'
        ],
        'filetype' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'filetype'
        ],
    ];


	public function __construct(array $values = []) {
		list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
		parent::__construct($parentValues);
		if (!array_key_exists(__CLASS__, self::$properties)) {
			self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
		}
		if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
			self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
		}
		$this->setValues(__CLASS__, $childValues);
	}


	public function create():int{
		$data = self::convert_values( $this->toArray(),self::$propertyTypes );
		yes_db_perform(self::TABLE_NAME, $data);
		return xtc_db_insert_id();
	}


	public static function delete(int $index) {
		yes_query(sprintf(
			"DELETE FROM %s WHERE %s=:id",
				self::TABLE_NAME,self::TABLE_INDEX
			),['id'=>$index]
		);
	}

	public static function delete_by_email_id(int $email_id) {
		yes_query(sprintf(
			"DELETE FROM %s WHERE email_id=:id",
				self::TABLE_NAME
			),['id'=>$email_id]
		);
	}


	public static function get_by_ebay_email_attachments_id(int $ebay_email_attachments_id, array $select_fields = []) {
		$select_field_string = '*';
		if(sizeOf($select_fields)){
			$select_field_string = implode(',',$select_fields);
		}
		$query = yes_query(sprintf(
			"SELECT %s FROM %s WHERE %s=:id",
				$select_field_string,self::TABLE_NAME, self::TABLE_INDEX
			),['id'=>$ebay_email_attachments_id]
		);
		if(!sizeOf($query)){
			return null;
		}
		$record = current($query);
		return new self(self::convert_values($record,self::$propertyTypes));
	}

    public static function get_by_email_id( int $email_id, array $select_fields = []){
        $items = [];
		$select_field_string = '*';
		if(sizeOf($select_fields)){
			$select_field_string = implode(',',$select_fields);
		}
		$query = yes_query(sprintf(
			"SELECT %s FROM %s WHERE email_id=:id",
				$select_field_string,self::TABLE_NAME
			),['id'=>$email_id]
		);
        foreach($query as $record){
            $items[] = new self(self::convert_values($record,self::$propertyTypes));
        }
        return $items;
    }

    /**
     * wrapper function to create
     * @param array $data
     * 
     * @return int insert_id
     */
    public static function create_ebay_email_attachments(array $data):int{
        $new = new self($data);
        return $new->create();
    }

}
