<?php
namespace YES4Trade\Model;
class ebay_media_videos extends \YES4Trade\Model\BaseType{
    const TABLE_NAME = 'ebay_media_videos';
    const TABLE_INDEX = 'ebay_media_videos_id';
    private static $propertyTypes = [
        'ebay_media_videos_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ebay_media_videos_id'
        ],
        'video_id' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'video_id'
        ],
        'video_status' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'video_status'
        ],
        'expirationDate' => [
            'type' => 'DateTime',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'expirationDate'
        ],
        'seller' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'seller'
        ],
        'video_description' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'video_description'
        ],
        'video_title' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'video_title'
        ],
        'video_thumbnail' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'video_thumbnail'
        ],
    ];
    
    public function __construct( array $values = [] ){
        list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
        parent::__construct($parentValues);

        if (!array_key_exists(__CLASS__, self::$properties)) {
            self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
        }

        if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
            self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
        }

        $this->setValues(__CLASS__, $childValues);
    }
    
    public static function convertInt( array $data ){
            foreach(get_class_vars(__CLASS__) as $pk=>$pv){
               if($pk == 'propertyTypes'){
                    foreach($pv as $kpart => $part){
                       if($part['type'] == 'integer' and isset($data[$kpart])){
                           $data[$kpart] = (int)$data[$kpart];
                       }
                       if($part['type'] == 'DateTime' and isset($data[$kpart])){
                           $data[$kpart] = $data[$kpart];
                       }
                    }
               }
            }
            return $data;
    }
        
    public function create(){
        $data = $this->toArray();
        $data = self::convertInt($data);
        xtc_db_perform(self::TABLE_NAME, $data);
        return xtc_db_insert_id();
    }
    
    public function update(){
        $data = $this->toArray();
        unset($data[self::TABLE_INDEX]);
        $data = self::convertInt($data);
        $index = self::TABLE_INDEX;
        xtc_db_perform(self::TABLE_NAME, $data,'update',self::TABLE_INDEX."='".$this->$index."'");
    }
    
    public static function delete( int $index ){
        xtc_db_query(sprintf(
                "DELETE FROM %s WHERE %s='%d'",
                self::TABLE_NAME,self::TABLE_INDEX, $index
        ));
    }
    
    
    public static function get_by_video_id( string $video_id, string $seller ){
        $query = xtc_db_query(sprintf(
            "SELECT * FROM %s WHERE video_id='%s' AND seller='%s'",
            self::TABLE_NAME, $video_id, $seller
        ));
        if(xtc_db_num_rows($query)){
            $record = xtc_db_fetch_array($query);
            $record = self::convertInt($record);
            return new self($record);
        }
        return null;
    }
    
    public static function get_by_seller( string $seller ){
        $items = [];
        $query = xtc_db_query(sprintf(
            "SELECT * FROM %s WHERE seller='%s'",
            self::TABLE_NAME, $seller
        ));
        while($record = xtc_db_fetch_array($query)){
            $record = self::convertInt($record);
            $items[] = new self($record);
        }
        return $items;
    }
}