<?php

namespace YES4Trade\Model;

class ebay_variations_pictures_sets extends \YES4Trade\Model\BaseType {

    const TABLE_NAME = 'ebay_variations_pictures_sets';
    const TABLE_INDEX = 'ebay_variations_pictures_sets_id';
    var $ebay_variations_pictures_sets_urls;
    
    private static $propertyTypes = [
        'ebay_variations_pictures_sets_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ebay_variations_pictures_sets_id'
        ],
        'ebay_variations_pictures_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ebay_variations_pictures_id'
        ],
        'VariationSpecificValue' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'VariationSpecificValue'
        ],
    ];


    public function __construct(array $values = []) {
        list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
        parent::__construct($parentValues);

        if (!array_key_exists(__CLASS__, self::$properties)) {
            self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
        }

        if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
            self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
        }

        $this->setValues(__CLASS__, $childValues);
    }


    public function create() {
        $data = $this->toArray();
        unset($data['ebay_variations_pictures_sets_urls']);
        xtc_db_perform(self::TABLE_NAME, $data);
        return xtc_db_insert_id();
    }


    public function update() {
        $data = $this->toArray();
        $data['ebay_variations_pictures_sets_id'] = (int)$data['ebay_variations_pictures_sets_id'];
        unset($data[self::TABLE_INDEX]);
        unset($data['ebay_variations_pictures_sets_urls']);
        $index = self::TABLE_INDEX;
        xtc_db_perform(self::TABLE_NAME, $data,'update',$index."='".$this->$index."'");
    }


    public static function delete(int $index) {
        $ebay_variations_pictures_sets_urls = \YES4Trade\Model\ebay_variations_pictures_sets_urls::get_by_ebay_variations_pictures_sets_id(
            $index
        );
        foreach($ebay_variations_pictures_sets_urls as $evpsu){
            \YES4Trade\Model\ebay_variations_pictures_sets_urls::delete(
                $evpsu->ebay_variations_pictures_sets_urls_id
            );
        }
        xtc_db_query(sprintf(
            "DELETE FROM %s WHERE %s='%d'",
            self::TABLE_NAME,self::TABLE_INDEX, $index
        ));
    }


    public static function get_by_ebay_variations_pictures_sets_id(int $ebay_variations_pictures_sets_id) {
        $query = xtc_db_query(sprintf(
                "SELECT * FROM %s WHERE %s='%d'",
                self::TABLE_NAME, self::TABLE_INDEX, $ebay_variations_pictures_sets_id
        ));
        if(!xtc_db_num_rows($query)){
            return null;
        }
        $record = xtc_db_fetch_array($query);
        foreach(get_class_vars(__CLASS__) as $pk=>$pv){
           if($pv['type'] == 'integer'){
               $record[$pk] = (int)$record[$pk];
           }
        }
        $item = new self($record);
        $item->ebay_variations_pictures_sets_urls = \YES4Trade\Model\ebay_variations_pictures_sets_urls::get_by_ebay_variations_pictures_sets_id(
                $record[ 'ebay_variations_pictures_sets_id' ]
        );
        return $item;
    }

    public static function get_by_ebay_variations_pictures_id(int $ebay_variations_pictures_id) {
        $items = [];
        $query = xtc_db_query(sprintf(
                "SELECT * FROM %s WHERE ebay_variations_pictures_id='%d'",
                self::TABLE_NAME, $ebay_variations_pictures_id
        ));
        while($record = xtc_db_fetch_array($query)){
            foreach(get_class_vars(__CLASS__) as $pk=>$pv){
               if($pv['type'] == 'integer'){
                   $record[$pk] = (int)$record[$pk];
               }
            }
            $item = new self($record);
            $item->ebay_variations_pictures_sets_urls = \YES4Trade\Model\ebay_variations_pictures_sets_urls::get_by_ebay_variations_pictures_sets_id(
                $record[ self::TABLE_INDEX ]
            );
            $items[] = $item;
        }
        return $items;
    }
}
