<?php
namespace YES4Trade\Model;

class groups_characteristic extends \YES4Trade\Model\BaseType{
    const TABLE_NAME = 'products_characteristic';
    const TABLE_INDEX = 'products_characteristic_id';
    var $sets, $description;
    private static $propertyTypes = [
        'products_characteristic_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'products_characteristic_id'
        ],
        'sort_order' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'sort_order'
        ],
        'groups_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'groups_id'
        ],
        'no_sets' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'no_sets'
        ],
        'visible' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'visible'
        ],
        'multiple' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'multiple'
        ],
        'ebay_visible' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ebay_visible'
        ],
        'deny_filter' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'deny_filter'
        ],
        'description' => [
            'type' => 'YES4Trade\Model\groups_characteristic_description',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'description'
        ],
    ];
    
    public function __construct( array $values = [] ){
        list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
        parent::__construct($parentValues);

        if (!array_key_exists(__CLASS__, self::$properties)) {
            self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
        }

        if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
            self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
        }

        $this->setValues(__CLASS__, $childValues);
    }

    public function create(){
        $data = $this->toArray();
        unset($data['description']);
        unset($data['sets']);
        xtc_db_perform(self::TABLE_NAME, $data);
        \YES4Trade\Model\group_handler::clear_cache();
        return xtc_db_insert_id();
    }
    
    public function update(){
        $data = $this->toArray();
        unset($data[self::TABLE_INDEX]);
        unset($data['description']);
        unset($data['sets']);
        $index = self::TABLE_INDEX;
        xtc_db_perform(self::TABLE_NAME, $data,'update',self::TABLE_INDEX."='".$this->$index."'");
        \YES4Trade\Model\group_handler::clear_cache();
    }
    
    public static function delete( int $index ){
        xtc_db_query(sprintf(
                "DELETE FROM %s WHERE %s='%d'",
                self::TABLE_NAME,self::TABLE_INDEX, $index
        ));
        $sets = \YES4Trade\Model\groups_characteristic_set::get_by_characteristic_id( $index );
        foreach($sets as $c){
            \YES4Trade\Model\groups_characteristic_set::delete( $c->products_characteristic_set_id );
        }
        $desc = \YES4Trade\Model\groups_characteristic_description::get_by_characteristic_id( $index );
        foreach($desc as $c){
            \YES4Trade\Model\groups_characteristic_description::delete( $c->products_characteristic_id );
        }
        $text_values = \YES4Trade\Model\groups_characteristic_text_values::get_by_characteristic_id( $index );
        foreach($text_values as $c){
            \YES4Trade\Model\groups_characteristic_text_values::delete( $c->products_characteristic_text_values_id );
        }
        \YES4Trade\Model\group_handler::clear_cache();
    }
    
    public static function get_by_groups_id( int $groups_id, int $language_id = -1 ){
        $items = [];
        $query = yes_query(sprintf(
            "SELECT * FROM %s WHERE groups_id=:id ORDER BY sort_order",
                self::TABLE_NAME
            ),['id'=>$groups_id]
        );
        foreach($query as $record){
            foreach($record as $k=>$v){
                $record[ $k ] = (int) $v;
            }
            $item = new \YES4Trade\Model\groups_characteristic($record);
            $item->sets = \YES4Trade\Model\groups_characteristic_set::get_by_characteristic_id( $item->products_characteristic_id, $language_id );
            if( $language_id > -1){
                $item->description = \YES4Trade\Model\groups_characteristic_description::get_by_characteristic_id($item->products_characteristic_id, $language_id );
            }
            $items[] = $item;
        }
        return $items;
    }
    
    public function get_descriptionData( int $language_id ){
        return \YES4Trade\Model\groups_characteristic_description::get_by_characteristic_id($this->products_characteristic_id, $language_id);
    }
    
    public function get_setsData( ){
        return \YES4Trade\Model\groups_characteristic_set::get_by_characteristic_id( $this->products_characteristic_id );
    }
    
    public static function get_by_characteristic_id( int $index ){
        $query = yes_query(sprintf(
            "SELECT * FROM %s WHERE %s=:id",
                self::TABLE_NAME, self::TABLE_INDEX
            ),['id'=>$index]
        );
        if(!sizeOf($query)){
            return;
        }
        $record = current($query);
        foreach($record as $k=>$v){
            $record[ $k ] = (int) $v;
        }
        return new \YES4Trade\Model\groups_characteristic($record);
    }
}