<?php
namespace YES4Trade\Model;

class groups_products extends \YES4Trade\Model\BaseType{
    const TABLE_NAME = 'groups_allocations';
    private static $propertyTypes = [
        'groups_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'groups_id'
        ],
        'products_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'products_id'
        ],
    ];
    
    public function __construct( array $values = [] ){
        list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
        parent::__construct($parentValues);

        if (!array_key_exists(__CLASS__, self::$properties)) {
            self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
        }

        if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
            self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
        }

        $this->setValues(__CLASS__, $childValues);
    }

    public function create(){
        $data = $this->toArray();
        unset($data['description']);
        unset($data['sets']);
        xtc_db_perform(self::TABLE_NAME, $data);
        return xtc_db_insert_id();
    }
    
   
    public static function delete( int $groups_id, int $products_id ){
        xtc_db_query(sprintf(
                "DELETE FROM %s WHERE groups_id='%d' AND products_id='%d'",
                self::TABLE_NAME,$groups_id, $products_id
        ));
        $characteristics = \YES4Trade\Model\groups_products_characteristics::get_by_products_id($products_id);
        foreach($characteristics as $c){
            \YES4Trade\Model\groups_products_characteristics::delete($c->products_to_characteristics_id);
        }
        $text_values = \YES4Trade\Model\groups_characteristic_text_values::get_by_products_id( $products_id );
        foreach($text_values as $c){
            \YES4Trade\Model\groups_characteristic_text_values::delete( $c->products_characteristic_text_values_id );
        }
    }
    
    public static function get_by_groups_id( int $groups_id ){
        $items = [];
        $query = yes_query(sprintf(
            "SELECT * FROM %s WHERE groups_id=:id",
                self::TABLE_NAME
            ),['id'=>$groups_id]
        );
        foreach($query as $record){
            foreach($record as $k=>$v){
                $record[ $k ] = (int) $v;
            }
            $items[] = new \YES4Trade\Model\groups_products($record);
        }
        return $items;
    }
    
    public static function get_by_products_id( int $products_id ){
        $items = [];
        $query = yes_query(sprintf(
            "SELECT * FROM %s WHERE products_id=:id",
            self::TABLE_NAME
            ),['id'=>$products_id]
        );
        foreach($query as $record){
            foreach($record as $k=>$v){
                $record[ $k ] = (int) $v;
            }
            $items[] = new \YES4Trade\Model\groups_products($record);
        }
        return $items;
    }
    
    public function getValues(){
        $characteristics = \YES4Trade\Model\groups_products_characteristics::get_by_products_id( $this->products_id );
    }
    
    public static function allocation_exists( int $products_id, int $groups_id ){
        $query = yes_query(sprintf(
            "SELECT * FROM %s WHERE products_id=:products_id AND groups_id=:groups_id",
                self::TABLE_NAME
            ),['products_id'=>$products_id, 'groups_id'=>$groups_id]
        );
        return (sizeOf($query)>0) ? true : false;
    }
}