<?php
namespace YES4Trade\Model;
class manufacturer extends \YES4Trade\Model\BaseType{
    const TABLE_NAME = 'manufacturers';
    const TABLE_INDEX = 'manufacturers_id';
    private static $propertyTypes = [
        'manufacturers_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'manufacturers_id'
        ],
        'manufacturers_name' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'manufacturers_name'
        ],
        'manufacturers_image' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'manufacturers_image'
        ],
        'date_added' => [
            'type' => 'DateTime',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'date_added'
        ],
        'last_modified' => [
            'type' => 'DateTime',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'last_modified'
        ],
        'short_name' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'short_name'
        ],
        'nmedia_id' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'nmedia_id'
        ],
        'manufacturer_cityname' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'manufacturer_cityname'
        ],
        'manufacturer_companyname' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'manufacturer_companyname'
        ],
        'manufacturer_country' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'manufacturer_country'
        ],
        'manufacturer_email' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'manufacturer_email'
        ],
        'manufacturer_phone' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'manufacturer_phone'
        ],
        'manufacturer_postalcode' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'manufacturer_postalcode'
        ],
        'manufacturer_stateorprovince' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'manufacturer_stateorprovince'
        ],
        'manufacturer_street1' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'manufacturer_street1'
        ],
        'manufacturer_street2' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'manufacturer_street2'
        ],
        
        
        
    ];
    
    public function __construct( array $values = [] ){
        list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
        parent::__construct($parentValues);

        if (!array_key_exists(__CLASS__, self::$properties)) {
            self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
        }

        if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
            self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
        }

        $this->setValues(__CLASS__, $childValues);
    }
    
    public function create(){
        $data = $this->toArray();
        xtc_db_perform(self::TABLE_NAME, $data);
        return xtc_db_insert_id();
    }
    
    public function update(){
        $data = $this->toArray();
        unset($data[self::TABLE_INDEX]);
        $index = self::TABLE_INDEX;
        xtc_db_perform(self::TABLE_NAME, $data,'update',self::TABLE_INDEX."='".$this->$index."'");
    }
    
    public static function delete( int $index ){
        xtc_db_query(sprintf(
                "DELETE FROM %s WHERE %s='%d'",
                self::TABLE_NAME,self::TABLE_INDEX, $index
        ));
    }
    
    public static function get_by_manufacturers_id( int $manufacturers_id, array $select_fields = [] ){
        if($manufacturers_id < 1){
            return null;
        }
        $select_field_string = '*';
        if(sizeOf($select_fields)){
            $select_field_string = implode(',',$select_fields);
        }
        $query = yes_query(sprintf(
            "SELECT %s FROM %s WHERE %s=:id",
                $select_field_string,self::TABLE_NAME, self::TABLE_INDEX
            ),['id'=>$manufacturers_id]
        );
        if(sizeOf($query)){
            $record = current($query);
            if(isset($record[self::TABLE_INDEX])){
                $record[self::TABLE_INDEX] = (int)$record[self::TABLE_INDEX];
            }
            return new self($record);
        }
        return null;
    }
    
    public static function get_manufacturers_name(int $manufacturers_id){
        global $InstanceCache;
        if($manufacturers_id < 1){
            return '';
        }
        $key = 'manufacturers.name-'.$manufacturers_id;
        $CachedString = $InstanceCache->getItem($key);
        if (!$CachedString->isHit()) {
            $record = yes_query(sprintf(
                "SELECT manufacturers_name FROM %s WHERE %s=:id",
                    self::TABLE_NAME, self::TABLE_INDEX
                ),['id'=>$manufacturers_id],
                true
            );
            $CachedString->set($record)->expiresAfter(3600);//manufacturers.name-*
            $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
        }else{
            $record = $CachedString->get();
        }
        return $record['manufacturers_name']??'';
    }
}