<?php
namespace YES4Trade\Model;

/**
 * Description of product_properties_xy_prices
 *
 * @author mario
 */
class product_properties_xy_prices extends \YES4Trade\Model\BaseType{
    var $product_properties_xy_prices_values;
    private static $propertyTypes = [
        'product_properties_xy_prices_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'product_properties_xy_prices_id'
        ],
        'products_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'products_id'
        ],
        'products_properties_id_X' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'products_properties_id_X'
        ],
        'products_properties_id_Y' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'products_properties_id_Y'
        ],
    ];
    
    public function __construct( array $values = [] ){
        list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
        parent::__construct($parentValues);

        if (!array_key_exists(__CLASS__, self::$properties)) {
            self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
        }

        if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
            self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
        }

        $this->setValues(__CLASS__, $childValues);
    }
    
    public function create(){
        xtc_db_perform('product_properties_xy_prices', $this->toArray());
        return xtc_db_insert_id();
    }
    
    public function update(){
        $data = $this->toArray();
        $data['product_properties_xy_prices_id'] = null;
        unset($data['product_properties_xy_prices_id']);
        xtc_db_perform('product_properties_xy_prices', $data,'update',"product_properties_xy_prices_id='".$this->product_properties_xy_prices_id."'");
    }
    
    public static function delete( int $product_properties_xy_prices_id ){
        \YES4Trade\Model\product_properties_xy_prices_values::delete_by_product_properties_xy_prices_id( $product_properties_xy_prices_id );
        xtc_db_query(sprintf(
                "DELETE FROM product_properties_xy_prices WHERE product_properties_xy_prices_id='%d'",
                $product_properties_xy_prices_id
        ));
    }
    
    private function get_values_from_db( ){
        $values = [];
        $query = yes_query(
            "SELECT * FROM product_properties_xy_prices_values WHERE product_properties_xy_prices_id=:id",
            ['id'=>$this->product_properties_xy_prices_id]
        );
        if(!sizeOf($query)){
            return $values;
        }
        foreach($query as $record){
            $record['product_properties_xy_prices_values_id'] = (int)$record['product_properties_xy_prices_values_id'];
            $record['product_properties_xy_prices_id'] = (int)$record['product_properties_xy_prices_id'];
            $record['val_X'] = (int)$record['val_X'];
            $record['val_Y'] = (int)$record['val_Y'];
            $record['xy_price'] = (float)$record['xy_price'];
            $obj = new \YES4Trade\Model\product_properties_xy_prices_values($record);
            $values[] = $obj;
        }
        return $values;
    }
    
    public static function get_from_products_id( int $products_id, $only_check = false ){
        $query = yes_query(
            "SELECT * FROM product_properties_xy_prices WHERE products_id=:id",
            ['id'=>$products_id]
        );
        if(!sizeOf($query)){
            return false;
        }
        if($only_check){
        	return true;
        }
        $record = current($query);
        $record['product_properties_xy_prices_id'] = (int)$record['product_properties_xy_prices_id'];
        $record['products_id'] = (int)$record['products_id'];
        $record['products_properties_id_X'] = (int)$record['products_properties_id_X'];
        $record['products_properties_id_Y'] = (int)$record['products_properties_id_Y'];
        $instance = new \YES4Trade\Model\product_properties_xy_prices($record);
        $instance->product_properties_xy_prices_values = \YES4Trade\Model\product_properties_xy_prices_values::get_by_product_properties_xy_prices_id($record['product_properties_xy_prices_id']);
        return $instance;
    }
    
    public function delete_values(){
        foreach($this->product_properties_xy_prices_values as $xyv){
            \YES4Trade\Model\product_properties_xy_prices_values::delete($xyv->product_properties_xy_prices_values_id);
        }
    }
    
    public function get_price( $X, $Y, $tax_rate ){
        $language_id = (isset($_SESSION['languages_id'])) ? $_SESSION['languages_id'] : 2;
        $ppIDX = $this->products_properties_id_X;
        $ppIDY = $this->products_properties_id_Y;
        $propX = new \product_properties($ppIDX);
        $propY = new \product_properties($ppIDY);
        foreach($propX->getValues($language_id) as $ppv){
            if(empty($ppv['input_span'])){
                continue;
            }
            $span = explode(':',$ppv['input_span']);
            if($X >= $span[0] and $X <= $span[1]){
                $X = $ppv['description']->title;
                break;
            }
        }
        foreach($propY->getValues($language_id) as $ppv){
            if(empty($ppv['input_span'])){
                continue;
            }
            $span = explode(':',$ppv['input_span']);
            if($Y >= $span[0] and $Y <= $span[1]){
                $Y = $ppv['description']->title;
                break;
            }
        }
        $allocated_prices = [];
        $properties = yes_get_products_properties_id_array($this->products_id);
        foreach($this->product_properties_xy_prices_values as $xyv){
            if($xyv->val_X == $X && $xyv->val_Y == $Y){
                $price_brutto = round(xtc_oe_get_price_i_tax($xyv->xy_price, $tax_rate),2);
                foreach($properties as $propID){
                    if($propID == $ppIDX or $propID == $ppIDY){
                        continue;
                    }
                    $pp = new \product_properties($propID);
                    foreach($pp->getValues(2) as $ppv){
                        $pb = 0;
                        if($ppv['xy_percent_add']>0 and $price_brutto > 0){
                            $pb = $price_brutto / 100 * $ppv['xy_percent_add'];
                        }elseif($ppv['price'] > 0){
                            $pb = round(xtc_oe_get_price_i_tax($ppv['price'], $tax_rate),2);
                        }
                        $alloc_prices[] = [
                            'products_properties_id'=>$propID,
                            'products_properties_values_id'=>$ppv['description']->products_properties_values_id,
                            'PRICE_BRUTTO'=>$pb
                        ];
                        //echo '<li>'.$propID.':'.$ppv['description']->products_properties_values_id.' = '.$ppv['xy_percent_add'].' ('.$ppv['description']->title.')';
                    }
                }
                //yes_debug($alloc_prices);
                return [
                    'PRICE_BRUTTO'=>$price_brutto,
                    'ALLOCATED_PROPERTIES_PRICES'=>$alloc_prices,
                ];
                /*
                if(is_countable($xyv->product_properties_xy_prices_values_for_properties) and sizeOf($xyv->product_properties_xy_prices_values_for_properties)){
                    foreach($xyv->product_properties_xy_prices_values_for_properties as $pvfp){
                        $allocated_prices[] = [
                            'products_properties_id'=>$pvfp->products_properties_id,
                            'PRICE_BRUTTO'=>round(xtc_oe_get_price_i_tax($pvfp->price_netto, $tax_rate),2),
                        ];
                    }
                }
                return [
                    'PRICE_BRUTTO'=>$price_brutto,
                    'ALLOCATED_PROPERTIES_PRICES'=>$allocated_prices,
                ];*/
            }
        }
        return [];
    }
    
    public static function is_products_properties_id_xy_price( int $products_properties_id ){
        $query = yes_query(
            "SELECT product_properties_xy_prices_id FROM product_properties_xy_prices WHERE products_properties_id_X=:x_val OR products_properties_id_Y=:y_val",
            ['x_val'=>$products_properties_id,'y_val'=>$products_properties_id]
        );
        if(sizeOf($query)>0){
            return true;
        }
        return false;
    }
}
