<?php

namespace YES4Trade\Model;

class product_properties_xy_prices_values_for_properties  extends \YES4Trade\Model\BaseType{
    private static $propertyTypes = [
        'product_properties_xy_prices_values_for_properties_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'product_properties_xy_prices_values_for_properties_id'
        ],
        'product_properties_xy_prices_values_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'product_properties_xy_prices_values_id'
        ],
        'products_properties_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'products_properties_id'
        ],
        'price_netto' => [
            'type'=>'double',
            'repeatable'=>false,
            'attribute'=>false,
            'elementName'=>'price_netto'
        ]
    ];
    
    public function __construct( array $values = [] ){
        list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
        parent::__construct($parentValues);

        if (!array_key_exists(__CLASS__, self::$properties)) {
            self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
        }

        if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
            self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
        }

        $this->setValues(__CLASS__, $childValues);
    }
    
    public function create(){
        xtc_db_perform('product_properties_xy_prices_values_for_properties', $this->toArray());
        return xtc_db_insert_id();
    }
    
    public function update(){
        $data = $this->toArray();
        unset($data['product_properties_xy_prices_values_for_properties_id']);
        xtc_db_perform('product_properties_xy_prices_values_for_properties', $data,'update',"product_properties_xy_prices_values_for_properties_id='".$this->product_properties_xy_prices_values_for_properties_id."'");
    }
    
    public static function delete( int $product_properties_xy_prices_values_for_properties_id ){
        xtc_db_query(sprintf(
                "DELETE FROM product_properties_xy_prices_values_for_properties WHERE product_properties_xy_prices_values_for_properties_id='%d'",
                $product_properties_xy_prices_values_for_properties_id
        ));
    }
    
    public static function get_by_product_properties_xy_prices_values_id( int $product_properties_xy_prices_values_id ){
        $items = [];
        $query = yes_query(
            "SELECT * FROM product_properties_xy_prices_values_for_properties WHERE product_properties_xy_prices_values_id=:id ORDER BY products_properties_id",
            ['id'=>$product_properties_xy_prices_values_id]
        );
        foreach($query as $record){
            $record[ 'product_properties_xy_prices_values_for_properties_id' ] = (int) $record['product_properties_xy_prices_values_for_properties_id'];
            $record[ 'product_properties_xy_prices_values_id' ] = (int) $record['product_properties_xy_prices_values_id'];
            $record[ 'products_properties_id' ] = (int) $record['products_properties_id'];
            $record[ 'price_netto' ] = (float) $record['price_netto'];
            $items[] = new \YES4Trade\Model\product_properties_xy_prices_values_for_properties( $record );
        }
        return $items;
    }
    
    public static function delete_by_product_properties_xy_prices_values_id( int $product_properties_xy_prices_values_id ){
        yes_query(
            "DELETE FROM product_properties_xy_prices_values_for_properties WHERE product_properties_xy_prices_values_id=:id",
            ['id'=>$product_properties_xy_prices_values_id]
        );
    }
}
