<?php
namespace YES4Trade\Model;

class products_conditions extends \YES4Trade\Model\BaseType{
    const TABLE_NAME = 'products_conditions';
    const TABLE_INDEX = 'products_conditions_id';
    const CACHE_KEY = 'products_conditions_%d';
    private static $propertyTypes = [
        'products_conditions_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'products_conditions_id'
        ],
        'date_added' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'date_added'
        ],
        'description'=> [
            'type' => 'YES4Trade\Model\products_conditions_description',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'description'
        ],
    ];
    
    public function __construct( array $values = [] ){
        list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
        parent::__construct($parentValues);

        if (!array_key_exists(__CLASS__, self::$properties)) {
            self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
        }

        if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
            self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
        }

        $this->setValues(__CLASS__, $childValues);
    }

    public function create(){
        xtc_db_perform(sprintf("`%s`",self::TABLE_NAME), $this->toArray());
        self::clear_cache();
        return xtc_db_insert_id();
    }
    
    public function update(){
        $data = $this->toArray();
        unset($data[self::TABLE_INDEX]);
        $index = self::TABLE_INDEX;
        xtc_db_perform(sprintf("`%s`",self::TABLE_NAME), $data,'update',self::TABLE_INDEX."='".$this->$index."'");
        self::clear_cache();
    }
    
    
    public static function delete( int $index ){
        xtc_db_query(sprintf(
                "DELETE FROM %s WHERE %s='%d'",
                sprintf("%s",self::TABLE_NAME),self::TABLE_INDEX, $index
        ));
        xtc_db_query(sprintf(
                "DELETE FROM %s_description WHERE %s='%d'",
                sprintf("%s",self::TABLE_NAME),self::TABLE_INDEX, $index
        ));
        self::clear_cache();
    }
    
    public static function clear_cache(){
        global $InstanceCache;
        $languages = xtc_get_languages();
        foreach($InstanceCache->getItemsByTags(['admin','shop']) as $cn=>$cd){
            foreach($languages as $lang){
                if($cd->getKey() == sprintf(self::CACHE_KEY,$lang['id'])){
                    $InstanceCache->deleteItem($cd->getKey()); // products_conditions
                }
            }
        }
    }
    
    public static function get_list(int $language_id = 2){
        global $InstanceCache;
        $key = sprintf(self::CACHE_KEY, $language_id);
        $CachedString = $InstanceCache->getItem($key);
        if (!$CachedString->isHit()) {
            $list = [];
            $query = yes_query(sprintf(
                "SELECT * FROM %s prc LEFT JOIN %s_description prcd USING(%s) WHERE language_id=:id ORDER BY title",
                    self::TABLE_NAME, self::TABLE_NAME, self::TABLE_INDEX
                ),['id'=>$language_id]
            );
            foreach($query as $data){
                $list[] = $data;
            }
            $CachedString->set($list)->expiresAfter(0)->addTags(['shop','admin']);//products_conditions_*
            $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
        }else{
            $list = $CachedString->get();
        }
        return $list;
    }
    
    public static function get_condition_title( int $products_conditions_id, int $language_id = 2){
        $list = self::get_list($language_id);
        foreach($list as $cond){
            if($cond['products_conditions_id'] != $products_conditions_id){
                continue;
            }
            return $cond['title'];
        }
        return '';
    }
}