<?php
namespace YES4Trade\Model;

class shipper_profiles extends \YES4Trade\Model\BaseType{
    private static $propertyTypes = [
        'shipper_profiles_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'shipper_profiles_id'
        ],
        'profile_name' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'profile_name'
        ],
        'versender' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'versender'
        ],
        'versender_params' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'versender_params'
        ],
    ];
    
    public function __construct( array $values = [] ){
        list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
        parent::__construct($parentValues);

        if (!array_key_exists(__CLASS__, self::$properties)) {
            self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
        }

        if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
            self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
        }

        $this->setValues(__CLASS__, $childValues);
    }
    
    public static function clear_cache(){
        global $InstanceCache;
        foreach($InstanceCache->getItemsByTags(['admin','shop']) as $cn=>$cd){
            if(strpos($cd->getKey(),'shipper_profiles')>-1){
                $InstanceCache->deleteItem($cd->getKey()); // shipper_profiles
            }
        }
    }
    
    public function create(){
        xtc_db_perform('shipper_profiles', $this->toArray());
        self::clear_cache();
        return xtc_db_insert_id();
    }
    
    public function update(){
        $data = $this->toArray();
        $data['shipper_profiles_id'] = null;
        unset($data['shipper_profiles_id']);
        $data['profile_name'] = null;
        unset($data['profile_name']);
        xtc_db_perform('shipper_profiles', $data,'update',"profile_name='".$this->profile_name."'");
        self::clear_cache();
    }
    
    public static function delete( string $profile_name ){
        xtc_db_query(sprintf(
                "DELETE FROM shipper_profiles WHERE profile_name='%s'",
                $profile_name
        ));
        self::clear_cache();
    }
    
    public static function get_list(){
        global $InstanceCache;
        $key = 'shipper_profiles';
        $CachedString = $InstanceCache->getItem($key);
        if (!$CachedString->isHit()) {
            $return = [];
            $query = xtc_db_query(
                    "SELECT * FROM shipper_profiles order by profile_name"
            );
            while($record = xtc_db_fetch_array($query)){
                $return[] = $record;
            }
            $CachedString->set($return)->expiresAfter(0)->addTags(['shop','admin']);//shipper_profiles
            $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
        }else{
            $return = $CachedString->get();
        }
        return $return;
    }
    
    public static function get_crud_link(){
        return sprintf('<a style="font-size: 1.4em;text-decoration: none;" title="%s" href="%s" target="_blank">%s</a>',
            TEXT_SHIPPER_PROFILES_ADMIN,
            xtc_href_link('modules.php','action=shipper_profiles&set=shipping'),
            '&#x270D;'
        );
    }
    
    public static function get_selection_list(){
        $return = [
            ['id'=>'','text'=>TEXT_SELECT]
        ];
        $array = self::get_list();
        foreach($array as $sh){
            $return[] = ['id'=>$sh['profile_name'],'text'=>$sh['profile_name']];
        }
        return $return;
    }
    
    public static function profile_name_exists( string $profile_name ){
        $query = yes_query(
            "SELECT shipper_profiles_id FROM shipper_profiles WHERE profile_name=:name",
            ['name'=>$profile_name]
        );
        return (sizeOf($query)>0)?true:false;
    }
    
    public static function get_products_id_value( int $products_id ){
        $query = yes_query(
            "SELECT shipper_profile FROM products_default_shipper WHERE products_id=:id",
            ['id'=>$products_id]
        );
        if(!sizeOf($query)){
            return '';
        }
        $record = current($query);
        return $record['shipper_profile'];
    }
    
    public static function allocate_to_products_id( string $shipper_profile, int $pID ){
        yes_query(
            "DELETE FROM products_default_shipper WHERE products_id=:id",
            ['id'=>$pID]
        );
        if(empty($shipper_profile)){
            return -1;
        }
        $insert_sql_array = [
            'products_id'=>$pID,
            'shipper_profile'=>$shipper_profile
        ];
        yes_db_perform('products_default_shipper',$insert_sql_array);
        return xtc_db_insert_id();
    }
    
    public static function get_profile( string $profile_name ){
        $query = yes_query(
            "SELECT * FROM shipper_profiles WHERE profile_name=:name",
            ['name'=>$profile_name]
        );
        if(!sizeOf($query)){
            return null;
        }
        $data = current($query);
        $data['shipper_profiles_id'] = (int)$data['shipper_profiles_id'];

        return new self( $data );
    }
}
