<?php
namespace YES4Trade\Model;

class shipping_status extends \YES4Trade\Model\BaseType {
    private static $propertyTypes = [
        'shipping_status_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'shipping_status_id'
        ],
        'language_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'language_id'
        ],
        'shipping_status_name' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'shipping_status_name'
        ],
        'shipping_status_image' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'shipping_status_image'
        ]
    ];
    
    public function __construct( array $values = [] ){
        list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
        parent::__construct($parentValues);

        if (!array_key_exists(__CLASS__, self::$properties)) {
            self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
        }

        if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
            self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
        }

        $this->setValues(__CLASS__, $childValues);
    }
    
    public static function get_by_id( int $shipping_status_id ){
        $return = [
            'meta'=>[],
            'languages'=>[]
        ];
        $query = yes_query(
            "SELECT * FROM shipping_status WHERE shipping_status_id=:id",
            ['id'=>$shipping_status_id]
        );
        foreach($query as $record){
            if(!isset($return['meta']['shipping_status_id'])){
                $return['meta'] = [
                    'shipping_status_id'=>$record['shipping_status_id'],
                    'shipping_status_image'=>$record['shipping_status_image'],
                ];
            }
            $return['languages'][] = [
                'language_id'=>$record['language_id'],
                'shipping_status_name'=>$record['shipping_status_name'],
            ];
        }
        return $return;
    }
    
    public static function get_list( int $language_id ){
        global $InstanceCache;
        $key = 'shipping_status_'.$language_id;
        $CachedString = $InstanceCache->getItem($key);
        if (!$CachedString->isHit()) {
            $return = [];
            $query = yes_query(
                "SELECT * FROM shipping_status WHERE language_id=:language_id ORDER BY shipping_status_id",
                ['language_id'=>$language_id]
            );
            foreach($query as $record){
                $return[] = $record;
            }
            $CachedString->set($return)->expiresAfter(0)->addTag('shop');//shipping_status_*
            $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
        }else{
            $return = $CachedString->get();
        }
        return $return;
    }
    
    public function update(){
        global $InstanceCache;
        $data = $this->toArray();
        $data['shipping_status_id'] = null;
        $data['language_id'] = null;
        unset($data['shipping_status_id']);
        unset($data['language_id']);
        xtc_db_perform('shipping_status', $data, 'update',"shipping_status_id='".$this->shipping_status_id."' AND language_id='".$this->language_id."'");
        $key = 'shipping_status_';
        foreach($InstanceCache->getItemsByTags(['admin','shop']) as $cn=>$cd){
            if(strpos($cd->getKey(),$key)>-1){
                $InstanceCache->deleteItem($cd->getKey()); // shipping_status_*
            }
        }
    }
    
    public static function delete( int $shipping_status_id ){
        global $InstanceCache;
        xtc_db_query(sprintf(
                "DELETE FROM shipping_status WHERE shipping_status_id='%d'",
                $shipping_status_id
        ));
        xtc_db_query(sprintf(
            "UPDATE products SET products_shippingtime='0' WHERE products_shippingtime='%d'",
            $shipping_status_id
        ));
        $key = 'shipping_status_';
        foreach($InstanceCache->getItemsByTags(['admin','shop']) as $cn=>$cd){
            if(strpos($cd->getKey(),$key)>-1){
                $InstanceCache->deleteItem($cd->getKey()); // shipping_status_*
            }
        }
    }
    
    public function create( ){
        global $InstanceCache;
        xtc_db_perform('shipping_status', $this->toArray());
        $key = 'shipping_status_';
        foreach($InstanceCache->getItemsByTags(['admin','shop']) as $cn=>$cd){
            if(strpos($cd->getKey(),$key)>-1){
                $InstanceCache->deleteItem($cd->getKey()); // shipping_status_*
            }
        }
    }
}
