<?php
namespace YES4Trade\Model;

define('YES_TODO_TEMPLATE_PLAIN', "##### YES4TRADE BATCHPROCESSING ###"
    ."\n"
    ."\nAnzahl Datensaetze gesamt: {TOTAL}"
    ."\nDatensaetze pro Aufruf:    {TOTAL_SESSION}"
    ."\n"
);

class todo{
    const LIMIT = 50;
    const simple_lock_file = DIR_FS_CATALOG.'cache/YES-SDK-TODO.lock';
    var $list = [];
    var $cli = true;
    var $simple_lock_obj;
    var $todo_type = '';
    // bei 1 wird der sonderpreis an ebay gesendet
    // bei 2 wird der origpreis wieder hergestellt und der specials_ebay_revise
    // eintrag geloescht
    var $target_status = 1; 
    
    public function __construct( string $todo_type ){
        self::check_requirements();
        $this->cli = http_response_code()!==FALSE;
        $this->todo_type = $todo_type;
        $this->simple_lock_obj = new \simple_lock( self::simple_lock_file );
    }
    
    private static function check_requirements(){
        if( !class_exists('simple_lock')){
            throw new \Exception('Missing class simple_lock');
        }
        if( !class_exists('specials_ebay_revise')){
            throw new \Exception('Missing class specials_ebay_revise');
        }
        if( !function_exists('yes_write_notice')){
            throw new \Exception('Missing function yes_write_notice');
        }
    }

    private function get_header_text(){
        $plain = str_replace([
              '{TOTAL}',
              '{TOTAL_SESSION}'
            ],[
                sizeOf($this->list),
                self::LIMIT
            ],YES_TODO_TEMPLATE_PLAIN
        );
        return $plain;
    }
    public function process_cli(){
        if(!sizeOf($this->list)){
            return false;
        }
        $this->simple_lock_obj->lock();
        echo $this->get_header_text();
        $notice = '';
        foreach($this->list as $nr=>$item){
            echo ($nr+1).': '.$this->get_item_info($item);
            if( $nr >= self::LIMIT){
                return true;
            }
            try{
                $revise = new \YES4Trade\Model\todo_item_revise( (object)$item );
                echo "\n\tverarbeitet";
            }catch( Exception $e ){
                printf("\n\t%s\n",$e->getMessage());
                $notice .= $e->getMessage()."\n";
            }
            sleep(1);
        }
        $this->write_result_error_notice( $notice );
        $this->simple_lock_obj->destroy();
    }
    
    private function write_result_error_notice( string $message ){
        if(empty($message)){
            return true;
        }
        switch($this->todo_type){
            case 'specials_ebay_revise_0':
                $subject = 'eBay Sonderangebote Revise Fehler';
                $msg = '<p>Es wurde versucht zu Artikeln, bei denen Sonderangebotspreise aktiviert wurden, die Preise in eBay Angebote zu synchronisieren. Dabei kam es zu folgenden Fehlern:</p>';
                $msg .= nl2br($message);
                break;
            case 'specials_ebay_revise_1':
                $subject = 'eBay Sonderangebote De-Revise Fehler';
                $msg = '<p>Es wurde versucht zu Artikeln, bei denen Sonderangebotspreise deaktiviert wurden, die Preise in eBay Angebote zu synchronisieren. Dabei kam es zu folgenden Fehlern:</p>';
                $msg .= nl2br($message);
                break;
        }
        $sender = 0;
        $recs = \main::get_notice_recipients('ebayapi_cart');
        yes_write_notice($subject,$msg, $sender,$recs);
    }
    
    public function add_list_item( array $item ){
        $this->list[] = new \YES4Trade\Model\todo_item($item['type'], $item['target_status'], $item['params']);
    }
    
    public function get_list(){
        return $this->list;
    }
    
    private static function encode_item_parameter( array $item ){
        return base64_encode(json_encode($item));
    }
    
    public static function decode_item_parameter( string $json ){
        return json_decode(base64_decode($json));
    }
    
    public static function get_item_checkbox_html( array $item ){
        return sprintf(
                '<input type="checkbox" class="todo_item" name="todo_item[]" value="%s" />',
                self::encode_item_parameter( $item )
        );
    }
    
    public static function get_item_info(\YES4Trade\Model\todo_item $info ){
        $changes = [];
        if(isset($info->params->variations->variation) and is_countable($info->params->variations->variation)){
            foreach($info->params->variations->variation as $v){
                $changes[] = sprintf('V-SKU %s auf %s',
                        $v->sku,$v->value
                );
            }
        }else{
            $changes[] = sprintf('SKU %s auf %s',
                    $info->params->sku,
                    $info->params->value
            );
        }
        return sprintf(
                "%s eaID %d %s",
                $info->type,
                $info->params->ebay_auctions_id,
                implode(', ',$changes)
        );
    }
}
