<?php
namespace YES4Trade\Model;
class yes_boxes_item {
    var $id, $active;
    public function __construct( $filename ){
        $this->set_id( $filename );
        $this->set_active( \YES4Trade\Model\yes_boxes_config::get_box_active_status( $this->get_id() ));
    }
    
    public function allow_include( $page ){
        switch( $this->get_id()){
            case 'add_a_quickie.php':
                return $_SESSION['customers_status']['customers_status_show_price']>0;
            case 'admin.php':
                return $_SESSION['customers_status']['customers_status_id'] == 0;
            case 'shopping_cart.php':
                return $_SESSION['customers_status']['customers_status_show_price'] == 1;
            case 'manufacturer_info.php':
                return isset($_GET['products_id']);
            case 'order_history.php':
                return isset($_SESSION['customer_id']);
            case 'best_sellers.php':
                if (isset($_GET['products_id'])) {
                    if (isset($_SESSION['customer_id'])) {
                        return \YES4Trade\Model\customers_info::customer_has_global_product_notifications(
                                intval($_SESSION['customer_id'])
                        );
                    }
                } else {
                    return true;
                }
                return false;
            case 'product_notifications.php':
                if (isset($_GET['products_id'])) {
                    if (isset($_SESSION['customer_id'])) {
                        return \YES4Trade\Model\customers_info::customer_has_global_product_notifications(
                                intval($_SESSION['customer_id'])
                        );
                    } else {
                        return true;
                    }
                }
                return false;
            case 'tell_a_friend.php':
                if (isset($_GET['products_id'])) {
                    return $page !== FILENAME_TELL_A_FRIEND;
                }
                return false;
            case 'specials.php':
                return !isset($_GET['products_id']);
            case 'yesdsgvo.php':
                return defined('MODULE_OTHER_YESDSGVO_ADMIN_STATUS') and MODULE_OTHER_YESDSGVO_ADMIN_STATUS == 'True';
        }
        return true;
    }
    
    public function set_id( string $id ){
        $this->id = $id;
    }
    
    public function get_id(){
        return $this->id;
    }
    
    public function set_active( bool $active ){
        $this->active = $active;
    }
    
    public function get_active(){
        return $this->active;
    }
}

