<?php
/**
 * PackageDetail
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Orders
 *
 * The Selling Partner API for Orders helps you programmatically retrieve order information. These APIs let you develop fast, flexible, custom applications in areas like order synchronization, order research, and demand-based decision support tools. The Orders API only supports orders that are less than two years old. Orders more than two years old will not show in the API response.
 *
 * The version of the OpenAPI document: v0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\OrdersV0;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;

/**
 * PackageDetail Class Doc Comment
 *
 * @category Class
 * @description Properties of packages
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class PackageDetail extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'PackageDetail';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'package_reference_id' => 'string',
        'carrier_code' => 'string',
        'carrier_name' => 'string',
        'shipping_method' => 'string',
        'tracking_number' => 'string',
        'ship_date' => 'string',
        'ship_from_supply_source_id' => 'string',
        'order_items' => '\SellingPartnerApi\Model\OrdersV0\ConfirmShipmentOrderItem[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'package_reference_id' => null,
        'carrier_code' => null,
        'carrier_name' => null,
        'shipping_method' => null,
        'tracking_number' => null,
        'ship_date' => null,
        'ship_from_supply_source_id' => null,
        'order_items' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'package_reference_id' => 'packageReferenceId',
        'carrier_code' => 'carrierCode',
        'carrier_name' => 'carrierName',
        'shipping_method' => 'shippingMethod',
        'tracking_number' => 'trackingNumber',
        'ship_date' => 'shipDate',
        'ship_from_supply_source_id' => 'shipFromSupplySourceId',
        'order_items' => 'orderItems'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'package_reference_id' => 'setPackageReferenceId',
        'carrier_code' => 'setCarrierCode',
        'carrier_name' => 'setCarrierName',
        'shipping_method' => 'setShippingMethod',
        'tracking_number' => 'setTrackingNumber',
        'ship_date' => 'setShipDate',
        'ship_from_supply_source_id' => 'setShipFromSupplySourceId',
        'order_items' => 'setOrderItems'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'package_reference_id' => 'getPackageReferenceId',
        'carrier_code' => 'getCarrierCode',
        'carrier_name' => 'getCarrierName',
        'shipping_method' => 'getShippingMethod',
        'tracking_number' => 'getTrackingNumber',
        'ship_date' => 'getShipDate',
        'ship_from_supply_source_id' => 'getShipFromSupplySourceId',
        'order_items' => 'getOrderItems'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['package_reference_id'] = $data['package_reference_id'] ?? null;
        $this->container['carrier_code'] = $data['carrier_code'] ?? null;
        $this->container['carrier_name'] = $data['carrier_name'] ?? null;
        $this->container['shipping_method'] = $data['shipping_method'] ?? null;
        $this->container['tracking_number'] = $data['tracking_number'] ?? null;
        $this->container['ship_date'] = $data['ship_date'] ?? null;
        $this->container['ship_from_supply_source_id'] = $data['ship_from_supply_source_id'] ?? null;
        $this->container['order_items'] = $data['order_items'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        if ($this->container['package_reference_id'] === null) {
            $invalidProperties[] = "'package_reference_id' can't be null";
        }
        if ($this->container['carrier_code'] === null) {
            $invalidProperties[] = "'carrier_code' can't be null";
        }
        if ($this->container['tracking_number'] === null) {
            $invalidProperties[] = "'tracking_number' can't be null";
        }
        if ($this->container['ship_date'] === null) {
            $invalidProperties[] = "'ship_date' can't be null";
        }
        if ($this->container['order_items'] === null) {
            $invalidProperties[] = "'order_items' can't be null";
        }
        return $invalidProperties;
    }


    /**
     * Gets package_reference_id
     *
     * @return string
     */
    public function getPackageReferenceId()
    {
        return $this->container['package_reference_id'];
    }

    /**
     * Sets package_reference_id
     *
     * @param string $package_reference_id A seller-supplied identifier that uniquely identifies a package within the scope of an order. Only positive numeric values are supported.
     *
     * @return self
     */
    public function setPackageReferenceId($package_reference_id)
    {
        $this->container['package_reference_id'] = $package_reference_id;

        return $this;
    }
    /**
     * Gets carrier_code
     *
     * @return string
     */
    public function getCarrierCode()
    {
        return $this->container['carrier_code'];
    }

    /**
     * Sets carrier_code
     *
     * @param string $carrier_code Identifies the carrier that will deliver the package. This field is required for all marketplaces, see [reference](https://developer-docs.amazon.com/sp-api/changelog/carriercode-value-required-in-shipment-confirmations-for-br-mx-ca-sg-au-in-jp-marketplaces).
     *
     * @return self
     */
    public function setCarrierCode($carrier_code)
    {
        $this->container['carrier_code'] = $carrier_code;

        return $this;
    }
    /**
     * Gets carrier_name
     *
     * @return string|null
     */
    public function getCarrierName()
    {
        return $this->container['carrier_name'];
    }

    /**
     * Sets carrier_name
     *
     * @param string|null $carrier_name Carrier Name that will deliver the package. Required when carrierCode is \"Others\"
     *
     * @return self
     */
    public function setCarrierName($carrier_name)
    {
        $this->container['carrier_name'] = $carrier_name;

        return $this;
    }
    /**
     * Gets shipping_method
     *
     * @return string|null
     */
    public function getShippingMethod()
    {
        return $this->container['shipping_method'];
    }

    /**
     * Sets shipping_method
     *
     * @param string|null $shipping_method Ship method to be used for shipping the order.
     *
     * @return self
     */
    public function setShippingMethod($shipping_method)
    {
        $this->container['shipping_method'] = $shipping_method;

        return $this;
    }
    /**
     * Gets tracking_number
     *
     * @return string
     */
    public function getTrackingNumber()
    {
        return $this->container['tracking_number'];
    }

    /**
     * Sets tracking_number
     *
     * @param string $tracking_number The tracking number used to obtain tracking and delivery information.
     *
     * @return self
     */
    public function setTrackingNumber($tracking_number)
    {
        $this->container['tracking_number'] = $tracking_number;

        return $this;
    }
    /**
     * Gets ship_date
     *
     * @return string
     */
    public function getShipDate()
    {
        return $this->container['ship_date'];
    }

    /**
     * Sets ship_date
     *
     * @param string $ship_date The shipping date for the package. Must be in ISO-8601 date/time format.
     *
     * @return self
     */
    public function setShipDate($ship_date)
    {
        $this->container['ship_date'] = $ship_date;

        return $this;
    }
    /**
     * Gets ship_from_supply_source_id
     *
     * @return string|null
     */
    public function getShipFromSupplySourceId()
    {
        return $this->container['ship_from_supply_source_id'];
    }

    /**
     * Sets ship_from_supply_source_id
     *
     * @param string|null $ship_from_supply_source_id The unique identifier of the supply source.
     *
     * @return self
     */
    public function setShipFromSupplySourceId($ship_from_supply_source_id)
    {
        $this->container['ship_from_supply_source_id'] = $ship_from_supply_source_id;

        return $this;
    }
    /**
     * Gets order_items
     *
     * @return \SellingPartnerApi\Model\OrdersV0\ConfirmShipmentOrderItem[]
     */
    public function getOrderItems()
    {
        return $this->container['order_items'];
    }

    /**
     * Sets order_items
     *
     * @param \SellingPartnerApi\Model\OrdersV0\ConfirmShipmentOrderItem[] $order_items A list of order items.
     *
     * @return self
     */
    public function setOrderItems($order_items)
    {
        $this->container['order_items'] = $order_items;

        return $this;
    }
}


