<?php
/**
 * ListOffersRequestFilters
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Replenishment
 *
 * The Selling Partner API for Replenishment (Replenishment API) provides programmatic access to replenishment program metrics and offers. These programs provide recurring delivery (automatic or manual) of any replenishable item at a frequency chosen by the customer.
 *
 * The version of the OpenAPI document: 2022-11-07
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\ReplenishmentV20221107;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;

/**
 * ListOffersRequestFilters Class Doc Comment
 *
 * @category Class
 * @description Use these parameters to filter results. Any result must match all of the provided parameters. For any parameter that is an array, the result must match at least one element in the provided array.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class ListOffersRequestFilters extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ListOffersRequestFilters';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'marketplace_id' => 'string',
        'skus' => 'string[]',
        'asins' => 'string[]',
        'eligibilities' => '\SellingPartnerApi\Model\ReplenishmentV20221107\EligibilityStatus[]',
        'preferences' => '\SellingPartnerApi\Model\ReplenishmentV20221107\Preference',
        'promotions' => '\SellingPartnerApi\Model\ReplenishmentV20221107\Promotion',
        'program_types' => '\SellingPartnerApi\Model\ReplenishmentV20221107\ProgramType[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'marketplace_id' => null,
        'skus' => null,
        'asins' => null,
        'eligibilities' => null,
        'preferences' => null,
        'promotions' => null,
        'program_types' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'marketplace_id' => 'marketplaceId',
        'skus' => 'skus',
        'asins' => 'asins',
        'eligibilities' => 'eligibilities',
        'preferences' => 'preferences',
        'promotions' => 'promotions',
        'program_types' => 'programTypes'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'marketplace_id' => 'setMarketplaceId',
        'skus' => 'setSkus',
        'asins' => 'setAsins',
        'eligibilities' => 'setEligibilities',
        'preferences' => 'setPreferences',
        'promotions' => 'setPromotions',
        'program_types' => 'setProgramTypes'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'marketplace_id' => 'getMarketplaceId',
        'skus' => 'getSkus',
        'asins' => 'getAsins',
        'eligibilities' => 'getEligibilities',
        'preferences' => 'getPreferences',
        'promotions' => 'getPromotions',
        'program_types' => 'getProgramTypes'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['marketplace_id'] = $data['marketplace_id'] ?? null;
        $this->container['skus'] = $data['skus'] ?? null;
        $this->container['asins'] = $data['asins'] ?? null;
        $this->container['eligibilities'] = $data['eligibilities'] ?? null;
        $this->container['preferences'] = $data['preferences'] ?? null;
        $this->container['promotions'] = $data['promotions'] ?? null;
        $this->container['program_types'] = $data['program_types'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        if ($this->container['marketplace_id'] === null) {
            $invalidProperties[] = "'marketplace_id' can't be null";
        }
        if (!is_null($this->container['skus']) && (count($this->container['skus']) > 20)) {
            $invalidProperties[] = "invalid value for 'skus', number of items must be less than or equal to 20.";
        }

        if (!is_null($this->container['skus']) && (count($this->container['skus']) < 1)) {
            $invalidProperties[] = "invalid value for 'skus', number of items must be greater than or equal to 1.";
        }

        if (!is_null($this->container['asins']) && (count($this->container['asins']) > 20)) {
            $invalidProperties[] = "invalid value for 'asins', number of items must be less than or equal to 20.";
        }

        if (!is_null($this->container['asins']) && (count($this->container['asins']) < 1)) {
            $invalidProperties[] = "invalid value for 'asins', number of items must be greater than or equal to 1.";
        }

        if (!is_null($this->container['eligibilities']) && (count($this->container['eligibilities']) < 1)) {
            $invalidProperties[] = "invalid value for 'eligibilities', number of items must be greater than or equal to 1.";
        }

        if ($this->container['program_types'] === null) {
            $invalidProperties[] = "'program_types' can't be null";
        }
        if ((count($this->container['program_types']) < 1)) {
            $invalidProperties[] = "invalid value for 'program_types', number of items must be greater than or equal to 1.";
        }

        return $invalidProperties;
    }


    /**
     * Gets marketplace_id
     *
     * @return string
     */
    public function getMarketplaceId()
    {
        return $this->container['marketplace_id'];
    }

    /**
     * Sets marketplace_id
     *
     * @param string $marketplace_id The marketplace identifier. The supported marketplaces for both sellers and vendors are US, CA, ES, UK, FR, IT, IN, DE and JP. The supported marketplaces for vendors only are BR, AU, MX, AE and NL. Refer to [Marketplace IDs](https://developer-docs.amazon.com/sp-api/docs/marketplace-ids) to find the identifier for the marketplace.
     *
     * @return self
     */
    public function setMarketplaceId($marketplace_id)
    {
        $this->container['marketplace_id'] = $marketplace_id;

        return $this;
    }
    /**
     * Gets skus
     *
     * @return string[]|null
     */
    public function getSkus()
    {
        return $this->container['skus'];
    }

    /**
     * Sets skus
     *
     * @param string[]|null $skus A list of SKUs to filter. This filter is only supported for sellers and not for vendors.
     *
     * @return self
     */
    public function setSkus($skus)
    {

        if (!is_null($skus) && (count($skus) > 20)) {
            throw new \InvalidArgumentException('invalid value for $skus when calling ListOffersRequestFilters., number of items must be less than or equal to 20.');
        }
        if (!is_null($skus) && (count($skus) < 1)) {
            throw new \InvalidArgumentException('invalid length for $skus when calling ListOffersRequestFilters., number of items must be greater than or equal to 1.');
        }
        $this->container['skus'] = $skus;

        return $this;
    }
    /**
     * Gets asins
     *
     * @return string[]|null
     */
    public function getAsins()
    {
        return $this->container['asins'];
    }

    /**
     * Sets asins
     *
     * @param string[]|null $asins A list of Amazon Standard Identification Numbers (ASINs).
     *
     * @return self
     */
    public function setAsins($asins)
    {

        if (!is_null($asins) && (count($asins) > 20)) {
            throw new \InvalidArgumentException('invalid value for $asins when calling ListOffersRequestFilters., number of items must be less than or equal to 20.');
        }
        if (!is_null($asins) && (count($asins) < 1)) {
            throw new \InvalidArgumentException('invalid length for $asins when calling ListOffersRequestFilters., number of items must be greater than or equal to 1.');
        }
        $this->container['asins'] = $asins;

        return $this;
    }
    /**
     * Gets eligibilities
     *
     * @return \SellingPartnerApi\Model\ReplenishmentV20221107\EligibilityStatus[]|null
     */
    public function getEligibilities()
    {
        return $this->container['eligibilities'];
    }

    /**
     * Sets eligibilities
     *
     * @param \SellingPartnerApi\Model\ReplenishmentV20221107\EligibilityStatus[]|null $eligibilities A list of eligibilities associated with an offer.
     *
     * @return self
     */
    public function setEligibilities($eligibilities)
    {


        if (!is_null($eligibilities) && (count($eligibilities) < 1)) {
            throw new \InvalidArgumentException('invalid length for $eligibilities when calling ListOffersRequestFilters., number of items must be greater than or equal to 1.');
        }
        $this->container['eligibilities'] = $eligibilities;

        return $this;
    }
    /**
     * Gets preferences
     *
     * @return \SellingPartnerApi\Model\ReplenishmentV20221107\Preference|null
     */
    public function getPreferences()
    {
        return $this->container['preferences'];
    }

    /**
     * Sets preferences
     *
     * @param \SellingPartnerApi\Model\ReplenishmentV20221107\Preference|null $preferences preferences
     *
     * @return self
     */
    public function setPreferences($preferences)
    {
        $this->container['preferences'] = $preferences;

        return $this;
    }
    /**
     * Gets promotions
     *
     * @return \SellingPartnerApi\Model\ReplenishmentV20221107\Promotion|null
     */
    public function getPromotions()
    {
        return $this->container['promotions'];
    }

    /**
     * Sets promotions
     *
     * @param \SellingPartnerApi\Model\ReplenishmentV20221107\Promotion|null $promotions promotions
     *
     * @return self
     */
    public function setPromotions($promotions)
    {
        $this->container['promotions'] = $promotions;

        return $this;
    }
    /**
     * Gets program_types
     *
     * @return \SellingPartnerApi\Model\ReplenishmentV20221107\ProgramType[]
     */
    public function getProgramTypes()
    {
        return $this->container['program_types'];
    }

    /**
     * Sets program_types
     *
     * @param \SellingPartnerApi\Model\ReplenishmentV20221107\ProgramType[] $program_types A list of replenishment program types.
     *
     * @return self
     */
    public function setProgramTypes($program_types)
    {


        if ((count($program_types) < 1)) {
            throw new \InvalidArgumentException('invalid length for $program_types when calling ListOffersRequestFilters., number of items must be greater than or equal to 1.');
        }
        $this->container['program_types'] = $program_types;

        return $this;
    }
}


