<?php
/**
 * ChargeDetails
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Retail Procurement Payments
 *
 * The Selling Partner API for Retail Procurement Payments provides programmatic access to vendors payments data.
 *
 * The version of the OpenAPI document: v1
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\VendorInvoicesV1;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;

/**
 * ChargeDetails Class Doc Comment
 *
 * @category Class
 * @description Monetary and tax details of the charge.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class ChargeDetails extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ChargeDetails';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'type' => 'string',
        'description' => 'string',
        'charge_amount' => '\SellingPartnerApi\Model\VendorInvoicesV1\Money',
        'tax_details' => '\SellingPartnerApi\Model\VendorInvoicesV1\TaxDetails[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'type' => null,
        'description' => null,
        'charge_amount' => null,
        'tax_details' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'type' => 'type',
        'description' => 'description',
        'charge_amount' => 'chargeAmount',
        'tax_details' => 'taxDetails'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'type' => 'setType',
        'description' => 'setDescription',
        'charge_amount' => 'setChargeAmount',
        'tax_details' => 'setTaxDetails'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'type' => 'getType',
        'description' => 'getDescription',
        'charge_amount' => 'getChargeAmount',
        'tax_details' => 'getTaxDetails'
    ];



    const TYPE_FREIGHT = 'Freight';
    const TYPE_PACKING = 'Packing';
    const TYPE_DUTY = 'Duty';
    const TYPE_SERVICE = 'Service';
    const TYPE_SMALL_ORDER = 'SmallOrder';
    const TYPE_INSURANCE_PLACEMENT_COST = 'InsurancePlacementCost';
    const TYPE_INSURANCE_FEE = 'InsuranceFee';
    const TYPE_SPECIAL_HANDLING_SERVICE = 'SpecialHandlingService';
    const TYPE_COLLECTION_AND_RECYCLING_SERVICE = 'CollectionAndRecyclingService';
    const TYPE_ENVIRONMENTAL_PROTECTION_SERVICE = 'EnvironmentalProtectionService';
    const TYPE_TAX_COLLECTED_AT_SOURCE = 'TaxCollectedAtSource';
    
    

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        $baseVals = [
            self::TYPE_FREIGHT,
            self::TYPE_PACKING,
            self::TYPE_DUTY,
            self::TYPE_SERVICE,
            self::TYPE_SMALL_ORDER,
            self::TYPE_INSURANCE_PLACEMENT_COST,
            self::TYPE_INSURANCE_FEE,
            self::TYPE_SPECIAL_HANDLING_SERVICE,
            self::TYPE_COLLECTION_AND_RECYCLING_SERVICE,
            self::TYPE_ENVIRONMENTAL_PROTECTION_SERVICE,
            self::TYPE_TAX_COLLECTED_AT_SOURCE,
        ];

        // This is necessary because Amazon does not consistently capitalize their
        // enum values, so we do case-insensitive enum value validation in ObjectSerializer
        return array_map(function ($val) { return strtoupper($val); }, $baseVals);
    }
    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['type'] = $data['type'] ?? null;
        $this->container['description'] = $data['description'] ?? null;
        $this->container['charge_amount'] = $data['charge_amount'] ?? null;
        $this->container['tax_details'] = $data['tax_details'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        if ($this->container['type'] === null) {
            $invalidProperties[] = "'type' can't be null";
        }
        $allowedValues = $this->getTypeAllowableValues();
        if (
            !is_null($this->container['type']) &&
            !in_array(strtoupper($this->container['type']), $allowedValues, true)
        ) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'type', must be one of '%s'",
                $this->container['type'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['charge_amount'] === null) {
            $invalidProperties[] = "'charge_amount' can't be null";
        }
        return $invalidProperties;
    }


    /**
     * Gets type
     *
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string $type Type of the charge applied.
     *
     * @return self
     */
    public function setType($type)
    {
        $allowedValues = $this->getTypeAllowableValues();
        if (!in_array(strtoupper($type), $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'type', must be one of '%s'",
                    $type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['type'] = $type;

        return $this;
    }
    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description Description of the charge.
     *
     * @return self
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }
    /**
     * Gets charge_amount
     *
     * @return \SellingPartnerApi\Model\VendorInvoicesV1\Money
     */
    public function getChargeAmount()
    {
        return $this->container['charge_amount'];
    }

    /**
     * Sets charge_amount
     *
     * @param \SellingPartnerApi\Model\VendorInvoicesV1\Money $charge_amount charge_amount
     *
     * @return self
     */
    public function setChargeAmount($charge_amount)
    {
        $this->container['charge_amount'] = $charge_amount;

        return $this;
    }
    /**
     * Gets tax_details
     *
     * @return \SellingPartnerApi\Model\VendorInvoicesV1\TaxDetails[]|null
     */
    public function getTaxDetails()
    {
        return $this->container['tax_details'];
    }

    /**
     * Sets tax_details
     *
     * @param \SellingPartnerApi\Model\VendorInvoicesV1\TaxDetails[]|null $tax_details Tax amount details applied on this charge.
     *
     * @return self
     */
    public function setTaxDetails($tax_details)
    {
        $this->container['tax_details'] = $tax_details;

        return $this;
    }
}


