<?php
/**
 * Diese Klasse wird verwendet um Reports aller Art von Amazon zu verarbeiten
 */
require_once(DIR_FS_INC.'yes_end_auction_add.inc.php');
class Report
{
	var $NextToken;
	var $ReportType;
	var $ReportDate;
	var $import_filename; // fuer sync per Amazonexport Datei
	function getReport($response){
		$getReportListResult = $response->getGetReportListResult();
		if($getReportListResult->isSetHasNext() and $getReportListResult->getHasNext() and $getReportListResult->isSetNextToken()) {
			printf('<p><a href="%s"><code>Next Token</code></a></p>',
				'GetReportListByNextTokenSample.php?NextToken='.urlencode($getReportListResult->getNextToken())
			);
		}
	}

	function setNextToken($NextToken){
		$this->NextToken = $NextToken;
	}
	function getNextToken(){
		return $this->NextToken;
	}

	function getReportType() {
		return $this->ReportType;
	}

	function setReportType($ReportType) {
		$this->ReportType = $ReportType;
	}

	public function getReportDate() {
		return $this->ReportDate;
	}

	public function setReportDate($ReportDate) {
		$this->ReportDate = $ReportDate;
	}

	public function getReportTypeTitle($ReportType) {
		switch($ReportType){
                        case 'GET_FLAT_FILE_OPEN_LISTINGS_DATA':
			case '_GET_FLAT_FILE_OPEN_LISTINGS_DATA_':
				return AMAZON_REPORT_TYPE_GET_FLAT_FILE_OPEN_LISTINGS_DATA;
				break;
			case '_GET_MERCHANT_LISTINGS_DATA_':
			case 'GET_MERCHANT_LISTINGS_DATA':
				return AMAZON_REPORT_TYPE_GET_MERCHANT_LISTINGS_DATA;
				break;
			case '_GET_FLAT_FILE_ORDERS_DATA_':
				return AMAZON_REPORT_TYPE_GET_FLAT_FILE_ORDERS_DATA;
				break;
			case '_GET_ORDERS_DATA_':
				return AMAZON_REPORT_TYPE_GET_ORDERS_DATA;
				break;
			case '_GET_AMAZON_FULFILLED_SHIPMENTS_DATA_':
				return AMAZON_REPORT_TYPE_GET_AMAZON_FULFILLED_SHIPMENTS_DATA;
				break;
		}
		return $ReportType.' (add in amz_Report.php)';
	}

	function get_message_report_string($messageData){
		$results = '';
		$status = sprintf('<font color="#FF0000">%s</font>',$messageData['StatusCode']);
		if(!sizeOf($messageData['Results'])){
			if($messageData['StatusCode'] == 'Complete')
				$status = sprintf('<font color="#00FF00">%s</font>',$messageData['StatusCode']);
		}
		foreach($messageData['Results'] as $result){
			$results .= sprintf('<li><strong>%s (%s):</strong> %s',
				$result['ResultCode'],$result['ResultCode'],$result['ResultDescription']
			);
		}
		return sprintf(
			"<p>DocumentTransactionID: %s<br />StatusCode: %s<br />%s</p>",
				$messageData['DocumentTransactionID'],
				$status,
				$results
		);
	}

	function process_message($msg){
		$PR = $msg->ProcessingReport;
		$results = array();
		$result = $PR->Result;
		foreach($result as $res){
			$results[] = array(
				'ResultCode' =>current($res->ResultCode),
				'ResultMessageCode' =>current($res->ResultMessageCode),
				'ResultDescription' =>current($res->ResultDescription)
			);
		}
		$data = array(
			'MessageID'=>current($msg->MessageID),
			'DocumentTransactionID'=>current($PR->DocumentTransactionID),
			'StatusCode'=>current($PR->StatusCode),
			'Results'=>$results
		);
		return $data;
	}


	function invokeGetReport($content, $selling_partner_id, $from_import_file=false){
		global $basics;
                if($from_import_file){
			$content = file_get_contents( $this->import_filename );
                }
		switch($this->getReportType()){
                        case 'GET_MERCHANT_LISTINGS_DATA':
			case '_GET_MERCHANT_LISTINGS_DATA_':
                                $csv = file_get_contents( $content->getUrl() );
                                if($content->getCompressionAlgorithm() == 'GZIP'){
					$csv = gzdecode($csv);
				}
				$lines = explode("\n",$csv);
				$items = array();
				$pID_qty_array = array();
				foreach($lines as $nr => $line){
					if($nr == 0){
						$keys = explode("\t",$line);
						continue;
					}

					$line = explode("\t",$line);
					if(sizeOf($line)<sizeOf($keys)) continue;

			                if($from_import_file){
						$open_date_parts = explode('/',$line[6]);
						$open_date = substr($open_date_parts[2],0,4).'-'.$open_date_parts[1].'-'.$open_date_parts[0];
						if( strtotime($open_date) < (time() - (60*60*24*7*4*6))) continue;
					}
					$asin = $line[22];
					$sku = $line[3];
					$price = number_format($line[4],2,'.','');
					$pID = yes_get_products_id_from_amazon_sku($sku,$selling_partner_id);
					$price_local = -1;
					$qty_available = -1;
					$price_local_changed_info = false;
					$qty_local_changed_info = false;
					$qty_update_in_progress = false;
					if($pID > 0){
						$amazon_query = xtc_db_query(sprintf(
							"SELECT price,quantity,last_price_feed,last_quantity_feed FROM amazon_products WHERE sku='%s' AND selling_partner_id='%s'",
							$sku,$selling_partner_id
						));
						$amazon_record = xtc_db_fetch_array($amazon_query);
						$qty_update_in_progress_query = xtc_db_query(sprintf(
							"SELECT amazon_feeds_quantity_items_id FROM amazon_feeds_quantity_items WHERE sku='%s' AND processed=0",
							$sku
						));
						if(xtc_db_num_rows($qty_update_in_progress_query)){
							$qty_update_in_progress = true;
						}

						$price_local = number_format($amazon_record['price'],2,'.','');
						$qty_local = $amazon_record['quantity'];

						$d1 = strtotime($amazon_record['last_quantity_feed']);
						$d2 = strtotime($_REQUEST['from']);
						if($qty_local <> $line[5] and $d1 > $d2){
							$qty_local_changed_info = sprintf(
								TEXT_AMAZON_LOCAL_CHANGE_QUANTITY,
								date('d.m.Y H:i:s',strtotime($amazon_record['last_quantity_feed'])),
								$qty_local
							);
						}
						$d1 = strtotime($amazon_record['last_price_feed']);
						$d2 = strtotime($_REQUEST['from']);
						if( ($price_local <> $price) and $d1 > $d2){
							$price_local_changed_info = sprintf(
								TEXT_AMAZON_LOCAL_CHANGE_PRICE,
								date('d.m.Y H:i:s',strtotime($amazon_record['last_price_feed'])),
								$price_local
							);
						}
						if(!in_array($pID,$pID_qty_array)){
							$SQ = new products_quantity($pID);
							$collies = xtc_get_product_collies($pID);
							if(sizeOf($collies)>0){
								$qty_available = xtc_get_product_collie_qty($pID);
							}else{
								$qty_available = $SQ->get_products_total_qty();
							}
							$pID_qty_array[$pID] = $qty_available;
						}else{
							$qty_available = $pID_qty_array[$pID];
						}
					}
					$items[] = array(
						'products_id'=>$pID,
						'name'=>utf8_encode($line[0]),
						'description'=>$line[1],
						'id'=>$line[2],
						'sku'=>$line[3],
						'price'=>$line[4],
						'price_local'=>$price_local,
						'price_local_changed_info'=>$price_local_changed_info,
						'qty'=>$line[5],
						'qty_local'=>$qty_local,
						'qty_local_changed_info'=>$qty_local_changed_info,
						'qty_available'=>$qty_available,
						'open_date'=>$line[6],
						'image_url'=>$line[7],
						'is_marketplace'=>$line[8],
						'type'=>$line[9],
						'z_shop_shipping_fee'=>$line[10],
						'note'=>$line[11],
						'condition'=>$line[12],
						'zshop_category1'=>$line[13],
						'zshop_browse_path'=>$line[14],
						'zshop_store_front_feature'=>$line[15],
						'asin'=>$line[16],
						'asin2'=>$line[17],
						'asin3'=>$line[18],
						'will_ship_international'=>$line[19],
						'expedited_shipping'=>$line[20],
						'zshop_boldface'=>$line[21],
						'product_id'=>$line[22],
						'bid_for_feature_placement'=>$line[23],
						'add_delete'=>$line[24],
						'pending_quantity'=>$line[25],
						'fulfillment_channell'=>$line[26],
						'qty_update_in_progress'=>$qty_update_in_progress
					);
				}
				return $items;
				break;
                                
			case '_GET_FLAT_FILE_OPEN_LISTINGS_DATA_':
                        case 'GET_FLAT_FILE_OPEN_LISTINGS_DATA':
                                $csv = file_get_contents( $content->getUrl() );
				$lines = explode("\n",$csv);
				$items = array();
				$pID_qty_array = array();
                                $pID_v1_array = array();
				foreach($lines as $nr => $line){
					if($nr == 0) continue;
					$line = explode("\t",$line);
					if(sizeOf($line)<4) continue;

					$price = number_format(trim($line[2]),2,'.','');
					$sku = $line[0];
					$qty = (int)trim($line[3]);
					$pID = yes_get_products_id_from_amazon_sku($sku,$selling_partner_id);
					$price_local = -1;
					$qty_available = -1;
					$price_local_changed_info = false;
					$qty_local_changed_info = false;
					$qty_update_in_progress = false;
                                        $price_update_in_progress = false;
                                        
					if($pID > 0){
						$amazon_query = xtc_db_query(sprintf(
							"SELECT price,quantity,last_price_feed,last_quantity_feed FROM amazon_products WHERE sku='%s' AND selling_partner_id='%s'",
							$sku,$selling_partner_id
						));
						$amazon_record = xtc_db_fetch_array($amazon_query);
						$qty_update_in_progress_query = xtc_db_query(sprintf(
							"SELECT amazon_feeds_quantity_items_id FROM amazon_feeds_quantity_items WHERE sku='%s' AND processed=0",
							$sku
						));
						if(xtc_db_num_rows($qty_update_in_progress_query)){
							$qty_update_in_progress = true;
						}else{
                                                    $qty_update_in_progress = \YES4Trade\Model\amazon_feed_collector::sku_exists($sku, 'JSON_LISTINGS_FEED.quantity');
                                                }
                                                
                                                
                                                $amazon_feeds_price_items = \YES4Trade\Model\amazon_feeds_price_items::get_by_sku_and_processed(
                                                        $sku, 0, ['amazon_feeds_price_items_id']
                                                );
                                                if(sizeOf($amazon_feeds_price_items)){
                                                    $price_update_in_progress = true;
						}else{
                                                    $price_update_in_progress = \YES4Trade\Model\amazon_feed_collector::sku_exists($sku, 'JSON_LISTINGS_FEED.price');
                                                }
						$price_local = number_format($amazon_record['price'],2,'.','');

						$qty_local = $amazon_record['quantity'];

						$d1 = strtotime($amazon_record['last_quantity_feed']);
						$d2 = strtotime($_REQUEST['from']);
						if($qty_local <> $qty and $d1 > $d2){
							$qty_local_changed_info = sprintf(
								TEXT_AMAZON_LOCAL_CHANGE_QUANTITY,
								date('d.m.Y H:i:s',strtotime($amazon_record['last_quantity_feed'])),
								$qty_local
							);
						}
						$d1 = strtotime($amazon_record['last_price_feed']);
						$d2 = strtotime($_REQUEST['from']);
						if( ($price_local <> $price) and $d1 > $d2){
							$price_local_changed_info = sprintf(
								TEXT_AMAZON_LOCAL_CHANGE_PRICE,
								date('d.m.Y H:i:s',strtotime($amazon_record['last_price_feed'])),
								$price_local
							);
						}
						if(!in_array($pID,$pID_qty_array)){
							$SQ = new products_quantity($pID);
							$collies = xtc_get_product_collies($pID);
							if(sizeOf($collies)>0){
								$qty_available = xtc_get_product_collie_qty($pID);
							}else{
								$qty_available = $SQ->get_products_total_qty();
							}
							$pID_qty_array[$pID] = $qty_available;
                                                        $v1 = $SQ->get_available1_qty();
                                                        $pID_v1_array[$pID] = $v1;
						}else{
							$qty_available = $pID_qty_array[$pID];
                                                        $v1 =$pID_v1_array[$pID];
						}
					}

					$items[] = array(
						'sku' => $sku,
						'asin' => $line[1],
						'price' => $price,
						'price_local' => $price_local,
						'price_local_changed_info'=>$price_local_changed_info,
						'qty_local'=>$qty_local,
						'qty_local_changed_info'=>$qty_local_changed_info,
						'qty_available'=>$qty_available,
						'qty' => $qty,
                                                'v1' => $v1,
						'products_id'=>$pID,
						'items'=>$products,
						'qty_update_in_progress'=>$qty_update_in_progress,
						'price_update_in_progress'=>$price_update_in_progress
					);
				}
				return $items;
				break;
			case '_GET_FLAT_FILE_ORDERS_DATA_':
				$lines = explode("\n",$content);
				$items = array();
				foreach($lines as $nr => $line){
					$line = explode("\t",$line);
					if($nr == 0){
						$keys = $line;
						continue;
					}
					if(sizeOf($line)<4) continue;

					$sku = $line[7];
					$products_name = utf8_encode($line[8]);
					$quantity_purchased = $line[9];
					$currency = $line[10];
					$price = $line[11];
					$item_tax = $line[12];
					$shipping_price = $line[13];
					$shipping_tax = $line[14];
					$ship_service_level = $line[15];
					$products = array();
					$item_prices = array();
					$item_prices[] = array(
						'type'=>'Principal',
						'amounts'=>array(
							0=>array(
								'amount'=>$price,
								'currency'=>$currency
							)
						)
					);
					$item_prices[] = array(
						'type'=>'Shipping',
						'amounts'=>array(
							0=>array(
								'amount'=>$shipping_price,
								'currency'=>$currency
							)
						)
					);
					$item_prices[] = array(
						'type'=>'Tax',
						'amounts'=>array(
							0=>array(
								'amount'=>$item_tax,
								'currency'=>$currency
							)
						)
					);
					$item_prices[] = array(
						'type'=>'ShippingTax',
						'amounts'=>array(
							0=>array(
								'amount'=>$shipping_tax,
								'currency'=>$currency
							)
						)
					);
					$products[] = array(
						'amazon_order_item_code'=>$line[1],
						'sku'=>$sku,
						'products_id'=>yes_get_products_id_from_amazon_sku($sku,$request->Merchant),
						'name'=>$products_name,
						'quantity_purchased'=>$quantity_purchased,
						'product_tax_code'=>$item_tax,
						'price'=>$item_prices
					);
					foreach($line as $k=>$it){
						$_item[ str_replace('-','_',$keys[$k]) ] = $it;
					}
					$_item['items'] = $products;
					$items[] = $_item;
				}
				return $items;
				break;
			case '_GET_ORDERS_DATA_':
				$xml = simplexml_load_string($content);
				$orders = array();
				$Message = $xml->Message;
				foreach($Message as $msg){
					$nr = $msg->MessageID;
					$order = $msg->OrderReport;
					$FF = $order->FulfillmentData;
					$products = array();
					$items_in_order_processed = 0;
//yes_mail_debug("amz_Report.php:_GET_ORDERS_DATA_\r\n".print_r($order,true));

					/**
					 * Haben alle Artikel des Auftrags eine pID?
					 * Wenn ein Artikel unbekannt ist, wird das Flag auf
					 * false gesetzt und die Rechnung darf nicht importiert
					 * werden
					 */
					$valid_products_ids = true;
					$currency = 'EUR'; // IN DEN ITEMS SPEICHERN WIR DEN ZULETZT VERWENDETEN WERT ALS CURRENCY
					foreach($order->Item as $order_product){
						$item_orders_id = $this->get_orders_id_from_amazon_item(current($order->AmazonOrderID),$order_product->AmazonOrderItemCode);
						if($item_orders_id > 0)
							$items_in_order_processed++;

						$item_prices = array();
						foreach($order_product->ItemPrice->children() as $component){
							$item_amounts = array();
							foreach($component->Amount as $amt){
								$priceAtt = $amt->attributes();
								$item_amounts[] = array(
									'amount'=>''.$amt,
									'currency'=>current($priceAtt['currency'])
								);
							}
							$item_prices[] = array(
								'type'=>current($component->Type),
								'amounts'=>$item_amounts
							);
						}
						$item_fees = array();
						$total_item_fee = 0;
						foreach($order_product->ItemFees->children() as $fee){
							$priceAtt = $fee->Amount->attributes();
							$item_fees[] = array(
								'type'=>current($fee->Type),
								'amount'=>''.$fee->Amount,
								'currency'=>current($priceAtt['currency'])
							);
							$total_item_fee += $fee->Amount;
							$currency = current($priceAtt['currency']);
						}
						$products_id = yes_get_products_id_from_amazon_sku(current($order_product->SKU),$request->Merchant);
						if(defined('MODULE_OTHER_AMAZON_DUMMY_PRODUCTS_ID') and MODULE_OTHER_AMAZON_DUMMY_PRODUCTS_ID > 0){
							$products_id = MODULE_OTHER_AMAZON_DUMMY_PRODUCTS_ID;
						}
						if($products_id < 1)
							$valid_products_ids = false;

						$products[] = array(
							'amazon_order_item_code'=>current($order_product->AmazonOrderItemCode),
							'sku'=>current($order_product->SKU),
							'products_id'=>$products_id,
							'name'=>yes_decode_string(current($order_product->Title)),
							'quantity_purchased'=>current($order_product->Quantity),
							'product_tax_code'=>current($order_product->ProductTaxCode),
							'price'=>$item_prices,
							'fees'=>$item_fees,
							'total_item_fee'=>$total_item_fee,
							'orders_id'=>$item_orders_id
						);
					}
					$orders[] = array(
						'items_in_order_processed'=>$items_in_order_processed,
						'items_in_order'=>sizeOf($order->Item),
						'valid_products_ids'=>$valid_products_ids,
						'order_id' => current($order->AmazonOrderID),
						'session_id'=>current($order->AmazonSessionID),
						'purchase_date'=>current($order->OrderDate),
						'posted_date'=>current($order->OrderPostedDate),
						'buyer_email'=>current($order->BillingData->BuyerEmailAddress),
						'buyer_name'=>$this->prepare_string(current($order->BillingData->BuyerName)),
						'buyer_phone_number'=>current($order->BillingData->BuyerPhoneNumber),
						'bill_name'=>$this->prepare_string(current($order->BillingData->Address->Name)),
						'bill_address_1'=>$this->prepare_string(current($order->BillingData->Address->AddressFieldOne)),
						'bill_address_2'=>$this->prepare_string(current($order->BillingData->Address->AddressFieldTwo)),
						'bill_address_3'=>$this->prepare_string(current($order->BillingData->Address->AddressFieldThree)),
						'bill_city'=>$this->prepare_string(current($order->BillingData->Address->City)),
						'bill_state'=>$this->prepare_string(current($order->BillingData->Address->StateOrRegion)),
						'bill_postal_code'=>current($order->BillingData->Address->PostalCode),
						'bill_country_code'=>current($order->BillingData->Address->CountryCode),
						'bill_phone_number'=>current($order->BillingData->Address->PhoneNumber),
						'shipping_method'=>current($FF->FulfillmentMethod),
						'shipping_service_level'=>current($FF->FulfillmentServiceLevel),
						'recipient_name'=>$this->prepare_string(current($FF->Address->Name)),
						'ship_address_1'=>$this->_get_address_field(current($FF->Address->AddressFieldOne)),
						'ship_address_2'=>$this->_get_address_field(current($FF->Address->AddressFieldTwo)),
						'ship_address_3'=>$this->_get_address_field(current($FF->Address->AddressFieldThree)),
						'ship_city'=>$this->prepare_string(current($FF->Address->City)),
						'ship_state'=>$this->prepare_string(current($FF->Address->StateOrRegion)),
						'ship_postal_code'=>current($FF->Address->PostalCode),
						'ship_country_code'=>current($FF->Address->CountryCode),
						'ship_phone_number'=>current($FF->Address->PhoneNumber),
						'items'=>$products,
						'currency'=>$currency,
						'merchant_id'=>$request->Merchant,
					    'IsPrime'=>(isset($order->IsPrime) and $order->IsPrime == 'true') ? true : false
					);
				}
				return $orders;
				break;
			case 'FeedSummaryReport':
				$xml = simplexml_load_string($content);
				if(!is_array($xml->Message) or !sizeOf($xml->Message)){
					$this->process_message($xml->Message);
				}
				foreach($xml->Message as $msg){
					$msg_data = $this->process_message($msg);
					echo $this->get_message_report_string($msg_data);
				}
				break;
			case 'AMAZON_REPORT_TYPE_GET_AMAZON_FULFILLED_SHIPMENTS_DATA':
			case '_GET_FLAT_FILE_PAYMENT_SETTLEMENT_DATA_':
			case '_GET_V2_SETTLEMENT_REPORT_DATA_FLAT_FILE_':
				$lines = explode("\n",$content);
				$data = array();
				foreach($lines as $kl=>$line){
					if($kl == 0){
						$col_heads = explode("\t",$line);
					}else{
						$parts = explode("\t",$line);
						$_tmp = array();
						foreach($parts as $pk=>$part){
							$_tmp[ $col_heads[$pk] ] = $part;
						}
						$data[] = $_tmp;
					}
				}
				return $data;
				break;
			case '_GET_FLAT_FILE_PAYMENT_SETTLEMENT_DATA_':
			    $orders = array();
			    $lines = explode("\n",$content);
			    $lk = array(); // line keys
			    foreach($lines as $kl=>$line){
				if($kl == 0){
				    // KEYS: Amazon Order ID	merchant-order-id	shipment-id	shipment-item-id	amazon-order-item-id	merchant-order-item-id	purchase-date	payments-date	shipment-date	reporting-date	buyer-email	buyer-name	buyer-phone-number	sku	product-name	quantity-shipped	currency	item-price	item-tax	shipping-price	shipping-tax	gift-wrap-price	gift-wrap-tax	ship-service-level	recipient-name	ship-address-1	ship-address-2	ship-address-3	ship-city	ship-state	ship-postal-code	ship-country	ship-phone-number	bill-address-1	bill-address-2	bill-address-3	bill-city	bill-state	bill-postal-code	bill-country	item-promotion-discount	ship-promotion-discount	carrier	tracking-number	estimated-arrival-date	fulfillment-center-id	fulfillment-channel	sales-channel
				    foreach(explode("\t",$line) as $ck=>$cv){
					$lk[ $cv ] = $ck;
				    }
				    continue;
				}
				/*
				 * DEBUG - ICH WILL DIE $line EINTRAEGE MIT DEM
				 * JEWEILIGEM KEY ANSPRECHEN
				 */
				die($line[ $lk['shipment-date'] ]);
				
				$orders[] = array(
					'items_in_order_processed'=>$items_in_order_processed,
					'items_in_order'=>sizeOf($order->Item),
					'valid_products_ids'=>$valid_products_ids,
					'order_id' => current($order->AmazonOrderID),
					'session_id'=>current($order->AmazonSessionID),
					'purchase_date'=>current($order->OrderDate),
					'posted_date'=>current($order->OrderPostedDate),
					'buyer_email'=>current($order->BillingData->BuyerEmailAddress),
					'buyer_name'=>$this->prepare_string(current($order->BillingData->BuyerName)),
					'buyer_phone_number'=>current($order->BillingData->BuyerPhoneNumber),
					'bill_name'=>$this->prepare_string(current($order->BillingData->Address->Name)),
					'bill_address_1'=>$this->prepare_string(current($order->BillingData->Address->AddressFieldOne)),
					'bill_address_2'=>$this->prepare_string(current($order->BillingData->Address->AddressFieldTwo)),
					'bill_address_3'=>$this->prepare_string(current($order->BillingData->Address->AddressFieldThree)),
					'bill_city'=>$this->prepare_string(current($order->BillingData->Address->City)),
					'bill_state'=>$this->prepare_string(current($order->BillingData->Address->StateOrRegion)),
					'bill_postal_code'=>current($order->BillingData->Address->PostalCode),
					'bill_country_code'=>current($order->BillingData->Address->CountryCode),
					'bill_phone_number'=>current($order->BillingData->Address->PhoneNumber),
					'shipping_method'=>current($FF->FulfillmentMethod),
					'shipping_service_level'=>current($FF->FulfillmentServiceLevel),
					'recipient_name'=>$this->prepare_string(current($FF->Address->Name)),
					'ship_address_1'=>$this->_get_address_field(current($FF->Address->AddressFieldOne)),
					'ship_address_2'=>$this->_get_address_field(current($FF->Address->AddressFieldTwo)),
					'ship_address_3'=>$this->_get_address_field(current($FF->Address->AddressFieldThree)),
					'ship_city'=>$this->prepare_string(current($FF->Address->City)),
					'ship_state'=>$this->prepare_string(current($FF->Address->StateOrRegion)),
					'ship_postal_code'=>current($FF->Address->PostalCode),
					'ship_country_code'=>current($FF->Address->CountryCode),
					'ship_phone_number'=>current($FF->Address->PhoneNumber),
					'items'=>$products,
					'currency'=>$currency
				);
			    }
			    break;
			case '_GET_AFN_INVENTORY_DATA_':
				$lines = explode("\n",$content);
				$lk = array(); // line keys
				foreach($lines as $kl=>$line){
					if($kl == 0){
						$col_heads = explode("\t",$line);
						foreach($col_heads as $k=>$v){
							$col_heads[$k] = str_replace(array(
								'-',' '
							),'_',strtolower(trim($v)));
						}
					}else{
						$parts = explode("\t",$line);
						$_tmp = array();
						foreach($parts as $pk=>$part){
							$_tmp[ $col_heads[$pk] ] = trim($part);
						}
						$data[] = $_tmp;
					}
				}
				return $data;
				break;
		}
	}

	/**
	 * AMAZON UEBERGIBT MANCHMAL "null" Werte in Adressen.
	 * Diese wandel ich hier in ''
	 *
	 * @param String $address_part
	 * @return String
	 */
	private static function _get_address_field($address_part,$decode = true){
		if(!empty($address_part) and strtolower($address_part) != 'null'){
			if($decode)
				return yes_decode_string($address_part);
			else
				return $address_part;
		}
		return '';
	}
	private function prepare_string($string){
		return yes_decode_string($string);
	}

	/**
	 * Importiert einen Auftrag als YES Bestellung
	 *
	 * @global Class Instance $basics
	 * @param Array $amazon_order
	 * @return boolean
	 */
	function import_order($amazon_order,$import_unknown_products = false){
		global $basics;
		if(!class_exists('product'))
			die("No class 'product' defined.");
		/**
		 * Dieses Array enthaelt am Ende alle Werte die notwendigen Variablen
		 * fuer den Bestellbestaetigung Feed
		 */
		$orders_created = array();
		$query = xtc_db_query(sprintf(
			"SELECT customers_id FROM amazon_orders WHERE buyer_email_address='%s' and customers_id>0",
			$amazon_order['buyer_email']
		));
		// CUSTOMER HAS ALREADY AN AMAZON ORDER
		if(xtc_db_num_rows($query)){
			$record = xtc_db_fetch_array($query);
			$customers_id = $record['customers_id'];
			$query = xtc_db_query(sprintf(
				"SELECT customers_default_address_id FROM customers WHERE customers_id='%s'",
				$customers_id
			));
			$record = xtc_db_fetch_array($query);
			$address_book_id = $record['customers_default_address_id'];
		}else{
			$query = xtc_db_query(sprintf(
				"SELECT customers_default_address_id,customers_id FROM customers WHERE customers_email_address='%s'",
				$amazon_order['buyer_email']
			));
			// CUSTOMER IS REGISTERED IN CUSTOMERS
			if(xtc_db_num_rows($query)){
				$record = xtc_db_fetch_array($query);
				$customers_id = $record['customers_id'];
				$address_book_id = $record['customers_default_address_id'];
			}else{
				$password = $basics->generate_password();
				$name_pairs = $this->get_name_pairs($amazon_order['buyer_name']);
				$insert_sql_array = array(
					'customers_email_address'=>$amazon_order['buyer_email'],
					'customers_status'=>MODULE_OTHER_AMAZON_CUSTOMERS_STATUS_ID,
					'customers_firstname'=>$name_pairs['first_name'],
					'customers_lastname'=>$name_pairs['last_name'],
					'customers_default_address_id'=>'',
					'customers_telephone'=>$amazon_order['buyer_phone_number'],
					'customers_password'=>xtc_encrypt_password($password)
				);
				xtc_db_perform('customers',$insert_sql_array);
				$customers_id = xtc_db_insert_id();

				$name_pairs = $this->get_name_pairs($amazon_order['bill_name']);
				$bill_country_id = yes_get_country_id_from_iso2($amazon_order['bill_country_code']);
				$new = new \YES4Trade\Model\address_book([
                                    'customers_id'=>(int)$customers_id,
                                    'entry_company'=>'',
                                    'entry_firstname'=>$name_pairs['first_name'],
                                    'entry_lastname'=>$name_pairs['last_name'],
                                    'entry_street_address'=>$amazon_order['bill_address_1'],
                                    'entry_suburb'=>$amazon_order['bill_address_2'].(
                                            (!empty($amazon_order['bill_address_3']) ? ' '.$amazon_order['bill_address_3']:'')
                                    ),
                                    'entry_postcode'=>$amazon_order['bill_postal_code'],
                                    'entry_city'=>$amazon_order['bill_city'],
                                    'entry_state'=>$amazon_order['bill_state'],
                                    'entry_country_id'=>(int)$bill_country_id,
                                    'entry_zone_id'=>0,
                                    'address_class'=>'',
                                    'address_date_added'=>date('Y-m-d H:i:s')
				]);
				$address_book_id = $new->create();
				
				$query = xtc_db_query(sprintf(
					"UPDATE customers SET customers_default_address_id='%s' WHERE customers_id='%s'",
					$address_book_id,$customers_id
				));
			}
		}

		$cs_query = yes_db_query(sprintf(
			"SELECT customers_status_name, customers_status_image FROM customers_status WHERE customers_status_id='%s'",
			MODULE_OTHER_AMAZON_CUSTOMERS_STATUS_ID
		),true);
		if($cs_query){
			$cs = current($cs_query);
		}else{
			$cs = array('Unbekannt', '');
		}
		if(!isset($bill_country_id)) // FALLS ADRESSE SCHON BEKANNT
			$bill_country_id = yes_get_country_id_from_iso2($amazon_order['bill_country_code']);
		$ship_country_id = yes_get_country_id_from_iso2($amazon_order['ship_country_code']);
                $shipping_costs = 0;
                $shipping_tax = 0;
                $price_netto = 0;
                $price_brutto = 0;
                $insert_products_sql = [];
                $models = [];
		foreach($amazon_order['items'] as $product){
                    $orders_id = $this->get_orders_id_from_amazon_item($amazon_order['order_id'], $product['amazon_order_item_code']);
                    if($orders_id > 0){
                            continue;
                    }
                    $YESproduct = new product($product['products_id']);
                    
                    $models[ $product['products_id'] ] = $YESproduct->info['products_model'];
                    
                    if(!isset($YESproduct->info['products_id']) and !$import_unknown_products)
                                    continue;

                    unset($orders_id);
                    $products_tax = 0;
                    $additional_costs = 0; // for amazon_features
                    if($product['products_id'] <= 0){
                            $tax_class_id = 1; // idR 19%
                            if(defined('MODULE_OTHER_AMAZON_DUMMY_PRODUCTS_ID') and MODULE_OTHER_AMAZON_DUMMY_PRODUCTS_ID > 0){
                                $tax_class_id = yes_eu_oss_get_products_tax_class_id(MODULE_OTHER_AMAZON_DUMMY_PRODUCTS_ID, $ship_country_id);
                                $product['products_id'] = MODULE_OTHER_AMAZON_DUMMY_PRODUCTS_ID;
                            }
                    }else{
                        // EU OSS
                        $tax_class_id = yes_eu_oss_get_products_tax_class_id($product['products_id'], $ship_country_id);

                        //ALT: $tax_class_id = $YESproduct->info['products_tax_class_id'];
                    }
                    $tax_rate = xtc_get_tax_rate($tax_class_id,$ship_country_id);
                    foreach($product['price'] as $price){
                        $amt = $price['amounts'];
                        switch($price['type']){
                                case 'Principal':
                                    $price_netto += floatval($amt['amount']) / ((100+$tax_rate)/100);
                                    $price_brutto += floatval($amt['amount']);
                                    if(!isset($currency)){
                                        $currency = $amt['currency'];
                                    }
                                    break;
                                case 'Shipping':
                                    $shipping_costs += floatval($amt['amount']);
                                    break;
                                case 'ShippingTax':
                                    /**
                                     *  shippingtax berechnen wir separat - hier nur der
                                     * vollstaendigkeit halber
                                     */
                                    $shipping_tax += floatval($amt['amount']);
                                    break;
                                case 'Tax':
                                    $tax += floatval($amt['amount']);
                                    break;
                                default:
                                    echo '<h4>Achtung: Unbekannte Preiskomponente. Bitte informieren Sie das YES4trade Team</h4><pre>';
                                    print_r($price);
                                    echo '</pre>';
                                    exit;
                                    break;
                        }
                    }
                } // end foreach items
                        
                $shipping_class = 'amazon';
                if(in_array(strtolower($amazon_order['shipping_service_level']),array('nextday','secondday'))){
                    $shipping_class .= '_'.strtolower($amazon_order['shipping_service_level']);
                }
                if($amazon_order['is_business_order'] == 'true'){
                    $customers_street_address = $amazon_order['bill_address_2'].' '.$amazon_order['bill_address_3'];
                    $customers_suburb = '';
                    $delivery_company = $amazon_order['ship_address_1'];
                    $delivery_street_address = $amazon_order['ship_address_2'].' '.$amazon_order['ship_address_3'];
                    $delivery_suburb = '';
                }else{
                    $customers_street_address = $amazon_order['bill_address_1'].' '.$amazon_order['bill_address_2'];
                    $customers_suburb = $amazon_order['bill_address_3'];
                    $delivery_company = '';
                    $delivery_street_address = $amazon_order['ship_address_1'].' '.$amazon_order['ship_address_2'];
                    $delivery_suburb = $amazon_order['ship_address_3'];
                }
                $bill_country = yes_get_country_id_from_iso2($amazon_order['bill_country_code']);
                $ship_country = yes_get_country_id_from_iso2($amazon_order['ship_country_code']);
                $shipping_comments = ($amazon_order['delivery_instructions']) ? $amazon_order['delivery_instructions'] : '';
                $insert_sql_array = array(
                        'customers_id'=>$customers_id,
                        'customers_cid'=>'',
                        'customers_vat_id'=>'',
                        'customers_status'=>MODULE_OTHER_AMAZON_CUSTOMERS_STATUS_ID,
                        'customers_status_name'=>$cs['customers_status_name'],
                        'customers_status_image'=>$cs['customers_status_image'],
                        'customers_status_discount'=>0,
                        'customers_name'=>$amazon_order['buyer_name'],
                        'customers_company'=>$amazon_order['buyer_company_name'],
                        'customers_street_address'=>$customers_street_address,
                        'customers_suburb'=>$customers_suburb,
                        'customers_city'=>$amazon_order['bill_city'],
                        'customers_postcode'=>$amazon_order['bill_postal_code'],
                        'customers_state'=>$amazon_order['bill_state'],
                        'customers_country'=>xtc_get_country_name($bill_country),
                        'customers_telephone'=>$amazon_order['buyer_phone_number'],
                        'customers_mobile'=>'',
                        'customers_email_address'=>$amazon_order['buyer_email'],
                        'customers_address_format_id'=>AMAZON_ADDRESS_FORMAT_ID,
                        'delivery_name'=>$amazon_order['recipient_name'],
                        'delivery_company'=>$delivery_company,
                        'delivery_street_address'=>$delivery_street_address,
                        'delivery_suburb'=>$delivery_suburb,
                        'delivery_city'=>$amazon_order['ship_city'],
                        'delivery_postcode'=>$amazon_order['ship_postal_code'],
                        'delivery_state'=>$amazon_order['ship_state'],
                        'delivery_country'=>xtc_get_country_name($ship_country),
                        'delivery_address_format_id'=>AMAZON_ADDRESS_FORMAT_ID,
                        'billing_name'=>$amazon_order['buyer_name'],
                        'billing_company'=>$amazon_order['buyer_company_name'],
                        'billing_street_address'=>$customers_street_address,
                        'billing_suburb'=>$customers_suburb,
                        'billing_city'=>$amazon_order['bill_city'],
                        'billing_postcode'=>$amazon_order['bill_postal_code'],
                        'billing_state'=>$amazon_order['bill_state'],
                        'billing_country'=>xtc_get_country_name($bill_country),
                        'billing_address_format_id'=>AMAZON_ADDRESS_FORMAT_ID,
                        'payment_method'=>'amazon_payment',
                    // ticket 2508
                        'comments'=>'',/*sprintf(
                                'AMAZON IMPORT %s %s/%s',
                                $amazon_order['order_id'],
                                ($current_item_nr+1),$total_items
                        ),*/
                        'date_purchased'=>$amazon_order['purchase_date'],

                        'orders_status'=>MODULE_OTHER_AMAZON_ORDER_STATUS,
                        'orders_date_finished'=>null,
                        'currency'=>$amazon_order['currency'],
                        'currency_value'=>0.000000,
                        'account_type'=>0,
                        'payment_class'=>'amazon_payment',
                        'shipping_method'=>$amazon_order['shipping_method'].'_'.$amazon_order['shipping_service_level'],
                        'shipping_class'=>$shipping_class,
                        'language'=>'german',
                        'source'=>'amazon',
                        'amazon_prime'=>($amazon_order['is_prime'] == 'true'),
                        'shipping_comments'=>$shipping_comments,
                );
                xtc_db_perform('orders',$insert_sql_array);
                $orders_id = xtc_db_insert_id();
                $insert_sql_array = array(
                        'orders_id'=>$orders_id,
                        'customers_id'=>$customers_id,
                        'orig_amazon_orders_id'=>$amazon_order['order_id'],
                        'date_created'=>$amazon_order['purchase_date'],
                        'buyer_name'=>$amazon_order['buyer_name'],
                        'buyer_email_address'=>$amazon_order['buyer_email'],
                        'buyer_telephone_number'=>$amazon_order['buyer_phone_number'],
                        'shipping_method'=>$amazon_order['shipping_method'],
                        'shipping_method_service_level'=>$amazon_order['shipping_service_level'],
                        'selling_partner_id'=>$amazon_order['selling_partner_id'],
                );
                xtc_db_perform('amazon_orders',$insert_sql_array);
                $amazon_orders_id = xtc_db_insert_id();
		foreach($amazon_order['items'] as $product){
                    foreach($product['price'] as $pp){
                        switch($pp['type']){
                            case 'Principal':
                                $single_price = floatval($pp['amounts']['amount']) / intval($product['quantity_purchased']);
                                $total_price = floatval($pp['amounts']['amount']);
                                break;
                            case 'Shipping':
                                $shipping_price = floatval($pp['amounts']['amount']);
                                break;
                            case 'Shipping':
                                $price_shipping = floatval($pp['amounts']['amount']);
                                break;
                            case 'ShippingTax':
                                $price_shipping_tax = floatval($pp['amounts']['amount']);
                                break;
                            case 'Tax':
                                $price_tax = floatval($pp['amounts']['amount']);
                                break;
                            
                        }
                    }
                    $products_tax = 0;
                    $additional_costs = 0; // for amazon_features
                    if($product['products_id'] <= 0){
                            $tax_class_id = 1; // idR 19%
                            if(defined('MODULE_OTHER_AMAZON_DUMMY_PRODUCTS_ID') and MODULE_OTHER_AMAZON_DUMMY_PRODUCTS_ID > 0){
                                $tax_class_id = yes_eu_oss_get_products_tax_class_id(MODULE_OTHER_AMAZON_DUMMY_PRODUCTS_ID, $ship_country_id);
                                $product['products_id'] = MODULE_OTHER_AMAZON_DUMMY_PRODUCTS_ID;
                            }
                    }else{
                        // EU OSS
                        $tax_class_id = yes_eu_oss_get_products_tax_class_id($product['products_id'], $ship_country_id);
                    }
                    $tax_rate = xtc_get_tax_rate($tax_class_id,$ship_country_id);
                    $insert_sql_array = array(
                        'amazon_orders_id'=>$amazon_orders_id,
                        'amazon_order_item_code'=>$product['amazon_order_item_code'],
                        'sku'=>$product['sku'],
                        'title'=>$product['name'],
                        'quantity'=>intval($product['quantity_purchased']),
                        'product_tax_code'=>$product['product_tax_code'],
                        'promotion_claim_code'=>$product['promotion_claim_code'],
                        'merchant_promotion_id'=>$product['merchant_promotion_id'],
                        'item_fees'=>floatval($product['total_item_fee']),
                        'price_principal'=>$total_price,
                        'price_shipping'=>$price_shipping,
                        'price_tax'=>$price_tax,
                        'price_shipping_tax'=>$price_shipping_tax
                    );
                    xtc_db_perform('amazon_orders_products',$insert_sql_array);
                    $pname = $product['name'];
                    if($product['products_id'] > 0 and defined('MODULE_OTHER_AMAZON_PRODUCTS_NAME_FROM_AMAZON') and MODULE_OTHER_AMAZON_PRODUCTS_NAME_FROM_AMAZON == 'True'){
                            if($product['products_id'] != MODULE_OTHER_AMAZON_DUMMY_PRODUCTS_ID){
                                    $pname = xtc_get_products_name($product['products_id']);
                            }
                    }
                    $insert_sql_array = array(
                        'orders_id'=>$orders_id,
                        'products_id'=>$product['products_id'],
                        'products_model'=>$models[ $product['products_id'] ],
                        'products_name'=>$pname,
                        'products_price'=>$single_price,
                        'products_discount_made'=>0,
                        'final_price'=>$total_price,
                        'products_tax'=>$tax_rate,
                        'products_quantity'=>$product['quantity_purchased'],
                        'allow_tax'=>1,
                        'date_added'=>'now()',
                        'amazon_order_item_code'=>$product['amazon_order_item_code'],
                        'amazon_sku'=>$product['sku']
                    );
                    xtc_db_perform('orders_products',$insert_sql_array);
                    $opID = xtc_db_insert_id();
                    $insert_sql_array = array(
                        'products_id'=>$product['products_id'],
                        'editor_id'=>0,
                        'date_saved'=>'now()',
                        'comments'=>sprintf('[Amazon Import] Amazon Order %s / YES Auftrag %d: %d Stk',
                                $amazon_order['order_id'],
                                $orders_id,
                                $product['quantity_purchased']
                        )
                    );
                    xtc_db_perform('products_history',$insert_sql_array);

                    // AUS AMAZON_PRODUCTS SUBTRAHIEREN
                    $query = yes_db_query(sprintf(
                            "SELECT quantity FROM amazon_products WHERE products_id='%s' AND selling_partner_id='%s'",
                            $product['products_id'],
                            $amazon_order['selling_partner_id']
                    ));
                    // NUR WENN KEINE ZUWEISUNG UND DIESE PID NICHT DER
                    // MODULE_OTHER_AMAZON_DUMMY_PRODUCTS_ID ENTSPRICHT
                    if(xtc_db_num_rows($query) && (!defined('MODULE_OTHER_AMAZON_DUMMY_PRODUCTS_ID') or MODULE_OTHER_AMAZON_DUMMY_PRODUCTS_ID != $product['products_id'])){
                        $record = current($query);
                        if($record['quantity'] > 0 and $product['products_id'] >= 0){
                                xtc_db_query(sprintf(
                                        "UPDATE amazon_products SET quantity=quantity-%s WHERE products_id='%s' AND selling_partner_id='%s'",
                                        $product['quantity_purchased'],
                                        $product['products_id'],
                                        $amazon_order['selling_partner_id']
                                ));
                        }
                    }

                    // -------------------------------------------
                    // VERKAUFTE-PRODUKTE-COUNTER IN products HOCHSETZEN
                    // ** ABER NUR WENN DIE PID NICHT DER
                    // ** MODULE_OTHER_AMAZON_DUMMY_PRODUCTS_ID ENTSPRICHT
                    // -------------------------------------------
                    if($product['products_id'] >= 0 && (!defined('MODULE_OTHER_AMAZON_DUMMY_PRODUCTS_ID') or MODULE_OTHER_AMAZON_DUMMY_PRODUCTS_ID != $product['products_id'])){
                            xtc_db_query("update " . TABLE_PRODUCTS . " set products_ordered = products_ordered + " . sprintf('%d', $product['quantity_purchased'] ). " where products_id = '" . $product['products_id'] . "'");
                            if( sizeOf($YESproduct->collies)>0 and STOCK_ALLOW_CHECKOUT != 'true' ){
                                    foreach($YESproduct->collies as $k=>$collie){
                                            xtc_db_query("update " . TABLE_PRODUCTS . " set products_ordered = products_ordered + " . sprintf('%d', $product['quantity_purchased'] * $collie['quantity'] ). " where products_id = '" . $product['collie_products_id'] . "'");
                                    }
                            }
                    }

                    if($product['products_id'] > 0 and defined('EBAY_END_AUCTION_AT_SHOPORDER') and EBAY_END_AUCTION_AT_SHOPORDER == 'True'){
                            yes_end_auction_add($product['products_id'],$product['quantity_purchased']);
                    }
                } // end foreach items
                // -------------------------------------------
                // SUBTOTAL
                // -------------------------------------------
                $orders_total_subtotal_array = array(
                        'orders_id'=>$orders_id,
                        'title'=>MODULE_ORDER_TOTAL_SUBTOTAL_TITLE.':',
                        'text'=>number_format($price_brutto,2,',','.').' '.$currency,
                        'value'=>$price_brutto,
                        'class'=>'ot_subtotal',
                        'sort_order'=>MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER
                );
                xtc_db_perform(TABLE_ORDERS_TOTAL, $orders_total_subtotal_array);

                // -------------------------------------------
                // SHIPPINGTOTAL
                // -------------------------------------------
                $orders_total_shipping_array = array(
                        'orders_id'=>$orders_id,
                        'title'=>sprintf(TEXT_AMAZON_SHIPPING_TITLE,
                                $amazon_order['shipping_method'],
                                $amazon_order['shipping_service_level']
                        ),
                        'text'=>number_format($shipping_costs,2,',','.').' '.$currency,
                        'value'=>$shipping_costs,
                        'class'=>'ot_shipping',
                        'sort_order'=>MODULE_ORDER_TOTAL_SHIPPING_SORT_ORDER
                );
                xtc_db_perform(TABLE_ORDERS_TOTAL, $orders_total_shipping_array);

                // -------------------------------------------
                // VATTOTAL
                // -------------------------------------------
                // WIR BERECHNEN UNSERE EIGENE SHIPPINGCOSTS-MWST
                if($shipping_costs > 0){
                    $shipping_costs_netto = $shipping_costs / ((100+$tax_rate)/100);
                }else{
                    $shipping_costs_netto = 0; // nicht durch null teilen, darum so
                }
                $shipping_tax = $shipping_costs - $shipping_costs_netto;
                $products_price_tax = ($price_brutto - $price_netto);
                /**
                 * Versand Steuerklasse gleich Produkt Steuerklasse
                 * Wir addieren beide und haben die gesamte Steuer
                 */
                $ot_tax_value = $shipping_tax + $products_price_tax;
                $orders_total_tax_array = array(
                        'orders_id'=>$orders_id,
                        'title'=>sprintf(AMAZON_TOTAL_TAX_TITLE,
                                number_format($tax_rate,0,',','.')),
                        'text'=> number_format($ot_tax_value,2,',','.' ).' '.$currency,
                        'value'=>$ot_tax_value,
                        'class'=>'ot_tax',
                        'sort_order'=>MODULE_ORDER_TOTAL_TAX_SORT_ORDER,
                    'tax_rate_percent'=>$tax_rate
                );
                xtc_db_perform(TABLE_ORDERS_TOTAL, $orders_total_tax_array);

                // -------------------------------------------
                // TOTAL
                // -------------------------------------------
                $orders_total_total_array = array(
                        'orders_id'=>$orders_id,
                        'title'=>MODULE_ORDER_TOTAL_TOTAL_TITLE,
                        'text'=>number_format($price_brutto+$shipping_costs+$additional_costs,2,',','.').' '.$currency,
                        'value'=>$price_brutto+$shipping_costs+$additional_costs,
                        'class'=>'ot_total',
                        'sort_order'=>MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER
                );
                xtc_db_perform(TABLE_ORDERS_TOTAL, $orders_total_total_array);

                // ----------------------------------------------------
                // IN BESTELLHISTORIE HINZUFUEGEN orders_status_history
                // ----------------------------------------------------
                $customer_notification = (SEND_EMAILS == 'true') ? '1' : '0';
                $order_history_sql_array = array(
                        'orders_id' => $orders_id,
                        'orders_status_id' => MODULE_OTHER_AMAZON_ORDER_STATUS,
                        'date_added' => 'now()',
                        'customer_notified' => $customer_notification,
                        'comments' => sprintf(TEXT_AMAZON_ORDER_IMPORTED,
                                $amazon_order['order_id']
                        )
                );
                xtc_db_perform(TABLE_ORDERS_STATUS_HISTORY, $order_history_sql_array);
                $orders_created[] = array(
                        'merchant_orders_id'=>$orders_id,
                        'amazon_orders_id'=>$amazon_order['order_id'],
                        'items'=>array(0=>array(
                                'amazon_order_item_code'=>$product['amazon_order_item_code'],
                                'merchant_order_item_id'=>$opID
                        ))
                );
		if(sizeOf($orders_created))
			return $orders_created;
		else
			return array();
	}

	/**
	 * In den Adressdatensaetzen von Amazon kriegen wir nur den zusammengesetzten
	 * Namen des Kunden wieder. Da dieser "Hans Schulz", aber auch genausogut
	 * "Dr. H. Martin von Gutzenhausen" sein kann, brauchen wir eine Routine
	 * um Vorname und Nachname getrennt zu erhalten.
	 *
	 * Wir machen es uns einfach und nehmen das letzte Wort als Nachname. Also
	 * zb Nachname: Gutzenhausen; Vorname: "Dr. H. Martin von"
	 *
	 * @param String $fullname
	 * @return Array
	 */
	private static function get_name_pairs($fullname){
		$parts = explode(' ',$fullname);
		$parts = array_reverse($parts);
		$last_name = array_shift($parts);
		$parts = array_reverse($parts);
		return array('last_name'=>$last_name,'first_name'=>implode(' ',$parts));
	}

	/**
	 * Da wir die einzelnen Artikel einer Amazonbestellung als separate Auftraege
	 * speichern, kann hiermit anhand der amazon-order-id und des order-item-code
	 * die Rechnungsnummer ermittelt werden.
	 *
	 * Die Funktion gibt -1 zurueck wenn noch kein YES Auftrag zum Artikel der
	 * Amazonbestellung existiert
	 *
	 * @param String $amazon_order_id
	 * @param String $amazon_order_item_code
	 * @return int
	 */
	public static function get_orders_id_from_amazon_item($amazon_order_id,$amazon_order_item_code){
		$query = yes_db_query(sprintf(
			"SELECT ao.orders_id FROM amazon_orders ao LEFT JOIN amazon_orders_products aop USING(amazon_orders_id) WHERE ao.orig_amazon_orders_id='%s' and aop.amazon_order_item_code='%s'",
			$amazon_order_id,$amazon_order_item_code
		));
		if(yes_db_num_rows($query)){
			$res = current($query);
			return $res['orders_id'];
		}
		return -1;
	}

	/**
	 * Prueft ob eine Amazonbestellung bereits vollstaendig importiert wurde.
	 * Da eine Amazonbestellung mehrere Artikel beinhalten kann und YES jeden
	 * Artikel als separaten Auftrag anlegt, wird geprueft ob die Anzahl ueber-
	 * einstimmt
         * 
         * 
	 *
	 * @param Array $amazon_order
	 * @return Boolean
	 */
	public static function is_order_processed($amazon_order){
		$query = xtc_db_query(sprintf(
			"SELECT count(orders_id) as anz FROM amazon_orders WHERE orig_amazon_orders_id='%s'",
			xtc_db_input($amazon_order['order_id'])
		));
		// WENN MIND. EIN EINTRAG VORHANDEN - WEITER PRUEFEN OB ALLE ARTIKEL
		// IMPORTIERT SIND
		$record = xtc_db_fetch_array($query);
		if($record['anz'] > 0){
			// ANZAHL DER AUFTRAEGE GLEICH ANZAHL ARTIKEL?
                        // **
                        // NEU GELOEST (11/2023)
                        // **
			//if($record['anz'] == sizeOf($amazon_order['items'])){
				return true;
			//}
		}
		return false;
	}
        
        /**
         * Solange wir fuer die SP Api keine Adressdaten kriegen, bietet sich
         * die Moeglichkeit den Order Report Manuell hochzuladen
         * Die CSV Daten werden hier aufbereitet.
         * 
         * @param string $ReportType
         * @param array $csv
         * @param string $selling_partner_id
         * @return array
         */
        public static function prepareCSVData( string $ReportType, array $csv, string $selling_partner_id ){
            $amazon_values = [];
            switch($ReportType){
                case 'ORDERREPORT_CSV':
                    $keys = [];
                    $keynr = 0;
                    foreach($csv[0] as $colname){
                        $keys[ str_replace('-','_',$colname) ] = $keynr;
                        $keynr++;
                    }
                    foreach($csv as $row=>$cols){
                        if($row < 1){
                            continue;
                        }
                        $exists = false;
                        foreach($amazon_values as $nr => $av){
                            if($av[ 'order_id' ] == $cols[ $keys['order_id'] ]){
                                // entry exists - also bestellung mit mehreren artikeln
                                $exists = true;
                                $exist_nr = $nr;
                                break;
                            }
                        }
                        // TICKET 3452
                        if($cols[ $keys['is_buyer_requested_cancellation'] ] == 'true'){
                            continue;
                        }
                        if($exists){
                            // items erweitern
                            $item = [
                                    'amazon_order_item_code'=>$cols[ $keys['order_item_id'] ],
                                    'products_id'=> yes_get_products_id_from_amazon_sku($cols[ $keys['sku'] ], $selling_partner_id),
                                    'price'=>[
                                        [
                                            'type'=>'Principal',
                                            'amounts'=>[
                                                'amount'=>$cols[ $keys['item_price'] ], 
                                                'currency'=>$cols[ $keys['currency'] ]
                                            ]
                                        ],[
                                            'type'=>'Shipping',
                                            'amounts'=>[
                                                'amount'=>$cols[ $keys['shipping_price'] ], 
                                            ]
                                        ],[
                                            'type'=>'ShippingTax',
                                            'amounts'=>[
                                                'amount'=>$cols[ $keys['shipping_tax'] ], 
                                            ]
                                        ],[
                                            'type'=>'Tax',
                                            'amounts'=>[
                                                'amount'=>$cols[ $keys['item_tax'] ], 
                                            ]
                                        ],
                                    ],
                                    'sku'=>$cols[ $keys['sku'] ],
                                    'name'=>$cols[ $keys['product_name'] ],
                                    'quantity_purchased'=>$cols[ $keys['quantity_purchased'] ],
                                    'product_tax_code'=>'',
                                    'promotion_claim_code'=>'',
                                    'merchant_promotion_id'=>$cols[ $keys['item_promotion_id'] ],
                                    'total_item_fee'=>''
                            ];
                            $amazon_values[ $exist_nr ]['items'][] = $item;
                            continue;
                        }else{
                            $items = [[
                                    'amazon_order_item_code'=>$cols[ $keys['order_item_id'] ],
                                    'products_id'=> yes_get_products_id_from_amazon_sku($cols[ $keys['sku'] ], $selling_partner_id),
                                    'price'=>[
                                        [
                                            'type'=>'Principal',
                                            'amounts'=>[
                                                'amount'=>$cols[ $keys['item_price'] ], 
                                                'currency'=>$cols[ $keys['currency'] ]
                                            ]
                                        ],[
                                            'type'=>'Shipping',
                                            'amounts'=>[
                                                'amount'=>$cols[ $keys['shipping_price'] ], 
                                            ]
                                        ],[
                                            'type'=>'ShippingTax',
                                            'amounts'=>[
                                                'amount'=>$cols[ $keys['shipping_tax'] ], 
                                            ]
                                        ],[
                                            'type'=>'Tax',
                                            'amounts'=>[
                                                'amount'=>$cols[ $keys['item_tax'] ], 
                                            ]
                                        ],
                                    ],
                                    'sku'=>$cols[ $keys['sku'] ],
                                    'name'=>$cols[ $keys['product_name'] ],
                                    'quantity_purchased'=>$cols[ $keys['quantity_purchased'] ],
                                    'product_tax_code'=>'',
                                    'promotion_claim_code'=>'',
                                    'merchant_promotion_id'=>$cols[ $keys['item_promotion_id'] ],
                                    'total_item_fee'=>''
                            ]];
                        }
                        $amazon_values[] = [
                            'buyer_email'=>$cols[ $keys['buyer_email'] ],
                            'buyer_name'=>$cols[ $keys['buyer_name'] ],
                            'buyer_company_name'=>$cols[ $keys['buyer_company_name']],
                            'buyer_phone_number'=>$cols[ $keys['buyer_phone_number'] ],
                            'bill_name'=>$cols[ $keys['bill_name'] ],
/* - */                     'bill_country_code'=>$cols[ $keys['bill_country'] ],
                            'bill_address_1'=>$cols[ $keys['bill_address_1'] ],
                            'bill_address_2'=>$cols[ $keys['bill_address_2'] ],
                            'bill_address_3'=>$cols[ $keys['bill_address_3'] ],
                            'bill_postal_code'=>$cols[ $keys['bill_postal_code'] ],
                            'bill_city'=>$cols[ $keys['bill_city'] ],
                            'bill_state'=>$cols[ $keys['bill_state'] ],
/* - */                     'ship_country_code'=>$cols[ $keys['ship_country'] ],
                            'items'=>$items,
                            'IsPrime'=>$cols[ $keys['is_prime'] ],
                            'order_id'=>$cols[ $keys['order_id'] ],
                            'delivery_instructions'=>$cols[ $keys['delivery_instructions'] ],

                            'ship_address_1'=>$cols[ $keys['ship_address_1'] ],
                            'ship_address_2'=>$cols[ $keys['ship_address_2'] ],
                            'ship_address_3'=>$cols[ $keys['ship_address_3'] ],
                            'shipping_service_level'=>$cols[ $keys['ship_service_level'] ],
                            'shipping_method'=>$cols[ $keys['ship_service_name'] ],

                            'recipient_name'=>$cols[ $keys['recipient_name'] ],
                            'ship_city'=>$cols[ $keys['ship_city'] ],
                            'ship_postal_code'=>$cols[ $keys['ship_postal_code'] ],
                            'ship_state'=>$cols[ $keys['ship_state'] ],
                            'purchase_date'=>$cols[ $keys['purchase_date'] ],
                            'currency'=>$cols[ $keys['currency'] ],
                            'selling_partner_id'=>$selling_partner_id,
                            'is_business_order'=>$cols[ $keys['is_business_order'] ],
                        ];
                    }
                    break;
            }
            return $amazon_values;
        }
}
