<?php


// I N A K T I V
throw new Exception('Disabled Script');


/**
 * EINE ebay_order BEINHALTET MEHRERE TRANSAKTIONEN EINES buyers
 *
 * @author mario aspeleiter <dazze@gmx.de>
 */
if(!class_exists('ebay_transaction'))
    die('Missing class ebay_transaction');
if(!class_exists('ebayAPI'))
    die('Missing class ebayAPI');
class ebay_order {
    var $seller;
    var $buyer;
    var $transactions = array();
    var $order_status;
    var $order_id;
    var $created_time;
    var $paymentmethod;
    var $shipping_address = array();
    var $shipping_service;
    var $totals = array();
    var $billing_address = array();
    var $customers_id;
    var $customers_email_address;
    var $ExternalTransaction = array();
    var $has_ebay_plus = false;
    

    //$this->setSeller($OrderType->getUserID()->value);
    public function get_customers_email_address() {
	return $this->customers_email_address;
    }

    public function set_customers_email_address($customers_email_address) {
	$this->customers_email_address = $customers_email_address;
    }

    public function get_seller() {
        return $this->seller;
    }

    public function set_seller($seller) {
        $this->seller = $seller;
    }

    public function get_buyer() {
        return $this->buyer;
    }

    public function set_buyer($buyer) {
        $this->buyer = $buyer;
    }

    public function get_order_status() {
        return $this->order_status;
    }

    public function set_order_status($order_status) {
        $this->order_status = $order_status;
    }

    public function get_order_id() {
        return $this->order_id;
    }

    public function set_order_id($order_id) {
        $this->order_id = $order_id;
    }

    public function get_created_time() {
        return $this->created_time;
    }

    public function set_created_time($created_time) {
        $this->created_time = $created_time;
    }

    public function get_paymentmethod() {
        return $this->paymentmethod;
    }

    public function set_paymentmethod($paymentmethod) {
        $this->paymentmethod = $paymentmethod;
    }

    public function get_shipping_address() {
        return $this->shipping_address;
    }

    public function set_shipping_address($shipping_address) {
        $this->shipping_address = $shipping_address;
    }

    public function get_shipping_service() {
        return $this->shipping_service;
    }

    public function set_shipping_service($shipping_service) {
        $this->shipping_service = $shipping_service;
    }

    public function get_totals() {
        return $this->totals;
    }

    public function set_totals($totals) {
        $this->totals[] = $totals;
    }

    public function get_transactions($i=-1) {
        if(isset($this->transactions[$i]))
            return $this->transactions[$i];
        return $this->transactions;
    }

    public function set_transactions($transactions) {
        $this->transactions[] = $transactions;
    }

    public function get_billing_address() {
	return $this->billing_address;
    }

    public function set_billing_address($billing_address) {
	$this->billing_address = $billing_address;
    }
    public function get_customers_id() {
	return $this->customers_id;
    }

    public function set_customers_id($customers_id) {
	$this->customers_id = $customers_id;
    }
    
    function get_has_ebay_plus() {
        return $this->has_ebay_plus;
    }

    function set_has_ebay_plus($has_ebay_plus) {
        $this->has_ebay_plus = $has_ebay_plus;
    }

        function  __construct($OrderType) {
			if($OrderType->ExternalTransaction){
				$ET = current($OrderType->ExternalTransaction);
				$this->ExternalTransaction = array(
					'ExternalTransactionID'=>$ET->ExternalTransactionID,
					'ExternalTransactionTime'=>$ET->ExternalTransactionTime,
					'PaymentOrRefundAmount'=>$ET->PaymentOrRefundAmount->value,
					'PaymentOrRefundAmountCurrency'=>$ET->PaymentOrRefundAmount->attributeValues['currencyID']
				);
			}
			foreach($OrderType->TransactionArray->Transaction as $TransactionType){
				$TT = new ebay_transaction($TransactionType,true);
				$this->set_transactions($TT);
			}
			$CheckoutStatus = $OrderType->CheckoutStatus;
			// wenn "Completed" dann die Payment Infos speichern
			$this->set_order_status($OrderType->OrderStatus);
			$this->set_order_id($OrderType->OrderID);
			$this->set_created_time($OrderType->CreatedTime->format('Y-m-d H:i:s'));
			$this->set_paymentmethod($CheckoutStatus->PaymentMethod);

			$SA = $OrderType->ShippingAddress;
			$names = $this->split_string($SA->Name);
			$iso2 = $this->get_iso2($SA->Country);
			$this->set_shipping_address(array(
				'company'=>'',
				'zone_id'=>'',
				'firstname'=>$names[0],
				'lastname'=>(isset($names[1])?$names[1]:''),
				'street_address'=>$SA->Street1,
				'suburb'=>$SA->Street2,
				'city'=>$SA->CityName,
				'state'=>$SA->StateOrProvince,
				'country_id'=>$this->get_countries_id_from_iso2( $iso2 ),
				'postcode'=>$SA->PostalCode
			));

			$SS = $OrderType->ShippingServiceSelected;
                        if(strtolower($SS->ShippingService) == 'ebayplus'){
                            $this->set_has_ebay_plus(true);
                        }
			$this->set_shipping_service($SS->ShippingService);
			$SSSic = $SS->ShippingInsuranceCost;
			$total_shipping = 0;
			if(is_object($SSSic))
				$total_shipping = (float)$SSSic->value;
			$SSSc = $SS->ShippingServiceCost;
			if(is_object($SSSc))
				$total_shipping += (float)$SSSc->value;
			$this->set_totals(array('shipping'=>$total_shipping));
			$this->set_totals(array('subtotal'=>$OrderType->Subtotal->value));
			$this->set_totals(array('total'=>$OrderType->Total->value));
			$this->set_buyer($OrderType->BuyerUserID);
			$transaction = current($this->get_transactions());
			$this->set_billing_address($transaction->get_registration_address());
			$this->set_customers_id($transaction->get_customers_id());
			$this->set_customers_email_address($transaction->get_customers_email_address());
    }
    
    public static function get_countries_id_from_iso2($code){
            $query = yes_db_query(
                "SELECT countries_name,countries_id FROM countries WHERE countries_iso_code_2='".xtc_db_input(strtoupper( $code ))."'",
                true
            );
            $record = current($query);
            return (($record['countries_id'] > 0)?$record['countries_id']:STORE_COUNTRY);
    }

    public static function split_string($value){
		// WIR BASTELN VOR- UND NACHNAMEN
		$reg_fullname = array();
		$reg_fullname_array = explode(" ",trim($value));
		$reg_fullname[0] = trim(current($reg_fullname_array));
		if( count($reg_fullname_array) > 1 ) {
			for($i=1;$i<count($reg_fullname_array);$i++) {
				if(!isset($reg_fullname[1]))
				$reg_fullname[1] = '';
				$reg_fullname[1] .= ' '.trim($reg_fullname_array[$i]);
			}
		}
		return $reg_fullname;
    }

    public static function get_iso2($countryname){
        global $EBAYAPI;
		if(strlen($countryname) == 2)
			return $countryname;
        return $EBAYAPI->get_iso2_from_ebay_countryname($countryname);
    }

    public function create_order( $ebay_orders_id,$currency=DEFAULT_CURRENCY ){
		$customer_info = xtc_get_customer_status_value($this->get_customers_id());
		$customer_data_query = yes_db_query(sprintf(
			"SELECT customers_cid,customers_vat_id,customers_telephone FROM customers WHERE customers_id='%s'",
			$this->get_customers_id()
		));
		$customer_data = current($customer_data_query);
		
		$orders_status = 1;
		$ebay_no_shippingaddress = 0;
		//$ebay_no_registrationaddress = 0;
		$ebay_different_address = 0;
		$orders_to_combine = array();
		foreach($this->get_transactions() as $trans){
			$toID = $trans->get_orders_id();
			if($toID < 1) return false; // sichergehen das alle Transaktionen bereits gespeichert sind
			$orders_to_combine[] = $toID;
			$query = xtc_db_query(sprintf(
				"SELECT orders_status,ebay_no_shippingaddress,ebay_no_registrationaddress,ebay_different_address,customers_status FROM orders WHERE orders_id='%s'",
				$toID
			));
			$record = xtc_db_fetch_array($query);
                        if(!isset($target_customers_status)){
                            $target_customers_status = $record['customers_status'];
                        }
			if($record['orders_status'] == ORDERS_STATUS_BEZAHLT){
				$orders_status = ORDERS_STATUS_BEZAHLT;
			}
			if($record['ebay_no_shippingaddress'] == 1){
			    $ebay_no_shippingaddress = 1;
			}
                        /*
			if($record['ebay_no_registrationaddress'] == 1){
			    $ebay_no_registrationaddress = 1;
			}*/
			if($record['ebay_different_address'] == 1){
			    $ebay_different_address = 1;
			}
		}
		if(sizeOf($this->ExternalTransaction)){
			// HIER payment_transaction_id_string erweitern
			$payment_transaction_id_string = $this->ExternalTransaction['ExternalTransactionID'];
		}else{
			$payment_transaction_id_string = '';
		}
		
		$shipping_address = $this->get_shipping_address();
                $registration_address = $shipping_address;
		//$registration_address = $this->get_billing_address();
		
		$pm = ($this->get_paymentmethod() == 'None') ? EBAY_PREFERRED_PAYMENTMETHOD : $this->get_paymentmethod();
		$insert_sql_array = array(
			'customers_id'=>$this->get_customers_id(),
			'customers_cid'=>$customer_data['customers_cid'],
			'customers_vat_id'=>$customer_data['customers_vat_id'],
			'customers_status'=>$target_customers_status,
			'customers_status_name'=>$this->get_customers_status_name($target_customers_status),
			'customers_status_image'=>$this->get_customers_status_image($target_customers_status),
			// customer
			'customers_name'=>$registration_address['firstname'].' '.$registration_address['lastname'],
			'customers_street_address'=>$registration_address['street_address'],
			'customers_suburb'=>$registration_address['suburb'],
			'customers_city'=>$registration_address['city'],
			'customers_postcode'=>$registration_address['postcode'],
			'customers_state'=>$registration_address['state'],
			'customers_country'=> xtc_get_country_name($registration_address['country_id']),
			'customers_telephone'=>$customer_data['customers_telephone'],
			'customers_email_address'=>$this->get_customers_email_address(),
			'customers_address_format_id'=>EBAY_ADDRESS_FORMAT_ID,
			// shipping
			'delivery_name'=>$shipping_address['firstname'].' '.$shipping_address['lastname'],
			'delivery_street_address'=>$shipping_address['street_address'],
			'delivery_suburb'=>$shipping_address['suburb'],
			'delivery_city'=>$shipping_address['city'],
			'delivery_postcode'=>$shipping_address['postcode'],
			'delivery_state'=>$shipping_address['state'],
			'delivery_country'=>  xtc_get_country_name($shipping_address['country_id']),
			'delivery_address_format_id'=>EBAY_ADDRESS_FORMAT_ID,

			// billing
			'billing_name'=>$registration_address['firstname'].' '.$registration_address['lastname'],
			'billing_street_address'=>$registration_address['street_address'],
			'billing_suburb'=>$registration_address['suburb'],
			'billing_city'=>$registration_address['city'],
			'billing_postcode'=>$registration_address['postcode'],
			'billing_state'=>$registration_address['state'],
			'billing_country'=>xtc_get_country_name($registration_address['country_id']),
			'billing_address_format_id'=>EBAY_ADDRESS_FORMAT_ID,

			'payment_method'=>$pm,
			'date_purchased'=>$this->get_created_time(),
			'orders_status'=>$orders_status,
			'currency'=>$currency,
			'payment_class'=>$pm,
			'shipping_method'=>$this->get_shipping_service(),
			'shipping_class'=>$this->get_shipping_service(),
			'language'=>'german',
			'payment_transaction_id'=>$payment_transaction_id_string,
			'ebay_no_shippingaddress'=>$ebay_no_shippingaddress,
			'ebay_no_registrationaddress'=>$ebay_no_registrationaddress,
			'ebay_different_address'=>$ebay_different_address,
		    'source'=>'ebay',
                    'ebay_plus'=>($this->get_has_ebay_plus() === true)?1:0,
		);
		xtc_db_perform('orders',$insert_sql_array);
		$orders_id = xtc_db_insert_id();
		
		// SOLLTE EIGENTLICH NICHT DER FALL SEIN, ABER SICHER IST SICHER
		if(!function_exists('yes_write_notice')){
		    mail('m.aspeleiter@yes-websolutions.de','yes_write_notice missing in ebay order','kwt');
		    require_once(DIR_FS_INC.'yes_write_notice.inc.php');
		}
                
                $rec_array = main::get_notice_recipients('orders_edit');
                if($this->get_has_ebay_plus() === true){
		    $text = 'Beim Kombinieren der eBay Re-Nr '.implode(', ',$orders_to_combine).' zu Re-Nr '.$orders_id.' wurde mindestens ein Auftrag mit eBay Plus Markierung kombiniert. Bitte Vorgang pr&uuml;fen.</b>';
		    yes_write_notice('Kombinierte eBay Re-Nr '.$orders_id.' - eBayPlus Markierung',$text,0,$rec_array);
                }
		
		if($this->get_paymentmethod() == 'None'){
		    $text = 'Beim Kombinieren der eBay Re-Nr '.implode(', ',$orders_to_combine).' zu Re-Nr '.$orders_id.' wurde von eBay als Bezahlart "None" gemeldet. Es wurde automatisch die von Ihnen konfigurierte bevorzugte eBay Bezahlmethode "'.EBAY_PREFERRED_PAYMENTMETHOD.'" zum Auftrag zugewiesen. <b>Bitte pr&uuml;fen Sie den Vorgang und korrigieren Sie ggf. die Bezahlart im Auftrag.</b>';
		    yes_write_notice('Kombinierte eBay Re-Nr '.$orders_id.' - Keine Bezahlart',$text,0,$rec_array);
ob_start();
print_r($this);
$comb_trans = ob_get_contents();
ob_end_clean();

mail('m.aspeleiter@yes-websolutions.de,b.agri@yes4trade.de','EBAY kombinieren mit none',$comb_trans."\r\n".STORE_NAME);
		}
		
		// MELDUNG AN BERECHTIGTE, WENN ADRESSPROBLEME
		if($ebay_no_shippingaddress == 1 or $ebay_no_registrationaddress == 1 or $ebay_different_address == 1){
		    
		    yes_write_notice('Fehlerhafte Adresse beim autom. Kombinieren',
			sprintf(
				'Beim autom. Kombinieren der eBay Bestellungen (%s) zu Auftrag %s, wurde festgestellt, dass mindestens eine der enthaltenen Bestellungen fehlerhafte Adressen beinhaltete. Bitte kontrollieren Sie den erzeugten Auftrag.',
				implode(', ',$orders_to_combine),$orders_id
			), 
			0,
			$rec_array    
		    );
		}
		

		$total_products = array(
			'products_price'=>0,
			'final_price'=>0
		);
		$default_tax_rate = number_format(xtc_get_tax_rate(MODULE_SHIPPING_YES_TAX_CLASS),2,'.','');
		
		$taxes = array(
			$default_tax_rate => $this->netto($this->get_totals_value('shipping'),$default_tax_rate)
		);
		// ARTIKEL DER EINZELNEN ENTHALTENEN ORDERS KOPIEREN
		$combined_orders_array = array();
		foreach($this->get_transactions() as $trans){
			$combined_orders_array[] = $trans->get_orders_id();
			$orders_products = $trans->get_orders_products( $trans->get_orders_id() );
			foreach($orders_products as $op){
				$tax_rate = number_format($op['products_tax'],2,'.','');
				if(!isset($taxes[$tax_rate]))
					$taxes[$tax_rate] = 0;
				$taxes[$tax_rate] += $this->netto($op['final_price'],$op['products_tax']);

				$total_products['products_price'] += $op['products_price'];
				$total_products['final_price'] += $op['final_price'];

				unset($op['price_fixing']);

				// OP KOPIEREN
				unset($op['orders_products_id']);
				$op['orders_id'] = $orders_id;
				$op['date_added'] = 'now()';
				xtc_db_perform('orders_products',$op);
				$opID = xtc_db_insert_id();
			}
		} // end foreach containing orders
		$insert_sql_array = array(
			'orders_id'=>$orders_id,
			'title'=>MODULE_ORDER_TOTAL_SUBTOTAL_TITLE,
			'text'=>number_format( (float)$total_products['final_price'],2,',','.').' '.$currency,
			'value'=>$total_products['final_price'],
			'class'=>'ot_subtotal',
			'sort_order'=>MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER
		);
		xtc_db_perform('orders_total',$insert_sql_array);

		if($this->get_totals_value('shipping') > 0){
			$insert_sql_array = array(
				'orders_id'=>$orders_id,
				'title'=>$this->get_shipping_service(),
				'text'=>number_format($this->get_totals_value('shipping'),2,',','.').' '.$currency,
				'value'=>$this->get_totals_value('shipping'),
				'class'=>'ot_shipping',
				'sort_order'=>MODULE_ORDER_TOTAL_SHIPPING_SORT_ORDER
			);
			xtc_db_perform('orders_total',$insert_sql_array);
		}

		foreach($taxes as $tax_rate => $tax_value){
			$insert_sql_array = array(
				'orders_id'=>$orders_id,
				'title'=>EBAY_TOTAL_TAX_TITLE . number_format($tax_rate,0,',','.').'%',
				'text'=>number_format($tax_value,2,',','.').' '.$currency,
				'value'=>$tax_value,
				'class'=>'ot_tax',
				'sort_order'=>MODULE_ORDER_TOTAL_TAX_SORT_ORDER,
			    'tax_rate_percent'=>$tax_rate
			);
			xtc_db_perform('orders_total',$insert_sql_array);
		}

		$insert_sql_array = array(
			'orders_id'=>$orders_id,
			'title'=>MODULE_ORDER_TOTAL_TOTAL_TITLE,
			'text'=>number_format($this->get_totals_value('total'),2,',','.').' '.$currency,
			'value'=>$this->get_totals_value('total'),
			'class'=>'ot_total',
			'sort_order'=>MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER
		);
		xtc_db_perform('orders_total',$insert_sql_array);

		// ENTHALTENE ORDERS AUF STORNIERT SETZEN
		// EINTRAG IN ebay_orders
		foreach($this->get_transactions() as $trans){
			xtc_db_query(sprintf(
				"UPDATE orders SET orders_status='%s',combined_orders_id='%s' WHERE orders_id='%s'",
				ORDERS_STATUS_STORNIERT,
				$orders_id,
				$trans->get_orders_id()
			));
			$trans->set_orders_status(ORDERS_STATUS_STORNIERT);

			$insert_sql_array = array(
				'orders_id'=>$trans->get_orders_id(),
				'orders_status_id'=>$trans->get_orders_status(),
				'editor_id'=>0,
				'date_added'=>'now()',
				'customer_notified'=>0,
				'comments'=>sprintf('Durch Ebaypayment in Auftrag %s kombiniert.',$orders_id)
			);
			xtc_db_perform('orders_status_history',$insert_sql_array);

			$insert_sql_array = array(
				'ebay_orders_id' => $ebay_orders_id,
				'transaction_id' => $trans->get_transaction_id(),
				'ebay_id' => $trans->get_ebay_id(),
				'products_id'=>$trans->get_products_id()
			);
			xtc_db_perform('ebay_orders_items',$insert_sql_array);
		}
		// BOF - Paypal Transaction als ZEP uebernehmen
		if(sizeOf($this->ExternalTransaction)){
			$insert_sql_array = array(
				'betrag'=>$this->ExternalTransaction['PaymentOrRefundAmount'],
				'waehrung'=>$this->ExternalTransaction['PaymentOrRefundAmountCurrency'],
				'buchungstag'=>date('d.m.Y'),
				'bankleitzahl'=>'',
				'kontonummer'=>'',
				'name'=>$registration_address['firstname'].' '.$registration_address['lastname'],
				'verwendungszweck1'=>$pm.' Transaktion '.$this->ExternalTransaction['ExternalTransactionID'],
				'confirmed'=>1,
				'sorting'=>0,
				'buchungstag_date'=>date('Y-m-d')
			);
			xtc_db_perform('incoming_payments',$insert_sql_array);
			$payment_id = xtc_db_insert_id();
			$insert_sql_array = array(
				'payment_id'=>$payment_id,
				'orders_id'=>$orders_id,
				'created'=>'now()'
			);
			xtc_db_perform('payment_orders',$insert_sql_array);
		}
		// EOF - Paypal Transaction als ZEP uebernehmen
		// 
		// HISTORIENEINTRAG
		$insert_sql_array = array(
			'orders_id'=>$orders_id,
			'orders_status_id'=>1,
			'editor_id'=>0,
			'date_added'=>'now()',
			'customer_notified'=>0,
			'comments'=>sprintf('Durch Ebaypayment erzeugt aus den Auftr&auml;gen %s.',implode(', ',$combined_orders_array))
		);
		xtc_db_perform('orders_status_history',$insert_sql_array);
		return $orders_id;
    }

    /**
     * Prueft ob eine Ebay Order bereits gespeichert wurde
     * @return bool
     */
    public function is_saved(){
		$query = yes_db_query(sprintf(
			"SELECT eoi.ebay_orders_id from ebay_orders_items eoi LEFT JOIN ebay_orders eo USING(ebay_orders_id) WHERE eo.OrderID='%s'",
			$this->get_order_id()
		));
		if(yes_db_num_rows($query))
			return true;
		return false;
    }

    public function get_ebay_orders_id(){
	$query = yes_db_query(sprintf(
	    "SELECT ebay_orders_id from ebay_orders eo WHERE eo.OrderID='%s'",
	    $this->get_order_id()
	));
	if(yes_db_num_rows($query)){
	    $record = current($query);
	    return $record['ebay_orders_id'];
	}
	return 0;
    }

    public static function get_customers_status_name($customers_status_id, $language_id = '') {
	if ($language_id == '') {
            $language_id = $_SESSION['languages_id'];
        }
        $customers_status = main::get_customers_status($customers_status_id, (int)$language_id);
	return $customers_status['customers_status_name'];
    }

    public static function get_customers_status_image($customers_status_id, $language_id = '') {
	if ($language_id == '') {
            $language_id = $_SESSION['languages_id'];
        }
        $customers_status = main::get_customers_status($customers_status_id, (int)$language_id);
	return $customers_status['customers_status_image'];
    }

    /**
     * NUR WENN ALLE ENTHALTENEN ORDERS AUF UPSELLING ODER BEZAHLT SIND
     * DARF KOMBINIERT WERDEN
     */
    public function allow_create(){
		$allow = true;
		foreach($this->get_transactions() as $trans){
			if(!in_array($trans->get_orders_status(),array(ORDERS_STATUS_UPSELLING,ORDERS_STATUS_BEZAHLT))){
				$allow = false;
			}
		}
		return $allow;
    }

    public static function get_orders_status_name($orders_status_id, $language_id = '') {
        if (empty($language_id)){
            $language_id = $_SESSION['languages_id'];
        }
        return main::get_orders_status_name($orders_status_id, $language_id);
  }

  private static function netto($price,$tax){
      if($price == 0 or $tax == 0)
	  return $price;
      return $price - ($price / (($tax+100)/100) );
  }

  private function get_totals_value($class){
	  foreach($this->get_totals() as $total){
		  if(key($total) == $class)
			  return current($total);
	  }
	  return 0;
  }

}

