<?php
class incoming_payments
{
	var $conf,$uploaded,$upload_file,$saved_file,$message_string;
	function __construct($type){
		$config_filename = DIR_FS_ADMIN.DIR_WS_INCLUDES.'ip_'.$type.'.conf';
		if(is_file($config_filename)){
			$this->getTextConf($config_filename,'config');
		}else{
			return false;
		}
	}

	function upload($file){
		$save_filename = DIR_FS_ADMIN.$this->conf['save_path'];
		if(copy($file,$save_filename)) {
			$this->upload_file = $file;
			$this->saved_file = $save_filename;
			$this->uploaded = true;
			return true;
		}else{
			return false;
		}
	}

	function clear_upload(){
		if($this->uploaded){
			unlink($this->upload_file);
			unlink($this->saved_file);
		}
	}

	function array_walk(&$input, $funcname) {
	        foreach ($input as $key => $value){
			$input[$key] = $this->$funcname($value);
		}
	}

	function make_array($itemvalue){
		$sep = ($this->conf['columnseparator'] == '[TAB]') ? "\t" : $this->conf['columnseparator'];
		return explode($sep,$itemvalue);
	}


	function strip_separator($itemvalue){
		$itemvalue = trim($itemvalue);
		if($this->conf['textseparator'] != ''){
			if($itemvalue[0] == $this->conf['textseparator'])
				$itemvalue = substr($itemvalue,1,strlen($itemvalue));
			if($itemvalue[ strlen($itemvalue)-1 ] == $this->conf['textseparator'])
				$itemvalue = substr($itemvalue,0,strlen($itemvalue)-1);
		}
		return $itemvalue;
	}

	function clear_string($lines){
		$this->array_walk($lines,'strip_separator');
		return $lines;
	}

	function _get_amount_string($string){
		// FALLS KEINE ODER NUR 1 KOMMASTELLE
		$decimal = '';
		if(strstr($string,$this->conf['col_amount_format_decimal'])){
			$decimal = current(array_reverse(split($this->conf['col_amount_format_decimal'],$string)));
		}
		if(strlen($decimal) == 0) $string = $string.$this->conf['col_amount_format_decimal'].'00';
		if(strlen($decimal) == 1) $string = $string.'0';

		// ENDE KOMMASTELLEN
		$sbstr_from = strlen($string) - strlen($this->conf['col_amount_format_decimal'].'00');
		$sbstr_to = strlen($string);
		$cents = substr($string,$sbstr_from+1,$sbstr_to);
		$euro = substr($string,0,$sbstr_from);
		$euro = str_replace($this->conf['col_amount_format_thousand'],'',$euro);
		return (float)$euro.'.'.$cents;
	}

	function format_betrag($value){
		$value = str_replace($this->conf['col_amount_format_pre'],'',$value);
		if(isset($this->conf['col_amount_after_length'])){
			$value = substr($value,0,strlen($value) - $this->conf['col_amount_after_length']);
		}else{
			$value = str_replace($this->conf['col_amount_format_after'],'',$value);
		}
		return $this->_get_amount_string($value);
	}
	function _get_date_formats(){
		$array = array();
		$split = explode(".",$this->conf['col_date_format']);
		for($i=0;$i<sizeOf($split);$i++){
			if(strstr($split[$i],"T")){
				$array['tag']['size'] = strlen($split[$i]);
				$array['tag']['format'] = $split[$i];
				$array['tag']['pos'] = strpos($this->conf['col_date_format'],$split[$i]);
				$array['tag']['array_pos'] = $i;
			}
			if(strstr($split[$i],"M")){
				$array['monat']['size'] = strlen($split[$i]);
				$array['monat']['format'] = $split[$i];
				$array['monat']['pos'] = strpos($this->conf['col_date_format'],$split[$i]);
				$array['monat']['array_pos'] = $i;
			}
			if(strstr($split[$i],"J")){
				$array['jahr']['size'] = strlen($split[$i]);
				$array['jahr']['format'] = $split[$i];
				$array['jahr']['pos'] = strpos($this->conf['col_date_format'],$split[$i]);
				$array['jahr']['array_pos'] = $i;
			}
		}
		return $array;
	}

	function check_tag($tag){
		if(strlen($tag) == 1)
			$tag = '0'.$tag;
		return $tag;
	}

	function check_monat($monat){
		if(strlen($monat) == 1)
			$monat = '0'.$monat;
		return $monat;
	}

	function check_jahr($jahr){
		if(strlen($jahr) == 2){
			$pre_jahr = substr(date('Y'),0,2);
			$jahr = $pre_jahr.$jahr;
		}
		return $jahr;
	}

	function format_date($value,$formats){
		if($this->conf['col_date_separator'] and $this->conf['col_date_separator'] != '')
			$date_sep = $this->conf['col_date_separator'];
		else
			$date_sep = '.';

		$value_split = explode($date_sep,$value);

		$tag = $value_split[ $formats['tag']['array_pos'] ];
		$monat = $value_split[ $formats['monat']['array_pos'] ];
		$jahr = $value_split[ $formats['jahr']['array_pos'] ];
		$tag = $this->check_tag($tag);
		$monat = $this->check_monat($monat);
		$jahr = trim($this->check_jahr($jahr));
		if( is_numeric($tag) and is_numeric($monat) and is_numeric($jahr)){
			return $tag.'.'.$monat.'.'.$jahr;
		}else{
			return 0;
		}
	}

	function clean_csv_string($string){
		$string = str_replace("'",'',$string);
		return str_replace('"','',$string);
	}

	function get_vwz($field,$line){
		$fields = explode(',',$this->conf['col_vwz'.$field]);
		$return_string = '';
		for($i=0;$i<sizeOf($fields);$i++){
			$value = $this->clean_csv_string($line[$fields[$i]]);
			if($value != ''){
				$combine = $this->conf['col_vwz'.$field.'_combine'];
				$combine = str_replace("[SPACE]"," ",$combine);
				$return_string .= $value . $combine;
			}
		}
		$return_string = substr($return_string,0,(strlen($return_string)-strlen($combine)));
		return $return_string;
	}

	function get_sql_array($lines){
		$array = array();
		$formats = $this->_get_date_formats();
		$nr = 0;
		for($i=0;$i<sizeOf($lines);$i++){
			$betrag = $this->format_betrag( $lines[$i][ $this->conf['col_amount'] ] );
			
			if(isset($this->conf['soll_haben_col']) and isset($this->conf['soll_haben_symbol']) and $this->conf['soll_haben_symbol'] != ''){
				if($lines[$i][ $this->conf['soll_haben_col'] ] != $this->conf['soll_haben_symbol']){
					$betrag = -$betrag;
				}
			}
			
			
			$date = $this->format_date( $lines[$i][ $this->conf['col_date'] ],$formats );
			if($betrag > 0 and $date > 0){
				$array[$nr]['betrag'] = $betrag;
	       		$array[$nr]['buchungstag'] = $this->format_date( $lines[$i][ $this->conf['col_date'] ],$formats );
	       		$array[$nr]['buchungstag_date'] = date('Y-m-d',strtotime($array[$nr]['buchungstag']));
				for($vwzi=1;$vwzi<=5;$vwzi++){
					if(isset($this->conf['col_vwz'.$vwzi]))
						$array[$nr]['verwendungszweck'.$vwzi] = $this->get_vwz($vwzi,$lines[$i]);
				}
				if(isset($this->conf['col_blz']))
					$array[$nr]['bankleitzahl'] = $this->clean_csv_string($lines[$i][ $this->conf['col_blz'] ]);
				if(isset($this->conf['col_kto']))
					$array[$nr]['kontonummer'] = $this->clean_csv_string($lines[$i][ $this->conf['col_kto'] ]);
				if(isset($this->conf['col_curr']))
					$array[$nr]['waehrung'] = $this->clean_csv_string($lines[$i][ $this->conf['col_curr'] ]);
				$nr++;
			}
		}
		return $array;
		
	}

	function get_double_sql_query($data){
        	$double_query_raw = "SELECT id FROM incoming_payments WHERE betrag='".$data['betrag']."' AND buchungstag='".$data['buchungstag']."' ";
		for($vwzi=1;$vwzi<=5;$vwzi++){
			$len = ($vwzi <= 2) ? 128 : 100; // DB LIMIT
			if(isset($this->conf['col_vwz'.$vwzi]))
				$double_query_raw .= " AND verwendungszweck".$vwzi."='".substr($data['verwendungszweck'.$vwzi],0,$len)."'";
		}
		if(isset($this->conf['col_blz']))
			$double_query_raw .= " AND bankleitzahl='".$data['bankleitzahl']."' ";
		if(isset($this->conf['col_kto']))
			$double_query_raw .= " AND kontonummer='".$data['kontonummer']."' ";
		if(isset($this->conf['col_curr']))
			$double_query_raw .= " AND waehrung='".$data['waehrung']."' ";
		return $double_query_raw;
	}

	function get_sorting(){
		$sorting_query = xtc_db_query("SELECT sorting FROM incoming_payments order by sorting DESC limit 1");
		$sorting_res = xtc_db_fetch_array($sorting_query);
		return ($sorting_res['sorting']+1);
	}

	function process($probe){
		if( $this->upload($probe) ){
			$lines = $this->read_saved_file();
			// generiere array aus lines
			$this->array_walk($lines,'make_array');
			// saeubere die values von den textseparatoren
			$this->array_walk($lines,'clear_string');

			$sql = $this->get_sql_array($lines);
			$sorting = $this->get_sorting();
			$num_all = sizeOf($sql);
			$num_imported = 0;
			$sql = array_reverse($sql);
			for($sqli=0;$sqli<sizeOf($sql);$sqli++){
				$sql_double_query = $this->get_double_sql_query($sql[$sqli]);
				$double_query = xtc_db_query($sql_double_query);
				if(!xtc_db_num_rows($double_query)){
					$sql[$sqli]['sorting'] = $sorting;
					$sorting++;
					$num_imported++;
					xtc_db_perform('incoming_payments',$sql[$sqli]);
				}
			}
			$this->clear_upload();
			$this->message_string = 'Es wurden '.$num_imported.' / '.$num_all.' Datens&auml;tze importiert';
			return true;
		}else{
			return false;
		}
	}

	function read_saved_file(){
		$content = '';
		$lines = array();
		$start_at_linenumber = 0;
		if(isset($this->conf['begin_with_empty_line']) and $this->conf['begin_with_empty_line'] == 1){
			$fp = @fopen($this->saved_file, "r") or die ("Kann Datei ".$this->saved_file." nicht lesen.");
			$current_line = 0;
			while ($line = fgets($fp, 1024)){
				if($line == "\n"){
					$start_at_linenumber = $current_line;
					break;
				}
				$current_line++;
			}
			fclose($fp);
		}
		if(isset($this->conf['begin_with_line_after_string']) and $this->conf['begin_with_line_after_string'] != ''){
			$fp = @fopen($this->saved_file, "r") or die ("Kann Datei ".$this->saved_file." nicht lesen.");
			$current_line = 0;
			while ($line = fgets($fp, 1024)){
				if(stristr($line,$this->conf['begin_with_line_after_string'])){
					$start_at_linenumber = $current_line+1;
					break;
				}
				$current_line++;
			}
			fclose($fp);
		}
		$current_line = 0;
		$fp = @fopen($this->saved_file, "r") or die ("Kann Datei ".$this->saved_file." nicht lesen.");
		while ($line = fgets($fp, 1024)){
			if($current_line >= $start_at_linenumber and strlen(trim($line)) > 0){
				$charset = mb_detect_encoding($line);
				if($charset == 'UTF-8'){
					$line = yes_decode_string($line);
				}
				$lines[] = $line;
				$content .= $line;
			}
			$current_line++;
		}
		fclose($fp);
		if(isset($this->conf['end_of_dataline']) and $this->conf['end_of_dataline'] != ''){
			$lines = array();
			$break = ($this->conf['end_of_dataline_type'] == 'n') ? "\n" : "\r";
			$_lines = explode(
				str_replace('[EOL]',$break,$this->conf['end_of_dataline']),
				$content
			);
			foreach($_lines as $line){
				if(!empty($line))
					$lines[] = str_replace("\n"," ",$line);
			}
		}
		return $lines;
	}

	function getTextConf($filename, $section)
	{
		$comment_line_start = ';';
		$lines = file ($filename);

		// \n und \r entfernen
		$next_index = 0;
		$valid_lines = array();
		foreach($lines as $k => $v){
			if(strlen(trim($v)) > 0 and $v[0] != $comment_line_start){
				$valid_lines[$next_index] = trim($v);
				$next_index++;
			}
		}

		$impotantLines = array();
		$start = array_search($section, $valid_lines);
		for($i=$start+1; $i<count($valid_lines); $i++){
			if($valid_lines[$i][0] != $comment_line_start){
			        $impotantLines[] = $valid_lines[$i];
			}
		}

		// assocArray erstellen
		$assocArray = array();
		foreach($impotantLines as $k => $v){
			$tmpStr = str_replace(array("'"), '', $v);
			$tmp = explode("=",$tmpStr);
			$assocArray[trim($tmp[0])] = trim(trim($tmp[1],":"));
		}
		$this->conf = $assocArray;
	}

}
