<?php
/* -----------------------------------------------------------------------------------------
   (c) 2004	 mario aspeleiter <dazze@gmx.de>
   ---------------------------------------------------------------------------------------*/
setlocale (LC_ALL, 'de_DE');
class incoming_payment {

	var $_SESSION;
	var $payments = array();
	var $orders = array();
	var $results = array();
	var $payment_tolerance;
	var $datafile;
	var $betrag;
	var $name; // dient als notizfeld
	var $text;
	var $text_raw;
	var $buchungstag;
	var $payment_id;
	var $allocated_orders = array();
	var $allocated_payments = array();
	var $feedback_text_array = array();
	var $feedback_recs = array();

	function set_datafile($value) {
		$this->datafile = $value;
	}

	function get_datafile() {
		return $value;
	}

	function is_ebay_order($oID){
		$query = xtc_db_query("SELECT ebay_id FROM orders WHERE orders_id='".$oID."'");
		$row = xtc_db_fetch_array($query);
		if(strlen($row['ebay_id']>0))
			return true;
		else
			return false;
	}
	
	function _init($pID) {
		$pay_query = xtc_db_query("SELECT * FROM incoming_payments WHERE id='".$pID."'");
		$pay = xtc_db_fetch_array( $pay_query );
		for($i=1;$i<20;$i++){
			if($pay['verwendungszweck'.$i] != '') {
				$this->text .= $pay['verwendungszweck'.$i].'<br>';
				$this->text_raw .= $pay['verwendungszweck'.$i].' ';
			}
		}
		$this->text_raw .= $pay['name'].' ';
		$this->name = $pay['name'];
		
		$this->betrag = number_format($pay['betrag'],2,',','.');
		$this->buchungstag = $pay['buchungstag'];
		$this->payment_id = $pay['id'];
		
		$payorder_query = xtc_db_query("SELECT orders_id FROM payment_orders WHERE payment_id='".$this->payment_id."'");
		$existing_payments = array();
		while($payorder = xtc_db_fetch_array($payorder_query)){
			$this->allocated_orders[] = $payorder['orders_id'];
			$allocPay_query = xtc_db_query("SELECT payment_id FROM payment_orders WHERE orders_id='".$payorder['orders_id']."' and payment_id != '".$this->payment_id."'");
			while($allocPay = xtc_db_fetch_array($allocPay_query) ){
				if(!in_array($allocPay['payment_id'],$existing_payments)){
					$this->allocated_payments[] = $allocPay['payment_id'];
					$existing_payments[] = $allocPay['payment_id'];
				}
			}
		}
	}

	function set_payment_tolerance($value){
		$this->payment_tolerance = $value;
	}

	function get_payment_tolerance(){
		return $this->payment_tolerance;
	}

	function set_text($value){
		$this->text = $value;
	}

	function get_text(){
		return $this->text;
	}

	function set_text_raw($value){
		$this->text_raw = $value;
	}

	function get_text_raw(){
		return $this->text_raw;
	}

	function set_betrag($value){
		$this->betrag = $value;
	}

	function get_betrag(){
		return $this->betrag;
	}

	function set_buchungstag($value){
		$this->buchungstag = $value;
	}

	function get_buchungstag(){
		return $this->buchungstag;
	}

	function set_payment_id($value){
		$this->payment_id = $value;
	}

	function get_payment_id(){
		return $this->payment_id;
	}

	function get_payment_allocations( $payment_id ) {
		$return = array();
		$allocation_query = xtc_db_query("SELECT orders_id FROM payment_orders WHERE payment_id='".$payment_id."'");
		while($allocation = xtc_db_fetch_array($allocation_query)){
			$return[] = $allocation['orders_id'];
		}
		return $return;
	}

	function get_order_allocations( $orders_id ) {
		$return = array();
		$allocation_query = xtc_db_query("SELECT payment_id FROM payment_orders WHERE orders_id='".$orders_id."'");
		while($allocation = xtc_db_fetch_array($allocation_query)){
			$return[] = $allocation['payment_id'];
		}
		return $return;
	}

	// eine order - mehrere zahlungseingaenge moeglich
	function allocate_check( $payment_id_array, $orders_id,$change_order = 0 ){
		$return = array();
		$payment_counter = 0;
			
		foreach($payment_id_array as $k=>$pID){
			
			$return['orders'][$orders_id] = $pID;
			$orders = $this->get_payment_allocations( $pID );
			if(is_array($orders)){
				foreach($orders as $a => $oID ){
					$return['orders'][$oID] = $pID;
				}
			}
                        
			$return['payments'][$pID][] = $orders_id;
			$payments = $this->get_order_allocations( $oID );
			if(is_array($payments)){
				foreach($payments as $b => $_pID){
					$return['payments'][$_pID][] = $oID;
				}
			}
			
			$datum_query = xtc_db_query("SELECT buchungstag FROM incoming_payments WHERE id='".$pID."'");
			$datum = xtc_db_fetch_array($datum_query);
			$date_mysql = implode( '-', array_reverse( explode( '.', $datum['buchungstag'] ) ) ) . ' 00:00:00';
		}
		return $return;
	}
	
	// eine order - mehrere zahlungseingaenge moeglich
	function allocate( $payment_id_array, $orders_id,$change_order = 0 ){
		global $EBAYAPI,$messageStack;
		if($change_order > 0) {
			
			foreach($payment_id_array as $k=>$pID){
				
				$allocated_orders = array(0=>$orders_id);
				$allocated_orders = $this->get_payment_allocations($pID,$allocated_orders );
					$allocated_orders[] = $allocation['orders_id'];

				$datum_query = xtc_db_query("SELECT buchungstag FROM incoming_payments WHERE id='".$pID."'");
				$datum = xtc_db_fetch_array($datum_query);
				$date_mysql = implode( '-', array_reverse( explode( '.', $datum['buchungstag'] ) ) ) . ' 00:00:00';
				
				// statt einem check ob der datensatz vorhanden is einfach loeschen und neuschreiben
				xtc_db_query("DELETE FROM payment_orders WHERE orders_id='".$orders_id."' && payment_id='".$pID."'");
				xtc_db_query("INSERT INTO payment_orders SET orders_id='".$orders_id."', payment_id='".$pID."',created='".$date_mysql."'");
				
				xtc_db_query("UPDATE incoming_payments SET confirmed=1 where id = '".xtc_db_prepare_input($pID)."'");
                $send_mail = (defined('PAYMENT_CONFIRMATION_EMAIL_ACTIVE') and PAYMENT_CONFIRMATION_EMAIL_ACTIVE == 'true') ? true : false;
				for($i=0;$i<count($allocated_orders);$i++){
					$payment_method_query = xtc_db_query("SELECT payment_method,orders_status FROM orders WHERE orders_id='".$orders_id."'");
					$payment_method = xtc_db_fetch_array($payment_method_query);
					if($payment_method['orders_status'] == ORDERS_STATUS_ABGESCHLOSSEN){
						continue;
					}
					if( xtc_is_shipping_before_payment($payment_method['payment_method']) ){
                                            if( $payment_method['orders_status'] == ORDERS_STATUS_VERSENDET ){
                                                xtc_db_query("update orders set orders_status = '".ORDERS_STATUS_ABGESCHLOSSEN."', last_modified=now(),date_payment=now() where orders_id = '".$allocated_orders[$i]."'");
                                                order::add_history_static(
                                                    intval($allocated_orders[$i]), 
                                                    ORDERS_STATUS_ABGESCHLOSSEN, 
                                                    $send_mail,
                                                    'Zahlungseingang gebucht.'
                                                );
                                            }else{
                                                xtc_db_query("update orders set orders_status = '".ORDERS_STATUS_BEZAHLT."', last_modified=now(),date_payment=now() where orders_id = '".$allocated_orders[$i]."'");
                                                order::add_history_static(
                                                    intval($allocated_orders[$i]), 
                                                    ORDERS_STATUS_BEZAHLT, 
                                                    $send_mail,
                                                    'Zahlungseingang gebucht.'
                                                );
                                            }
					}else{
						xtc_db_query("update orders set orders_status = '".ORDERS_STATUS_BEZAHLT."', last_modified=now(),date_payment=now() where orders_id = '".$allocated_orders[$i]."'");
                                                order::add_history_static(
                                                    intval($allocated_orders[$i]), 
                                                    ORDERS_STATUS_BEZAHLT, 
                                                    $send_mail,
                                                    'Zahlungseingang gebucht.'
                                                );
					}
					// FIBUNUMBER ADDON
					$order = new order($allocated_orders[$i]);
					
					
					if($send_mail){
						$mail_smarty = new yesSmarty;
						$mail_smarty->caching = 0;
						$mail_smarty->assign('language', $_SESSION['language']);
		
						$mail_smarty->assign('tpl_path','templates/'.CURRENT_TEMPLATE.'/');
						$mail_smarty->assign('logo_path',HTTP_SERVER  . DIR_WS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/img/');
						$adresse  = $order->delivery['name']."<br />";
						$adresse .= (!empty($order->delivery['company'])) ? $order->delivery['company']."<br />" : '';
						$adresse .= $order->delivery['street_address']."<br />";
						if($order->delivery['suburb'] != '')
							$adresse .= $order->delivery['suburb']."<br />";
						$adresse .= "<br />";
						$adresse .= $order->delivery['postcode'] . " " . $order->delivery['city'] . "<br />";
						$adresse .= $order->delivery['country']."<br />";
						$adresse_text = str_replace("<br />","\r\n",$adresse);
						
						$products_string = '';
						foreach ($order->products as $k=>$products) {
							$products_string .= $products['qty'] . " x " . $products['model'] . "- " . $products['name']."<br />\n";
						}
						$mail_smarty->assign('ADDRESS_TEXT',$adresse_text);
						$mail_smarty->assign('ADDRESS',$adresse);
						$mail_smarty->assign('PRODUCTS',$products_string);
						$mail_smarty->assign('NAME',$order->billing['name']);
						$mail_smarty->assign('STORE_NAME_ADDRESS',STORE_NAME_ADDRESS);
						$mail_html = $mail_smarty->fetch(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/admin/mail/'.$_SESSION['language'].'/payment_confirmation.html');
						$mail_txt = $mail_smarty->fetch(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/admin/mail/'.$_SESSION['language'].'/payment_confirmation.txt');
						xtc_php_mail(EMAIL_BILLING_ADDRESS,
							EMAIL_BILLING_NAME,
							$order->customer['email_address'],
							$order->customer['name'],
							'',
							EMAIL_BILLING_REPLY_ADDRESS,
							EMAIL_BILLING_REPLY_ADDRESS_NAME,
							'',
							'',
							sprintf(PAYMENT_CONFIRMATION_EMAIL_SUBJECT,$allocated_orders[$i]),
							$mail_html,
							$mail_txt
						);
						$dbMail = new DBmail('0');
						$dbMail->save_mail(
							sprintf(PAYMENT_CONFIRMATION_EMAIL_SUBJECT,$allocated_orders[$i]),
							$order->customer['email_address'],
							EMAIL_BILLING_REPLY_ADDRESS_NAME,
							EMAIL_BILLING_REPLY_ADDRESS,
							$mail_html,
							date('Y-m-d H:i:s'),
							$order->info['ebay_id'],
							$order->customer['ID'],
							$allocated_orders[$i]
						);
					}
					
				}
			}
		}else{ // nur in payment_orders hinzufuegen
			foreach($payment_id_array as $k=>$pID){
				
				$datum_query = xtc_db_query("SELECT buchungstag FROM incoming_payments WHERE id='".$pID."'");
				$datum = xtc_db_fetch_array($datum_query);
				$date_mysql = implode( '-', array_reverse( explode( '.', $datum['buchungstag'] ) ) ) . ' 00:00:00';
				
				// statt einem check ob der datensatz vorhanden is einfach loeschen und neuschreiben
				xtc_db_query("DELETE FROM payment_orders WHERE orders_id='".$orders_id."' && payment_id='".$pID."'");
				xtc_db_query("INSERT INTO payment_orders SET orders_id='".$orders_id."', payment_id='".$pID."',created='".$date_mysql."'");
			}
		}
	}

	/**
	 * 
	 * @require customer.php
	 * @global type $EBAYAPI
	 * @global type $messageStack
	 * @param type $payment_id
	 * @param type $orders_id_array
	 * @param type $change_order
	 */
	function allocate_filter( $payment_id, $orders_id_array, $change_order = 0 ){
		global $EBAYAPI,$messageStack;
		$paydata_query = xtc_db_query("SELECT * FROM incoming_payments WHERE id='".$payment_id."'");
		$paydata = xtc_db_fetch_array($paydata_query);
		$date_mysql = implode( '-', array_reverse( explode( '.', $paydata['buchungstag'] ) ) ) . ' 00:00:00';
		$vwz = '';
		for($i=1;$i<20;$i++){
			if($paydata['verwendungszweck'.$i] != '') {
				$vwz .= $paydata['verwendungszweck'.$i].' ';
			}
		}
		$vwz .= $paydata['name'];
		for($i=0;$i<count($orders_id_array);$i++){
			$other_payments = array();
			// eintrag in payment_orders falls nicht vorhanden
			$double_query = xtc_db_query("SELECT count(1) as anzahl FROM	payment_orders WHERE payment_id='".$payment_id."' and orders_id='".$orders_id_array[$i]."'");
			$double = xtc_db_fetch_array($double_query);
			if($double['anzahl'] == 0){ // verhindern dass doppelt eingetragen wird
				$orders_status_id_query = xtc_db_query(sprintf(
					"SELECT orders_status FROM orders WHERE orders_id='%s'",
					$orders_id_array[$i]
				));
				$orders_status_id_record = xtc_db_fetch_array($orders_status_id_query);
				$comments = sprintf(HISTORY_ALLOCATE_PAYMENT_ORDER,
                                    $vwz,
                                    number_format($paydata['betrag'],2,',','.'),
                                    $paydata['buchungstag']
                                );
                                order::add_history_static(
                                    intval($orders_id_array[$i]), 
                                    $orders_status_id_record['orders_status'], 
                                    false,
                                    str_replace("'",'"',$comments)
                                );
				xtc_db_query("INSERT INTO payment_orders SET payment_id='".$payment_id."',orders_id='".$orders_id_array[$i]."',created='".$date_mysql."'");
			}
			if($change_order > 0) {
				$order = new order($orders_id_array[$i]);
				$payment_method_query = xtc_db_query("SELECT payment_method,orders_status FROM orders WHERE orders_id='".$orders_id_array[$i]."'");
				$payment_method = xtc_db_fetch_array($payment_method_query);
                                $send_mail = (defined('PAYMENT_CONFIRMATION_EMAIL_ACTIVE') and PAYMENT_CONFIRMATION_EMAIL_ACTIVE == 'true') ? true : false;
				if( xtc_is_shipping_before_payment($payment_method['payment_method']) ){
                                    if( $payment_method['orders_status'] == ORDERS_STATUS_VERSENDET ){
                                        xtc_db_query("update orders set orders_status = '".ORDERS_STATUS_ABGESCHLOSSEN."',date_payment=now(), last_modified=now() where orders_id = '".$orders_id_array[$i]."'");
                                        $order->add_history(ORDERS_STATUS_ABGESCHLOSSEN, 
                                            $send_mail, 
                                            'Zahlungseingang per Filter gebucht.'
                                        );
                                    }else{
                                        if($payment_method['orders_status'] != ORDERS_STATUS_ABGESCHLOSSEN){
                                            xtc_db_query("update orders set orders_status = '".ORDERS_STATUS_BEZAHLT."',date_payment=now(), last_modified=now() where orders_id = '".$orders_id_array[$i]."'");
                                            $order->add_history(ORDERS_STATUS_BEZAHLT, 
                                                $send_mail, 
                                                'Zahlungseingang per Filter gebucht.'
                                            );
                                        }
                                    }
				}else{
                                    // order updaten
                                    xtc_db_query("update orders set orders_status = '".ORDERS_STATUS_BEZAHLT."',date_payment=now(), last_modified=now() where orders_id = '".$orders_id_array[$i]."'");
                                    $order->add_history(ORDERS_STATUS_BEZAHLT, 
                                        $send_mail, 
                                        'Zahlungseingang per Filter gebucht.'
                                    );
				}
				$customer = new customer($order->customer['ID']);
				$customer->update_current_account_value();
								
				// andere payments zur order inaktiv setzen
				$other_pay_query = xtc_db_query("SELECT payment_id FROM payment_orders WHERE orders_id='".$orders_id_array[$i]."' and payment_id != '".$payment_id."'");
				while($other_pay = xtc_db_fetch_array($other_pay_query) ){
					if(!in_array($other_pay['payment_id'],$other_payments) ){
						xtc_db_query("update incoming_payments SET confirmed=1 WHERE id='".$other_pay['payment_id']."'");
						$other_payments[] = $other_pay['payment_id'];
					}
				}
				if($send_mail ){
					$mail_smarty = new yesSmarty;
					$mail_smarty->caching = 0;
					$mail_smarty->assign('language', $_SESSION['language']);

					$mail_smarty->assign('tpl_path','templates/'.CURRENT_TEMPLATE.'/');
					$mail_smarty->assign('logo_path',HTTP_SERVER  . DIR_WS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/img/');
					$adresse  = $order->delivery['name']."<br />";
					$adresse .= (!empty($order->delivery['company'])) ? $order->delivery['company']."<br />" : '';
					$adresse .= $order->delivery['street_address']."<br />";
					if($order->delivery['suburb'] != '')
						$adresse .= $order->delivery['suburb']."<br />";
					$adresse .= "<br />";
					$adresse .= $order->delivery['postcode'] . " " . $order->delivery['city'] . "<br />";
					$adresse .= $order->delivery['country']."<br />";
					$adresse_text = str_replace("<br />","\r\n",$adresse);

					$products_string = '';
					foreach ($order->products as $k=>$products) {
						$products_string .= $products['qty'] . " x " . $products['model'] . "- " . $products['name']."<br />\n";
					}
					$mail_smarty->assign('ADDRESS_TEXT',$adresse_text);
					$mail_smarty->assign('ADDRESS',$adresse);
					$mail_smarty->assign('PRODUCTS',$products_string);
					$mail_smarty->assign('NAME',$order->billing['name']);
					$mail_smarty->assign('STORE_NAME_ADDRESS',STORE_NAME_ADDRESS);
					$mail_html = $mail_smarty->fetch(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/admin/mail/'.$_SESSION['language'].'/payment_confirmation.html');
					$mail_txt = $mail_smarty->fetch(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/admin/mail/'.$_SESSION['language'].'/payment_confirmation.txt');
					xtc_php_mail(EMAIL_BILLING_ADDRESS,
						EMAIL_BILLING_NAME,
						$order->customer['email_address'],
						$order->customer['name'],
						'',
						EMAIL_BILLING_REPLY_ADDRESS,
						EMAIL_BILLING_REPLY_ADDRESS_NAME,
						'',
						'',
						sprintf(PAYMENT_CONFIRMATION_EMAIL_SUBJECT,$orders_id_array[$i]),
						$mail_html,
						$mail_txt
					);
					$dbMail = new DBmail('0');
					$dbMail->save_mail(sprintf(PAYMENT_CONFIRMATION_EMAIL_SUBJECT,$orders_id_array[$i]),
							$order->customer['email_address'],
							EMAIL_BILLING_REPLY_ADDRESS_NAME,EMAIL_BILLING_REPLY_ADDRESS,
							$mail_html,date('Y-m-d H:i:s'), $order->info['ebay_id'],
							$order->customer['ID'],
                                                        $order->info['id']
					);
				}
				// FIBUNUMBER ADDON
				/* KOMPLETT RAUS - TICKET 2096
				if(MODULE_OTHER_FIBUNUMBERS_STATUS == 'True'){
					$fibu_number = $order->get_fibunumber();
					if( (empty($fibu_number) or strlen($fibu_number) <= 1)
						&&	MODULE_OTHER_FIBUNUMBERS_AUTOMATIC == 'True'){
						$fibu_number = $order->add_fibunumber();
						$order->add_history($order->info['orders_status'],false,sprintf(HISTORY_FIBUNUMBER_AUTOMATIC_ADD,$fibu_number));
					}
				}
				 * 
				 */
			}
		}
		if($change_order > 0){
			// wenn keine teilzahlungen und statuswechsel: loeschen
			$valid_orders_statuses = sprintf("1,2,%s,%s",
					ORDERS_STATUS_UPSELLING,ORDERS_STATUS_VERSENDET
			);
			$query = xtc_db_query("SELECT count(1) as anzahl FROM payment_orders po LEFT JOIN orders o USING(orders_id) WHERE po.payment_id='".$payment_id."' AND o.orders_status IN(".$valid_orders_statuses.")");
			$record = xtc_db_fetch_array($double_query);
			if($record['anzahl'] == 0)
				xtc_db_query("UPDATE incoming_payments SET confirmed=1 where id = '".intval(xtc_db_input($payment_id))."'");
		}
	}

	function save_csv_template($title,$zweck1,$zweck2,$name,$betrag) {
		xtc_db_query("INSERT INTO incoming_payment_mask SET title='".$title."',zweck1='".$zweck1."',zweck2='".$zweck2."',name='".$name."',betrag='".$betrag."'");
	}

	function get_active_template() {
		$query = xtc_db_query("SELECT id FROM incoming_payment_mask WHERE active='1' LIMIT 1");
		$row   = xtc_db_fetch_array($query);
		return $row['id'];
	}

	function save_active_template($id) {
		xtc_db_query("UPDATE incoming_payment_mask SET active='0'");
		xtc_db_query("UPDATE incoming_payment_mask SET active='1' WHERE id='".$id."'");
		$insert_id = xtc_db_insert_id();
		return $insert_id;
	}

	function delete_template($id) {
		xtc_db_query("DELETE FROM incoming_payment_mask WHERE id='".$id."'");
	}

	function get_unconfirmed_payment_data($order_by='betrag',$day = '') {
		if($day and $day != '')
			$payment_query_raw = "select * from incoming_payments WHERE confirmed='0' and buchungstag='".xtc_db_input($day)."' order by ".$order_by;
		else
			$payment_query_raw = "select * from incoming_payments WHERE confirmed='0' order by ".$order_by;
		$payment_query = xtc_db_query($payment_query_raw);
		while ($payment = xtc_db_fetch_array($payment_query)) {
			$allocated_orders = array();
			$allocation_query = xtc_db_query("SELECT orders_id FROM payment_orders WHERE payment_id='".$payment['id']."'");
			while($allocation = xtc_db_fetch_array($allocation_query) ){
				$allocated_orders[] = $allocation['orders_id'];
			}
			$payment['orders'] = $allocated_orders;
			$this->payments[] = $payment;
		}
	}

	function _prepare_string($string){
		if(!function_exists('xtc_parse_input_field_data')){
			require_once(DIR_FS_INC.'xtc_parse_input_field_data.inc.php');
		}
		$string = strtolower(trim($string));
		return xtc_parse_input_field_data($string, array('�' => 'ae','�' => 'oe','�' => 'ue', '�' => 'ss'));
	}

	function get_orders_data() {
		$array = array();
		
		// KAUF AUF RECHNG ADDON: NEUEN STATUS VERSENDET BERUECKSICHTIGEN
		$orders_query_raw = "select 
					o.orders_id, o.ebay_id,o.customers_company,
					c.customers_ebay_userid, c.customers_lastname, c.customers_id,
					ot.value, o.payment_transaction_id";
                if(defined('MODULE_OTHER_FIBUNUMBERS_STATUS') and MODULE_OTHER_FIBUNUMBERS_STATUS == 'True'){
                    $orders_query_raw .= ", ofb.fibunumber ";
                }
		$orders_query_raw .= " from orders_total ot ";
                if(defined('MODULE_OTHER_FIBUNUMBERS_STATUS') and MODULE_OTHER_FIBUNUMBERS_STATUS == 'True'){
                    $orders_query_raw .= " LEFT JOIN orders_fibunumbers ofb ON ot.orders_id=ofb.orders_id ";
                }
		$orders_query_raw .= " LEFT JOIN orders o ON ot.orders_id=o.orders_id LEFT JOIN customers c ON c.customers_id=o.customers_id ";
                                
		$orders_query_raw .= " where";
		$orders_query_raw .= " ot.class ='ot_total'";
		$orders_query_raw .= " and o.orders_status IN(1,2,".ORDERS_STATUS_UPSELLING.",".ORDERS_STATUS_VERSENDET;
        $orders_query_raw .= ')';
		$orders_query = xtc_db_query($orders_query_raw);
		while ($orders = xtc_db_fetch_array($orders_query)) {
			$array['oID'][ $orders['orders_id'] ][] = $orders['orders_id'];
                        $array['fibu'][ $orders['fibunumber']][] = $orders['orders_id'];
			$ebay_id_array = $this->get_auction_array($orders['orders_id'],$orders['ebay_id']);
			for($eid=0;$eid<sizeOf($ebay_id_array);$eid++){
				if(xtc_not_null($ebay_id_array[$eid]))
					$array['ebay_id'][$ebay_id_array[$eid]][] = $orders['orders_id'];
			}
			$array['customers_ebay_userid'][strtolower($orders['customers_ebay_userid'])][] = $orders['orders_id'];
			$array['customers_name'][$this->_prepare_string($orders['customers_lastname'])][]  = $orders['orders_id'];
			if($orders['payment_transaction_id'] != ''){
				$pt = explode(' ',$orders['payment_transaction_id']);
				foreach($pt as $ptransid){
					$array['s u'][$this->_prepare_string($ptransid)][] = $orders['orders_id'];
				}
			}
			
			$array['company'][$this->_prepare_string($orders['customers_company'])][]  = $orders['orders_id'];
			$array['customers_id'][$orders['customers_id']][] = $orders['orders_id'];
			$array['ot_total'][ number_format($orders['value'],2,',','.') ][] = $orders['orders_id'];
		}
		$this->orders = $array;
	}

	function _searchEbayId( $string ) {
		$return = false;
		$ebay_id = preg_match('([0-9]{10,20})',$string,$list);
		if(is_countable($list) and sizeOf($list)>0) {
			// list sind alle ebay_ids
			for($list_counter=0; $list_counter < count($list); $list_counter++){
				if( is_countable( $this->orders['ebay_id'][ $list[ $list_counter ] ] ) and sizeOf($this->orders['ebay_id'][ $list[$list_counter] ]) > 0 ){
					foreach($this->orders['ebay_id'][ $list[$list_counter] ] as $k=>$order){
						$return[] = $order;
					}
				}
			}
			return $return;
		}else{
			return $return;
		}
	}

	function _searchOrdersId( $string ) {
		$return = false;
		if( is_countable($this->orders['oID'][ $string]) and sizeOf($this->orders['oID'][ $string] ) > 0 ){
			foreach( $this->orders['oID'][ $string ] as $k=>$order){
				$return[] = $order;
			}
		}
		return $return;
	}

	function _searchFibuNummer( $string ) {
		$return = false;
		if( is_countable($this->orders['fibu'][ $string]) and sizeOf($this->orders['fibu'][ $string] ) > 0 ){
			foreach( $this->orders['fibu'][ $string ] as $k=>$order){
				$return[] = $order;
			}
		}
		return $return;
	}

	function _searchEbayUserId( $string ) {
		$return = false;
		if( is_countable($this->orders['customers_ebay_userid'][ $string ])){
			foreach($this->orders['customers_ebay_userid'][ $string ] as $k=>$order){
				$return[] = $order;
			}
		}
		return $return;
	}

	function _searchCustomersName( $string ) {
		$return = false;
		if( is_countable($this->orders['customers_name'][ $string ]) and sizeOf($this->orders['customers_name'][ $string ]) > 0 ){
			foreach($this->orders['customers_name'][ $string ] as $k=>$order){
				$return[] = $order;
			}
		}
		return $return;
	}

	function _searchPaymentTransactionID( $string ) {
		$return = false;
		if( is_countable($this->orders['payment_transaction_id'][ $string ]) and sizeOf($this->orders['payment_transaction_id'][ $string ]) > 0 ){
			foreach($this->orders['payment_transaction_id'][ $string ] as $k=>$order){
				$return[] = $order;
			}
		}
		return $return;
	}

	function _searchCompany( $string ) {
		$return = false;
		if( is_countable($this->orders['company'][ $string ]) and sizeOf($this->orders['company'][ $string ]) > 0 ){
			foreach($this->orders['company'][ $string ] as $k=>$order){
				$return[] = $order;
			}
		}
		return $return;
	}

	function _searchPayment( $string ) {
		$return = false;
		$string = eregi_replace('euro','',$string);
		$string = eregi_replace('eur','',$string);
		$string = eregi_replace('eu','',$string);
		$string = trim($string);
		if( (int)$string > 0 ){
			if( is_countable($this->orders['ot_total'][ $string ]) and sizeOf($this->orders['ot_total'][ $string ]) > 0 ){
				foreach( $this->orders['ot_total'][ $string ] as $k=>$order ){
					$return[] = $order;
				}
			}
		}
		return $return;
	}

	function filter( $allocateds=array() ) {
		$pID = $this->get_payment_id();
		$view = array();
		$this->get_orders_data();
		
		$words = $this->split_string( $this->text_raw );
		if(is_countable($words) and sizeOf($words)>0){
			foreach( $words as $string=>$k ){
				$string = $this->_prepare_string($string);
				$res = $this->_searchEbayId( $string);
				if( is_countable($res) and sizeOf($res) > 0 ){
					$matched_orders[] = array('payment_id'=>$pID,'ebay_id' => $res );
				}
				
				$res = $this->_searchEbayUserId( $string );
				if( is_countable($res) and sizeOf($res) > 0 ){
					$matched_orders[] = array('payment_id'=>$pID,'ebay_user' => $res);
				}
				
				$res = $this->_searchPaymentTransactionID( $string );
				if( is_countable($res) and sizeOf($res) > 0 ){
					$matched_orders[] = array('payment_transaction_id'=>$pID,'payment_transaction_id' => $res);
				}
                $_matches = [];
				if (preg_match('/[^a-zäöüß\s]/iu', $string, $_matches)) {
				//if(!eregi("[^a-z����]",$string,$_matches)){ // alt 2025/05
					$res = $this->_searchCustomersName( $string );
					if( is_countable($res) and sizeOf($res) > 0 and $res != ''){
						$matched_orders[] = array('payment_id'=>$pID,'shop_user' => $res );
					}else{
						$match = $this->search_lev($string);
						if($match)
							$matched_orders[] = array('payment_id'=>$pID,'shop_user' => $match);
					}
				}else{
					$res = $this->_searchCustomersName( $string );
					if( is_countable($res) and sizeOf($res) > 0 ){
						$matched_orders[] = array('payment_id'=>$pID,'shop_user' => $res );
					}
				}

				$res = $this->_searchCompany( $string );
				if( is_countable($res) and sizeOf($res) > 0 ){
					$matched_orders[] = array('payment_id'=>$pID,'company' => $res );
				}
				
				$res = $this->_searchOrdersId( $string );
				if( is_countable($res) and sizeOf($res) > 0 ){
					$matched_orders[] = array('payment_id'=>$pID,'orders_id' =>$res);
				}
				
				$res = $this->_searchFibuNummer( $string );
				if( is_countable($res) and sizeOf($res) > 0 ){
					$matched_orders[] = array('payment_id'=>$pID,'fibu' =>$res);
				}

				$res = $this->_searchPayment( $this->betrag );
				if( is_countable($res) and sizeOf($res) > 0 ){
					$matched_orders[] = array('payment_id'=>$pID,'payment' =>$res);
				}


			}
		}
		$res = $this->_searchPayment( $this->betrag );
		if( is_countable($res) and count( $res ) > 0 ){
			$matched_orders[] = array('payment_id'=>$pID,'payment' => $res );
		}
		if(is_countable($matched_orders) and is_array($matched_orders)){
			foreach($matched_orders as $payID=>$payment_class){
				if(is_countable($payment_class)){
					foreach($payment_class as $class=>$v) {
						switch($class){
							case 'ebay_id':
								if(is_countable($v))
									foreach($v as $nr=>$oID) {
										if( !in_array($oID,$allocateds) )
											$view[$oID][] = $class;
									}
								break;
							case 'ebay_user':
								if(is_countable($v))
									foreach($v as $nr=>$oID) {
										if( !in_array($oID,$allocateds) )
											$view[$oID][] = $class;
									}
								break;
							case 'company':
								if(is_countable($v))
									foreach($v as $nr=>$oID) {
										if( !in_array($oID,$allocateds) )
											$view[$oID][] = $class;
									}
								break;
							case 'shop_user':
								if(is_countable($v))
									foreach($v as $nr=>$oID) {
										if( !in_array($oID,$allocateds) )
											$view[$oID][] = $class;
									}
								break;
							case 'orders_id':
								if(is_countable($v))
									foreach($v as $nr=>$oID) {
										if( !in_array($oID,$allocateds) )
											$view[$oID][] = $class;
									}
								break;
							case 'fibu':
								if(is_countable($v))
									foreach($v as $nr=>$oID) {
										if( !in_array($oID,$allocateds) )
											$view[$oID][] = $class;
									}
								break;
							case 'payment':
								if(is_countable($v))
									foreach($v as $nr=>$oID) {
										if( !in_array($oID,$allocateds) )
											$view[$oID][] = $class;
									}
								break;
							case 'payment_transaction_id':
								if(is_countable($v))
									foreach($v as $nr=>$oID) {
										if( !in_array($oID,$allocateds) )
											$view[$oID][] = $class;
									}
								break;
						}
					}
				}
			}
		}
		return $view;
	}

	function search_lev($input){
		$words = array_keys($this->orders['customers_name']);
		// noch keine k�rzeste Distanz gefunden
		$shortest = -1;

		// durch die Wortliste gehen, um das �hnlichste Wort zu finden
		foreach ($words as $word) {
			// berechne die Distanz zwischen Inputwort und aktuellem Wort
			$lev = levenshtein($input, $word);

			  // auf einen exakten Treffer pr�fen
			  if ($lev == 0) {

				  // das n�chste Wort ist das Wort selbst (exakter Treffer)
				  $closest = $word;
				  $shortest = 0;

				  // Schleife beenden, da wir einen exakten Treffer gefunden haben
				break;
			}

			// Wenn die Distanz kleiner ist als die n�chste gefundene kleinste Distanz
			// ODER wenn ein n�chstkleineres Wort noch nicht gefunden wurde
			if ($lev <= $shortest || $shortest < 0) {
				// setze den n�chstliegenden Treffer und die k�rzestes Distanz
				$closest  = $word;
				$shortest = $lev;
			}
		}
		if($shortest <= 1)
			return $this->orders['customers_name'][$closest];
		else
			return false;
	}

	function split_string($string) {
		$array = array();
		if(trim($string)!=''){
			$words = str_replace(":"," ",$string);
			$words = str_replace("<br>"," ",$words);
			$words = str_replace(","," ",$words);
			$words = explode(' ',$words);
			if(is_countable($words) and sizeOf($words)>0){
				foreach($words as $k=>$v){
					if(trim($v)!='')
						$array[trim(strtolower($v))] = true;
				}
			}
		}
		return $array;
	}
	
	function delete_payment($payment_id){
		if($payment_id > 0){
			xtc_db_query("DELETE FROM payment_orders WHERE payment_id='".(int)xtc_db_input($payment_id)."'");
			xtc_db_query("DELETE FROM incoming_payments WHERE id='".(int)xtc_db_input($payment_id)."'");
			return true;
		}else{
			return false;
		}
		return true;
	}
	
	function delete_payment_order($payment_id,$oID,$update_confirmed = false){
		if($payment_id > 0 && $oID > 0){
			if($update_confirmed){
				xtc_db_query(sprintf(
					"UPDATE incoming_payments SET confirmed='0' WHERE id='%s'",
					$payment_id
				));
			}
			xtc_db_query("DELETE FROM payment_orders WHERE payment_id='".(int)xtc_db_input($payment_id)."' && orders_id='".$oID."'");
		}else{
			return -1;
		}
	}

	/**
	* BEI KOMBINIERTEN AUFTRAEGEN KOENNEN MEHR ALS EINE
	* AUKTIONSNUMMERN ENTHALTEN SEIN
	*
	* @return array ebay_id
	*/
	//
	function get_auction_array($orders_id,$orig_ebay_id){
		$ebay_id = array();
  		$child_orders = array();
		$query = xtc_db_query("SELECT orders_id FROM ".TABLE_ORDERS." WHERE combined_orders_id = '".$orders_id."'");
	  	while($res = xtc_db_fetch_array($query)) {
			$child_orders[] = $res['orders_id'];
	  	}
		if(!sizeOf($child_orders))
			return array($orig_ebay_id);

		foreach($child_orders as $combined_id){
			$ebay_id_query = xtc_db_query(sprintf(
				"SELECT ebay_id FROM orders WHERE orders_id='%s'",
				$combined_id
			));
			$ebay_id_result = xtc_db_fetch_array($ebay_id_query);
			if(xtc_not_null($ebay_id_result['ebay_id']))
				$ebay_id[] = $ebay_id_result['ebay_id'];
		}
		return $ebay_id;
	}

}
