<?php
// BOF - INCLUDES SPEZIELL FUER ORDER PDF KRAM
if(!function_exists('xtc_get_orders_ebay_seller')){
    require_once(DIR_FS_INC.'xtc_get_orders_ebay_seller.inc.php');
}
if(!function_exists('xtc_format_price_order')){
    require_once(DIR_FS_INC.'xtc_format_price_order.inc.php');
}
if(!function_exists('xtc_generate_packingslip_barcode')){
    require_once(DIR_FS_INC.'xtc_generate_packingslip_barcode.inc.php');
}


if(!class_exists('CSVfile')){
    require_once(DIR_FS_CATALOG.'admin/includes/classes/class.csv.php');
}
// EOF - SPEZIELL FUER ORDER


class counter_history {
    var $secure_path, $save_path, 
            $save_file_prefix = 'DOKUMENT_',
            $errors, $branches_id,
            $SUMMARY_DIR = 'DAILY',
            $SUMMARY_PATH_PREFIX = 'TAGESABSCHLUSS_FILIALE_',
            $DAILY_PATH_PREFIX = 'FILIALE_',
            $DAILY_ZIP_FILENAME = 'TAGESABSCHLUSS_FILIALE_%s.zip';
    
    function __construct($branches_id){
        $this->setSecure_path(main::get_secure_path());
        $this->setSave_path($this->getSecure_path().'counter_history'.DIRECTORY_SEPARATOR);
        if(!is_dir($this->getSave_path())){
            mkdir($this->getSave_path());
        }
        $this->setBranches_id($branches_id);
        if(!class_exists('ZipArchive')){
            $this->add_error('PHP ZipArchive must be enabled');
            $this->shutdown();
        }
    }
    
    public function getBranches_id() {
        return $this->branches_id;
    }

    public function setBranches_id($branches_id) {
        $this->branches_id = $branches_id;
    }

    private function add_error($err){
        $this->errors[] = $err;
    }
    
    public function getErrors(){
        return $this->errors;
    }
    function getSave_file_prefix() {
        return $this->save_file_prefix;
    }

    function setSave_file_prefix($save_file_prefix) {
        $this->save_file_prefix = $save_file_prefix;
    }

    function getSecure_path() {
        return $this->secure_path;
    }

    function getSave_path() {
        return $this->save_path;
    }

    function setSecure_path($secure_path) {
        $this->secure_path = $secure_path;
    }

    function setSave_path($save_path) {
        $this->save_path = $save_path;
    }
    
    private function check_if_file_is_pdf($file){
        if(mime_content_type($file) != 'application/pdf' or stripos($file,'.pdf') === false or !is_file($file) or !is_readable($file)){
            return false;
        }
        return true;
    }
    
    private function get_save_file_path(DateTime $date, $save_as_name){
        $date_save_path = $this->get_date_savepath($date);
        return $date_save_path.$this->get_next_filename($date_save_path,$save_as_name,$date);
    }

    private function get_files_from_directory($path){
        $files = array();
        foreach(scandir($path) as $f){
            if(!is_file($path.$f)){
                continue;
            }
            $files[] = $path.$f;
        }
        return $files;
    }
    private function get_next_filename($path, $file, DateTime $date){
        $number_of_files = sizeof($this->get_files_from_directory($path));
        return sprintf('%s%s--%s--%s',
                $this->getSave_file_prefix(),
                sprintf('%04d', ($number_of_files+1)), 
                $date->format('H_i_s'),
                basename($file)
        );
    }
    
    private function get_date_savepath(DateTime $date){
        $date_save_path = $this->getSave_path().$date->format('Y-m-d').DIRECTORY_SEPARATOR;
        if(!is_dir($date_save_path)){
            mkdir($date_save_path);
        }
        $date_save_path .= $this->DAILY_PATH_PREFIX.$this->getBranches_id().DIRECTORY_SEPARATOR;
        if(!is_dir($date_save_path)){
            mkdir($date_save_path);
        }
        return $date_save_path;
    }
    
    public function get_counter_activities(DateTime $date){
        $activities = array(
            'counter'=>array(),
            'reimbursements'=>array()
        );
        $query = xtc_db_query(sprintf(
                "SELECT * FROM kasse WHERE date_purchased >= '%s' AND date_purchased <= '%s' AND branches_id='%s'",
                $date->format('Y-m-d 00:00:00'),
                $date->format('Y-m-d 23:59:59'),
                $this->getBranches_id()
        ));
        while($record = xtc_db_fetch_array($query)){
            $activity_group = ($record['orders_id']>0) ? 'counter' : 'reimbursements';
            $activities[$activity_group][] = $record;
        }
        return $activities;
    }
    
    /**
     * ERWARTET DIE INSTANZ DES AUFTRAGS ODER DER RUECK, EINE SMARTY INSTANZ
     * SOWIE EIN ARRAY FUER DEN kasse EINTRAG
     * WENN DOMPDF AKTIVIERT IST, WIRD EIN PDF ERZEUGT
     * UND DER HISTORIE HINZUGEFUEGT
     * SQL ARRAY STRUKTUR:
     * 
        array(
            'orders_id'=>INT, // oder rueck
            'rueckerstattungen_id'=>INT, // oder order
            'paymode'=>'bar1',
            'customers_id'=>INT,
            'date_purchased'=>DATE,
            'total'=>INT,
            'branches_id'=>INT
        )
     * 
     * @param array SQL INSERT ARRAY FUER kasse
     * @return boolean
     */
    public function insert_entry( $target_class, yesSmarty $smarty, array $kasse_insert_sql ){
        if(!defined('USE_DOMPDF') or USE_DOMPDF != 'True'){
            xtc_db_perform('kasse',$kasse_insert_sql);
            return true;
        }
        $target_html_function = '';
        switch(get_class($target_class)){   
            case 'order':
                $target_html_function = 'xtc_get_order_html_for_pdf';
                $template = 'mail/german/pdf_order.html';
                $save_as_name = sprintf(
                        'ORDER_%s.pdf',
                        $target_class->info['id']
                );
                break;
            case 'rueckerstattung':
                $target_html_function = 'xtc_get_rueckerstattung_html_for_pdf';
                $template = 'pdf_rueckerstattung.html';
                $save_as_name = sprintf(
                        'RUECK_%s.pdf',
                        $target_class->info['id']
                );
                break;
            default:
                $this->add_error('insert_entry: invalid target class');
                break;
        }
        if(!empty($target_html_function) and !function_exists($target_html_function)){
            require_once(DIR_FS_INC.$target_html_function.'.inc.php');
        }
        $template = sprintf('%s/templates/%s/admin/%s',
            DIR_FS_CATALOG,
            CURRENT_TEMPLATE,
            $template
        );
        if(!is_file($template)){
            $this->add_error(sprintf('%s PDF Template not found (%s)',
                get_class($target_class),basename($template)
            ));
        }
        $content = $target_html_function($target_class, $smarty, $template);
        $yes_pdf = new yes_pdf;
        $yes_pdf->set_html($content);
        $filename = $this->get_save_file_path(new DateTime('now'), $save_as_name);
        if(is_countable($this->getErrors()) and sizeOf($this->getErrors())){
            $this->shutdown();
        }
        $yes_pdf->save($filename);
        xtc_db_perform('kasse',$kasse_insert_sql);
    }
    
    private function shutdown(){
        throw new Exception(implode("\r\n",$this->getErrors()));
    }
    
    private function get_summary_savepath(DateTime $date){
        if(!is_dir($this->getSave_path().$this->SUMMARY_DIR)){
            mkdir($this->getSave_path().$this->SUMMARY_DIR);
        }
        $summary_save_path = $this->getSave_path().$this->SUMMARY_DIR.DIRECTORY_SEPARATOR.$date->format('Y-m-d').DIRECTORY_SEPARATOR;
        if(!is_dir($summary_save_path)){
            mkdir($summary_save_path);
        }
        return $summary_save_path.$this->SUMMARY_PATH_PREFIX.$this->getBranches_id().'.csv';
    }
    
    private function write_daily_summary_to_csv($save_as_name,$activities,$date){
        $total = 0;
        touch($save_as_name);
        $CSV = new CSVfile($save_as_name);
    	$CSV->open("w");
        $CSV->delimiter = "\t";
        $CSV->addRow(array(
            'AUFTRAG','RUECKERSTATTUNG','ERSTELLT','BETRAG','BEZAHLART'
        ));
        foreach($activities as $source=>$transactions){
            foreach($transactions as $trans){
                $CSV->addRow(array(
                    ($source == 'counter') ? $trans['orders_id'] : '',
                    ($source == 'reimbursements') ? $trans['rueckerstattungen_id'] : '',
                    $trans['date_purchased'],
                    $trans['total'],
                    ($trans['paymode'] == 'bar1') ? 'bar' : $trans['paymode']
                ));
                $total += $trans['total'];
            }
        }
        $CSV->addRow(array(
            sprintf(
                    'Gesamt %s:',$date->format('d.m.Y')
            ),$total,
            '','',''
        ));
        $CSV->close();
    }
    private function write_summary_zip($files, $filename){
        $zip = new ZipArchive();

        if ($zip->open($filename, ZipArchive::CREATE)!==TRUE) {
            $this->add_error('Cant create '.$filename);
            $this->shutdown();
        }
        foreach($files as $file){
            $zip->addFile($file,basename($file));
        }
        $zip->close();
    }

    public function daily_summary(DateTime $date){
        $to_zip = array();
        $activities = $this->get_counter_activities($date);
        if(!sizeOf($activities['counter']) and !sizeOf($activities['reimbursements'])){
            return false;
        }
        $save_as_name = $this->get_summary_savepath($date);
        $pi = pathinfo($save_as_name);
        $this->write_daily_summary_to_csv($save_as_name, $activities, $date);
        $to_zip[] = $save_as_name;
        $date_path = $this->get_date_savepath($date);
        foreach($this->get_files_from_directory($date_path) as $file){
            $to_zip[] = $file;
        }
        $zip_file_path = $pi['dirname'].DIRECTORY_SEPARATOR.sprintf($this->DAILY_ZIP_FILENAME,$this->getBranches_id());
        $this->write_summary_zip($to_zip, $zip_file_path);
        unlink($save_as_name); // TAGESABSCHLUSS_FILALE_x.csv LOESCHEN
        return $zip_file_path;
    }
}
