<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                             Author M. ASPELEITER <dazze@gmx.de>
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/

class distributor_invoice {
    var $info, $totals, $products, $entries,$distributor,$installments;

    function __construct($distributor_invoice_id) {
      $this->info = array();
      $this->totals = array();
      $this->entries = array();
      $this->products = array();
      $this->distributor = array();
      $this->installments = array();
      $this->query($distributor_invoice_id);
    }

    function query($distributor_invoice_id) {
		$distributor_invoice_query = xtc_db_query("select *
                                  from distributor_invoices di where
                                  distributor_invoices_id = '" . xtc_db_input($distributor_invoice_id) . "'");

		$distributor_invoice = xtc_db_fetch_array($distributor_invoice_query);

		$totals_query = xtc_db_query("select * from distributor_invoices_total where distributor_invoices_id = '" . xtc_db_input($distributor_invoice_id) . "' order by sort_order");
		while ($totals = xtc_db_fetch_array($totals_query)) {
			$this->totals[] = array('title' => $totals['title'],
                                'text' => $totals['text'],
                                'value' => $totals['value'],
                                'id' => $totals['distributor_invoices_id'],
                                'otid' => $totals['distributor_invoices_total_id'],
                                'class' => $totals['class']);
		}
		// invoice type kann 'installment' (Teilzahlungen) oder 'receipt' (Wareneingang) sein
		$this->info = array(
                    'status' => $distributor_invoice['status'],
                    'date_created' => $distributor_invoice['date_created'],
                    'payment_target'=>$distributor_invoice['payment_target'],
                    'date_finished'=>$distributor_invoice['date_finished'],
                    'id' => $distributor_invoice['distributor_invoices_id'],
                    'distributor_id' => $distributor_invoice['distributor_id'],
                    'distributor_orders_id' => $distributor_invoice['distributor_orders_id'],
                    'original_invoice_id'=>$distributor_invoice['original_invoice_id'],
                    'currency'=>$distributor_invoice['currency'],
                    'from_date'=>$distributor_invoice['from_date'],
                    'last_modified' => $distributor_invoice['last_modified'],
                    'reasons_id'=>$distributor_invoice['reasons_id'],
                    'invoice_type'=> $distributor_invoice['invoice_type'],
                    'payment_terms'=>$distributor_invoice['payment_terms']
		);
	
		$this->distributor = array('name' => $distributor_invoice['distributor_name'],
								  'id' => $distributor_invoice['distributor_id'],
								  'street_address' => $distributor_invoice['distributor_street_address'],
								  'city' => $distributor_invoice['distributor_city'],
								  'postcode' => $distributor_invoice['distributor_postcode'],
								  'telephone' => $distributor_invoice['distributor_telephone'],
								  'country' => $distributor_invoice['distributor_country'],
								  'email_address' => $distributor_invoice['distributor_email_address']);
	
		$i = 0;
		$entries_query = xtc_db_query("SELECT * FROM distributor_invoices_entries WHERE distributor_invoices_id='".$distributor_invoice_id."'");
		while($entry = xtc_db_fetch_array($entries_query)){
			$this->entries[$i] = array('qty' => $entry['quantity'],
								  'id' => $entry['distributor_invoices_entries_id'],
								  'title' => xtc_db_prepare_input($entry['entry_title']),
								  'price' => $entry['entry_price'],
								  'price_netto' => $entry['entry_price']/(($entry['entry_tax']+100)/100),
								  'tax' => $entry['entry_tax'],
								  'total'=>$entry['entry_price']*$entry['quantity']);
				$i++;
		}
	
		$i = 0;
		$products_query = xtc_db_query("SELECT dip.*,pd.distributor_products_link FROM distributor_invoices_products dip LEFT JOIN products_distributors pd USING(products_id) WHERE dip.distributor_invoices_id='".$distributor_invoice_id."' and pd.distributor_id='".$distributor_invoice['distributor_id']."'");
		while($product = xtc_db_fetch_array($products_query)){
			$netto = ($product['products_price']/((100+$product['products_tax'])/100));
			$this->products[$i] = array('distributor_invoices_products_id'=>$product['distributor_invoices_products_id'],
				'distributor_invoices_id'=>$product['distributor_invoices_id'],
				'id'=>$product['products_id'],
				'model'=>$product['products_model'],
				'distributor_link'=>$product['distributor_products_link'],
				'name'=>$product['products_name'],
				'link'=>xtc_href_link('categories.php','pID='.$product['products_id'].'&cPath='.xtc_get_product_path($product['products_id']).'&action=new_product'),
				'price'=>$product['products_price'],
				'price_netto'=>$netto,
				'discount'=>$product['products_discount_made'],
				'final_price'=>$product['final_price'],
				'tax'=>$product['products_tax'],
				'qty'=>$product['products_quantity'],
				'allow_tax'=>$product['allow_tax'],
				'stuecklisten_id'=>$product['stuecklisten_id'],
				'collie_qty'=>$product['collie_qty'],
				'stuecklistenartikel'=>$product['stuecklistenartikel'],
				'properties'=>$this->get_properties($product['distributor_invoices_products_id'])
			);
			$i++;
		}
	
		$i = 0;
		$installments_query = xtc_db_query("SELECT * FROM distributor_invoices_installments WHERE distributor_invoices_id='".$distributor_invoice_id."'");
		while($installment = xtc_db_fetch_array($installments_query)){
			$this->installments[$i] = array('id'=>$installment['distributor_invoices_installments_id'],
					  'installment' => $installment['installment'],
					  'payment_method' => xtc_db_prepare_input($installment['payment_method']),
					  'date_payment'=>$installment['date_payment']);
			$i++;
		}
    }
    function calc_new(){
		$total = 0;
		for($i=0;$i<sizeOf($this->entries);$i++){
			$total += $this->entries[$i]['qty']*$this->entries[$i]['price'];
		}
		$update_sql_array = array(
			'text'=>number_format($total,2,',','.').' '.$this->info['currency'],
			'value'=>$total,
		);
		xtc_db_perform('distributor_invoices_total',$update_sql_array,'update',"distributor_invoices_id='".$this->info['id']."' and class='ot_subtotal'");
		xtc_db_perform('distributor_invoices_total',$update_sql_array,'update',"distributor_invoices_id='".$this->info['id']."' and class='ot_total'");
    }
	
    function get_total_sum(){
		$total = 0;
		for($i=0;$i<sizeOf($this->totals);$i++){
			if($this->totals[$i]['class'] == 'ot_total')
				$total = $this->totals[$i]['value'];
		}
		return $total;
    }
	
    function get_installments_sum(){
		$total = 0;
		for($i=0;$i<sizeOf($this->installments);$i++){
			$total += $this->installments[$i]['installment'];
		}
		return $total;
    }
	
	public static function insert_history_static(int $distributor_invoices_id, int $status,bool $customer_notified,string $comments,int $usr = null){
            if($usr === null){
                $usr = intval($_SESSION['customer_id']??0);
            }
            $insert_sql_array = array('distributor_invoices_id'=>$distributor_invoices_id,
                'distributor_invoices_status_id'=>$status,
                'date_added'=>date('Y-m-d H:i:s'),
                'customer_notified'=>($customer_notified)?1:0,
                'comments'=>$comments,
                'editor_id'=>$usr
            );
            xtc_db_perform('distributor_invoices_status_history',$insert_sql_array);
	}
	
	function insert_history($status,$customer_notified,$comments,$usr){
		$insert_sql_array = array('distributor_invoices_id'=>$this->info['id'],
			'distributor_invoices_status_id'=>$status,
			'date_added'=>'now()',
			'customer_notified'=>$customer_notified,
			'comments'=>$comments,
			'editor_id'=>$usr
		);
		xtc_db_perform('distributor_invoices_status_history',$insert_sql_array);
	}
	
	function update_status($status,&$msg,$usr=0){
		if($status == 2){
			$update_sql_array = array(
				'status'=>$status,
				'date_finished'=>"now()",
				'last_modified'=>"now()"
			);
		}else if($status == 1){
			$update_sql_array = array(
				'status'=>$status,
				'date_finished'=>"",
				'last_modified'=>"now()"
			);
		}else{
			$update_sql_array = array(
				'status'=>$status,
				'last_modified'=>"now()"
			);
		}
		xtc_db_perform('distributor_invoices',$update_sql_array,'update',"distributor_invoices_id='".$this->info['id']."'");
		$status_name = $this->get_invoice_status_name($status);
		$msg = 'Die Lieferantenrechnung wurde auf den Status '.$status_name.' gesetzt. '.$msg;
		$this->insert_history($status,$customer_notified='0',$msg,$usr);
	}
	
	function get_invoice_status_name($status_id){
		$invoice_status_query = xtc_db_query("SELECT distributor_invoices_status_name FROM distributor_invoices_status WHERE distributor_invoices_status_id='".$status_id."'");
		$invoice_status = xtc_db_fetch_array($invoice_status_query);
		return xtc_db_prepare_input($invoice_status['distributor_invoices_status_name']);
	}
	
	function delete(&$msg,$usr){
		xtc_db_query("DELETE FROM distributor_invoices WHERE distributor_invoices_id='".$this->info['id']."' LIMIT 1");
		xtc_db_query("DELETE FROM distributor_invoices_entries WHERE distributor_invoices_id='".$this->info['id']."'");
		
		$query = xtc_db_query(sprintf(
			"SELECT distributor_invoices_products_id FROM distributor_invoices_products WHERE distributor_invoices_id='%s'",
			$this->info['id']
		));
		while($record = xtc_db_fetch_array($query)){
			xtc_db_query(sprintf(
				"DELETE FROM distributor_invoices_products_properties WHERE distributor_invoices_products_id='%s'",
				$record['distributor_invoices_products_id']
			));
		}
		xtc_db_query("DELETE FROM distributor_invoices_products WHERE distributor_invoices_id='".$this->info['id']."'");
		
		
		xtc_db_query("DELETE FROM distributor_invoices_installments WHERE distributor_invoices_id='".$this->info['id']."'");
		xtc_db_query("DELETE FROM distributor_invoices_status_history WHERE distributor_invoices_id='".$this->info['id']."'");
		xtc_db_query("DELETE FROM distributor_invoices_total WHERE distributor_invoices_id='".$this->info['id']."'");
		$msg = 'Die Lieferantenrechnung Nr. '.$this->info['id'].' wurde geloescht.';
		if($this->info['distributor_orders_id']>0){
			$do = new distributor_order($this->info['distributor_orders_id']);
			$do->insert_history($do->info['orders_status'],$customer_notified='0',$msg,$usr);
		}
	}
	
	function delete_installment($iID,$usr){
			xtc_db_query("DELETE FROM distributor_invoices_installments WHERE distributor_invoices_id='".$this->info['id']."' and distributor_invoices_installments_id='".$iID."'");
			$msg = 'Ueberweisung geloescht';
			$this->insert_history($this->info['status'],$customer_notified='0',$msg,$usr);
	}
	
	function update_installment($iID,$installment,$payment_method,$usr){
		$update_sql_array = array(
			'installment'=>$installment,
			'payment_method'=>$payment_method
		);
		xtc_db_perform('distributor_invoices_installments',$update_sql_array,'update',"distributor_invoices_id='".$this->info['id']."' and distributor_invoices_installments_id='".$iID."'");
		$msg = 'Ueberweisung geaendert zu - Titel: '.$payment_method.' / Betrag: '.$installment;
		$this->insert_history($this->info['status'],$customer_notified='0',$msg,$usr);
	}
	
	function insert_installment($installment,$payment_method,$usr){
		$insert_sql_array = array(
			'distributor_invoices_id'=>$this->info['id'],
			'date_payment'=>'now()',
			'installment'=>$installment,
			'payment_method'=>$payment_method
		);
		xtc_db_perform('distributor_invoices_installments',$insert_sql_array);
		$msg = 'Ueberweisung Titel: '.$payment_method.' / Betrag: '.$installment.' gespeichert.';
		$this->insert_history($this->info['status'],$customer_notified='0',$msg,$usr);
	}
	
	public function get_properties($dipID){
		$properties_array = array();
		$properties_query = xtc_db_query(sprintf(
			"SELECT property_title,property_value FROM distributor_invoices_products_properties WHERE distributor_invoices_products_id='%s'",
			$dipID
		));
		if(xtc_db_num_rows($properties_query)){
			while($properties = xtc_db_fetch_array($properties_query)){
				 $properties_array[] = $properties;
			}
		}
		return $properties_array;
	}
	
}
