<?php
if (!function_exists('getimagesizefromstring')) {
    function getimagesizefromstring($data)
    {
        $uri = 'data://application/octet-stream;base64,' . base64_encode($data);
        return getimagesize($uri);
    }
}

/**
 * Created by PhpStorm.
 * User: daniel
 * Date: 28.08.15
 * Time: 14:08
 */
class eosWeb
{
    /**
     * @var bool
     */
    private $debug = false;

    /**
     * @var string
     */
    private $eosWebUser = '';

    /**
     * @var string
     */
    private $eosWebPassword = '';

    /**
     * @var string
     */
    private $url = 'http://www1.eosweb.de/eosweb/index.php';

    /**
     * @var string
     */
    private $Session = '';

    /**
     * @var string
     */
    private $eosWeb_X1 = '';

    /**
     * @var string
     */
    private $eosWeb_X2 = '';

    /**
     * @var int
     */
    private $pic_min_size = 500;

    /**
     * @var resource
     */
    private $curl = null;

    /**
     * Anmeldeinformationen in Klasse sichern und Session erzeugen.
     * @param string $eosWebUser
     * @param string $eosWebPassword
     */
    public function __construct($eosWebUser, $eosWebPassword)
    {
        $this->eosWebUser = $eosWebUser;
        $this->eosWebPassword = $eosWebPassword;
        $this->getSession();

        if ($this->debug) {
            print_r($this);
            var_dump($this->Session);
            exit;
        }

    }

    /**
     * Artikelnummer, alle Zeichen ausser Dezimalzeichen werden entfernt
     * @param string $articleNumber
     * Produktinformationen mit laden?
     * @param bool $more
     * Produktbild mit laden und als Base64 ausgeben.
     * @param bool $loadImage
     * @return array
     */
    public function getProduct($articleNumber, $more = false, $loadImage = false)
    {
        preg_match_all('/[\dA-Z]{1,}/', strtoupper($articleNumber), $matches);
        $productNumber = implode('', $matches[0]);
        $article = $this->setArticle($productNumber);
        return $this->forceUTF8($this->getArticle($article, $productNumber, $more, $loadImage));
    }

    /**
     * minimale Größe des Produktbildes
     * @param int $pic_min_size
     * @return bool
     */
    public function setPicMinSize($pic_min_size = 500)
    {
        if (is_int($pic_min_size)) {
            $this->pic_min_size = $pic_min_size;
            return true;
        }
        return false;
    }

    /**
     * @param $productNumber
     * @return string
     */
    private function setArticle($productNumber)
    {
        $hierarchie = null;

        $post = array();

        $cookie = array(
            'PHPSESSID' => $this->Session,
            'EOSWEB::X1' => $this->eosWeb_X1,
            'EOSWEB::X2' => $this->eosWeb_X2,
        );

        $get = array(
            'hirID' => -1,
            'typ' => 'artikel',
            'q' => $productNumber,
            'func' => 'suche',
        );

        $this->getURL($this->url, $get, $post, $cookie);
        $get = array(
            'func' => 'gruppenuebersicht',
            'aktion' => 'suche',
            'hirID' => -1,
            'typ' => 'artikel',
            'q' => $productNumber,
            'searchHirID' => -1,
            'part' => 'noheader',
        );

        return $this->getURL($this->url, $get, $post, $cookie);
    }

    /**
     * @param $page
     * @param $productNumber
     * @param bool $more
     * @param bool $loadImage
     * @return array|bool
     */
    private function getArticle($page, $productNumber, $more = false, $loadImage = false)
    {
        if (array_key_exists('body', $page) && stripos($page['body'], $productNumber) !== false) {
            $return = array();

            $exp_fieldset = explode('</fieldset>', $page['body']);
            $fieldset = null;
            foreach ($exp_fieldset as $f) {
                if (stripos($f, 'artnr_' . $productNumber . '_')) {
                    $fieldset = $f;
                    break;
                }
            }

            //Bildurl per Regexp raussuchen
            if (preg_match('/(<a.*)(http)(.*)(images\/artikel_xl\/)(.*">)/', $fieldset, $matches)) {
                $return['bildurl'] = array();
                $tag = implode('', $matches);

                if (preg_match_all('/(href|rel|title)="([^"]*)"/i', $tag, $tag_matches)) {
                    $group_id = $tag_matches[2][2];
                    list($url) = explode('?', $tag_matches[2][1]);
                    $exp_url = explode('/', $url);
                    $url_index = array_pop($exp_url);
                    $return['bildurl'][$url_index] = $url;
                    $regexp = '/=\"(http)(.*)(images\/artikel_xl\/)(.*)\?t.*\".*rel=\"' . $group_id . '.*\"/im';
                    if (preg_match_all($regexp, $fieldset, $matches)) {
                        if (count($matches[0])) {
                            $return['bildurl'] = array();
                            array_shift($matches);
                            foreach ($matches as $arr) {
                                foreach ($arr as $k => $v) {
                                    list(, $key) = explode('/', $matches[count($matches) - 1][$k], 2);
                                    if (array_key_exists($key, $return['bildurl'])) {
                                        $return['bildurl'][$key] .= $v;
                                    } else {
                                        $return['bildurl'][$key] = $v;
                                    }
                                }
                            }
                        }
                    }
                }

                if ($more) {
                    //Produktname
                    $return['title'] = html_entity_decode(str_replace(array('<b>', '</b>'), '', $tag_matches[2][0]));

                    //Weitere Informationen zum Artikel
                    preg_match('/<span id\=\"artnr_' . $productNumber . '_(.*)\/span>/i', $fieldset, $matches);
                    list($Originalnummer) = explode('</div>', $matches[0], 2);
                    $return['Originalnummer'] = str_replace('&nbsp;', ' ', strip_tags($Originalnummer));


                    $exp_match = explode($matches[0], $fieldset, 2);
                    $exp_match = explode('</span>', $exp_match[1], 2);
                    $Variante = explode('</div>', $exp_match[0]);
                    $return['Variante'] = trim(html_entity_decode(str_replace('&nbsp;', ' ', strip_tags(array_pop($Variante)))));

                    preg_match('/show_artikelinformationen\(\'(\d{1,})\',.\'\d{1,}\',.\'(\d{1,})/', $fieldset, $internalProduct);

                    if (is_array($internalProduct) && array_key_exists(1, $internalProduct)) {
                        $return['Productdetails'] = $this->getProductDetails($internalProduct[1], $internalProduct[2]);
                    } else {
                        $return['Productdetails'] = false;
                    }

                }

                //Bild mit laden wenn true
                if ($loadImage) {
                    $return['image_base64'] = array();
                    foreach ($return['bildurl'] as $name => $url) {
                        $return['image_base64'][$name] = $this->resizeImage($this->loadImage($url), $this->pic_min_size);
                        if ($return['image_base64'][$name]) {
                            $return['image_base64'][$name] = base64_encode($return['image_base64'][$name]);
                        }
                    }
                }

                return $return;
            }
        }
        return false;
    }

    /**
     * @param $internalProductNumber
     * @param $internalGroupID
     * @return array
     */
    private function getProductDetails($internalProductNumber, $internalGroupID)
    {
        //http://www3.eosweb.de/eosweb/index.php?func=artikelinformationen&artID=144873&grpID=22247
        $post = array();

        $cookie = array(
            'PHPSESSID' => $this->Session,
            'EOSWEB::X1' => $this->eosWeb_X1,
            'EOSWEB::X2' => $this->eosWeb_X2,
        );

        $get = array(
            'func' => 'artikelinformationen',
            'artID' => $internalProductNumber,
            'grpID' => $internalGroupID,
        );

        $page = $this->getURL($this->url, $get, $post, $cookie, false);
        $dom = new DOMDocument();
        @$dom->loadHTML($page['body']);

        $return = array();

        if (stripos($page['body'], 'expandTab_Beschreibung_' . $internalProductNumber . '_0') !== false) {
            $Beschreibung = $dom->getElementById('expandTab_Beschreibung_' . $internalProductNumber . '_0');
            $tmp_beschreibung = array();
            $Beschreibung_b = $Beschreibung->getElementsByTagName('b');
            for ($b = 0; $b < $Beschreibung_b->length; $b++) {
                $tmp = trim($Beschreibung_b->item($b)->nodeValue);
                if (strlen($tmp)) {
                    $tmp_beschreibung[] = $tmp;
                }
            }
            $Beschreibung_t = str_replace($tmp_beschreibung, '', trim($Beschreibung->nodeValue));
            if (strlen($Beschreibung_t)) {
                $Beschreibung_b_last = array_pop($tmp_beschreibung);
                $tmp_beschreibung[] = $Beschreibung_t;
                $tmp_beschreibung[] = $Beschreibung_b_last;
            }
            if (count($tmp_beschreibung)) {
                $return['Beschreibung'] = $tmp_beschreibung;
            }
        }

        if (stripos($page['body'], 'expandTab_TechnischeDaten_' . $internalProductNumber . '_0') !== false) {
            $TechnischeDaten = $dom->getElementById('expandTab_TechnischeDaten_' . $internalProductNumber . '_0');
            $tmp_technischedaten = array();
            $TechnischeDaten_div = $TechnischeDaten->childNodes;
            for ($t = 0; $t < $TechnischeDaten_div->length; $t++) {
                $div = $TechnischeDaten_div->item($t);
                if (strlen(trim($div->nodeValue))) {
                    list($k, $v) = explode(":", trim($div->nodeValue), 2);
                    $tmp_technischedaten[trim($k)] = trim($v);
                }
            }
            if (count($tmp_technischedaten)) {
                $return['TechnischeDaten'] = $tmp_technischedaten;
            }
        }

        if (stripos($page['body'], 'expandTab_Spezifikationen_' . $internalProductNumber . '_0') !== false) {
            $Spezifikationen = $dom->getElementById('expandTab_Spezifikationen_' . $internalProductNumber . '_0');
            $tmp_spezifikationen = array();
            $Spezifikationen_div = $Spezifikationen->childNodes;
            for ($t = 0; $t < $Spezifikationen_div->length; $t++) {
                $div = $Spezifikationen_div->item($t);
                if (strlen(trim($div->nodeValue))) {
                    list($k, $v) = explode(":", trim($div->nodeValue), 2);
                    $tmp_spezifikationen[trim($k)] = trim($v);
                }
            }
            if (count($tmp_spezifikationen)) {
                $return['Spezifikationen'] = $tmp_spezifikationen;
            }
        }

        if (stripos($page['body'], 'expandTab_Zubehoer_' . $internalProductNumber . '_0') !== false) {
            $Zubehoer = $dom->getElementById('expandTab_Zubehoer_' . $internalProductNumber . '_0');
            $tmp_zubehoer = array();
            $Zubehoer_div = $Zubehoer->childNodes;
            for ($t = 0; $t < $Zubehoer_div->length; $t++) {
                $div = $Zubehoer_div->item($t);
                if ($div instanceof DOMElement) {
                    if ($div->childNodes->length) {
                        $z = trim($div->childNodes->item(1)->nodeValue);
                        if (strlen(($z))) {
                            $tmp_zubehoer[] = $z;
                        }
                    }
                }
            }
            if (count($tmp_zubehoer)) {
                $return['Zubehoer'] = $tmp_zubehoer;
            }
        }

        if (stripos($page['body'], 'expandTab_ModelleZuDiesemArtikel_' . $internalProductNumber . '_0') !== false) {
            $return['Modelle'] = $this->getProductModelle($internalProductNumber);
            if (!count($return['Modelle'])) {
                unset($return['Modelle']);
            }
        }

        if (stripos($page['body'], 'expandTab_Stammdaten_' . $internalProductNumber . '_0') !== false) {
            $return['Stammdaten'] = $this->getProductStammdaten($internalProductNumber, $internalGroupID);
            if (!count($return['Stammdaten'])) {
                unset($return['Stammdaten']);
            }
        }

        return $return;
    }

    /**
     * @param $internalProductNumber
     * @param $internalGroupID
     * @return array
     */
    private function getProductStammdaten($internalProductNumber, $internalGroupID)
    {
        //www3.eosweb.de/eosweb/index.php?func=gruppenuebersicht.detailsStammdaten&artID=144873&grpID=22247
        $return = array();
        $post = array();

        $cookie = array(
            'PHPSESSID' => $this->Session,
            'EOSWEB::X1' => $this->eosWeb_X1,
            'EOSWEB::X2' => $this->eosWeb_X2,
        );

        $get = array(
            'func' => 'gruppenuebersicht.detailsStammdaten',
            'artID' => $internalProductNumber,
            'grpID' => $internalGroupID,
        );

        $page = $this->getURL($this->url, $get, $post, $cookie, false);

        $dom = new DOMDocument();
        @$dom->loadHTML($page['body']);

        $table_tr = $dom->getElementsByTagName('tr');
        for ($i = 0; $i < $table_tr->length; $i++) {
            $tmp = trim($table_tr->item($i)->nodeValue);
            if (strlen($tmp)) {
                list($k, $v) = explode(":", $tmp, 2);
                $return[trim($k)] = trim($v);
            }
        }
        return $return;
    }

    /**
     * @param $internalProductNumber
     * @return array
     */
    private function getProductModelle($internalProductNumber)
    {
        //http://www3.eosweb.de/eosweb/index.php?func=gruppenuebersicht.detailsModelle&artID=355918
        $return = array();
        $post = array();

        $cookie = array(
            'PHPSESSID' => $this->Session,
            'EOSWEB::X1' => $this->eosWeb_X1,
            'EOSWEB::X2' => $this->eosWeb_X2,
        );

        $get = array(
            'func' => 'gruppenuebersicht.detailsModelle',
            'artID' => $internalProductNumber,
        );

        $page = $this->getURL($this->url, $get, $post, $cookie, false);

        $dom = new DOMDocument();
        @$dom->loadHTML($page['body']);

        $table_tr = $dom->getElementsByTagName('tr');
        $keys = array();
        $data = array();
        for ($i = 0; $i < $table_tr->length; $i++) {
            $tr = $table_tr->item($i);
            if ($i > 0) {
                $data[$i] = array();
            }
            for ($c = 0; $c < $tr->childNodes->length; $c++) {
                if ($i == 0) {
                    $tmp = trim($tr->childNodes->item($c)->nodeValue);
                    if (strlen($tmp)) {
                        $keys[] = $tmp;
                    }
                } else {
                    $data[$i][] = trim($tr->childNodes->item($c)->nodeValue);
                }
            }
        }
        foreach ($data as $row) {
            $tmp = array();
            foreach ($keys as $k => $name) {
                $tmp[$name] = $row[$k];
            }
            $return[] = $tmp;
        }
        return $return;
    }

    /**
     * @return bool
     */
    private function getSession()
    {
        $get = array(
            'func' => 'login',
        );

        $post = array(
            'username' => $this->eosWebUser,
            'password' => $this->eosWebPassword,
            'permanent_login' => 'J',
        );

        $page = $this->getURL($this->url, $get, $post);

        if ($this->debug) {
            print_r($page);
        }

        if (is_array($page)) {
            if (array_key_exists('cookie', $page)) {
                if (array_key_exists('EOSWEB::X1', $page['cookie'])) {
                    $this->eosWeb_X1 = $page['cookie']['EOSWEB::X1']['value'];
                }
                if (array_key_exists('EOSWEB::X2', $page['cookie'])) {
                    $this->eosWeb_X2 = $page['cookie']['EOSWEB::X2']['value'];
                }
                if (array_key_exists('PHPSESSID', $page['cookie'])) {
                    $this->Session = $page['cookie']['PHPSESSID']['value'];
                }
            }
        }
        return (bool)strlen($this->Session);
    }

    /**
     * Bild von Server holen
     * @param $bildurl
     * @return bool|string
     */
    private function loadImage($bildurl)
    {
        if (filter_var($bildurl, FILTER_VALIDATE_URL)) {
            $pic_raw = file_get_contents($bildurl);
            if ($pic_raw) {
                return $pic_raw;
            }
        }
        return false;
    }

    /**
     * Prüfen ob bild kleiner als $min ist und entsprechend vergrößern
     * @param $pic_raw
     * @param int $min
     * @return bool|string
     */
    private function resizeImage($pic_raw, $min = 500)
    {
        if (strlen($pic_raw)) {
            $pic_info = getimagesizefromstring($pic_raw);
            if (is_array($pic_info)) {
                if ($pic_info[0] > $min || $pic_info[1] > $min) {
                    return $pic_raw;
                }

                if ($pic_info[0] >= $pic_info[1]) {
                    $ratio = $min / $pic_info[0];
                    $width = $min;
                    $height = $pic_info[1] * $ratio;
                } else {
                    $ratio = $min / $pic_info[1];
                    $height = $min;
                    $width = $pic_info[0] * $ratio;
                }

                $image = imagecreatefromstring($pic_raw);
                $image_p = imagecreatetruecolor($width, $height);
                imagecopyresampled($image_p, $image, 0, 0, 0, 0, $width, $height, $pic_info[0], $pic_info[1]);

                ob_start();
                switch ($pic_info[2]) {
                    case IMG_GIF:
                        imagegif($image_p);
                        break;
                    case IMG_JPG:
                        imagejpeg($image_p, NULL, 90);
                        break;
                    case IMG_PNG:
                        imagepng($image_p, NULL, 0);
                        break;
                }
                $return = ob_get_contents();

                ob_end_clean();
                imagedestroy($image);
                imagedestroy($image_p);

                return strlen($return) ? $return : false;
            }
        }
        return false;
    }

    /**
     * Curl aufruf mit entsprechenden Parametern
     * @param string $url
     * @param array $get
     * @param array $post
     * @param array $cookie
     * @param bool $utf8
     * @return array|bool|string
     */
    private function getURL($url, array $get = array(), array $post = array(), array $cookie = array(), $utf8 = true)
    {
        if (filter_var($url, FILTER_VALIDATE_URL)) {
            if (!is_array($get)) {
                $get = array();
            }
            if (!is_array($post)) {
                $post = array();
            }
            if (!is_array($cookie)) {
                $cookie = array();
            }

            if (count($get)) {
                $url .= '?' . http_build_query($get);
            }

            $post = http_build_query($post);
            $cook = array();

            foreach ($cookie as $key => $value) {
                $cook[] = $key . '=' . $value;
            }
            $cookie = implode('; ', $cook);

            if ($this->curl === null) {
                $this->curl = curl_init();
            }

            $headers = array(
                'POST ' . $url . ' HTTP/1.1',
                'Accept-Encoding: gzip,deflate',
                'Content-type: application/x-www-form-urlencoded;charset=UTF-8',
                'Content-length: ' . strlen($post),
                'Host: ' . parse_url($url, PHP_URL_HOST),
                'Connection: Keep-Alive',
            );

            $options = array(
                CURLOPT_RETURNTRANSFER => 1,
                CURLOPT_FOLLOWLOCATION => 1,
                CURLOPT_HEADER => 1,
                CURLOPT_URL => $url,
                CURLOPT_USERAGENT => 'Mozilla/5.0 (Linux; U; Android 2.2; de-de; HTC Magic Build/FRF91) AppleWebKit/533.1 (KHTML, like Gecko) Version/4.0 Mobile Safari/533.1',
                CURLINFO_HEADER_OUT => 1,
                CURLOPT_POSTFIELDS => $post,
                CURLOPT_HTTPHEADER => $headers,
                CURLOPT_COOKIE => $cookie,
            );

            curl_setopt_array($this->curl, $options);

            $output = curl_exec($this->curl);

            if ($utf8) {
                $output = $this->forceUTF8($output);
            } else {
                $output = utf8_decode($output);
            }

            if ($output === false) {
                $err = 'Curl error: ' . curl_error($this->curl);
                return $err;
            }

            $info = curl_getinfo($this->curl);
            $header = substr($output, 0, $info['header_size']);
            $body = substr($output, $info['header_size']);

            return array(
                'header' => $this->http_parse_headers($header),
                'cookie' => $this->cookie_parse(explode("\n", $header)),
                'body' => $body,
                'info' => $info,
            );
        }
        return false;
    }

    /**
     * Methode zum Parsen von Header Infos
     * @param $raw_headers
     * @return array
     */
    private function http_parse_headers($raw_headers)
    {
        $headers = array();
        $key = '';

        foreach (explode("\n", $raw_headers) as $i => $h) {
            $h = explode(':', $h, 2);

            if (isset($h[1])) {
                if (!isset($headers[$h[0]])) {
                    $headers[$h[0]] = trim($h[1]);
                } elseif (is_array($headers[$h[0]])) {
                    $headers[$h[0]] = array_merge($headers[$h[0]], array(trim($h[1])));
                } else {
                    $headers[$h[0]] = array_merge(array($headers[$h[0]]), array(trim($h[1])));
                }

                $key = $h[0];
            } else {
                if (substr($h[0], 0, 1) == "\t")
                    $headers[$key] .= "\r\n\t" . trim($h[0]);
                elseif (!$key)
                    $headers[0] = trim($h[0]);
                trim($h[0]);
            }
        }

        return $headers;
    }

    /**
     * Methode zum Parsen von Cookie Strings
     * @param array $header
     * @return array
     */
    private function cookie_parse(array $header)
    {
        $cookies = array();
        foreach ($header as $line) {
            if (preg_match('/^Set-Cookie: /i', $line)) {
                $k = null;
                $line = preg_replace('/^Set-Cookie: /i', '', trim($line));
                $csplit = explode(';', $line);
                $cdata = array();
                foreach ($csplit as $data) {
                    $cinfo = explode('=', $data);
                    $cinfo[0] = trim($cinfo[0]);
                    if ($cinfo[0] == 'expires') $cinfo[1] = strtotime($cinfo[1]);
                    if ($cinfo[0] == 'secure') $cinfo[1] = "true";
                    if (in_array(strtolower($cinfo[0]), array('domain', 'expires', 'path', 'secure', 'comment', 'max-age'))) {
                        $cdata[trim($cinfo[0])] = $cinfo[1];
                    } else {
                        $key = $cinfo[0];
                        $cdata['value'] = $cinfo[1];
                    }
                }
                if (isset($key)) {
                    $cookies[$key] = $cdata;
                } else {
                    $cookies[] = $cdata;
                }
            }
        }
        return $cookies;
    }

    /**
     * @param $var
     * @return array|string
     */
    private function forceUTF8($var)
    {
        if (is_string($var)) {
            if (!mb_check_encoding($var, 'UTF-8')) {
                return mb_convert_encoding($var, 'UTF-8//TRANSLIT', mb_detect_encoding($var));
            }
        } elseif (is_array($var) || is_object($var)) {
            foreach ($var as $k => $v) {
                $var[$k] = $this->forceUTF8($v);
            }
        }
        return $var;
    }

    /**
     * Destructor
     * Curl Schließen
     */
    function __destruct()
    {
        if ($this->curl !== null) {
            curl_close($this->curl);
        }
    }

}
