<?php
class order_customer_status_update
{
	var $debug = false;
	var $orders_id,$current_order_rules,$new_order_rules,$language_id;
	public function __construct( $order,$language_id ){
		$this->order = $order;
		$this->language_id = $language_id;
	}

	public function update(){
            $cs_record = main::get_customers_status($this->order->info['status'],$this->language_id);
            $this->current_order_rules = $this->get_rules($cs_record['customers_status_show_price_tax'],$cs_record['customers_status_add_tax_ot']);

		$cs_query = xtc_db_query(sprintf(
	    		"SELECT cs.customers_status_name,c.customers_status,customers_status_add_tax_ot,customers_status_show_price_tax FROM %s c LEFT JOIN %s cs ON cs.customers_status_id=c.customers_status WHERE customers_id='%d' AND language_id='%d'",
			TABLE_CUSTOMERS,TABLE_CUSTOMERS_STATUS,$this->order->customer['ID'],$this->language_id
		));
		$cs_record = xtc_db_fetch_array($cs_query);
		if($this->debug){
			printf("Change orders customers_status from %s to %s\r\n\r\n",$this->order->info['status_name'],$cs_record['customers_status_name']);
		}

		$this->new_order_rules = $this->get_rules($cs_record['customers_status_show_price_tax'],$cs_record['customers_status_add_tax_ot']);

		$xtPrice = $this->order->get_price_instance();
		foreach($this->new_order_rules as $new_rule=>$value){
			if($this->current_order_rules[ $new_rule ] == $value ){
				continue;
			}
			//printf("%s diff: current=%s, new=%s\n",$rule,$this->current_order_rules[ $rule ], $value);
			switch($new_rule){
				case 'allow_tax':
					if($value === True){
						$this->orders_products_price_update('brutto',$value);
					}else{
						$this->orders_products_price_update('netto',$value);
					}
					break;
				case 'ot_subtotal':
				case 'ot_subtotal_no_tax':
					$this->ot_subtotal_switch($new_rule,$value);
					break;
				case 'ot_tax':
					$this->ot_tax_switch($value);
					break;
			}
		}
		$this->ot_shipping_update( $this->current_order_rules['allow_tax'],$this->new_order_rules['allow_tax'] );
	    	$customers_status = xtc_get_customer_status($this->order->customer['ID']);
		$update_sql_array = array(
			'customers_status'=>$customers_status['customers_status'],
			'customers_status_name'=>$customers_status['customers_status_name'],
			'customers_status_image'=>$customers_status['customers_status_image'],
			'last_modified'=>'now()'
		);
		xtc_db_perform(TABLE_ORDERS,$update_sql_array,'update',"orders_id='".$this->order->info['id']."'");
		return array(
			'old_status_name'=>$this->order->info['status_name'],
			'new_status_name'=>$cs_record['customers_status_name']
		);
	}

    private function orders_products_price_update($to,$allow_tax_flag){
        if($this->debug){
            printf("\torders_products_price_update(%s,%s)\r\n",$to,$allow_tax_flag);
	}
        // BOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
        /*if(yes_eu_oss_use_country_handling($this->order->delivery['country_id'])){
            $country_id = $this->order->delivery['country_id'];
            $zone_id = $this->order->delivery['zone_id'];
        }else{
            $country_id = STORE_COUNTRY;
            $zone_id = 0;
        }*/
        // EOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
        
        // BUGF_CH_OSS
        $country_id = $this->order->delivery['country_id'];
        $zone_id = $this->order->delivery['zone_id'];
        
	foreach($this->order->products as $op){
            $products_tax_class_id = yes_eu_oss_get_products_tax_class_id($op['id'], $country_id);
            $products_tax_rate = xtc_get_tax_rate($products_tax_class_id, $country_id, $zone_id);
            switch($to){
		case 'brutto':
                    $price = xtc_oe_get_price_i_tax($op['price'], $products_tax_rate);
                    break;
		case 'netto':
                    $price = xtc_oe_get_price_o_tax($op['price'], $products_tax_rate);
                    break;
            }
            if($this->debug){
                printf("\t\tConvert price for pID %s from %s to %s\r\n",$op['id'],$op['price'],$price);
            }else{
                $update_sql_array = array(
                    'products_price'=>$price,
                    'final_price'=>$price*$op['qty'],
                    'allow_tax'=>(int)$allow_tax_flag
                );
                xtc_db_perform(TABLE_ORDERS_PRODUCTS,$update_sql_array,'update',"orders_products_id='".$op['opID']."'");
            }
	}
    }

    private static function get_rules($show_price_tax, $add_tax_ot){
		$rules = array(
			'ot_subtotal'=>true,
			'ot_subtotal_no_tax'=>false,
			'ot_tax'=>true,
			'allow_tax'=>true
		);
		$code = $show_price_tax.'-'.$add_tax_ot;
		switch($code){
			case '1-1':
				break;
			case '1-0':
				$rules['allow_tax'] = false;
				$rules['ot_subtotal_no_tax'] = true;
				$rules['ot_subtotal'] = false;
				break;
			case '0-1':
				$rules['allow_tax'] = false;
				$rules['ot_subtotal_no_tax'] = true;
				$rules['ot_subtotal'] = false;
				break;
			case '0-0':
				$rules['allow_tax'] = false;
				$rules['ot_tax'] = false;
				break;
		}
		return $rules;
    }

    private function order_total_class_exists($class){
        foreach($this->order->totals as $ot){
            if($ot['class'] == $class){
                if($this->debug){
                        printf("\t\torder_total_class_exists(%s) === True\r\n",$class);
                }
                return true;
            }
        }
        if($this->debug){
            printf("\t\torder_total_class_exists(%s) === False\r\n",$class);
        }
        return false;
    }

    private function ot_subtotal_switch( $class, $value){
        if($value === True){
            // ZUR SICHERHEIT NOCHMAL CHECKEN OB WIRKLICH KEIN $class VORHANDEN IST
            if($this->order_total_class_exists($class)){
                return false;
            }
            $xtPrice = $this->order->get_price_instance();
            $ot_subtotal_class = new $class($xtPrice);
            $ot_subtotal_new = 0; // erstmal null - wird bei recalc() eh neu berechnet
            $insert_sql_array = array(
                    'orders_id'=>$this->order->info['id'],
                    'value'=>$ot_subtotal_new,
                    'title'=>$ot_subtotal_class->title.':',
                    'text'=>$xtPrice->xtcFormat($ot_subtotal_new,true,0,$this->order->info['currency']),
                    'class'=>$ot_subtotal_class->code,
                    'sort_order'=>$ot_subtotal_class->sort_order,
                    'tax_rate_percent'=>0
            );
            if($this->debug){
                    printf("\t\tInsert %s as %s\r\n",$class,$ot_subtotal_class->title.':');
            }else{
                    xtc_db_perform(TABLE_ORDERS_TOTAL,$insert_sql_array);
            }
        }else{
            // ZUR SICHERHEIT NOCHMAL CHECKEN OB WIRKLICH $class VORHANDEN IST
            if(!$this->order_total_class_exists($class)){
                return false;
            }
            if($this->debug){
                    printf(
                            "\t\tSQL: DELETE FROM %s WHERE orders_id='%s' AND class='%s'\r\n",
                            TABLE_ORDERS_TOTAL,$this->order->info['id'],$class
                    );
            }else{
                    xtc_db_query(sprintf(
                            "DELETE FROM %s WHERE orders_id='%s' AND class='%s'",
                            TABLE_ORDERS_TOTAL,$this->order->info['id'],$class
                    ));
            }
	}
    }

    private function ot_tax_switch($value){
        if($value === True){
            if($this->order_total_class_exists('ot_tax')){
                return false;
            }
            $tax_rates = $this->get_tax_rates();
            $xtPrice = $this->order->get_price_instance();
            foreach($tax_rates as $tr => $tv){
                    $ot_tax = new ot_tax($tv);
                    $ot_subtotal_new = 0; // erstmal null
                    $insert_sql_array = array(
                        'orders_id'=>$this->order->info['id'],
                        'value'=>$tv,
                        'title'=>$ot_tax->title.' '.number_format($tr,0,'','').'%:',
                        'text'=>$xtPrice->xtcFormat($ot_subtotal_new,true,0,$this->order->info['currency']),
                        'class'=>$ot_tax->code,
                        'sort_order'=>$ot_tax->sort_order,
                        'tax_rate_percent'=>$tr
                    );
                    if($this->debug){
                            printf("\t\tInsert ot_tax %s rate %s with value %s\r\n",$insert_sql_array['title'],$tr,$tv);
                    }else{
                            xtc_db_perform(TABLE_ORDERS_TOTAL,$insert_sql_array);
                    }
            }
	}else{
            if(!$this->order_total_class_exists('ot_tax')){
                return false;
            }
            if($this->debug){
                    printf(
                            "\t\tSQL: DELETE FROM %s WHERE orders_id='%s' AND class='ot_tax'\r\n",
                            TABLE_ORDERS_TOTAL,$this->order->info['id']
                    );
            }else{
                    xtc_db_query(sprintf(
                            "DELETE FROM %s WHERE orders_id='%s' AND class='ot_tax'",
                            TABLE_ORDERS_TOTAL,$this->order->info['id']
                    ));
            }
	}
    }

    private function ot_shipping_update( $brutto_flag_old,$brutto_flag_new ){
        if($this->debug){
                printf("\tot_shipping_update( %s, %s )\r\n",$brutto_flag_old,$brutto_flag_new);
        }
        if($brutto_flag_old == $brutto_flag_new){
                if($this->debug){
                        printf("\t\tKEIN ot_shipping UPDATE\r\n");
                }
                return true;
        }
        $xtPrice = $this->order->get_price_instance();
        
        // BOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
        /*if(yes_eu_oss_use_country_handling($this->order->delivery['country_id'])){
            $country_id = $this->order->delivery['country_id'];
            $zone_id = $this->order->delivery['zone_id'];
        }else{
            $country_id = STORE_COUNTRY;
            $zone_id = 0;
        }*/
        // EOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
        
        // BUGF_CH_OSS
        $country_id = $this->order->delivery['country_id'];
        $zone_id = $this->order->delivery['zone_id'];
        
        
        if($brutto_flag_new === True){
            // MWST ADD
            foreach($this->order->totals as $ot){
                switch($ot['class']){
                    case 'ot_shipping':
                        $order = new order($this->order->info['id']);
                        $tax_class_id = $order->get_shipping_tax_class();
                        $tax_rate = xtc_get_tax_rate($tax_class_id,$country_id,$zone_id);
                        $tax_multiplier = ($tax_rate+100)/100;
                        $update_sql_array = array(
                                'value'=>$ot['value']*$tax_multiplier,
                                'text'=>$xtPrice->xtcFormat($ot['value']*$tax_multiplier,true,0,$this->order->info['currency']),
                                'tax_rate_percent'=>$tax_rate
                        );
                        if($this->debug){
                                printf("\t\tShipping Costs Update Netto %s to Brutto %s",$ot['text'],$update_sql_array['text']);
                        }else{
                                xtc_db_perform(TABLE_ORDERS_TOTAL,$update_sql_array,'update',"orders_id='".$this->order->info['id']."' AND class='ot_shipping'");
                        }
                        break;
                }
            }
	}else{
            // MWST REMOVE
            foreach($this->order->totals as $ot){
                switch($ot['class']){
                    case 'ot_shipping':
                        $tax_rate = $ot['tax_rate_percent'];
                        if($tax_rate == 0){
                            continue;
                        }
                        $tax_divisor = ($tax_rate+100)/100;
                        $update_sql_array = array(
                            'value'=>$ot['value']/$tax_divisor,
                            'text'=>$xtPrice->xtcFormat($ot['value']/$tax_divisor,true,0,$this->order->info['currency']),
                        );
                        if($this->debug){
                            printf("\t\tShipping Costs Update Brutto %s to Netto %s",$ot['text'],$update_sql_array['text']);
                        }else{
                            xtc_db_perform(TABLE_ORDERS_TOTAL,$update_sql_array,'update',"orders_id='".$this->order->info['id']."' AND class='ot_shipping'");
                        }
                        break;
                }
            }
	}
    }
	
    private function get_tax_rates(){
        $tax_rates = array();
        $query = xtc_db_query(sprintf(
                "SELECT products_tax,final_price FROM %s WHERE orders_id='%s'",
                TABLE_ORDERS_PRODUCTS,$this->order->info['id']
        ));
        while($record = xtc_db_fetch_array($query)){
            if(!isset($tax_rates[ $record['products_tax'] ])){
                $tax_rates[ $record['products_tax'] ] = 0;
            }
            $divisor = ($record['products_tax'] + 100) /100;
            $tax_rates[ $record['products_tax'] ] += $record['final_price'] / $divisor;
        }
        return $tax_rates;
    }
}

