<?php
/* --------------------------------------------------------------
   (c) mario aspeleiter 05/2005 <dazze@gmx.de>
   --------------------------------------------------------------*/

  class reclamation {
    var $info, $totals, $products, $customer, $delivery,$rueckerstattungen,$costs,$total,$weight,$editor_id,$reasons;

    function __construct($reclamation_id) {
        $this->info = array();
        $this->totals = array();
        $this->products = array();
        $this->customer = array();
        $this->delivery = array();
        $this->rueckerstattungen = array();
        $this->costs = array();
        $this->editor_id = $_SESSION['customer_id'];
        $this->reasons = array();
        $this->query($reclamation_id);	
    }

    function query($reclamation_id) {
      $reclamation_query = xtc_db_query("select *
                                  from reclamations r where
                                  reclamations_id = '" . xtc_db_input($reclamation_id) . "'");

      $reclamation = xtc_db_fetch_array($reclamation_query);

      $totals_query = xtc_db_query("select * from reclamations_total where reclamations_id = '" . xtc_db_input($reclamation_id) . "' order by sort_order");
      while ($totals = xtc_db_fetch_array($totals_query)) {
        $this->totals[] = array('title' => $totals['title'],
                                'text' => $totals['text'],
                                'value' => $totals['value'],
                                'id' => $totals['reclamations_id'],
                                'otid' => $totals['reclamations_total_id'],
                                'class' => $totals['class']);
      }
      
      $costs_query = xtc_db_query("select * from costs where reclamations_id = '" . xtc_db_input($reclamation_id) . "' order by date_created");
      while ($costs = xtc_db_fetch_array($costs_query)) {
        $this->costs[] = array('class' => $costs['class'],
		'reclamations_id'=>$costs['reclamations_id'],
		'customers_id'=>$costs['customers_id'],
		'comments'=>xtc_db_input($costs['comments']),
		'value'=>xtc_db_input($costs['value']),
		'date_created'=>$costs['date_created'],
		'editor_id'=>$costs['editor_id']
		);
      }
      
        $rueck_query = xtc_db_query("select * from rueckerstattungen where reclamations_id = '" . xtc_db_input($reclamation_id) . "' order by date_created");
        while ($rueck = xtc_db_fetch_array($rueck_query)) {
            $this->rueckerstattungen[] = array(
                    'id'=>$rueck['rueckerstattungs_id'],
                    'betrag'=>$rueck['betrag'],
                    'betrag_formatted'=>number_format($rueck['betrag'],2,',',''),
                    'paymode'=>$rueck['paymode'],
                    'date_created'=>$rueck['date_created'],
                    'date_payment'=>$rueck['date_payment'],
                    'kto_nummer'=>$rueck['kto_nummer'],
                    'kto_blz'=>$rueck['kto_blz'],
                    'kto_inhaber'=>$rueck['kto_inhaber'],
                    'kto_bank'=>$rueck['kto_bank'],
                    'kto_iban'=>$rueck['kto_iban'],
                    'kto_swift'=>$rueck['kto_swift'],
                    'kto_grund'=>$rueck['kto_grund'],
                    'comments'=>$rueck['comments'],
                    'editor_id'=>$rueck['editor_id'],
                    'status'=>$rueck['status'],
                    'status_name'=>xtc_get_rueckerstattungen_status_name($rueck['status'])
            );
        }
      
      $eb_query = xtc_db_query("SELECT customers_ebay_userid FROM customers WHERE customers_id='".$reclamation['customers_id']."'");
      $eb = xtc_db_fetch_array($eb_query);
      $ebayuser = $eb['customers_ebay_userid'];


        $this->info = array('currency' => $reclamation['currency'],
            'currency_value' => $reclamation['currency_value'],
            'status' => $reclamation['customers_status'],
            'send' => $reclamation['send'],
            'send_status' => $reclamation['send_status'],
            'rueckerstattung' => $reclamation['rueckerstattung'],
            'versender' => $reclamation['versender'],
            'repair' => $reclamation['repair'],
            'comments' => $reclamation['comments'],
            'language' => $reclamation['language'],
            'date_created' => $reclamation['date_created'],
            'reclamations_status' => $reclamation['reclamations_status'],
            'reclamations_type' => $reclamation['reclamations_type'],
            'id' => $reclamation['reclamations_id'],
            'ebay_id'=>$reclamation['ebay_id'],
            'orders_id'=>$reclamation['orders_id'],
            'ebay_userid'=>$ebayuser,
            'last_modified' => $reclamation['last_modified'],
            'date_payment' => $reclamation['date_payment'],
            'block_shipping' => $reclamation['block_shipping'],
            'block_shipping_comment' => $reclamation['block_shipping_comment'],
            'block_shipping_end_date' => $reclamation['block_shipping_end_date'],
            'versender' => $reclamation['versender'],
            'versender_proposal' => $reclamation['versender_proposal'],
            'shipping_comments'=>$reclamation['shipping_comments']
        );

        $this->customer = array('name' => $reclamation['customers_name'],
            'company' => $reclamation['customers_company'],
            'csID' => $reclamation['customers_cid'],
            'vat_id' => $reclamation['customers_vat_id'],
            'ID' => $reclamation['customers_id'],
            'street_address' => $reclamation['customers_street_address'],
            'suburb' => $reclamation['customers_suburb'],
            'city' => $reclamation['customers_city'],
            'postcode' => $reclamation['customers_postcode'],
            'state' => $reclamation['customers_state'],
            'country' => $reclamation['customers_country'],
            'format_id' => $reclamation['customers_address_format_id'],
            'telephone' => $reclamation['customers_telephone'],
            'email_address' => $reclamation['customers_email_address']
        );

        // WE NEED THE COUNTRY ID
        $delivery_country_id_query = xtc_db_query(sprintf(
            "SELECT countries_id,countries_iso_code_2 FROM countries WHERE countries_name='%s'",
            xtc_db_input($reclamation['delivery_country'])
        ));
        $delivery_country_id = xtc_db_fetch_array($delivery_country_id_query);
        $this->delivery = array('name' => $reclamation['delivery_name'],
            'company' => $reclamation['delivery_company'],
            'street_address' => $reclamation['delivery_street_address'],
            'suburb' => $reclamation['delivery_suburb'],
            'city' => $reclamation['delivery_city'],
            'postcode' => $reclamation['delivery_postcode'],
            'state' => $reclamation['delivery_state'],
            'country' => $reclamation['delivery_country'],
            'country_id' => $delivery_country_id['countries_id'],
            'zone_id'=>0,
            'iso_code_2' => $delivery_country_id['countries_iso_code_2'],
            'format_id' => $reclamation['delivery_address_format_id']
        );

        $this->billing = array('name' => $reclamation['billing_name'],
            'company' => $reclamation['billing_company'],
            'street_address' => $reclamation['billing_street_address'],
            'suburb' => $reclamation['billing_suburb'],
            'city' => $reclamation['billing_city'],
            'postcode' => $reclamation['billing_postcode'],
            'state' => $reclamation['billing_state'],
            'country' => $reclamation['billing_country'],
            'format_id' => $reclamation['billing_address_format_id']
        );

        $index = 0;
        $reclamations_products_query = xtc_db_query("select
                reclamations_products_id,products_id, products_name, products_model, products_price, products_tax, products_quantity, final_price,allow_tax, products_discount_made,false_products_id,quantity_shipped 
            from
                reclamations_products
            where
                reclamations_id ='" . xtc_db_input($reclamation_id) . "'");

        while ($reclamations_products = xtc_db_fetch_array($reclamations_products_query)) {
            $this->products[$index] = array(
                'qty' => $reclamations_products['products_quantity'],
                'name' => $reclamations_products['products_name'],
                'id' => $reclamations_products['products_id'],
                'rpID' => $reclamations_products['reclamations_products_id'],
                'model' => $reclamations_products['products_model'],
                'tax' => $reclamations_products['products_tax'],
                'price' => $reclamations_products['products_price'],
                'discount' => $reclamations_products['products_discount_made'],
                'final_price' => $reclamations_products['final_price'],
                'allow_tax' => $reclamations_products['allow_tax'],
                'false_products_id'=>$reclamations_products['false_products_id'],
                'ean'=> yes_get_products_ean($reclamations_products['products_id']),
                'quantity_shipped'=>$reclamations_products['quantity_shipped']
            );
            if($reclamations_products['false_products_id'] > 0){
                    $this->products[$index]['false_products_id_name'] = xtc_get_products_name($reclamations_products['false_products_id']);
            }
            $properties = array();
            $query = xtc_db_query(sprintf(
                "SELECT property_title,property_value,input_span FROM reclamations_products_properties WHERE reclamations_products_id='%s'",
                $reclamations_products['reclamations_products_id']
            ));
            while($record = xtc_db_fetch_array($query)){
                $properties[] = $record;
            }
            $this->products[$index]['properties'] = $properties;
				
            $subindex = 0;
            //$attributes_query = xtc_db_query("select products_options, products_options_values, options_values_price, price_prefix from " . TABLE_ORDERS_PRODUCTS_ATTRIBUTES . " where reclamations_id = '" . xtc_db_input($reclamation_id) . "' and orders_products_id = '" . $reclamations_products['orders_products_id'] . "'");
            $index++;
        }

        // REASONS
        $reclamations_reasons_query = xtc_db_query(sprintf(
            "SELECT rr.reason FROM reclamations_reasons rr LEFT JOIN reclamations_to_reclamations_reasons rtrr USING(reclamations_reasons_id) WHERE rtrr.reclamations_id='%d' AND rtrr.reclamations_reasons_id > 0 ORDER BY rr.reason; ",
            (int)xtc_db_input($reclamation_id)
        ));
        while($reclamations_reasons = xtc_db_fetch_array($reclamations_reasons_query)){
            $this->reasons[] = xtc_db_prepare_input($reclamations_reasons['reason']);
        }
    }

    function calculate( $shippings_id = 0) {
		$this->total = 0;
		$this->weight = 0;
		if (!is_array($this->products)) 
			return 0;
		reset($this->products);
                if($shippings_id > 0){
                    $shippings_products_query = xtc_db_query(sprintf(
                            "SELECT products_id, quantity FROM shippings_products WHERE shippings_id='%s'",
                            $shippings_id
                    ));
                    while($shippings_products = xtc_db_fetch_array($shippings_products_query)){
                        $weight = xtc_get_ext_products_weight($shippings_products['products_id']);
                        $this->weight += ($shippings_products['quantity'] * $weight);
                    }
                }
                // FALLS IN shippings_products KEIN EINTRAG IST
                if( $this->weight == 0){
                    // php8 bugfix
                    //while (list($id, ) = each($this->products)) {
                    foreach($this->products as $id=>$egal) {
                            if(!function_exists('xtc_get_ext_products_weight'))
                                    require(DIR_FS_INC.'xtc_get_ext_products_weight.inc.php');
                            $weight = xtc_get_ext_products_weight($this->products[$id]['id']);
                            $this->weight += ($this->products[$id]['qty'] * $weight);
                    }
                }
    }
    function show_weight( $shippings_id = 0 ) {
        $this->calculate($shippings_id);
        return $this->weight;
    }

    function add_history($status_id,$notified,$comments){
	$new = new \YES4Trade\Model\reclamations_status_history([
            'reclamations_id'=>(int)$this->info['id'],
            'reclamations_status_id'=>(int)$status_id,
            'date_added'=>date('Y-m-d H:i:s'),
            'customer_notified'=>($notified)?1:0,
            'comments'=>$comments,
            'editor_id'=>(int)$this->editor_id
	]);
	$new->create();
    }

	// DER EINZIGE FALL FUER EINE REASON_SUBCLASS WAERE HIER - "Abholung" - MUSS NOCH HINTERFRAGT WERDEN
	public function get_transferred_places($products_id,$reason_subclass = '',$is_colli = false){
		return yes_get_transferred_storage_products($products_id,'reklamation', $this->info['id'] , $reason_subclass,$is_colli);
	}
	
	public function get_shipped_products_with_collis($products){
		if(!sizeOf($this->products)){
			return $products;
		}
		foreach($this->products as $product){
			$colli_query = xtc_db_query(sprintf(
				"SELECT collie_products_id,quantity FROM products_collies WHERE products_id='%s'",
				$product['id']
			));
			if(!xtc_db_num_rows($colli_query)){
				if(!isset($products[$product['id']]))
					$products[$product['id']] = 0;
				$products[$product['id']] += $product['qty'];
			}
			while($colli = xtc_db_fetch_array($colli_query)){
				if(!isset($products[ $colli['collie_products_id'] ]))
					$products[ $colli['collie_products_id'] ] = 0;
				$products[ $colli['collie_products_id'] ] += $colli['quantity'] * $product['qty'];
			}
		}
		return $products;
	}
	
	public function allow_shipping(){
		$wc_query = xtc_db_query(sprintf(
			"SELECT wrapping_counter_id FROM wrapping_counter WHERE reclamations_id='%d'",
			$this->info['id']
		));
		if(xtc_db_num_rows($wc_query)){
			return false;
		}
		if($this->info['block_shipping'] == 0 and in_array($this->info['reclamations_status'],array(1,2)) ){
			return true;
		}
	}
	
	function recalc(){
	    $costs['tax'] = 0;
            $tax_rate = RECLAMATION_TAXCLASS;
            $tax_class_id = $this->get_shipping_tax_class();
            $country_id = $this->delivery['country_id'];
            if($tax_class_id > 0){
                $tax_rate = xtc_get_tax_rate($tax_class_id, $country_id);
            }
	    // versand
	    $costs['versand'] = 0;
	    $shipping_query = xtc_db_query("select value from reclamations_total where reclamations_id = '" . $this->info['id'] . "' and class='ot_shippings' ");
	    while($shipping = xtc_db_fetch_array($shipping_query)){
		    $costs['versand'] += $shipping['value'];
	    }
	    $costs['tax'] += $costs['versand'] - ($costs['versand'] / ((100+$tax_rate)/100));

	    // reparatur
	    $costs['repair'] = 0;
	    $repair_query = xtc_db_query("select value from reclamations_total where reclamations_id = '" . $this->info['id'] . "' and class='ot_repair' ");
	    while($repair = xtc_db_fetch_array($repair_query)){
		    $costs['repair'] += $repair['value'];
	    }
	    $costs['tax'] += $costs['repair'] - ($costs['repair'] / ((100+$tax_rate)/100));

	    // bearbeitungsgebuehr
	    $costs['bearbeitung'] = 0;
	    $bearbeitung_query = xtc_db_query("select value from reclamations_total where reclamations_id = '" . $this->info['id'] . "' and class='ot_bearbeitung' ");
	    while($bearbeitung = xtc_db_fetch_array($bearbeitung_query)){
		    $costs['bearbeitung'] += $bearbeitung['value'];
	    }
	    $costs['tax'] += $costs['bearbeitung'] - ($costs['bearbeitung'] / ((100+$tax_rate)/100));

	    // transportkosten 
	    $costs['transport'] = 0;
	    $transport_query = xtc_db_query("select value from reclamations_total where reclamations_id = '" . $this->info['id'] . "' and class='ot_transport' ");
	    while($transport = xtc_db_fetch_array($transport_query)){
		    $costs['transport'] += $transport['value'];
	    }
	    $costs['tax'] += $costs['transport'] - ($costs['transport'] / ((100+$tax_rate)/100));

	    // Alte UST L�schen
	    xtc_db_query("delete from reclamations_total where reclamations_id = '" . $this->info['id'] . "' and class='ot_tax'");
	    // Alte UST L�schen ENDE

	    $sql_data_array = array('reclamations_id' => $this->info['id'],
                'title' => xtc_db_prepare_input('Enth. MwSt. '.$tax_rate.'%'),
                'text' => number_format($costs['tax'],2,',','').' '.$this->info['currency'],
                'value' => $costs['tax'],
                'sort_order' => MODULE_ORDER_TOTAL_TAX_SORT_ORDER,
                'class' => 'ot_tax');

	    xtc_db_perform('reclamations_total', $sql_data_array);

	    // Neue UST Zusammenrechnen und in die DB Schreiben ENDE
	    // Errechne neue MWSt. f�r die Bestellung Ende

	    $total_query = xtc_db_query("select SUM(value) as value_new from reclamations_total where reclamations_id = '" . $this->info['id'] . "' and class!='ot_coupon' and class!='ot_gv' and class!='ot_tax' and class!='ot_total'");
	    $total = xtc_db_fetch_array($total_query);

	    $text = number_format($total['value_new'],2,',','').' '.$this->info['currency'];

	    $sql_data_array = array('reclamations_id' => $this->info['id'],
				'text' => $text,
				'value' => xtc_db_prepare_input($total['value_new']));

	    xtc_db_perform('reclamations_total', $sql_data_array, 'update', 'reclamations_id = \'' . $this->info['id'] . '\' and class="ot_total"');
	}
	public function get_update_address_part_prefix($address_type){
		switch($address_type){
			case 'customer':
				$prefix = 'customers_';
				break;
			case 'shipping':
				$prefix = 'delivery_';
				break;
			case 'invoice':
				$prefix = 'billing_';
				break;
		}
		return $prefix;
	}
	
	public function get_address_part_sql($address_type,$data,$transform_to='',$utf8_decode=true){
		$prefix = $this->get_update_address_part_prefix($address_type);
		$update_sql_array = array();
		$target_key = ($transform_to != '') ? $this->get_update_address_part_prefix($transform_to) : '';
		foreach($data as $key=>$val){
			if(!strstr($key,$prefix) or $key == 'update_customers_name'){
				continue;
			}
			if(strstr($key,'country')){
				if($target_key != ''){
					if($utf8_decode)
						$update_sql_array[ str_replace($prefix,$target_key,$key) ] = yes_decode_string( xtc_get_country_name( $val ) );
					else
						$update_sql_array[ str_replace($prefix,$target_key,$key) ] = xtc_get_country_name( $val );
				}else{
					if($utf8_decode)
						$update_sql_array[ $key ] = yes_decode_string(xtc_get_country_name($val));
					else
						$update_sql_array[ $key ] = xtc_get_country_name($val);
				}
			}else{
				if($target_key != ''){
					if(!strstr($key,'telephone') and !strstr($key,'mobile') and !strstr($key,'vat_id')){
						$update_sql_array[ str_replace($prefix,$target_key,$key) ] = yes_decode_string($val);
					}
				}else{
					$update_sql_array[ $key ] = yes_decode_string($val);
				}
			}
		}
		return $update_sql_array;
	}
	public function update_address_part($update_sql_array){
		foreach($update_sql_array as $key => $val){
			if(mb_detect_encoding($val) == 'UTF-8'){
				//$update_sql_array[ $key ] = utf8_encode($val);
			}
		}
		xtc_db_perform('reclamations',$update_sql_array,'update',"reclamations_id='".$this->info['id']."'");
	}
	
    public function get_shipping_tracking_id_array(){
	$array = array();
	$query = xtc_db_query(sprintf(
	    "SELECT id,versender, tracking_id,date_finished FROM shippings WHERE reclamations_id='%s' ORDER BY date_finished DESC",
	    $this->info['id']
	));
	while($record = xtc_db_fetch_array($query)){
	    /**
	     * DAS IST ALTES HANDLING, BEIM NEUEN HANDLING WERDEN DIE tracking_id
	     * IN shippings_tracking_numbers GESPEICHERT UND PER yes_shipping Klasse
	     * ausgelesen
	     */
	    if($record['tracking_id'] != ''){
		$array[] = $record;
	    }
	    // NEUES HANDLING
	    $YS = new yes_shipping($record['id']);
	    $_array = $YS->getTracking_id_array();
	    if(sizeOf($_array)){
		foreach($_array as $_a){
		    $array[] = array(
			'id'=>$record['id'],
			'versender'=>$record['versender'],
			'tracking_id'=>$_a,
			'date_finished'=>$record['date_finished']
		    );
		}
	    }
	}
	return $array;
  }
  public function check_delete(){
      if(!in_array($this->info['reclamations_status'],array(1,2)))
	      return false;
      $query = xtc_db_query(sprintf(
	      "SELECT reclamations_id FROM shippings WHERE reclamations_id='%s'",
	      $this->info['id']
      ));
      return !xtc_db_num_rows($query);
  }
  public function delete(){
      if(!$this->check_delete())
	  return false;
      foreach($this->products as $rp){
	  $pID = $rp['id'];
	  $rpID = $rp['rpID'];
	  xtc_db_query(sprintf(
		  "DELETE FROM reclamations_products_properties WHERE reclamations_products_id='%s'",
		  $rpID
	  ));
	  $insert_sql_array = array(
	      'products_id'=>$pID,
	      'date_saved'=>'now()',
	      'comments'=>sprintf(
		      TEXT_HISTORY_RECLAMATIONS_PRODUCT_DELETED,
		      $this->info['id'],
		      $rp['qty']
		    ),
	      'editor_id'=>(isset($_SESSION['customer_id'])) ? $_SESSION['customer_id'] : 0
	  );
	  xtc_db_perform('products_history',$insert_sql_array);
      }
      xtc_db_query(sprintf(
	      "DELETE FROM reclamations_bestandssperre WHERE reclamations_id='%s'",
	      $this->info['id']
	));
      xtc_db_query(sprintf(
	      "DELETE FROM reclamations_recalculate WHERE reclamations_id='%s'",
	      $this->info['id']
	));
      $items = \YES4Trade\Model\reclamations_status_history::get_by_reclamations_id( (int)$this->info['id']);
      foreach($items as $it){
          \YES4Trade\Model\reclamations_status_history::delete( (int) $it->reclamations_status_history_id);
      }
      xtc_db_query(sprintf(
	      "DELETE FROM reclamations_total WHERE reclamations_id='%s'",
	      $this->info['id']
	));
      xtc_db_query(sprintf(
	      "DELETE FROM reclamations_to_reclamations_reasons WHERE reclamations_id='%s'",
	      $this->info['id']
	));
      xtc_db_query(sprintf(
	      "DELETE FROM reclamations WHERE reclamations_id='%s'",
	      $this->info['id']
	));
      if($this->info['orders_id'] > 0){
	  $query = xtc_db_query(sprintf(
		  "SELECT orders_status FROM %s WHERE orders_id='%s'",
		  TABLE_ORDERS,$this->info['orders_id']
	  ));
	  $record = xtc_db_fetch_array($query);
	  $insert_sql_array = array(
	      'orders_id'=>$this->info['orders_id'],
	      'orders_status_id'=>$record['orders_status'],
	      'date_added'=>'now()',
	      'customer_notified'=>0,
	      'comments'=>sprintf(TEXT_HISTORY_ORDER_RECLAMATIONS_DELETED,$this->info['id']),
	      'editor_id'=>(isset($_SESSION['customer_id'])) ? $_SESSION['customer_id'] : 0
	  );
	  xtc_db_perform(TABLE_ORDERS_STATUS_HISTORY,$insert_sql_array);
      }
      $new = new \YES4Trade\Model\customers_memo([
	  'customers_id'=>(int)$this->customer['ID'],
	  'memo_date'=>date('Y-m-d H:i:s'),
	  'memo_title'=>TEXT_HISTORY_CUSTOMER_RECLAMATIONS_DELETED_TITLE,
	  'memo_text'=>sprintf(TEXT_HISTORY_CUSTOMER_RECLAMATIONS_DELETED_TITLE,$this->info['id']),
	  'poster_id'=>(isset($_SESSION['customer_id'])) ? (int)$_SESSION['customer_id'] : 0
      ]);
      $new->create();
      return true;
  }
  
  /**
   * Prueft ob die Rekla ueber Warenausgabe (otc) abgewickelt wurde
   * 
   * @return int Anzahl Datensaetze (0 = keine otc Eintraege)
   */
  public function is_otc(){
      $query = xtc_db_query(sprintf(
              "SELECT otc_id FROM otc WHERE reclamations_id='%s'",
              $this->info['id']
      ));
      return xtc_db_num_rows($query);
  }
  /**
   * Versandabschluss/Teillieferung YESShippingItems
   * 
   * wird im Versandabschluss aufgerufen fuer order/reclamation
   * 
   */
  public function add_quantity_shipped(int $rpID, int $quantity = 0){
        xtc_db_query(sprintf(
            "UPDATE reclamations_products SET quantity_shipped=quantity_shipped+%d WHERE reclamations_products_id='%d' and reclamations_id='%d'",
            $quantity,$rpID,$this->info['id']
        ));
  }
  
  // KANN BEI V2 AKTIVIERUNG WEG
  // IST NUN BESTANDTEIL VON YESShippingItems::versandabschluss_update_class_obj()
  public function process_shipping($versender){
        foreach ($this->products as $k=>$products) {
            // KOMMENTAR IN HISTORY
            $collies = xtc_get_product_collies($products['id']);
            if(sizeOf($collies)>0){
                foreach($collies as $ck=>$colli){
                    if($this->info['reclamations_type'] == 3){
                        $SQ = new products_quantity($colli['collie_products_id']);
                        $qty_total = $SQ->get_products_total_qty();
                        $new_qty = $products['qty']*$colli['quantity'];
                        $comment = sprintf(HISTORY_RECLAMATION_SEND,$this->info['id'],$new_qty);
                        $collie_comment = sprintf(HISTORY_SEND_COLLIES,$products['id'],$qty_total,$qty_total);
                        $SQ->update_qty(-$new_qty,$SQ->get_default_storage_id(),$qty_total,$collie_comment,
                                'reklamation',$this->info['id'], 'Versand'
                        );
                    }else{
                        yes_add_products_history($colli['collie_products_id'], sprintf(HISTORY_SEND_NO_QTY_CHANGE_RECLAMATION,$this->info['id']));
                    }
                }
            }
            if($this->info['reclamations_type'] == 3){
                $SQ = new products_quantity($products['id']);
                $qty_total = $SQ->get_products_total_qty();
                $new_qty = $products['qty'];
                $comment = sprintf(HISTORY_RECLAMATION_SEND,$this->info['id'],$new_qty);
                $SQ->update_qty(-$new_qty,$SQ->get_default_storage_id(),$qty_total,$comment,
                        'reklamation',$this->info['id'],'Versand'
                );
            }else{
                yes_add_products_history($products['id'], sprintf(HISTORY_SEND_NO_QTY_CHANGE_RECLAMATION,$this->info['id']));
            }
        }

        // NEU
        xtc_db_query(sprintf(
                "UPDATE reclamations SET send_status='2', last_modified=now() WHERE reclamations_id='%s'",
                $this->info['id']
        ));
        $comments = sprintf(HISTORY_RECLAMATION_SHIPPED_SENDER,$versender);
        $recla_abgeschlossen = true;
        switch($this->info['reclamations_type']){
            case 3:
            case 4:
                foreach($this->rueckerstattungen as $rueck){
                    if( in_array($rueck['status'],array(1,4))){
                        $recla_abgeschlossen = false;
                    }
                }
                if($recla_abgeschlossen){
                    $ret_query = xtc_db_query(sprintf(
                            "SELECT retoure_id FROM retouren WHERE reclamations_id='%s' AND retoure_status IN(%s)",
                            $this->info['id'],implode(',',array(1,2))
                    ));
                    if(xtc_db_num_rows($ret_query)){
                        $recla_abgeschlossen = false;
                    }
                }
                break;
        }
        if($recla_abgeschlossen){
            $recla_status = 3;
            xtc_db_query(sprintf(
                "UPDATE reclamations SET reclamations_status='%s' WHERE reclamations_id='%s'",
                $recla_status,$this->info['id']
            ));
        }else{
            $recla_status = $this->info['reclamations_status'];
        }
        $this->add_history($recla_status, false, $comments);
  }
    /**
     * FSK18 Artikel enthalten?
     * 
     * Prueft die Artikel der Bestellung ob FSK18 Artikel enthalten sind.
     * Beruecksichtigt Collis
     * Wird der Parameter rpID uebergeben, wird nur dieser Reklamationsartikel
     * geprueft
     * 
     * @return bool
     */
    function has_FSK18_products( int $rpID = null ){
        foreach($this->products as $rp){
            if($rpID !== null && $rpID != $rp['rpID']){
                continue;
            }
            $check_products = array($rp['id']);
            $collies = xtc_get_product_collies($rp['id']);
            foreach($collies as $c){
                $check_products[] = $c['collie_products_id'];
            }
            $query = xtc_db_query(sprintf(
                    "SELECT COUNT(products_id) as anz FROM `%s` WHERE products_id IN(%s) AND products_fsk18=1",
                    TABLE_PRODUCTS,
                    implode(',',$check_products)
            ));
            $record = xtc_db_fetch_array($query);
            if($record['anz']>0){
                return true;
            }
        }
        return false;
    }
    
    public function get_shipping_tax_class(){
        $tax_class_id = 0;
	if(!is_array($this->products)){
            return $tax_class_id;
        }
        $taxes = array();
        $country_id = $this->delivery['country_id'];
        
        // BOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
        /*if(!yes_eu_oss_use_country_handling($country_id)){
            $country_id = STORE_COUNTRY;
        }*/
        // EOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
        
        foreach($this->products as $k=>$product){
            $products_tax_class_id = yes_eu_oss_get_products_tax_class_id($product['id'], $country_id);
            $key = $products_tax_class_id.':'.number_format($product['tax'],2,'.','');
            if(!isset($taxes[ $key ])){
                $taxes[ $key ] = 0;
            }
            $taxes[ $key ] += $product['final_price'];
        }
        $max = max($taxes);
        foreach($taxes as $tax=>$val){
            if($val == $max){
                $tax_parts = explode(':',$tax);
                $tax_class_id = $tax_parts[0];
            }
        }
	return $tax_class_id;
    }
    
    public function has_part_delivery(){
        if( $this->info['reclamations_status'] == 3){ // abgeschlossen
            $query = xtc_db_query(sprintf(
                    "SELECT count(id) as anz FROM shippings WHERE reclamations_id='%d'",
                    $this->info['id']
            ));
            $record = xtc_db_fetch_array($query);
            return ($record['anz'] > 1) ? true : false;
        }else{
            $query = xtc_db_query(sprintf(
                    "SELECT count(id) as anz FROM shippings WHERE reclamations_id='%d' AND status=1",
                    $this->info['id']
            ));
            $record = xtc_db_fetch_array($query);
            if($record['anz'] < 1){
                return false;
            }
            foreach($this->products as $product){
                if($product['quantity_shipped'] > 0){
                    return true;
                }
            }
        }
    }
}
