<?php
if(!defined('TABLE_EBAY_AUCTIONS')){
    define('TABLE_EBAY_AUCTIONS','ebay_auctions');
}
if(!class_exists('product')){
    // ADMIN BEREICH - IM SHOP WIRD product.php BEREITS IN 
    // DER application_top.php GELADEN
    require_once(__DIR__.DIRECTORY_SEPARATOR.'product.php');
}
if(!class_exists('ebay_auction')){
    require_once(__DIR__.DIRECTORY_SEPARATOR.'class.ebay_item.php');
    require_once(__DIR__.DIRECTORY_SEPARATOR.'class.ebay_auction.php');
}

class specials_ebay_revise {
    var $specials_ebay_revise_id, $specials_id, $ebay_auctions_id, $sku, 
        $status, $original_price, $is_revised, $special_price;
    const SPECIALS_EBAY_REVISE_PATH = 'LMS'.DIRECTORY_SEPARATOR.'SPECIALS_REVISE'.DIRECTORY_SEPARATOR;
    
    function __construct($specials_ebay_revise_id){
        $query = xtc_db_query(sprintf(
                "SELECT * FROM specials_ebay_revise WHERE specials_ebay_revise_id='%s'",
                $specials_ebay_revise_id
        ));
        if(!xtc_db_num_rows($query)){
            return false;
        }
        $this->setSpecials_ebay_revise_id($specials_ebay_revise_id);
        $record = xtc_db_fetch_array($query);
        $this->setEbay_auctions_id($record['ebay_auctions_id']);
        $this->setSku($record['sku']);
        $this->setSpecials_id($record['specials_id']);
        $this->setStatus($record['status']);
	$this->setOriginal_price($record['original_price']);
        $this->setIs_revised($record['is_revised']);
        $this->setSpecial_price($record['special_price']);
    }
    function getSpecials_ebay_revise_id() {
        return $this->specials_ebay_revise_id;
    }

    function getSpecials_id() {
        return $this->specials_id;
    }

    function getEbay_auctions_id() {
        return $this->ebay_auctions_id;
    }

    function getSku() {
        return $this->sku;
    }

    function getStatus() {
        return $this->status;
    }

    function setSpecials_ebay_revise_id($specials_ebay_revise_id) {
        $this->specials_ebay_revise_id = $specials_ebay_revise_id;
    }

    function setSpecials_id($specials_id) {
        $this->specials_id = $specials_id;
    }

    function setEbay_auctions_id($ebay_auctions_id) {
        $this->ebay_auctions_id = $ebay_auctions_id;
    }

    function setSku($sku) {
        $this->sku = $sku;
    }

    function setStatus($status) {
        $this->status = $status;
    }

    function getOriginal_price(){
	return $this->original_price;
    }

    function setOriginal_price($original_price){
	$this->original_price = $original_price;
    }

    function getIs_revised() {
        return $this->is_revised;
    }

    function setIs_revised($is_revised) {
        $this->is_revised = $is_revised;
    }

    function getSpecial_price() {
        return $this->special_price;
    }

    function setSpecial_price($special_price) {
        $this->special_price = $special_price;
    }

    public static function get_reviseable_auctions( $specials_id = Null){
        $lang_id = (isset($_SESSION['languages_id'])) ? $_SESSION['languages_id'] : 2;
        $products = array();
        $auctions = array();
        if($specials_id !== Null){
            $query = xtc_db_query(sprintf(
                    "SELECT s.products_id FROM %s s LEFT JOIN specials_ebay_revise ser USING(specials_id) WHERE ebay_price_revise=1 AND s.status=1 AND ser.specials_ebay_revise_id IS NULL AND s.specials_id='%s'",
                    TABLE_SPECIALS, $specials_id
            ));
        }else{
            $query = xtc_db_query(sprintf(
                    "SELECT s.products_id FROM %s s LEFT JOIN specials_ebay_revise ser USING(specials_id) WHERE ebay_price_revise=1 AND s.status=1 AND ser.specials_ebay_revise_id IS NULL",
                    TABLE_SPECIALS
            ));
        }
        while($record = xtc_db_fetch_array($query)){
            $products[] = $record['products_id'];
        }
        foreach($products as $pID){
            $P = new product($pID,$lang_id);
            $R = $P->get_running_auctions_list();
            if(!sizeOf($R)){
                continue;
            }
            $auctions_array = array();
            foreach($R as $au){
                // KEINE AUKTIONEN!
                if(!in_array($au['type'],array('FixedPriceItem','StoresFixedPrice'))){
                    continue;
                }
                if($au['variation'] > 0){
                    $EA = new ebay_auction($au['id']);
                    foreach($EA->variations as $v){
                        if($v->products_id == $pID){
                                if(!self::exists($au['id'], self::get_specials_id_from_products_id($pID), $v->sku)){
                                    $auctions_array[] = $au;
                                }
                        }
                    }
                }else{
                    if(!self::exists($au['id'], self::get_specials_id_from_products_id($pID), '')){
                        $auctions_array[] = $au;
                    }
                }
            }
            $auctions[] = array(
                'products_id'=>$pID,
                'auctions'=>$auctions_array
            );
        }
        return $auctions;
    }
    
    public static function get_ebay_auctions_id_from_ebay_id($ebay_id){
        $ea = \YES4Trade\Model\ebay_auctions::get_by_ebay_id($ebay_id,['id']);
        return intval($ea->id);
    }
    
    public static function get_specials_id_from_products_id($pID){
        $query = xtc_db_query(sprintf(
                "SELECT specials_id FROM %s WHERE products_id='%s'",
                TABLE_SPECIALS, $pID
        ));
        $record = xtc_db_fetch_array($query);
        return $record['specials_id'];
    }
    
    public static function exists($eaID, $spID, $sku){
        $query = xtc_db_query(sprintf(
                "SELECT specials_ebay_revise_id FROM specials_ebay_revise WHERE ebay_auctions_id='%s' AND specials_id='%s' AND sku='%s'",
                $eaID,$spID,$sku
        ));
        return xtc_db_num_rows($query);
    }
    
    public static function add_entry($pID, $ebay_id, $orig_price, $special_price, $sku = ''){
        $eaID = self::get_ebay_auctions_id_from_ebay_id($ebay_id);
        $spID = self::get_specials_id_from_products_id($pID);
        if(self::exists($eaID, $spID, $sku)){
            return false;
        }
        $insert_sql_array = array(
            'ebay_auctions_id'=>$eaID,
            'specials_id'=>$spID,
            'sku'=>$sku,
            'original_price'=>$orig_price,
            'special_price'=>$special_price
        );
        xtc_db_perform('specials_ebay_revise',$insert_sql_array);
    }

    public static function delete_entry($ebay_id, $sku = ''){
        $eaID = self::get_ebay_auctions_id_from_ebay_id($ebay_id);
        if($eaID < 1){
            return false;
        }
        xtc_db_query(sprintf(
		"DELETE FROM specials_ebay_revise WHERE ebay_auctions_id='%s' AND sku='%s'",
		$eaID, $sku
	));
	return true;
    }

    /**
     * Gibt ein Array der 'specials_ebay_revise' Eintraege zu
     * einer specials_id zurueck
     * @param Int $specials_id
     * @return Array mit specials_ebay_revise_id
     */
    public static function get_specials_ebay_revise_id_from_specials_id($specials_id){
	$return = array();
        $query = xtc_db_query(sprintf(
                "SELECT specials_ebay_revise_id FROM specials_ebay_revise WHERE specials_id='%s'",
                $specials_id
        ));
	while($record = xtc_db_fetch_array($query)){
		$return[] = $record['specials_ebay_revise_id'];
	}
	return $return;
    }

    /**
     * Datensaetze holen zur PID
     * 
     * Holt alle passenden Datensaetze aus der Tabelle specials_ebay_revise
     * zu einem bestimmten Artikel, Status und is_revise Flag
     * zb in xtc_expire_specials.inc.php
     * 
     * @param int $status (0=Muss auf Sonderpreis/1=wieder origpreis)
     * @param int $is_revised (1=wurde bereits auf sonderpreis gesetzt)
     * @param int $products_id
     * @return array enthaelt die specials_ebay_revise_ids
     */
    public static function get_items_by_status_and_products_id(int $status, int $is_revised, int $products_id){
        $return = [];
        $product = new product( $products_id );
        $in_auction_list = $product->get_running_auctions_list();
        $serIDs = [];
        foreach($in_auction_list as $in_auction){
            if(self::has_ebay_auction_id_reference($in_auction['id'])){
                $serIDs = self::get_specials_ebay_revise_ids_from_ebay_auction_id($in_auction['id']);
            }
            //id,type,ebay_id,quantity,title,0 as variation
        }
        foreach($serIDs as $specials_ebay_revise_id){
            $query = xtc_db_query(sprintf(
                    "SELECT * FROM specials_ebay_revise WHERE specials_ebay_revise_id='%d' AND status='%d' AND is_revised='%d'",
                    $specials_ebay_revise_id, $status, $is_revised
            ));
            if(!xtc_db_num_rows($query)){
                continue;
            }
            $return[] = $specials_ebay_revise_id;
        }
        return $return;
    }
    
    public static function get_items_by_status(int $status, int $is_revised = -1){
	$return = array();
        if($is_revised >= 0){
            $query = xtc_db_query(sprintf(
                    "SELECT specials_ebay_revise_id FROM specials_ebay_revise WHERE status='%s' AND is_revised='%s'",
                    $status, $is_revised
            ));
        }else{
            $query = xtc_db_query(sprintf(
                    "SELECT specials_ebay_revise_id FROM specials_ebay_revise WHERE status='%s'",
                    $status
            ));
        }
	while($record = xtc_db_fetch_array($query)){
		$return[] = $record['specials_ebay_revise_id'];
	}
	return $return;
    }
    
    public function update_status( $status ){
        $update_sql_array = array(
            'status'=>$status
        );
        xtc_db_perform('specials_ebay_revise', $update_sql_array, 'update',"specials_ebay_revise_id='".$this->getSpecials_ebay_revise_id()."'");
    }
    
    public static function create_from_specials_id($specials_id, $specials_price){
        $reviseable = self::get_reviseable_auctions($specials_id);
        if(!sizeOf($reviseable)){
            return true;
        }
        foreach($reviseable as $rs){
            foreach($rs['auctions'] as $auction){
                if($auction['variation'] == 1){
                    $pID = $rs['products_id'];
                    $eaID = self::get_ebay_auctions_id_from_ebay_id($auction['ebay_id']);
                    $ea = new ebay_auction( $eaID );
                    $price = 0;
                    $sku = '';
                    foreach($ea->getVariations() as $V){
                        if($V->products_id == $pID){
                            $sku = $V->sku;
                            $price = $V->current_auctionprice;
                        }
                    }
                    if($price <> $specials_price){
                        self::add_entry($pID, $auction['ebay_id'], $price, $specials_price, $sku);
                    }
                }else{
                    $pID = $rs['products_id'];
                    $sku = ''; // nur varianten kriegen SKU
                    $eaID = self::get_ebay_auctions_id_from_ebay_id($auction['ebay_id']);
                    $ea = new ebay_auction( $eaID );
                    if($ea->auctionprice <> $specials_price){
                        self::add_entry($pID, $auction['ebay_id'], $ea->auctionprice, $specials_price, $sku);
                    }
                }
            }
        }
    }
    
    
    public function get_revise_auction_data_array(&$normal_auctions, &$variation_auctions, $use_special_price = false){
        global $EBAYAPI;
        if(!is_object($EBAYAPI)){
            $EBAYAPI = new ebayAPI;
        }
        $au = new ebay_auction($this->getEbay_auctions_id());
        $pID = $au->products_id;
        $siteID = $EBAYAPI->get_site_id_from_name($au->site);
        if(is_array($au->variations)){
		foreach($au->variations as $v){
		    if($v->sku == $this->sku){
			    $pID = $v->products_id;
			    $price = $v->current_auctionprice;
		    }
		}
		if(!isset($variation_auctions[ $au->user ])){
		    $variation_auctions[ $au->user ] = array();
		}
		if(!isset($variation_auctions[ $au->user ][ $siteID ])){
		    $variation_auctions[ $au->user ][ $siteID ] = array();
		}
		if(!isset($variation_auctions[ $au->user ][$siteID][ $au->ebay_id ])){
		    $variation_auctions[ $au->user ][$siteID][ $au->ebay_id ] = array();
		}
		$price = ($use_special_price === true) ? $this->getSpecial_price() : $this->getOriginal_price();
		$variation_auctions[ $au->user ][$siteID][ $au->ebay_id ][$pID] = array(
		        'sku'=>$this->sku,
		        'ebay_auctions_id'=>$this->getEbay_auctions_id(),
		        'ebay_id'=>$au->ebay_id,
		        'specials_id'=>$this->getSpecials_id(),
		        'original_price'=>$this->getOriginal_price(),
		        'price'=>$price,
			'type'=>$au->getType(),
                    'special_ebay_revise_status'=>$this->getStatus(),
                    'special_ebay_revise_is_revised'=>$this->getIs_revised(),
                    
		);
        }else{
		if(!isset($normal_auctions[$au->user])){
			$normal_auctions[$au->user] = array();
		}
		if(!isset($normal_auctions[$au->user][$siteID])){
			$normal_auctions[$au->user][$siteID] = array();
		}
		$aprice = ($use_special_price === true) ? $this->getSpecial_price() : $this->getOriginal_price();
		$normal_auctions[$au->user][$siteID][$pID] = array(
			'sku'=>'',
			'ebay_auctions_id'=>$this->getEbay_auctions_id(),
			'ebay_id'=>$au->ebay_id,
			'specials_id'=>$this->getSpecials_id(),
			'original_price'=>$this->getOriginal_price(),
			'price'=>$aprice,
			'type'=>$au->getType(),
                    'special_ebay_revise_status'=>$this->getStatus(),
                    'special_ebay_revise_is_revised'=>$this->getIs_revised(),
		);
	}
    }
    
    /**
     *  IMMER WENN DER status GEAENDERT WIRD, MUSS DIESES FLAG NEU
     *  GESETZT WERDEN. ES ZEIGT AN OB EIN REVISE BEI EBAY BEREITS
     *  STATTGEFUNDEN HAT. Values: 0, 1
     * @param int $is_revised
     * @return nothing
    **/
    public function update_is_revised($is_revised){
        $update_sql_array = array(
            'is_revised'=>$is_revised
        );
        xtc_db_perform('specials_ebay_revise', $update_sql_array, 'update',"specials_ebay_revise_id='".$this->getSpecials_ebay_revise_id()."'");
    }
    
    public function delete(){
        xtc_db_query(sprintf(
                "DELETE FROM specials_ebay_revise WHERE specials_ebay_revise_id='%s'",
                $this->getSpecials_ebay_revise_id()
        ));
    }
    
    /**
     * Prueft ob es einen specials_ebay_revise Eintrag zu einer bestimmten
     * ebay_auctions_id gibt
     * @param int $ebay_auctions_id
     * @return bool
     */
    public static function has_ebay_auction_id_reference($ebay_auctions_id){
        $query = xtc_db_query(sprintf(
                "SELECT specials_ebay_revise_id FROM specials_ebay_revise WHERE ebay_auctions_id='%s'",
                $ebay_auctions_id
        ));
        return (xtc_db_num_rows($query)>0)?true:false;
    }
    
    public static function get_specials_ebay_revise_ids_from_ebay_auction_id($ebay_auctions_id, $sku=null){
        $array = array();
        if($sku === null){
            $query = xtc_db_query(sprintf(
                    "SELECT specials_ebay_revise_id FROM specials_ebay_revise WHERE ebay_auctions_id='%s'",
                    $ebay_auctions_id
            ));
        }else{
            $query = xtc_db_query(sprintf(
                    "SELECT specials_ebay_revise_id FROM specials_ebay_revise WHERE ebay_auctions_id='%s' AND sku='%s'",
                    $ebay_auctions_id,$sku
            ));
        }
        while($record = xtc_db_fetch_array($query)){
            $array[] = $record['specials_ebay_revise_id'];
        }
        return $array;
    }
    
    public static function get_specials_ebay_revise_id_from_auction($ebay_auctions_id, $sku){
        $query = xtc_db_query(sprintf(
                "SELECT specials_ebay_revise_id FROM specials_ebay_revise WHERE ebay_auctions_id='%s' AND sku='%s'",
                $ebay_auctions_id, $sku
        ));
        $record = xtc_db_fetch_array($query);
        return $record['specials_ebay_revise_id'];
    }

	public function update_auction_price(){
		if($this->getStatus() == 0){
			// AUF SPECIAL PRICE
			$price = $this->getSpecial_price();
		}else{
			// AUF NORMAL PRICE
			$price = $this->getOriginal_price();
		}
        \YES4Trade\Model\ebay_auctions::update_ebay_auction([ // auction price update
            'auctionprice'=>(float)$price,
            'id'=>intval($this->getEbay_auctions_id)
        ]);
	}
        
    public static function is_task_allocated( string $taskId ){
        $save_real_path = main::get_secure_path().self::SPECIALS_EBAY_REVISE_PATH;
        $files = basics::get_directory_content( $save_real_path );
        foreach($files as $f){
            if(strpos($f, $taskId)>0){
                return true;
            }
        }
        return false;
    }
}
